/*
 * Decompiled with CFR 0.152.
 */
package forge.ai.ability;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import forge.ai.AiBlockController;
import forge.ai.ComputerUtil;
import forge.ai.ComputerUtilCard;
import forge.ai.ComputerUtilCombat;
import forge.ai.ComputerUtilCost;
import forge.ai.SpecialCardAi;
import forge.ai.SpellAbilityAi;
import forge.game.CardTraitBase;
import forge.game.card.Card;
import forge.game.card.CardCollection;
import forge.game.card.CardLists;
import forge.game.card.CardPredicates;
import forge.game.card.CounterEnumType;
import forge.game.combat.Combat;
import forge.game.cost.Cost;
import forge.game.keyword.Keyword;
import forge.game.phase.PhaseType;
import forge.game.player.Player;
import forge.game.spellability.SpellAbility;
import forge.game.zone.ZoneType;
import java.util.Iterator;

public class DestroyAllAi
extends SpellAbilityAi {
    private static final Predicate<Card> predicate = c -> !c.hasKeyword(Keyword.INDESTRUCTIBLE) && c.getCounters(CounterEnumType.SHIELD) <= 0 && !c.hasSVar("SacMe");

    @Override
    protected boolean doTriggerAINoCost(Player ai, SpellAbility sa, boolean mandatory) {
        if (mandatory) {
            return true;
        }
        return DestroyAllAi.doMassRemovalLogic(ai, sa);
    }

    @Override
    public boolean chkAIDrawback(SpellAbility sa, Player aiPlayer) {
        return DestroyAllAi.doMassRemovalLogic(aiPlayer, sa);
    }

    @Override
    protected boolean canPlayAI(Player ai, SpellAbility sa) {
        Cost abCost = sa.getPayCosts();
        Card source = sa.getHostCard();
        if (abCost != null && !ComputerUtilCost.checkLifeCost(ai, abCost, source, 4, sa)) {
            return false;
        }
        if (ComputerUtil.preventRunAwayActivations(sa)) {
            return false;
        }
        String aiLogic = sa.getParamOrDefault("AILogic", "");
        if ("FellTheMighty".equals(aiLogic)) {
            return SpecialCardAi.FellTheMighty.consider(ai, sa);
        }
        return DestroyAllAi.doMassRemovalLogic(ai, sa);
    }

    public static boolean doMassRemovalLogic(Player ai, SpellAbility sa) {
        Iterator iterator;
        Card source = sa.getHostCard();
        String logic = sa.getParamOrDefault("AILogic", "");
        int CREATURE_EVAL_THRESHOLD = 200 / (!sa.usesTargeting() ? ai.getOpponents().size() : 1);
        if (logic.equals("Always")) {
            return true;
        }
        String valid = sa.getParamOrDefault("ValidCards", "");
        if (valid.contains("X") && sa.getSVar("X").equals("Count$xPaid")) {
            int xPay = ComputerUtilCost.getMaxXValue(sa, ai, sa.isTrigger());
            sa.setXManaCostPaid(xPay);
            valid = valid.replace("X", Integer.toString(xPay));
        }
        if ((iterator = ai.getOpponents().iterator()).hasNext()) {
            Player opponent = (Player)iterator.next();
            CardCollection opplist = CardLists.getValidCards((Iterable<Card>)opponent.getCardsIn(ZoneType.Battlefield), valid, source.getController(), source, (CardTraitBase)sa);
            CardCollection ailist = CardLists.getValidCards((Iterable<Card>)ai.getCardsIn(ZoneType.Battlefield), valid, source.getController(), source, (CardTraitBase)sa);
            opplist = CardLists.filter((Iterable<Card>)opplist, predicate);
            ailist = CardLists.filter((Iterable<Card>)ailist, predicate);
            if (opplist.isEmpty()) {
                return false;
            }
            if (sa.usesTargeting()) {
                sa.resetTargets();
                if (sa.canTarget(opponent)) {
                    sa.getTargets().add(opponent);
                    ailist.clear();
                } else {
                    return false;
                }
            }
            if (logic.equals("RaidingParty")) {
                int numAiCanSave = Math.min(CardLists.count(ai.getCreaturesInPlay(), Predicates.and(CardPredicates.isColor((byte)1), CardPredicates.Presets.UNTAPPED)) * 2, ailist.size());
                int numOppsCanSave = Math.min(CardLists.count(ai.getOpponents().getCreaturesInPlay(), Predicates.and(CardPredicates.isColor((byte)1), CardPredicates.Presets.UNTAPPED)) * 2, opplist.size());
                return numOppsCanSave < opplist.size() && ailist.size() - numAiCanSave < opplist.size() - numOppsCanSave;
            }
            if (!CardLists.getType(opplist, "Creature").isEmpty() && ai.getGame().getPhaseHandler().is(PhaseType.COMBAT_DECLARE_BLOCKERS) && ai.getGame().getCombat() != null && ComputerUtilCombat.lifeInSeriousDanger(ai, ai.getGame().getCombat())) {
                return true;
            }
            if (!CardLists.getType(opplist, "Creature").isEmpty() && ai.getGame().getPhaseHandler().is(PhaseType.COMBAT_DECLARE_BLOCKERS) && ai.getGame().getCombat() != null && ComputerUtilCombat.lifeInDanger(ai, ai.getGame().getCombat()) && ComputerUtilCard.evaluatePermanentList(ailist) - 6 >= ComputerUtilCard.evaluatePermanentList(opplist)) {
                return true;
            }
            if (CardLists.getNotType(opplist, "Creature").isEmpty() && CardLists.getNotType(ailist, "Creature").isEmpty()) {
                if (ComputerUtilCard.evaluateCreatureList(ailist) + CREATURE_EVAL_THRESHOLD < ComputerUtilCard.evaluateCreatureList(opplist)) {
                    return true;
                }
                if (ai.getGame().getPhaseHandler().getPhase().isBefore(PhaseType.MAIN2)) {
                    return false;
                }
                Combat combat = new Combat(opponent);
                boolean containsAttacker = false;
                for (Card att : opponent.getCreaturesInPlay()) {
                    if (!ComputerUtilCombat.canAttackNextTurn(att, ai)) continue;
                    combat.addAttacker(att, ai);
                    containsAttacker = containsAttacker || opplist.contains(att);
                }
                if (!containsAttacker) {
                    return false;
                }
                AiBlockController block = new AiBlockController(ai, false);
                block.assignBlockersForCombat(combat);
                return ComputerUtilCombat.lifeInSeriousDanger(ai, combat);
            }
            if (CardLists.getNotType(opplist, "Land").isEmpty() && CardLists.getNotType(ailist, "Land").isEmpty()) {
                if (ai.isCardInPlay("Crucible of Worlds") && !opponent.isCardInPlay("Crucible of Worlds")) {
                    return true;
                }
                CardCollection aiCreatures = ai.getCreaturesInPlay();
                CardCollection oppCreatures = opponent.getCreaturesInPlay();
                if (!oppCreatures.isEmpty() && ComputerUtilCard.evaluateCreatureList(aiCreatures) < ComputerUtilCard.evaluateCreatureList(oppCreatures) + CREATURE_EVAL_THRESHOLD) {
                    return false;
                }
                if (ComputerUtilCard.evaluatePermanentList(ailist) > ComputerUtilCard.evaluatePermanentList(opplist) + 1) {
                    return false;
                }
            } else if (ComputerUtilCard.evaluatePermanentList(ailist) + 3 >= ComputerUtilCard.evaluatePermanentList(opplist)) {
                return false;
            }
            return true;
        }
        return false;
    }
}

