/*
 * Decompiled with CFR 0.152.
 */
package forge.ai.ability;

import forge.ai.SpecialCardAi;
import forge.ai.ability.DamageAiBase;
import forge.game.ability.AbilityUtils;
import forge.game.player.Player;
import forge.game.player.PlayerCollection;
import forge.game.player.PlayerPredicates;
import forge.game.spellability.SpellAbility;

public class DamageEachAi
extends DamageAiBase {
    @Override
    protected boolean canPlayAI(Player ai, SpellAbility sa) {
        String logic = sa.getParam("AILogic");
        PlayerCollection targetableOpps = ai.getOpponents().filter(PlayerPredicates.isTargetableBy(sa));
        Player weakestOpp = targetableOpps.min(PlayerPredicates.compareByLife());
        if (sa.usesTargeting() && weakestOpp != null) {
            if ("MadSarkhanUltimate".equals(logic) && !SpecialCardAi.SarkhanTheMad.considerUltimate(ai, sa, weakestOpp)) {
                return false;
            }
            sa.resetTargets();
            sa.getTargets().add(weakestOpp);
            return weakestOpp.canLoseLife() && !weakestOpp.cantLoseForZeroOrLessLife();
        }
        String damage = sa.getParam("NumDmg");
        int iDmg = AbilityUtils.calculateAmount(sa.getHostCard(), damage, sa);
        return this.shouldTgtP(ai, sa, iDmg, false);
    }

    @Override
    public boolean chkAIDrawback(SpellAbility sa, Player aiPlayer) {
        return true;
    }

    @Override
    protected boolean doTriggerAINoCost(Player ai, SpellAbility sa, boolean mandatory) {
        return mandatory || this.canPlayAI(ai, sa);
    }
}

