/*
 * Decompiled with CFR 0.152.
 */
package forge.ai.ability;

import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import forge.ai.ComputerUtil;
import forge.ai.ComputerUtilCard;
import forge.ai.ComputerUtilCost;
import forge.ai.SpellAbilityAi;
import forge.game.Game;
import forge.game.GameEntity;
import forge.game.GameObject;
import forge.game.ability.AbilityUtils;
import forge.game.card.Card;
import forge.game.card.CardCollection;
import forge.game.card.CardCollectionView;
import forge.game.card.CardLists;
import forge.game.card.CardPredicates;
import forge.game.card.CounterEnumType;
import forge.game.card.CounterType;
import forge.game.keyword.Keyword;
import forge.game.phase.PhaseHandler;
import forge.game.phase.PhaseType;
import forge.game.player.Player;
import forge.game.spellability.SpellAbility;
import forge.game.spellability.TargetRestrictions;
import forge.game.zone.ZoneType;
import java.util.List;
import java.util.Map;

public class CountersRemoveAi
extends SpellAbilityAi {
    @Override
    protected boolean canPlayWithoutRestrict(Player ai, SpellAbility sa) {
        if ("Always".equals(sa.getParam("AILogic"))) {
            return true;
        }
        return super.canPlayWithoutRestrict(ai, sa);
    }

    @Override
    protected boolean checkPhaseRestrictions(Player ai, SpellAbility sa, PhaseHandler ph) {
        String type = sa.getParam("CounterType");
        if (ph.getPhase().isBefore(PhaseType.MAIN2) && !sa.hasParam("ActivationPhases") && !type.equals("M1M1")) {
            return false;
        }
        return super.checkPhaseRestrictions(ai, sa, ph);
    }

    @Override
    protected boolean checkPhaseRestrictions(Player ai, SpellAbility sa, PhaseHandler ph, String logic) {
        if (!(!"EndOfOpponentsTurn".equals(logic) || ph.is(PhaseType.END_OF_TURN) && ph.getNextTurn().equals(ai))) {
            return false;
        }
        return super.checkPhaseRestrictions(ai, sa, ph, logic);
    }

    @Override
    protected boolean checkApiLogic(Player ai, SpellAbility sa) {
        int currCounters;
        String type = sa.getParam("CounterType");
        if (sa.usesTargeting()) {
            return this.doTgt(ai, sa, false);
        }
        if (!type.matches("Any") && !type.matches("All") && (currCounters = sa.getHostCard().getCounters(CounterType.getType(type))) < 1) {
            return false;
        }
        return super.checkApiLogic(ai, sa);
    }

    private boolean doTgt(Player ai, SpellAbility sa, boolean mandatory) {
        boolean maritEmpty;
        Card source = sa.getHostCard();
        Game game = ai.getGame();
        String type = sa.getParam("CounterType");
        String amountStr = sa.getParamOrDefault("CounterNum", "1");
        TargetRestrictions tgt = sa.getTargetRestrictions();
        CardCollection list = CardLists.getTargetableCards(game.getCardsIn(tgt.getZone()), sa);
        if (list.isEmpty()) {
            return false;
        }
        list = ComputerUtil.filterAITgts(sa, ai, list, false);
        CardCollectionView marit = ai.getCardsIn(ZoneType.Battlefield, "Marit Lage");
        boolean bl = maritEmpty = marit.isEmpty() || Iterables.contains(marit, Card::ignoreLegendRule);
        if (type.matches("All")) {
            if (maritEmpty) {
                CardCollectionView depthsList = ai.getCardsIn(ZoneType.Battlefield, "Dark Depths");
                if (!(depthsList = CardLists.filter(depthsList, CardPredicates.isTargetableBy(sa), CardPredicates.hasCounter(CounterEnumType.ICE, 3))).isEmpty()) {
                    sa.getTargets().add((GameObject)depthsList.getFirst());
                    return true;
                }
            }
            list = ai.getOpponents().getCardsIn(ZoneType.Battlefield);
            CardCollection planeswalkerList = CardLists.filter(list = CardLists.filter((Iterable<Card>)list, CardPredicates.isTargetableBy(sa)), CardPredicates.Presets.PLANESWALKERS, CardPredicates.hasCounter(CounterEnumType.LOYALTY, 5));
            if (!planeswalkerList.isEmpty()) {
                sa.getTargets().add(ComputerUtilCard.getBestPlaneswalkerAI(planeswalkerList));
                return true;
            }
        } else if (type.matches("Any")) {
            int amount;
            boolean xPay = false;
            if (amountStr.equals("X") && sa.getSVar("X").equals("Count$xPaid")) {
                int manaLeft = ComputerUtilCost.getMaxXValue(sa, ai, sa.isTrigger());
                if (manaLeft == 0) {
                    return false;
                }
                amount = manaLeft;
                xPay = true;
            } else {
                amount = AbilityUtils.calculateAmount(source, amountStr, sa);
            }
            if (maritEmpty) {
                Card depth;
                int ice;
                CardCollectionView depthsList = ai.getCardsIn(ZoneType.Battlefield, "Dark Depths");
                if (!(depthsList = CardLists.filter(depthsList, CardPredicates.isTargetableBy(sa), CardPredicates.hasCounter(CounterEnumType.ICE))).isEmpty() && amount >= (ice = (depth = (Card)depthsList.getFirst()).getCounters(CounterEnumType.ICE))) {
                    sa.getTargets().add(depth);
                    if (xPay) {
                        sa.setXManaCostPaid(ice);
                    }
                    return true;
                }
            }
            list = game.getPlayers().getCardsIn(ZoneType.Battlefield);
            CardCollection planeswalkerList = CardLists.filter(list = CardLists.filter((Iterable<Card>)list, CardPredicates.isTargetableBy(sa)), Predicates.and(CardPredicates.Presets.PLANESWALKERS, CardPredicates.isControlledByAnyOf(ai.getOpponents())), CardPredicates.hasLessCounter(CounterEnumType.LOYALTY, amount));
            if (!planeswalkerList.isEmpty()) {
                Card best = ComputerUtilCard.getBestPlaneswalkerAI(planeswalkerList);
                sa.getTargets().add(best);
                if (xPay) {
                    sa.setXManaCostPaid(best.getCurrentLoyalty());
                }
                return true;
            }
            if (!xPay) {
                CardCollection aiList = CardLists.filterControlledBy((Iterable<Card>)list, ai);
                CardCollection aiM1M1List = CardLists.filter((Iterable<Card>)aiList, CardPredicates.hasCounter(CounterEnumType.M1M1));
                CardCollection aiPersistList = CardLists.getKeyword((Iterable<Card>)aiM1M1List, Keyword.PERSIST);
                if (!aiPersistList.isEmpty()) {
                    aiM1M1List = aiPersistList;
                }
                if (!aiM1M1List.isEmpty()) {
                    sa.getTargets().add(ComputerUtilCard.getBestCreatureAI(aiM1M1List));
                    return true;
                }
                CardCollection aiP1P1List = CardLists.filter((Iterable<Card>)aiList, CardPredicates.hasLessCounter(CounterEnumType.P1P1, amount));
                CardCollection aiUndyingList = CardLists.getKeyword((Iterable<Card>)aiP1P1List, Keyword.UNDYING);
                if (!aiUndyingList.isEmpty()) {
                    sa.getTargets().add(ComputerUtilCard.getBestCreatureAI(aiUndyingList));
                    return true;
                }
                CardCollection oppP1P1List = CardLists.filter(list, Predicates.and(CardPredicates.Presets.CREATURES, CardPredicates.isControlledByAnyOf(ai.getOpponents())), CardPredicates.hasCounter(CounterEnumType.P1P1));
                if (!oppP1P1List.isEmpty()) {
                    sa.getTargets().add(ComputerUtilCard.getBestCreatureAI(oppP1P1List));
                    return true;
                }
                CardCollection oppList = CardLists.filterControlledBy((Iterable<Card>)list, ai.getOpponents());
                if (!(oppList = CardLists.filter((Iterable<Card>)oppList, CardPredicates.hasCounters())).isEmpty()) {
                    Card best = ComputerUtilCard.getBestAI(oppList);
                    for (CounterType aType : best.getCounters().keySet()) {
                        if (ComputerUtil.isNegativeCounter(aType, best)) continue;
                        sa.getTargets().add(best);
                        return true;
                    }
                }
            }
        } else if (type.equals("M1M1")) {
            int amount = AbilityUtils.calculateAmount(source, amountStr, sa);
            CardCollection aiList = CardLists.filterControlledBy((Iterable<Card>)list, ai);
            CardCollection aiPersist = CardLists.getKeyword((Iterable<Card>)(aiList = CardLists.filter((Iterable<Card>)aiList, CardPredicates.hasCounter(CounterEnumType.M1M1, amount))), Keyword.PERSIST);
            if (!aiPersist.isEmpty()) {
                aiList = aiPersist;
            }
            if (!aiList.isEmpty()) {
                sa.getTargets().add(ComputerUtilCard.getBestCreatureAI(aiList));
                return true;
            }
        } else if (type.equals("P1P1")) {
            CardCollection oppList;
            int amount = AbilityUtils.calculateAmount(source, amountStr, sa);
            CardCollection aiList = CardLists.filterControlledBy((Iterable<Card>)(list = CardLists.filter((Iterable<Card>)list, CardPredicates.hasCounter(CounterEnumType.P1P1, amount))), ai);
            if (!aiList.isEmpty()) {
                CardCollection aiListUndying = CardLists.getKeyword((Iterable<Card>)aiList, Keyword.UNDYING);
                if (!aiListUndying.isEmpty()) {
                    aiList = aiListUndying;
                }
                if (!aiList.isEmpty()) {
                    sa.getTargets().add(ComputerUtilCard.getBestCreatureAI(aiList));
                    return true;
                }
            }
            if (!(oppList = CardLists.filterControlledBy((Iterable<Card>)list, ai.getOpponents())).isEmpty()) {
                CardCollection oppListNotUndying = CardLists.getNotKeyword((Iterable<Card>)oppList, Keyword.UNDYING);
                if (!oppListNotUndying.isEmpty()) {
                    oppList = oppListNotUndying;
                }
                if (!oppList.isEmpty()) {
                    sa.getTargets().add(ComputerUtilCard.getWorstCreatureAI(oppList));
                    return true;
                }
            }
        } else if (type.equals("TIME")) {
            int amount;
            boolean xPay = false;
            if (amountStr.equals("X") && sa.getSVar("X").equals("Count$xPaid")) {
                int manaLeft = ComputerUtilCost.getMaxXValue(sa, ai, sa.isTrigger());
                if (manaLeft == 0) {
                    return false;
                }
                amount = manaLeft;
                xPay = true;
            } else {
                amount = AbilityUtils.calculateAmount(source, amountStr, sa);
            }
            CardCollection timeList = CardLists.filter((Iterable<Card>)list, CardPredicates.hasLessCounter(CounterEnumType.TIME, amount));
            if (!timeList.isEmpty()) {
                Card best = ComputerUtilCard.getBestAI(timeList);
                int timeCount = best.getCounters(CounterEnumType.TIME);
                sa.getTargets().add(best);
                if (xPay) {
                    sa.setXManaCostPaid(timeCount);
                }
                return true;
            }
        }
        if (mandatory) {
            if (type.equals("P1P1")) {
                CardCollection adaptCreats = CardLists.filter((Iterable<Card>)list, CardPredicates.hasKeyword(Keyword.ADAPT));
                if (!adaptCreats.isEmpty()) {
                    sa.getTargets().add(ComputerUtilCard.getWorstAI(adaptCreats));
                    return true;
                }
                CardCollection outlastCreats = CardLists.filter((Iterable<Card>)list, CardPredicates.hasKeyword(Keyword.OUTLAST));
                if (!outlastCreats.isEmpty()) {
                    CardCollection betterTargets = CardLists.filter((Iterable<Card>)outlastCreats, CardPredicates.hasCounter(CounterEnumType.P1P1, 2));
                    if (!betterTargets.isEmpty()) {
                        sa.getTargets().add(ComputerUtilCard.getWorstAI(betterTargets));
                        return true;
                    }
                    sa.getTargets().add(ComputerUtilCard.getWorstAI(outlastCreats));
                    return true;
                }
            }
            sa.getTargets().add(ComputerUtilCard.getWorstAI(list));
            return true;
        }
        return false;
    }

    @Override
    protected boolean doTriggerAINoCost(Player aiPlayer, SpellAbility sa, boolean mandatory) {
        if (sa.usesTargeting()) {
            return this.doTgt(aiPlayer, sa, mandatory);
        }
        return mandatory;
    }

    @Override
    public int chooseNumber(Player player, SpellAbility sa, int min2, int max, Map<String, Object> params) {
        GameEntity target = (GameEntity)params.get("Target");
        CounterType type = (CounterType)params.get("CounterType");
        if (target instanceof Card) {
            Card targetCard = (Card)target;
            if (targetCard.getController().isOpponentOf(player)) {
                return !ComputerUtil.isNegativeCounter(type, targetCard) ? max : min2;
            }
            if (targetCard.hasKeyword(Keyword.UNDYING) && type.is(CounterEnumType.P1P1) && targetCard.getCounters(CounterEnumType.P1P1) >= max) {
                return max;
            }
            return ComputerUtil.isNegativeCounter(type, targetCard) ? max : min2;
        }
        if (target instanceof Player) {
            Player targetPlayer = (Player)target;
            if (targetPlayer.isOpponentOf(player)) {
                return !type.is(CounterEnumType.POISON) ? max : min2;
            }
            return type.is(CounterEnumType.POISON) ? max : min2;
        }
        return super.chooseNumber(player, sa, min2, max, params);
    }

    @Override
    public CounterType chooseCounterType(List<CounterType> options, SpellAbility sa, Map<String, Object> params) {
        block12: {
            GameEntity target;
            Player ai;
            block11: {
                ai = sa.getActivatingPlayer();
                target = (GameEntity)params.get("Target");
                if (!(target instanceof Card)) break block11;
                Card targetCard = (Card)target;
                if (targetCard.getController().isOpponentOf(ai)) {
                    if (targetCard.isPlaneswalker()) {
                        return CounterType.get(CounterEnumType.LOYALTY);
                    }
                    for (CounterType type : options) {
                        if (ComputerUtil.isNegativeCounter(type, targetCard)) continue;
                        return type;
                    }
                } else {
                    if (options.contains(CounterType.get(CounterEnumType.M1M1)) && targetCard.hasKeyword(Keyword.PERSIST)) {
                        return CounterType.get(CounterEnumType.M1M1);
                    }
                    if (options.contains(CounterType.get(CounterEnumType.P1P1)) && targetCard.hasKeyword(Keyword.UNDYING)) {
                        return CounterType.get(CounterEnumType.P1P1);
                    }
                    for (CounterType type : options) {
                        if (!ComputerUtil.isNegativeCounter(type, targetCard)) continue;
                        return type;
                    }
                }
                break block12;
            }
            if (!(target instanceof Player)) break block12;
            Player targetPlayer = (Player)target;
            if (targetPlayer.isOpponentOf(ai)) {
                for (CounterType type : options) {
                    if (type.is(CounterEnumType.POISON)) continue;
                    return type;
                }
            } else {
                for (CounterType type : options) {
                    if (!type.is(CounterEnumType.POISON)) continue;
                    return type;
                }
            }
        }
        return super.chooseCounterType(options, sa, params);
    }
}

