/*
 * Decompiled with CFR 0.152.
 */
package forge.ai.ability;

import com.google.common.collect.Iterables;
import forge.ai.ComputerUtil;
import forge.ai.ComputerUtilCard;
import forge.ai.SpellAbilityAi;
import forge.game.Game;
import forge.game.GameObject;
import forge.game.ability.AbilityUtils;
import forge.game.card.Card;
import forge.game.card.CardCollection;
import forge.game.card.CardCollectionView;
import forge.game.card.CardLists;
import forge.game.card.CardPredicates;
import forge.game.card.CounterEnumType;
import forge.game.card.CounterType;
import forge.game.keyword.Keyword;
import forge.game.player.Player;
import forge.game.player.PlayerController;
import forge.game.spellability.SpellAbility;
import forge.game.spellability.TargetRestrictions;
import forge.game.zone.ZoneType;
import java.util.List;
import java.util.Map;

public class CountersPutOrRemoveAi
extends SpellAbilityAi {
    @Override
    protected boolean checkApiLogic(Player ai, SpellAbility sa) {
        if (sa.usesTargeting()) {
            return this.doTgt(ai, sa, false);
        }
        return super.checkApiLogic(ai, sa);
    }

    private boolean doTgt(Player ai, SpellAbility sa, boolean mandatory) {
        TargetRestrictions tgt;
        Game game = ai.getGame();
        CardCollection list = CardLists.getTargetableCards(game.getCardsIn((tgt = sa.getTargetRestrictions()).getZone()), sa);
        if (list.isEmpty()) {
            return false;
        }
        list = ComputerUtil.filterAITgts(sa, ai, list, false);
        int amount = AbilityUtils.calculateAmount(sa.getHostCard(), sa.getParamOrDefault("CounterNum", "1"), sa);
        if (sa.hasParam("CounterType")) {
            CounterType type = CounterType.getType(sa.getParam("CounterType"));
            CardCollection countersList = CardLists.filter((Iterable<Card>)list, CardPredicates.hasCounter(type, amount));
            if (countersList.isEmpty()) {
                return false;
            }
            Card best = ComputerUtilCard.getBestAI(countersList);
            sa.getTargets().add(best);
            return true;
        }
        CardCollection countersList = CardLists.filter((Iterable<Card>)list, CardPredicates.hasCounters());
        if (!countersList.isEmpty()) {
            CardCollection depthsList;
            boolean maritEmpty;
            CardCollectionView marit = ai.getCardsIn(ZoneType.Battlefield, "Marit Lage");
            boolean bl = maritEmpty = marit.isEmpty() || Iterables.contains(marit, Card::ignoreLegendRule);
            if (maritEmpty && !(depthsList = CardLists.filter(countersList, CardPredicates.nameEquals("Dark Depths"), CardPredicates.hasCounter(CounterEnumType.ICE))).isEmpty()) {
                sa.getTargets().add((GameObject)depthsList.getFirst());
                return true;
            }
            CardCollection planeswalkerList = CardLists.filter(CardLists.filterControlledBy((Iterable<Card>)countersList, ai.getOpponents()), CardPredicates.Presets.PLANESWALKERS, CardPredicates.hasLessCounter(CounterEnumType.LOYALTY, amount));
            if (!planeswalkerList.isEmpty()) {
                sa.getTargets().add(ComputerUtilCard.getBestPlaneswalkerAI(planeswalkerList));
                return true;
            }
            CardCollection aiList = CardLists.filterControlledBy((Iterable<Card>)countersList, ai);
            CardCollection aiM1M1List = CardLists.filter((Iterable<Card>)aiList, CardPredicates.hasCounter(CounterEnumType.M1M1));
            CardCollection aiPersistList = CardLists.getKeyword((Iterable<Card>)aiM1M1List, Keyword.PERSIST);
            if (!aiPersistList.isEmpty()) {
                aiM1M1List = aiPersistList;
            }
            if (!aiM1M1List.isEmpty()) {
                sa.getTargets().add(ComputerUtilCard.getBestCreatureAI(aiM1M1List));
                return true;
            }
            CardCollection aiP1P1List = CardLists.filter((Iterable<Card>)aiList, CardPredicates.hasCounter(CounterEnumType.P1P1));
            CardCollection aiUndyingList = CardLists.getKeyword((Iterable<Card>)aiM1M1List, Keyword.UNDYING);
            if (!aiUndyingList.isEmpty()) {
                aiP1P1List = aiUndyingList;
            }
            if (!aiP1P1List.isEmpty()) {
                sa.getTargets().add(ComputerUtilCard.getBestCreatureAI(aiP1P1List));
                return true;
            }
            CardCollection oppList = CardLists.filterControlledBy((Iterable<Card>)countersList, ai.getOpponents());
            if (!(oppList = CardLists.filter((Iterable<Card>)oppList, CardPredicates.hasCounters())).isEmpty()) {
                Card best = ComputerUtilCard.getBestAI(oppList);
                for (CounterType aType : best.getCounters().keySet()) {
                    if (!ComputerUtil.isNegativeCounter(aType, best)) {
                        sa.getTargets().add(best);
                        return true;
                    }
                    if (ComputerUtil.isUselessCounter(aType, best) || best.getCounters(aType) > amount) continue;
                    sa.getTargets().add(best);
                    return true;
                }
            }
        }
        if (mandatory) {
            sa.getTargets().add(ComputerUtilCard.getWorstAI(list));
            return true;
        }
        return false;
    }

    @Override
    protected boolean doTriggerAINoCost(Player ai, SpellAbility sa, boolean mandatory) {
        if (sa.usesTargeting()) {
            return this.doTgt(ai, sa, mandatory);
        }
        return mandatory;
    }

    @Override
    public CounterType chooseCounterType(List<CounterType> options, SpellAbility sa, Map<String, Object> params) {
        Player ai = sa.getActivatingPlayer();
        Card tgt = (Card)params.get("Target");
        if (tgt.isPlaneswalker() && options.contains(CounterType.get(CounterEnumType.LOYALTY))) {
            return CounterType.get(CounterEnumType.LOYALTY);
        }
        if (tgt.getController().isOpponentOf(ai)) {
            if (tgt.isCreature() && tgt.getBaseToughness() <= 0) {
                if (options.contains(CounterType.get(CounterEnumType.P1P1))) {
                    return CounterType.get(CounterEnumType.P1P1);
                }
                if (options.contains(CounterType.get(CounterEnumType.M1M1))) {
                    return CounterType.get(CounterEnumType.M1M1);
                }
            }
            for (CounterType type : options) {
                if (ComputerUtil.isNegativeCounter(type, tgt)) continue;
                return type;
            }
        } else {
            if ("Dark Depths".equals(tgt.getName()) && options.contains(CounterType.get(CounterEnumType.ICE))) {
                boolean maritEmpty;
                CardCollectionView marit = ai.getCardsIn(ZoneType.Battlefield, "Marit Lage");
                boolean bl = maritEmpty = marit.isEmpty() || Iterables.contains(marit, Card::ignoreLegendRule);
                if (maritEmpty) {
                    return CounterType.get(CounterEnumType.ICE);
                }
            } else {
                if (tgt.hasKeyword(Keyword.UNDYING) && options.contains(CounterType.get(CounterEnumType.P1P1))) {
                    return CounterType.get(CounterEnumType.P1P1);
                }
                if (tgt.hasKeyword(Keyword.PERSIST) && options.contains(CounterType.get(CounterEnumType.M1M1))) {
                    return CounterType.get(CounterEnumType.M1M1);
                }
            }
            for (CounterType type : options) {
                if (ComputerUtil.isNegativeCounter(type, tgt)) continue;
                return type;
            }
        }
        return super.chooseCounterType(options, sa, params);
    }

    @Override
    public boolean chooseBinary(PlayerController.BinaryChoiceType kindOfChoice, SpellAbility sa, Map<String, Object> params) {
        if (kindOfChoice.equals((Object)PlayerController.BinaryChoiceType.AddOrRemove)) {
            Player ai = sa.getActivatingPlayer();
            Card tgt = (Card)params.get("Target");
            CounterType type = (CounterType)params.get("CounterType");
            if (tgt.getController().isOpponentOf(ai)) {
                if (type.is(CounterEnumType.LOYALTY) && tgt.isPlaneswalker()) {
                    return false;
                }
                return ComputerUtil.isNegativeCounter(type, tgt);
            }
            if (type.is(CounterEnumType.ICE) && "Dark Depths".equals(tgt.getName())) {
                boolean maritEmpty;
                CardCollectionView marit = ai.getCardsIn(ZoneType.Battlefield, "Marit Lage");
                boolean bl = maritEmpty = marit.isEmpty() || Iterables.contains(marit, Card::ignoreLegendRule);
                if (maritEmpty) {
                    return false;
                }
            } else {
                if (type.is(CounterEnumType.M1M1) && tgt.hasKeyword(Keyword.PERSIST)) {
                    return false;
                }
                if (type.is(CounterEnumType.P1P1) && tgt.hasKeyword(Keyword.UNDYING)) {
                    return false;
                }
            }
            return !ComputerUtil.isNegativeCounter(type, tgt);
        }
        return super.chooseBinary(kindOfChoice, sa, params);
    }
}

