/*
 * Decompiled with CFR 0.152.
 */
package forge.ai.ability;

import com.google.common.collect.Iterables;
import forge.ai.ComputerUtil;
import forge.ai.ComputerUtilCard;
import forge.ai.SpellAbilityAi;
import forge.game.Game;
import forge.game.ability.AbilityUtils;
import forge.game.card.Card;
import forge.game.card.CardCollection;
import forge.game.card.CardCopyService;
import forge.game.card.CardLists;
import forge.game.card.CardPredicates;
import forge.game.card.CounterEnumType;
import forge.game.card.CounterType;
import forge.game.keyword.Keyword;
import forge.game.phase.PhaseHandler;
import forge.game.phase.PhaseType;
import forge.game.player.Player;
import forge.game.player.PlayerCollection;
import forge.game.spellability.SpellAbility;
import forge.game.zone.ZoneType;
import forge.util.MyRandom;
import java.util.List;
import java.util.Map;

public class CountersMoveAi
extends SpellAbilityAi {
    @Override
    protected boolean checkApiLogic(Player ai, SpellAbility sa) {
        if (sa.usesTargeting()) {
            sa.resetTargets();
            if (!this.moveTgtAI(ai, sa)) {
                return false;
            }
        }
        if (!CountersMoveAi.playReusable(ai, sa)) {
            return false;
        }
        return MyRandom.getRandom().nextFloat() < 0.8f;
    }

    @Override
    protected boolean checkPhaseRestrictions(Player ai, SpellAbility sa, PhaseHandler ph) {
        CounterType cType;
        Card host = sa.getHostCard();
        String type = sa.getParam("CounterType");
        CounterType counterType = cType = "Any".equals(type) ? null : CounterType.getType(type);
        if (ComputerUtil.waitForBlocking(sa)) {
            return false;
        }
        if (cType != null && cType.is(CounterEnumType.P1P1) && sa.hasParam("Source")) {
            int amount = CountersMoveAi.calcAmount(sa, cType);
            CardCollection srcCards = AbilityUtils.getDefinedCards(host, sa.getParam("Source"), sa);
            if (ph.getPlayerTurn().isOpponentOf(ai) && ph.inCombat() && ph.getPhase().isBefore(PhaseType.COMBAT_DECLARE_BLOCKERS)) {
                for (Card c : srcCards) {
                    int a;
                    if (!ph.isPlayerTurn(c.getController()) || (a = c.getCounters(cType)) < amount || !ph.getCombat().isAttacking(c)) continue;
                    Card cpy = CardCopyService.getLKICopy(c);
                    cpy.setCounters(cType, (Integer)(a - amount));
                    if (cpy.getNetToughness() <= cpy.getDamage()) {
                        return true;
                    }
                    if (ComputerUtilCard.canBeBlockedProfitably(ai, cpy, false)) continue;
                    return true;
                }
                return false;
            }
            return ph.getNextTurn().equals(ai) && !ph.getPhase().isBefore(PhaseType.END_OF_TURN);
        }
        if (cType != null && cType.is(CounterEnumType.P1P1) && sa.hasParam("Defined")) {
            if (!ph.getPlayerTurn().isOpponentOf(ai) || !ph.inCombat() || ph.getPhase().isBefore(PhaseType.COMBAT_DECLARE_BLOCKERS)) {
                // empty if block
            }
            if (!ph.getNextTurn().equals(ai) || ph.getPhase().isBefore(PhaseType.END_OF_TURN)) {
                return false;
            }
            if ("Self".equals(sa.getParam("Source"))) {
                return host == null || host.getNetToughness() - 1 > 0;
            }
        }
        return true;
    }

    @Override
    protected boolean doTriggerAINoCost(Player ai, SpellAbility sa, boolean mandatory) {
        if (sa.usesTargeting()) {
            sa.resetTargets();
            if (!this.moveTgtAI(ai, sa) && !mandatory) {
                return false;
            }
            if (!sa.isTargetNumberValid() && mandatory) {
                Game game = ai.getGame();
                CardCollection tgtCards = CardLists.getTargetableCards(game.getCardsIn(ZoneType.Battlefield), sa);
                if (tgtCards.isEmpty()) {
                    return false;
                }
                Card card = ComputerUtilCard.getWorstAI(tgtCards);
                sa.getTargets().add(card);
            }
            return true;
        }
        if (mandatory) {
            return true;
        }
        Card host = sa.getHostCard();
        String type = sa.getParam("CounterType");
        CounterType cType = "Any".equals(type) ? null : CounterType.getType(type);
        CardCollection srcCards = AbilityUtils.getDefinedCards(host, sa.getParam("Source"), sa);
        CardCollection destCards = AbilityUtils.getDefinedCards(host, sa.getParam("Defined"), sa);
        if (srcCards.isEmpty() || destCards.isEmpty()) {
            return false;
        }
        Card src = (Card)srcCards.get(0);
        Card dest = (Card)destCards.get(0);
        if (!dest.getController().equals(ai)) {
            return false;
        }
        if (ComputerUtilCard.isUselessCreature(ai, dest)) {
            return false;
        }
        if (dest.hasSVar("EndOfTurnLeavePlay")) {
            return false;
        }
        if (cType != null) {
            if (!dest.canReceiveCounters(cType)) {
                return false;
            }
            int amount = CountersMoveAi.calcAmount(sa, cType);
            int a = src.getCounters(cType);
            if (a < amount) {
                return false;
            }
            Card srcCopy = CardCopyService.getLKICopy(src);
            srcCopy.setCounters(cType, (Integer)(a - amount));
            Card destCopy = CardCopyService.getLKICopy(dest);
            destCopy.setCounters(cType, (Integer)(dest.getCounters(cType) + amount));
            int oldEval = ComputerUtilCard.evaluateCreature(src) + ComputerUtilCard.evaluateCreature(dest);
            int newEval = ComputerUtilCard.evaluateCreature(srcCopy) + ComputerUtilCard.evaluateCreature(destCopy);
            if (newEval < oldEval) {
                return false;
            }
            if ("DontMoveCounterIfLethal".equals(sa.getParam("AILogic"))) {
                return !cType.is(CounterEnumType.P1P1) || src.getNetToughness() - src.getTempToughnessBoost() - 1 > 0;
            }
        }
        return true;
    }

    @Override
    public boolean chkAIDrawback(SpellAbility sa, Player ai) {
        if (sa.usesTargeting()) {
            sa.resetTargets();
            return this.moveTgtAI(ai, sa);
        }
        return true;
    }

    private static int calcAmount(SpellAbility sa, CounterType cType) {
        Card host = sa.getHostCard();
        String amountStr = sa.getParamOrDefault("CounterNum", "1");
        int amount = 0;
        if (amountStr.equals("All") || amountStr.equals("Any")) {
            if (sa.hasParam("Source")) {
                CardCollection srcCards = AbilityUtils.getDefinedCards(host, sa.getParam("Source"), sa);
                for (Card c : srcCards) {
                    amount += c.getCounters(cType);
                }
            }
        } else {
            amount = AbilityUtils.calculateAmount(host, amountStr, sa);
        }
        return amount;
    }

    private boolean moveTgtAI(Player ai, SpellAbility sa) {
        CardCollection oppList;
        Card card2;
        Card host = sa.getHostCard();
        Game game = ai.getGame();
        String type = sa.getParam("CounterType");
        CounterType cType = "Any".equals(type) || "All".equals(type) ? null : CounterType.getType(type);
        CardCollection tgtCards = CardLists.getTargetableCards(game.getCardsIn(ZoneType.Battlefield), sa);
        if (sa.hasParam("Defined")) {
            int amount = CountersMoveAi.calcAmount(sa, cType);
            tgtCards = CardLists.filter((Iterable<Card>)tgtCards, CardPredicates.hasCounter(cType));
            CardCollection destCards = AbilityUtils.getDefinedCards(host, sa.getParam("Defined"), sa);
            if (destCards.isEmpty()) {
                return false;
            }
            Card dest = (Card)destCards.get(0);
            tgtCards.remove(dest);
            if (cType != null && !dest.canReceiveCounters(cType)) {
                return false;
            }
            CardCollection oppList2 = CardLists.filterControlledBy((Iterable<Card>)tgtCards, ai.getOpponents());
            if (!oppList2.isEmpty()) {
                Card card3;
                CardCollection best = CardLists.filter((Iterable<Card>)oppList2, card -> {
                    if (ComputerUtilCard.isUselessCreature(ai, card)) {
                        return false;
                    }
                    Card srcCardCpy = CardCopyService.getLKICopy(card);
                    srcCardCpy.setCounters(cType, (Integer)(srcCardCpy.getCounters(cType) - amount));
                    if (cType != null && cType.is(CounterEnumType.P1P1) && srcCardCpy.getNetToughness() <= 0) {
                        return srcCardCpy.getCounters(cType) > 0 || !card.hasKeyword(Keyword.UNDYING) || card.isToken();
                    }
                    return true;
                });
                if (best.isEmpty()) {
                    best = oppList2;
                }
                if ((card3 = ComputerUtilCard.getBestCreatureAI(best)) != null) {
                    sa.getTargets().add(card3);
                    return true;
                }
            }
            PlayerCollection ally = ai.getAllies();
            ally.add(ai);
            CardCollection aiList = CardLists.filterControlledBy((Iterable<Card>)tgtCards, ally);
            if (!aiList.isEmpty()) {
                Card card4;
                CardCollection best = CardLists.filter((Iterable<Card>)aiList, card -> {
                    if (ComputerUtilCard.isUselessCreature(ai, card)) {
                        return true;
                    }
                    if (card.hasSVar("EndOfTurnLeavePlay")) {
                        return true;
                    }
                    if (cType != null && cType.is(CounterEnumType.P1P1) && (card.hasKeyword(Keyword.UNDYING) || card.hasKeyword(Keyword.EVOLVE) || card.hasKeyword(Keyword.ADAPT))) {
                        return true;
                    }
                    return cType != null && cType.is(CounterEnumType.M1M1) && card.hasKeyword(Keyword.PERSIST);
                });
                if (best.isEmpty()) {
                    best = aiList;
                }
                if ((card4 = ComputerUtilCard.getWorstCreatureAI(best)) != null) {
                    sa.getTargets().add(card4);
                    return true;
                }
            }
            return false;
        }
        if (sa.getMaxTargets() == 2) {
            return false;
        }
        CardCollection srcCards = AbilityUtils.getDefinedCards(host, sa.getParam("Source"), sa);
        if (srcCards.isEmpty()) {
            return false;
        }
        Card src = (Card)srcCards.get(0);
        if (cType != null && src.getCounters(cType) <= 0) {
            return false;
        }
        Card lkiWithCounters = CardCopyService.getLKICopy(src);
        Card lkiWithoutCounters = CardCopyService.getLKICopy(src);
        if (cType == null) {
            lkiWithoutCounters.clearCounters();
        } else {
            lkiWithoutCounters.setCounters(cType, (Integer)0);
        }
        lkiWithCounters.addType("Creature");
        lkiWithoutCounters.addType("Creature");
        if (ComputerUtilCard.evaluateCreature(lkiWithCounters) > ComputerUtilCard.evaluateCreature(lkiWithoutCounters)) {
            boolean isMandatoryTrigger;
            CardCollection aiList = CardLists.filterControlledBy((Iterable<Card>)tgtCards, ai);
            if (!aiList.isEmpty()) {
                CardCollection best = CardLists.filter((Iterable<Card>)aiList, card -> {
                    if (ComputerUtilCard.isUselessCreature(ai, card)) {
                        return false;
                    }
                    if (card.hasSVar("EndOfTurnLeavePlay")) {
                        return false;
                    }
                    if (cType != null) {
                        if (cType.is(CounterEnumType.P1P1) && card.hasKeyword(Keyword.UNDYING)) {
                            return false;
                        }
                        if (cType.is(CounterEnumType.M1M1)) {
                            return false;
                        }
                        if (!card.canReceiveCounters(cType)) {
                            return false;
                        }
                    }
                    return true;
                });
                if (best.isEmpty()) {
                    best = aiList;
                }
                if ((card2 = ComputerUtilCard.getBestCreatureAI(best)) != null) {
                    sa.getTargets().add(card2);
                    return true;
                }
            }
            boolean bl = isMandatoryTrigger = sa.isTrigger() && !sa.isOptionalTrigger() || sa.getRootAbility().isTrigger() && !sa.getRootAbility().isOptionalTrigger();
            if (!isMandatoryTrigger) {
                return false;
            }
        }
        if (!(oppList = CardLists.filterControlledBy((Iterable<Card>)tgtCards, ai.getOpponents())).isEmpty()) {
            CardCollection best = CardLists.filter((Iterable<Card>)oppList, card -> {
                if (!ComputerUtilCard.isUselessCreature(ai, card)) {
                    return true;
                }
                return !card.hasSVar("EndOfTurnLeavePlay");
            });
            if (best.isEmpty()) {
                best = oppList;
            }
            if ((card2 = ComputerUtilCard.getBestCreatureAI(best)) != null) {
                sa.getTargets().add(card2);
                return true;
            }
        }
        return false;
    }

    @Override
    protected Card chooseSingleCard(Player ai, SpellAbility sa, Iterable<Card> options, boolean isOptional, Player targetedPlayer, Map<String, Object> params) {
        if (sa.hasParam("AILogic")) {
            String logic = sa.getParam("AILogic");
            if ("ToValid".equals(logic)) {
                CardCollection aiCards = CardLists.filterControlledBy(options, ai);
                return ComputerUtilCard.getBestCreatureAI(aiCards);
            }
            if ("FromValid".equals(logic)) {
                return ComputerUtilCard.getWorstCreatureAI(options);
            }
        }
        return Iterables.getFirst(options, null);
    }

    @Override
    public int chooseNumber(Player player, SpellAbility sa, int min2, int max, Map<String, Object> params) {
        return max;
    }

    @Override
    public CounterType chooseCounterType(List<CounterType> options, SpellAbility sa, Map<String, Object> params) {
        return super.chooseCounterType(options, sa, params);
    }
}

