/*
 * Decompiled with CFR 0.152.
 */
package forge.ai.ability;

import forge.ai.AiCardMemory;
import forge.ai.AiPlayDecision;
import forge.ai.AiProps;
import forge.ai.ComputerUtilCard;
import forge.ai.PlayerControllerAi;
import forge.ai.SpecialCardAi;
import forge.ai.SpellAbilityAi;
import forge.game.Game;
import forge.game.ability.ApiType;
import forge.game.player.Player;
import forge.game.player.PlayerActionConfirmMode;
import forge.game.spellability.Spell;
import forge.game.spellability.SpellAbility;
import forge.util.MyRandom;
import java.util.List;
import java.util.Map;

public class CopySpellAbilityAi
extends SpellAbilityAi {
    @Override
    protected boolean canPlayAI(Player aiPlayer, SpellAbility sa) {
        Game game = aiPlayer.getGame();
        int chance = ((PlayerControllerAi)aiPlayer.getController()).getAi().getIntProperty(AiProps.CHANCE_TO_COPY_OWN_SPELL_WHILE_ON_STACK);
        int diff = ((PlayerControllerAi)aiPlayer.getController()).getAi().getIntProperty(AiProps.ALWAYS_COPY_SPELL_IF_CMC_DIFF);
        String logic = sa.getParamOrDefault("AILogic", "");
        if (game.getStack().isEmpty()) {
            return sa.isMandatory();
        }
        SpellAbility top = game.getStack().peekAbility();
        if (top != null && top.getPayCosts().getCostMana() != null && sa.getPayCosts().getCostMana() != null && top.getPayCosts().getCostMana().getMana().getCMC() >= sa.getPayCosts().getCostMana().getMana().getCMC() + diff) {
            chance = 100;
        }
        if (top.getActivatingPlayer().isOpponentOf(aiPlayer)) {
            chance = 100;
        }
        if (!(MyRandom.percentTrue(chance) || "AlwaysIfViable".equals(logic) || "OnceIfViable".equals(logic) || "AlwaysCopyActivatedAbilities".equals(logic))) {
            return false;
        }
        if ("OnceIfViable".equals(logic) && AiCardMemory.isRememberedCard(aiPlayer, sa.getHostCard(), AiCardMemory.MemorySet.ACTIVATED_THIS_TURN)) {
            return false;
        }
        if (sa.usesTargeting()) {
            if ("OnlyOwned".equals(sa.getParam("AITgts")) && !top.getActivatingPlayer().equals(aiPlayer)) {
                return false;
            }
            if (top.isWrapper() || top.isActivatedAbility()) {
                return false;
            }
            if (top.getApi() == ApiType.CopySpellAbility) {
                return false;
            }
            if (top.getApi() == ApiType.Mana) {
                return false;
            }
            if (top.getApi() == ApiType.DestroyAll || top.getApi() == ApiType.SacrificeAll || top.getApi() == ApiType.ChangeZoneAll || top.getApi() == ApiType.TapAll || top.getApi() == ApiType.UnattachAll) {
                if (!top.usesTargeting() || top.getActivatingPlayer().equals(aiPlayer)) {
                    return false;
                }
            } else {
                if (top.hasParam("ConditionManaSpent") || top.getHostCard().hasSVar("AINoCopy")) {
                    return false;
                }
                if (ComputerUtilCard.isCardRemAIDeck(top.getHostCard())) {
                    return false;
                }
            }
            SpellAbility topCopy = top.copy(aiPlayer);
            topCopy.clearManaPaid();
            topCopy.resetTargets();
            if (top.canBeTargetedBy(sa)) {
                AiPlayDecision decision = AiPlayDecision.CantPlaySa;
                if (top instanceof Spell) {
                    decision = ((PlayerControllerAi)aiPlayer.getController()).getAi().canPlayFromEffectAI((Spell)topCopy, false, true);
                } else if (top.isActivatedAbility() && top.getActivatingPlayer().equals(aiPlayer) && logic.contains("CopyActivatedAbilities")) {
                    decision = AiPlayDecision.WillPlay;
                }
                if (decision == AiPlayDecision.WillPlay) {
                    sa.getTargets().add(top);
                    AiCardMemory.rememberCard(aiPlayer, sa.getHostCard(), AiCardMemory.MemorySet.ACTIVATED_THIS_TURN);
                    return true;
                }
            }
        }
        return sa.isMandatory() || "Always".equals(logic);
    }

    @Override
    protected boolean doTriggerAINoCost(Player aiPlayer, SpellAbility sa, boolean mandatory) {
        String logic = sa.getParamOrDefault("AILogic", "");
        return mandatory || logic.contains("Always");
    }

    @Override
    public boolean chkAIDrawback(SpellAbility sa, Player aiPlayer) {
        if ("ChainOfSmog".equals(sa.getParam("AILogic"))) {
            return SpecialCardAi.ChainOfSmog.consider(aiPlayer, sa);
        }
        if ("ChainOfAcid".equals(sa.getParam("AILogic"))) {
            return SpecialCardAi.ChainOfAcid.consider(aiPlayer, sa);
        }
        return this.canPlayAI(aiPlayer, sa) || sa.isMandatory() && super.chkAIDrawback(sa, aiPlayer);
    }

    @Override
    public SpellAbility chooseSingleSpellAbility(Player player, SpellAbility sa, List<SpellAbility> spells, Map<String, Object> params) {
        return spells.get(0);
    }

    @Override
    public boolean confirmAction(Player player, SpellAbility sa, PlayerActionConfirmMode mode, String message, Map<String, Object> params) {
        if ("ChainOfAcid".equals(sa.getParam("AILogic"))) {
            return SpecialCardAi.ChainOfAcid.consider(player, sa);
        }
        return true;
    }
}

