/*
 * Decompiled with CFR 0.152.
 */
package forge.ai.ability;

import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import forge.ai.ComputerUtilCard;
import forge.ai.SpellAbilityAi;
import forge.game.card.Card;
import forge.game.card.CardCollection;
import forge.game.card.CardLists;
import forge.game.card.CardPredicates;
import forge.game.player.Player;
import forge.game.spellability.SpellAbility;
import forge.game.zone.ZoneType;
import java.util.Map;

public class ControlGainVariantAi
extends SpellAbilityAi {
    @Override
    protected boolean canPlayAI(Player ai, SpellAbility sa) {
        String logic = sa.getParam("AILogic");
        if ("GainControlOwns".equals(logic)) {
            CardCollection list = CardLists.filter((Iterable<Card>)ai.getGame().getCardsIn(ZoneType.Battlefield), crd -> crd.isCreature() && !crd.getController().equals(crd.getOwner()));
            if (list.isEmpty()) {
                return false;
            }
            for (Card c : list) {
                if (!ai.equals(c.getController())) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public Card chooseSingleCard(Player ai, SpellAbility sa, Iterable<Card> options, boolean isOptional, Player targetedPlayer, Map<String, Object> params) {
        CardCollection otherCtrl = CardLists.filter(options, Predicates.not(CardPredicates.isController(ai)));
        if (Iterables.isEmpty(otherCtrl)) {
            return ComputerUtilCard.getWorstAI(options);
        }
        return ComputerUtilCard.getBestAI(otherCtrl);
    }
}

