/*
 * Decompiled with CFR 0.152.
 */
package forge.ai.ability;

import com.google.common.collect.Lists;
import forge.ai.ComputerUtilCard;
import forge.ai.SpecialCardAi;
import forge.ai.SpellAbilityAi;
import forge.game.CardTraitBase;
import forge.game.ability.AbilityUtils;
import forge.game.card.Card;
import forge.game.card.CardCollection;
import forge.game.card.CardCollectionView;
import forge.game.card.CardLists;
import forge.game.player.Player;
import forge.game.spellability.SpellAbility;
import forge.game.spellability.TargetRestrictions;
import forge.game.zone.ZoneType;
import forge.util.MyRandom;

public class ControlExchangeAi
extends SpellAbilityAi {
    @Override
    protected boolean canPlayAI(Player ai, SpellAbility sa) {
        Card object1 = null;
        Card object2 = null;
        TargetRestrictions tgt = sa.getTargetRestrictions();
        sa.resetTargets();
        CardCollection list = CardLists.getValidCards((Iterable<Card>)ai.getOpponents().getCardsIn(ZoneType.Battlefield), tgt.getValidTgts(), ai, sa.getHostCard(), (CardTraitBase)sa);
        list = CardLists.filter((Iterable<Card>)list, c -> !ComputerUtilCard.isCardRemAIDeck(c) && c.canBeTargetedBy(sa));
        object1 = ComputerUtilCard.getBestAI(list);
        if (sa.hasParam("Defined")) {
            object2 = (Card)AbilityUtils.getDefinedCards(sa.getHostCard(), sa.getParam("Defined"), sa).get(false);
        } else if (tgt.getMinTargets(sa.getHostCard(), sa) > 1) {
            CardCollectionView list2 = ai.getCardsIn(ZoneType.Battlefield);
            list2 = CardLists.getValidCards((Iterable<Card>)list2, tgt.getValidTgts(), ai, sa.getHostCard(), (CardTraitBase)sa);
            object2 = ComputerUtilCard.getWorstAI(list2);
            sa.getTargets().add(object2);
        }
        if (object1 == null || object2 == null) {
            return false;
        }
        if (ComputerUtilCard.evaluateCreature(object1) > ComputerUtilCard.evaluateCreature(object2) + 40) {
            sa.getTargets().add(object1);
            return (double)MyRandom.getRandom().nextFloat() <= Math.pow(0.6667, sa.getActivationsThisTurn());
        }
        return false;
    }

    @Override
    protected boolean doTriggerAINoCost(Player aiPlayer, SpellAbility sa, boolean mandatory) {
        if (!sa.usesTargeting()) {
            if (mandatory) {
                return true;
            }
        } else {
            if (mandatory) {
                return this.chkAIDrawback(sa, aiPlayer) || sa.isTargetNumberValid();
            }
            return this.canPlayAI(aiPlayer, sa);
        }
        return true;
    }

    @Override
    public boolean chkAIDrawback(SpellAbility sa, Player aiPlayer) {
        Card object;
        Card realBest;
        if (!sa.usesTargeting()) {
            return true;
        }
        TargetRestrictions tgt = sa.getTargetRestrictions();
        if ("PowerStruggle".equals(sa.getParam("AILogic"))) {
            return SpecialCardAi.PowerStruggle.considerSecondTarget(aiPlayer, sa);
        }
        CardCollectionView unfilteredList = "TrigTwoTargets".equals(sa.getParam("AILogic")) ? aiPlayer.getOpponents().getCardsIn(ZoneType.Battlefield) : aiPlayer.getGame().getCardsIn(ZoneType.Battlefield);
        CardCollection list = CardLists.getValidCards((Iterable<Card>)unfilteredList, tgt.getValidTgts(), aiPlayer, sa.getHostCard(), (CardTraitBase)sa);
        if ((list = CardLists.getTargetableCards(list, sa)).isEmpty()) {
            return false;
        }
        Card best = ComputerUtilCard.getBestAI(list);
        sa.getTargets().add(best);
        if (sa.hasParam("Defined") && (!sa.isTrigger() || sa.getRootAbility().isOptionalTrigger()) && !best.equals(realBest = ComputerUtilCard.getBestAI(Lists.newArrayList(best, object = (Card)AbilityUtils.getDefinedCards(sa.getHostCard(), sa.getParam("Defined"), sa).get(false))))) {
            return false;
        }
        if ("TrigTwoTargets".equals(sa.getParam("AILogic"))) {
            return this.doTrigTwoTargetsLogic(aiPlayer, sa, best);
        }
        return true;
    }

    private boolean doTrigTwoTargetsLogic(Player ai, SpellAbility sa, Card bestFirstTgt) {
        TargetRestrictions tgt = sa.getTargetRestrictions();
        int creatureThreshold = 100;
        int nonCreatureThreshold = 2;
        CardCollection list = CardLists.getValidCards((Iterable<Card>)ai.getCardsIn(ZoneType.Battlefield), tgt.getValidTgts(), ai, sa.getHostCard(), (CardTraitBase)sa);
        if ((list = CardLists.getTargetableCards(list, sa)).isEmpty()) {
            return false;
        }
        Card aiWorst = ComputerUtilCard.getWorstAI(list);
        if (aiWorst == null) {
            return false;
        }
        if (aiWorst != bestFirstTgt) {
            if (bestFirstTgt.isCreature() && aiWorst.isCreature()) {
                if (ComputerUtilCard.evaluateCreature(bestFirstTgt) > ComputerUtilCard.evaluateCreature(aiWorst) + 100 || sa.isMandatory()) {
                    sa.getTargets().add(aiWorst);
                    return true;
                }
            } else if (bestFirstTgt.getCMC() > aiWorst.getCMC() + 2 || sa.isMandatory()) {
                sa.getTargets().add(aiWorst);
                return true;
            }
        }
        sa.clearTargets();
        return false;
    }
}

