/*
 * Decompiled with CFR 0.152.
 */
package forge.ai.ability;

import forge.ai.ComputerUtil;
import forge.ai.ComputerUtilCard;
import forge.ai.ComputerUtilMana;
import forge.ai.SpellAbilityAi;
import forge.game.card.Card;
import forge.game.card.CardCollection;
import forge.game.card.CardLists;
import forge.game.player.Player;
import forge.game.spellability.SpellAbility;
import forge.game.zone.ZoneType;

public class ConniveAi
extends SpellAbilityAi {
    @Override
    protected boolean canPlayAI(Player ai, SpellAbility sa) {
        if (!ai.canDraw()) {
            return false;
        }
        CardCollection list = CardLists.getTargetableCards(ai.getCardsIn(ZoneType.Battlefield), sa);
        list = ComputerUtil.filterAITgts(sa, ai, list, false);
        if ("X".equals(sa.getParam("TargetMax")) && "Count$xPaid".equals(sa.getSVar("X"))) {
            int maxTargets = Math.min(list.size(), Math.max(0, ai.getCardsIn(ZoneType.Library).size() - 5));
            maxTargets = Math.min(maxTargets, ComputerUtilMana.getAvailableManaEstimate(ai));
            sa.setXManaCostPaid(maxTargets);
        }
        sa.resetTargets();
        while (sa.canAddMoreTarget()) {
            if (list.isEmpty() && sa.isTargetNumberValid() && !sa.getTargets().isEmpty()) {
                return true;
            }
            if (list.isEmpty()) {
                list = CardLists.getTargetableCards(ai.getCardsIn(ZoneType.Battlefield), sa);
            }
            if (list.isEmpty()) {
                return sa.isTargetNumberValid();
            }
            Card choice = ComputerUtilCard.getBestCreatureAI(list);
            if (choice != null) {
                sa.getTargets().add(choice);
                list.remove(choice);
                continue;
            }
            list.clear();
        }
        return !sa.getTargets().isEmpty() && sa.isTargetNumberValid();
    }

    @Override
    protected boolean doTriggerAINoCost(Player ai, SpellAbility sa, boolean mandatory) {
        if (!ai.canDraw() && !mandatory) {
            return false;
        }
        boolean preferred = true;
        CardCollection list = CardLists.getTargetableCards(ai.getCardsIn(ZoneType.Battlefield), sa);
        list = ComputerUtil.filterAITgts(sa, ai, list, false);
        sa.resetTargets();
        while (sa.canAddMoreTarget()) {
            if (mandatory) {
                if ((list.isEmpty() || !preferred) && sa.isTargetNumberValid()) {
                    return true;
                }
                if (list.isEmpty() && preferred) {
                    list = CardLists.getTargetableCards(ai.getOpponents().getCardsIn(ZoneType.Battlefield), sa);
                    preferred = false;
                }
                if (list.isEmpty()) {
                    list = CardLists.getTargetableCards(ai.getCardsIn(ZoneType.Battlefield), sa);
                    preferred = false;
                }
            }
            if (list.isEmpty()) {
                return sa.isTargetNumberValid();
            }
            Card choice = ComputerUtilCard.getBestCreatureAI(list);
            if (choice != null) {
                sa.getTargets().add(choice);
                list.remove(choice);
                continue;
            }
            list.clear();
        }
        return true;
    }
}

