/*
 * Decompiled with CFR 0.152.
 */
package forge.ai.ability;

import com.google.common.collect.Iterables;
import forge.ai.ComputerUtilCard;
import forge.ai.SpellAbilityAi;
import forge.game.card.Card;
import forge.game.card.CardCollection;
import forge.game.card.CardCollectionView;
import forge.game.card.CardLists;
import forge.game.card.CardPredicates;
import forge.game.player.Player;
import forge.game.player.PlayerCollection;
import forge.game.player.PlayerPredicates;
import forge.game.spellability.SpellAbility;
import forge.game.zone.ZoneType;
import java.util.Map;

public class ClashAi
extends SpellAbilityAi {
    @Override
    protected boolean doTriggerAINoCost(Player aiPlayer, SpellAbility sa, boolean mandatory) {
        boolean legalAction = true;
        if (sa.usesTargeting()) {
            legalAction = this.selectTarget(aiPlayer, sa);
        }
        return legalAction;
    }

    @Override
    protected boolean checkApiLogic(Player ai, SpellAbility sa) {
        boolean legalAction = true;
        if (sa.usesTargeting()) {
            legalAction = this.selectTarget(ai, sa);
        }
        return legalAction;
    }

    @Override
    protected Player chooseSinglePlayer(Player ai, SpellAbility sa, Iterable<Player> options, Map<String, Object> params) {
        for (Player p : options) {
            if (!p.getCardsIn(ZoneType.Library).isEmpty()) continue;
            return p;
        }
        CardCollectionView col = ai.getCardsIn(ZoneType.Library);
        if (!col.isEmpty() && ((Card)col.getFirst()).mayPlayerLook(ai)) {
            Card top = (Card)col.get(false);
            for (Player p : options) {
                Card oppTop = (Card)p.getCardsIn(ZoneType.Library).getFirst();
                if (top.getCMC() <= oppTop.getCMC()) continue;
                return p;
            }
        }
        return Iterables.getFirst(options, null);
    }

    private boolean selectTarget(Player ai, SpellAbility sa) {
        String valid = sa.getParam("ValidTgts");
        PlayerCollection players = ai.getOpponents().filter(PlayerPredicates.isTargetableBy(sa));
        Player chosen = this.chooseSinglePlayer(ai, sa, players, null);
        if (chosen != null) {
            sa.resetTargets();
            sa.getTargets().add(chosen);
        }
        if ("Creature".equals(valid)) {
            Card tgt;
            CardCollection aiCreats = ai.getCreaturesInPlay();
            CardCollection oppCreats = CardLists.filter((Iterable<Card>)ai.getOpponents().getCardsIn(ZoneType.Battlefield), CardPredicates.Presets.CREATURES);
            Card card = tgt = aiCreats.isEmpty() ? ComputerUtilCard.getWorstCreatureAI(oppCreats) : ComputerUtilCard.getBestCreatureAI(aiCreats);
            if (tgt != null) {
                sa.resetTargets();
                sa.getTargets().add(tgt);
            } else {
                return false;
            }
        }
        return sa.getTargets().size() > 0;
    }
}

