/*
 * Decompiled with CFR 0.152.
 */
package forge.ai.ability;

import com.google.common.collect.Iterables;
import forge.ai.AiController;
import forge.ai.AiPlayerPredicates;
import forge.ai.AiProps;
import forge.ai.ComputerUtil;
import forge.ai.ComputerUtilAbility;
import forge.ai.ComputerUtilCard;
import forge.ai.ComputerUtilCombat;
import forge.ai.ComputerUtilCost;
import forge.ai.PlayerControllerAi;
import forge.ai.SpecialCardAi;
import forge.ai.SpellAbilityAi;
import forge.game.Game;
import forge.game.ability.AbilityUtils;
import forge.game.card.Card;
import forge.game.card.CardCollection;
import forge.game.card.CardCollectionView;
import forge.game.card.CardLists;
import forge.game.card.CardPredicates;
import forge.game.cost.Cost;
import forge.game.phase.PhaseType;
import forge.game.player.Player;
import forge.game.player.PlayerActionConfirmMode;
import forge.game.player.PlayerCollection;
import forge.game.player.PlayerPredicates;
import forge.game.spellability.SpellAbility;
import forge.game.zone.ZoneType;
import forge.util.MyRandom;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;

public class ChangeZoneAllAi
extends SpellAbilityAi {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected boolean canPlayAI(Player ai, SpellAbility sa) {
        Cost abCost = sa.getPayCosts();
        Card source = sa.getHostCard();
        String sourceName = ComputerUtilAbility.getAbilitySourceName(sa);
        Game game = ai.getGame();
        ZoneType destination = ZoneType.smartValueOf(sa.getParam("Destination"));
        ZoneType origin = ZoneType.listValueOf(sa.getParam("Origin")).get(0);
        String aiLogic = sa.getParamOrDefault("AILogic", "");
        if (abCost != null) {
            boolean aiLogicAllowsDiscard;
            if (!ComputerUtilCost.checkLifeCost(ai, abCost, source, 4, sa)) {
                return false;
            }
            if (!ComputerUtilCost.checkDiscardCost(ai, abCost, source, sa) && !(aiLogicAllowsDiscard = aiLogic.startsWith("DiscardAll"))) {
                return false;
            }
        }
        boolean chance = (double)MyRandom.getRandom().nextFloat() <= Math.pow(0.6667, sa.getActivationsThisTurn());
        CardCollection cardCollection = ai.getOpponents().getCardsIn(origin);
        CardCollectionView computerType = ai.getCardsIn(origin);
        if (sourceName.equals("Ugin, the Spirit Dragon")) {
            return SpecialCardAi.UginTheSpiritDragon.considerPWAbilityPriority(ai, sa, origin, cardCollection, computerType);
        }
        CardCollectionView cardCollectionView = AbilityUtils.filterListByType(cardCollection, sa.getParam("ChangeType"), sa);
        computerType = AbilityUtils.filterListByType(computerType, sa.getParam("ChangeType"), sa);
        if ("LivingDeath".equals(aiLogic)) {
            return SpecialCardAi.LivingDeath.consider(ai, sa);
        }
        if ("Timetwister".equals(aiLogic)) {
            return SpecialCardAi.Timetwister.consider(ai, sa);
        }
        if ("RetDiscardedThisTurn".equals(aiLogic)) {
            if (ai.getDiscardedThisTurn().size() <= 0) return false;
            if (!ai.getGame().getPhaseHandler().is(PhaseType.END_OF_TURN)) return false;
            return true;
        }
        if ("ExileGraveyards".equals(aiLogic)) {
            CardCollection creats;
            Iterator iterator = ai.getOpponents().iterator();
            do {
                if (!iterator.hasNext()) return false;
                Player opp = (Player)iterator.next();
                CardCollectionView cardsGY = opp.getCardsIn(ZoneType.Graveyard);
                creats = CardLists.filter((Iterable<Card>)cardsGY, CardPredicates.Presets.CREATURES);
                if (opp.hasDelirium()) return true;
                if (opp.hasThreshold()) return true;
            } while (creats.size() < 5);
            return true;
        }
        if ("ManifestCreatsFromGraveyard".equals(aiLogic)) {
            Player bestTgt;
            PlayerCollection players = ai.getOpponents();
            players.add(ai);
            int maxSize = 1;
            Iterator cardsGY = players.iterator();
            do {
                int numGY;
                if (!cardsGY.hasNext()) return false;
                Player player = (Player)cardsGY.next();
                bestTgt = null;
                if (!player.canBeTargetedBy(sa) || (numGY = CardLists.count(player.getCardsIn(ZoneType.Graveyard), CardPredicates.Presets.CREATURES)) <= maxSize) continue;
                maxSize = numGY;
                bestTgt = player;
            } while (bestTgt == null);
            sa.resetTargets();
            sa.getTargets().add(bestTgt);
            return true;
        }
        if (origin.equals((Object)ZoneType.Hand) || origin.equals((Object)ZoneType.Library)) {
            if (!sa.usesTargeting()) {
                return true;
            }
            PlayerCollection oppList = ai.getOpponents().filter(PlayerPredicates.isTargetableBy(sa));
            if (oppList.isEmpty()) {
                return false;
            }
            Player oppTarget = oppList.max(PlayerPredicates.compareByZoneSize(origin));
            if (oppTarget.getCardsIn(ZoneType.Hand).isEmpty()) return false;
            sa.resetTargets();
            sa.getTargets().add(oppTarget);
        } else if (origin.equals((Object)ZoneType.Battlefield)) {
            if (sa.usesTargeting()) {
                PlayerCollection oppList = ai.getOpponents().filter(PlayerPredicates.isTargetableBy(sa));
                if (oppList.isEmpty()) {
                    return false;
                }
                Player oppTarget = oppList.max(PlayerPredicates.compareByZoneSize(origin));
                if (!oppTarget.getCardsIn(ZoneType.Graveyard).isEmpty()) return false;
                sa.resetTargets();
                sa.getTargets().add(oppTarget);
                computerType = new CardCollection();
            }
            int creatureEvalThreshold = 200;
            int nonCreatureEvalThreshold = 3;
            if (ai.getController().isAI()) {
                AiController aic = ((PlayerControllerAi)ai.getController()).getAi();
                if (destination == ZoneType.Hand) {
                    creatureEvalThreshold = aic.getIntProperty(AiProps.BOUNCE_ALL_TO_HAND_CREAT_EVAL_DIFF);
                    nonCreatureEvalThreshold = aic.getIntProperty(AiProps.BOUNCE_ALL_TO_HAND_NONCREAT_EVAL_DIFF);
                } else {
                    creatureEvalThreshold = aic.getIntProperty(AiProps.BOUNCE_ALL_ELSEWHERE_CREAT_EVAL_DIFF);
                    nonCreatureEvalThreshold = aic.getIntProperty(AiProps.BOUNCE_ALL_ELSEWHERE_NONCREAT_EVAL_DIFF);
                }
            }
            if (CardLists.getNotType(cardCollectionView, "Creature").isEmpty() && CardLists.getNotType(computerType, "Creature").isEmpty()) {
                if (game.getCombat() != null && ComputerUtilCombat.lifeInSeriousDanger(ai, game.getCombat()) && game.getPhaseHandler().is(PhaseType.COMBAT_DECLARE_BLOCKERS) && game.getPhaseHandler().getPlayerTurn().isOpponentOf(ai)) {
                    return true;
                }
                if (ComputerUtilCard.evaluateCreatureList(computerType) + creatureEvalThreshold >= ComputerUtilCard.evaluateCreatureList(cardCollectionView)) {
                    return false;
                }
            } else if (ComputerUtilCard.evaluatePermanentList(computerType) + nonCreatureEvalThreshold >= ComputerUtilCard.evaluatePermanentList(cardCollectionView)) {
                return false;
            }
            if (game.getPhaseHandler().is(PhaseType.MAIN1, ai) && !aiLogic.equals("Main1")) {
                return false;
            }
        } else if (origin.equals((Object)ZoneType.Graveyard)) {
            if (sa.usesTargeting()) {
                PlayerCollection oppList = ai.getOpponents().filter(PlayerPredicates.isTargetableBy(sa));
                if (oppList.isEmpty()) {
                    return false;
                }
                Player oppTarget = Collections.max(oppList, AiPlayerPredicates.compareByZoneValue(sa.getParam("ChangeType"), origin, sa));
                if (oppTarget.getCardsIn(ZoneType.Graveyard).isEmpty()) return false;
                sa.resetTargets();
                sa.getTargets().add(oppTarget);
            } else if (destination.equals((Object)ZoneType.Library) && "Card.YouOwn".equals(sa.getParam("ChangeType"))) {
                if (ai.getCardsIn(ZoneType.Graveyard).size() <= ai.getCardsIn(ZoneType.Library).size()) return false;
                if (ComputerUtil.isPlayingReanimator(ai)) return false;
                return true;
            }
        } else if (origin.equals((Object)ZoneType.Exile)) {
            if (aiLogic.startsWith("DiscardAllAndRetExiled")) {
                int numExiledWithSrc = CardLists.filter((Iterable<Card>)ai.getCardsIn(ZoneType.Exile), CardPredicates.isExiledWith(source)).size();
                int curHandSize = ai.getCardsIn(ZoneType.Hand).size();
                int minAdv = aiLogic.contains(".minAdv") ? Integer.parseInt(aiLogic.substring(aiLogic.indexOf(".minAdv") + 7)) : 0;
                boolean noDiscard = aiLogic.contains(".noDiscard");
                if ((numExiledWithSrc > curHandSize || noDiscard && numExiledWithSrc > 0) && ComputerUtil.predictThreatenedObjects(ai, sa, true).contains(source)) {
                    return true;
                }
                if (curHandSize + minAdv - 1 < numExiledWithSrc) return true;
                if (noDiscard) return false;
                if (numExiledWithSrc < ai.getMaxHandSize()) return false;
                return true;
            }
        } else if (origin.equals((Object)ZoneType.Stack)) {
            return false;
        }
        if (destination.equals((Object)ZoneType.Battlefield) && (sa.hasParam("GainControl") ? (CardLists.getNotType(cardCollectionView, "Creature").isEmpty() && CardLists.getNotType(computerType, "Creature").isEmpty() ? ComputerUtilCard.evaluateCreatureList(computerType) + ComputerUtilCard.evaluateCreatureList(cardCollectionView) < 400 : ComputerUtilCard.evaluatePermanentList(computerType) + ComputerUtilCard.evaluatePermanentList(cardCollectionView) < 6) : (CardLists.getNotType(cardCollectionView, "Creature").isEmpty() && CardLists.getNotType(computerType, "Creature").isEmpty() ? ComputerUtilCard.evaluateCreatureList(computerType) <= ComputerUtilCard.evaluateCreatureList(cardCollectionView) + 100 : ComputerUtilCard.evaluatePermanentList(computerType) <= ComputerUtilCard.evaluatePermanentList(cardCollectionView) + 2))) {
            return false;
        }
        if (!((double)MyRandom.getRandom().nextFloat() < 0.8)) {
            if (!sa.isTrigger()) return false;
        }
        if (!chance) return false;
        return true;
    }

    @Override
    public boolean chkAIDrawback(SpellAbility sa, Player aiPlayer) {
        return true;
    }

    @Override
    public boolean confirmAction(Player ai, SpellAbility sa, PlayerActionConfirmMode mode, String message, Map<String, Object> params) {
        Card source = sa.getHostCard();
        String hostName = source.getName();
        ZoneType origin = ZoneType.listValueOf(sa.getParam("Origin")).get(0);
        if (hostName.equals("Dawnbreak Reclaimer")) {
            CardCollectionView cards = AbilityUtils.filterListByType(ai.getGame().getCardsIn(origin), sa.getParam("ChangeType"), sa);
            CardCollection aiCards = CardLists.filterControlledBy((Iterable<Card>)cards, ai);
            if (aiCards.isEmpty()) {
                return false;
            }
            CardCollection humanCards = CardLists.filterControlledBy((Iterable<Card>)cards, ai.getOpponents());
            if (humanCards.isEmpty()) {
                return true;
            }
            return ComputerUtilCard.evaluateCreatureList(aiCards) >= ComputerUtilCard.evaluateCreatureList(humanCards);
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected boolean doTriggerAINoCost(Player ai, SpellAbility sa, boolean mandatory) {
        ZoneType destination = ZoneType.smartValueOf(sa.getParam("Destination"));
        ZoneType origin = ZoneType.listValueOf(sa.getParam("Origin")).get(0);
        if (ComputerUtilAbility.getAbilitySourceName(sa).equals("Profaner of the Dead")) {
            return Iterables.any(ai.getOpponents().getCardsIn(origin), CardPredicates.Presets.CREATURES);
        }
        CardCollectionView humanType = ai.getOpponents().getCardsIn(origin);
        humanType = AbilityUtils.filterListByType(humanType, sa.getParam("ChangeType"), sa);
        CardCollectionView computerType = ai.getCardsIn(origin);
        computerType = AbilityUtils.filterListByType(computerType, sa.getParam("ChangeType"), sa);
        if (origin.equals((Object)ZoneType.Hand) || origin.equals((Object)ZoneType.Library)) {
            if (sa.usesTargeting()) {
                PlayerCollection oppList = ai.getOpponents().filter(PlayerPredicates.isTargetableBy(sa));
                if (oppList.isEmpty()) {
                    if (!mandatory) return false;
                    if (sa.isTargetNumberValid()) return false;
                    if (!sa.canTarget(ai)) return false;
                    sa.resetTargets();
                    sa.getTargets().add(ai);
                    return true;
                }
                Player oppTarget = oppList.max(PlayerPredicates.compareByZoneSize(origin));
                if (oppTarget.getCardsIn(ZoneType.Hand).isEmpty()) {
                    if (!mandatory) return false;
                }
                sa.resetTargets();
                sa.getTargets().add(oppTarget);
            }
        } else if (origin.equals((Object)ZoneType.Battlefield)) {
            if (mandatory) {
                return true;
            }
            if (CardLists.getNotType(humanType, "Creature").isEmpty() && CardLists.getNotType(computerType, "Creature").isEmpty() ? ComputerUtilCard.evaluateCreatureList(computerType) >= ComputerUtilCard.evaluateCreatureList(humanType) : ComputerUtilCard.evaluatePermanentList(computerType) >= ComputerUtilCard.evaluatePermanentList(humanType)) {
                return false;
            }
        } else if (origin.equals((Object)ZoneType.Graveyard)) {
            if (sa.usesTargeting()) {
                PlayerCollection oppList = ai.getOpponents().filter(PlayerPredicates.isTargetableBy(sa));
                if (oppList.isEmpty()) {
                    if (!mandatory) return sa.isTargetNumberValid();
                    if (sa.isTargetNumberValid()) return sa.isTargetNumberValid();
                    if (!sa.canTarget(ai)) return sa.isTargetNumberValid();
                    sa.resetTargets();
                    sa.getTargets().add(ai);
                    return true;
                }
                Player oppTarget = oppList.max(AiPlayerPredicates.compareByZoneValue(sa.getParam("ChangeType"), origin, sa));
                if (oppTarget.getCardsIn(ZoneType.Graveyard).isEmpty()) {
                    if (!mandatory) return false;
                }
                sa.resetTargets();
                sa.getTargets().add(oppTarget);
            }
        } else if (origin.equals((Object)ZoneType.Exile) || origin.equals((Object)ZoneType.Stack)) {
            // empty if block
        }
        if (!destination.equals((Object)ZoneType.Battlefield)) return true;
        if (mandatory) {
            return true;
        }
        if (sa.hasParam("GainControl")) {
            if (CardLists.getNotType(humanType, "Creature").isEmpty() && CardLists.getNotType(computerType, "Creature").isEmpty()) {
                if (ComputerUtilCard.evaluateCreatureList(computerType) + ComputerUtilCard.evaluateCreatureList(humanType) < 1) return false;
                return true;
            }
            if (ComputerUtilCard.evaluatePermanentList(computerType) + ComputerUtilCard.evaluatePermanentList(humanType) < 1) return false;
            return true;
        }
        if (CardLists.getNotType(humanType, "Creature").isEmpty() && CardLists.getNotType(computerType, "Creature").isEmpty()) {
            if (ComputerUtilCard.evaluateCreatureList(computerType) <= ComputerUtilCard.evaluateCreatureList(humanType)) return false;
            return true;
        }
        if (ComputerUtilCard.evaluatePermanentList(computerType) <= ComputerUtilCard.evaluatePermanentList(humanType)) return false;
        return true;
    }
}

