/*
 * Decompiled with CFR 0.152.
 */
package forge.ai.ability;

import forge.ai.SpellAbilityAi;
import forge.game.GameEntity;
import forge.game.player.Player;
import forge.game.player.PlayerCollection;
import forge.game.player.PlayerPredicates;
import forge.game.spellability.SpellAbility;
import java.util.Collection;
import java.util.Map;

public class ChangeCombatantsAi
extends SpellAbilityAi {
    @Override
    protected boolean canPlayAI(Player aiPlayer, SpellAbility sa) {
        return false;
    }

    @Override
    protected boolean doTriggerAINoCost(Player aiPlayer, SpellAbility sa, boolean mandatory) {
        return mandatory || this.canPlayAI(aiPlayer, sa);
    }

    @Override
    public boolean chkAIDrawback(SpellAbility sa, Player aiPlayer) {
        String logic = sa.getParamOrDefault("AILogic", "");
        if (logic.equals("WeakestOppExceptCtrl")) {
            PlayerCollection targetableOpps = aiPlayer.getOpponents();
            targetableOpps.remove(sa.getHostCard().getController());
            return !targetableOpps.isEmpty();
        }
        return false;
    }

    @Override
    public <T extends GameEntity> T chooseSingleEntity(Player ai, SpellAbility sa, Collection<T> options, boolean isOptional, Player targetedPlayer, Map<String, Object> params) {
        PlayerCollection targetableOpps = new PlayerCollection();
        for (GameEntity p : options) {
            Player pp;
            if (!(p instanceof Player) || p.equals(sa.getHostCard().getController()) || !(pp = (Player)p).isOpponentOf(ai)) continue;
            targetableOpps.add(pp);
        }
        Player weakestTargetableOpp = targetableOpps.filter(PlayerPredicates.isTargetableBy(sa)).min(PlayerPredicates.compareByLife());
        return (T)weakestTargetableOpp;
    }
}

