/*
 * Decompiled with CFR 0.152.
 */
package forge.ai.ability;

import forge.ai.AiAttackController;
import forge.ai.ComputerUtilCard;
import forge.ai.SpellAbilityAi;
import forge.game.Game;
import forge.game.card.Card;
import forge.game.card.CardCollection;
import forge.game.card.CardLists;
import forge.game.player.Player;
import forge.game.spellability.SpellAbility;
import forge.game.spellability.TargetRestrictions;
import forge.game.zone.ZoneType;
import forge.util.MyRandom;

public class BidLifeAi
extends SpellAbilityAi {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected boolean canPlayAI(Player aiPlayer, SpellAbility sa) {
        Card source = sa.getHostCard();
        Game game = source.getGame();
        TargetRestrictions tgt = sa.getTargetRestrictions();
        if (tgt != null) {
            sa.resetTargets();
            if (tgt.canTgtCreature()) {
                CardCollection list = CardLists.getTargetableCards(AiAttackController.choosePreferredDefenderPlayer(aiPlayer).getCardsIn(ZoneType.Battlefield), sa);
                if (list.isEmpty()) {
                    return false;
                }
                Card c = ComputerUtilCard.getBestCreatureAI(list);
                if (!sa.canTarget(c)) return false;
                sa.getTargets().add(c);
            } else if (tgt.getZone().contains((Object)ZoneType.Stack)) {
                if (game.getStack().isEmpty()) {
                    return false;
                }
                SpellAbility topSA = game.getStack().peekAbility();
                if (!topSA.isCounterableBy(sa)) return false;
                if (aiPlayer.equals(topSA.getActivatingPlayer())) {
                    return false;
                }
                if (!sa.canTargetSpellAbility(topSA)) return false;
                sa.getTargets().add(topSA);
            }
        }
        if (!((double)MyRandom.getRandom().nextFloat() <= Math.pow(0.6667, sa.getActivationsThisTurn()))) return false;
        return true;
    }
}

