/*
 * Decompiled with CFR 0.152.
 */
package forge.ai.ability;

import forge.ai.ComputerUtilCard;
import forge.ai.SpellAbilityAi;
import forge.game.Game;
import forge.game.card.Card;
import forge.game.card.CardCollection;
import forge.game.card.CardLists;
import forge.game.keyword.Keyword;
import forge.game.phase.PhaseType;
import forge.game.player.Player;
import forge.game.spellability.SpellAbility;
import forge.game.spellability.TargetRestrictions;
import forge.game.zone.ZoneType;

public class BecomesBlockedAi
extends SpellAbilityAi {
    @Override
    protected boolean canPlayAI(Player aiPlayer, SpellAbility sa) {
        Card source = sa.getHostCard();
        TargetRestrictions tgt = sa.getTargetRestrictions();
        Game game = aiPlayer.getGame();
        if (!game.getPhaseHandler().is(PhaseType.COMBAT_DECLARE_BLOCKERS) || !game.getPhaseHandler().getPlayerTurn().isOpponentOf(aiPlayer)) {
            return false;
        }
        if (tgt != null) {
            sa.resetTargets();
            CardCollection list = CardLists.filterControlledBy((Iterable<Card>)game.getCardsIn(ZoneType.Battlefield), aiPlayer.getOpponents());
            list = CardLists.getTargetableCards(list, sa);
            list = CardLists.getNotKeyword((Iterable<Card>)list, Keyword.TRAMPLE);
            while (sa.canAddMoreTarget()) {
                Card choice = null;
                if (list.isEmpty()) {
                    return false;
                }
                choice = ComputerUtilCard.getBestCreatureAI(list);
                if (choice == null) {
                    return false;
                }
                list.remove(choice);
                sa.getTargets().add(choice);
            }
        }
        return true;
    }

    @Override
    public boolean chkAIDrawback(SpellAbility sa, Player aiPlayer) {
        return false;
    }

    @Override
    protected boolean doTriggerAINoCost(Player aiPlayer, SpellAbility sa, boolean mandatory) {
        boolean chance = false;
        return chance;
    }
}

