/*
 * Decompiled with CFR 0.152.
 */
package forge.ai.ability;

import com.google.common.base.Predicates;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import forge.ai.AiAttackController;
import forge.ai.AiCardMemory;
import forge.ai.AiController;
import forge.ai.AiProps;
import forge.ai.ComputerUtil;
import forge.ai.ComputerUtilAbility;
import forge.ai.ComputerUtilCard;
import forge.ai.ComputerUtilCombat;
import forge.ai.ComputerUtilCost;
import forge.ai.PlayerControllerAi;
import forge.ai.SpecialCardAi;
import forge.ai.SpellAbilityAi;
import forge.game.CardTraitBase;
import forge.game.Game;
import forge.game.GameEntity;
import forge.game.ability.AbilityFactory;
import forge.game.ability.AbilityUtils;
import forge.game.ability.ApiType;
import forge.game.card.Card;
import forge.game.card.CardCollection;
import forge.game.card.CardCollectionView;
import forge.game.card.CardCopyService;
import forge.game.card.CardLists;
import forge.game.card.CardPredicates;
import forge.game.card.CardUtil;
import forge.game.combat.Combat;
import forge.game.combat.CombatUtil;
import forge.game.cost.Cost;
import forge.game.cost.CostPart;
import forge.game.cost.CostSacrifice;
import forge.game.keyword.Keyword;
import forge.game.phase.PhaseHandler;
import forge.game.phase.PhaseType;
import forge.game.player.Player;
import forge.game.player.PlayerActionConfirmMode;
import forge.game.spellability.SpellAbility;
import forge.game.spellability.TargetRestrictions;
import forge.game.staticability.StaticAbility;
import forge.game.staticability.StaticAbilityCantAttackBlock;
import forge.game.trigger.Trigger;
import forge.game.trigger.TriggerType;
import forge.game.zone.ZoneType;
import forge.util.Aggregates;
import forge.util.MyRandom;
import forge.util.collect.FCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.ObjectUtils;

public class AttachAi
extends SpellAbilityAi {
    @Override
    protected boolean canPlayAI(Player ai, SpellAbility sa) {
        Cost abCost = sa.getPayCosts();
        Card source = sa.getHostCard();
        if (source.hasKeyword("MayFlashSac") && !ai.canCastSorcery()) {
            return false;
        }
        if (abCost != null) {
            if (!ComputerUtilCost.checkSacrificeCost(ai, abCost, source, sa)) {
                return false;
            }
            if (!ComputerUtilCost.checkLifeCost(ai, abCost, source, 4, sa)) {
                return false;
            }
        }
        if (source.isAura() && sa.isSpell() && !source.ignoreLegendRule() && ai.isCardInPlay(source.getName())) {
            return false;
        }
        if (ComputerUtil.preventRunAwayActivations(sa)) {
            return false;
        }
        TargetRestrictions tgt = sa.getTargetRestrictions();
        if (tgt != null) {
            sa.resetTargets();
            if (!AttachAi.attachPreference(sa, tgt, false)) {
                return false;
            }
        }
        boolean advancedFlash = false;
        if (ai.getController().isAI()) {
            advancedFlash = ((PlayerControllerAi)ai.getController()).getAi().getBooleanProperty(AiProps.FLASH_ENABLE_ADVANCED_LOGIC);
        }
        if ((source.hasKeyword(Keyword.FLASH) || !ai.canCastSorcery() && sa.canCastTiming(ai)) && source.isAura() && advancedFlash && !this.doAdvancedFlashAuraLogic(ai, sa, sa.getTargetCard())) {
            return false;
        }
        if (abCost.getTotalMana().countX() > 0 && sa.getSVar("X").equals("Count$xPaid")) {
            int xPay = ComputerUtilCost.getMaxXValue(sa, ai, sa.isTrigger());
            if (xPay == 0) {
                return false;
            }
            sa.setXManaCostPaid(xPay);
        }
        if (ComputerUtilAbility.getAbilitySourceName(sa).equals("Chained to the Rocks")) {
            SpellAbility effectExile = AbilityFactory.getAbility(source.getSVar("TrigExile"), source);
            effectExile.setActivatingPlayer(ai, true);
            List<Card> targets = CardUtil.getValidCardsToTarget(effectExile);
            return !targets.isEmpty();
        }
        return true;
    }

    private boolean doAdvancedFlashAuraLogic(Player ai, SpellAbility sa, Card attachTarget) {
        boolean alternativeConsiderations;
        SpellAbility peekSa;
        Player activator;
        boolean isBuffAura;
        Card source = sa.getHostCard();
        Game game = ai.getGame();
        Combat combat = game.getCombat();
        AiController aic = ((PlayerControllerAi)ai.getController()).getAi();
        if (!aic.getBooleanProperty(AiProps.FLASH_USE_BUFF_AURAS_AS_COMBAT_TRICKS)) {
            return true;
        }
        int power = 0;
        int toughness = 0;
        ArrayList<String> keywords = Lists.newArrayList();
        for (StaticAbility stAb : source.getStaticAbilities()) {
            if (!"Continuous".equals(stAb.getParam("Mode"))) continue;
            if (stAb.hasParam("AddPower")) {
                power += AbilityUtils.calculateAmount(source, stAb.getParam("AddPower"), stAb);
            }
            if (stAb.hasParam("AddToughness")) {
                toughness += AbilityUtils.calculateAmount(source, stAb.getParam("AddToughness"), stAb);
            }
            if (!stAb.hasParam("AddKeyword")) continue;
            keywords.addAll(Lists.newArrayList(stAb.getParam("AddKeyword").split(" & ")));
        }
        boolean bl = isBuffAura = !sa.isCurse() && (power > 0 || toughness > 0 || !keywords.isEmpty());
        if (!isBuffAura) {
            return true;
        }
        boolean canRespondToStack = false;
        if (!game.getStack().isEmpty() && (activator = (peekSa = game.getStack().peekAbility()).getActivatingPlayer()) != null && activator.isOpponentOf(ai) && (!peekSa.usesTargeting() || peekSa.getTargets().getTargetCards().contains(attachTarget))) {
            if (peekSa.getApi() == ApiType.DealDamage || peekSa.getApi() == ApiType.DamageAll) {
                int dmg = AbilityUtils.calculateAmount(peekSa.getHostCard(), peekSa.getParam("NumDmg"), peekSa);
                if (dmg < toughness + attachTarget.getNetToughness()) {
                    canRespondToStack = true;
                }
            } else if (peekSa.getApi() == ApiType.Destroy || peekSa.getApi() == ApiType.DestroyAll) {
                if (!attachTarget.hasKeyword(Keyword.INDESTRUCTIBLE) && !ComputerUtil.canRegenerate(ai, attachTarget) && keywords.contains("Indestructible")) {
                    canRespondToStack = true;
                }
            } else if (peekSa.getApi() == ApiType.Pump || peekSa.getApi() == ApiType.PumpAll) {
                int p = AbilityUtils.calculateAmount(peekSa.getHostCard(), peekSa.getParam("NumAtt"), peekSa);
                int t2 = AbilityUtils.calculateAmount(peekSa.getHostCard(), peekSa.getParam("NumDef"), peekSa);
                if (t2 < 0 && toughness > 0 && attachTarget.getNetToughness() + t2 + toughness > 0) {
                    canRespondToStack = true;
                } else if (p < 0 && power > 0 && attachTarget.getNetPower() + p + power > 0 && attachTarget.getNetToughness() + t2 + toughness > 0) {
                    canRespondToStack = true;
                }
            }
        }
        boolean canSurviveCombat = true;
        if (combat != null && combat.isBlocked(attachTarget) && !attachTarget.hasKeyword(Keyword.INDESTRUCTIBLE) && !ComputerUtil.canRegenerate(ai, attachTarget)) {
            boolean dangerous = false;
            int totalAtkPower = 0;
            for (Card attacker : combat.getBlockers(attachTarget)) {
                if (attacker.hasKeyword(Keyword.DEATHTOUCH) || attacker.isWitherDamage()) {
                    dangerous = true;
                }
                totalAtkPower += attacker.getNetPower();
            }
            if (totalAtkPower > attachTarget.getNetToughness() + toughness || dangerous) {
                canSurviveCombat = false;
            }
        }
        if (!canSurviveCombat || attachTarget.isCreature() && ComputerUtilCard.isUselessCreature(ai, attachTarget)) {
            return false;
        }
        int chanceToCastAtEOT = aic.getIntProperty(AiProps.FLASH_BUFF_AURA_CHANCE_CAST_AT_EOT);
        int chanceToCastEarly = aic.getIntProperty(AiProps.FLASH_BUFF_AURA_CHANCE_TO_CAST_EARLY);
        int chanceToRespondToStack = aic.getIntProperty(AiProps.FLASH_BUFF_AURA_CHANCE_TO_RESPOND_TO_STACK);
        boolean hasFloatMana = ai.getManaPool().totalMana() > 0;
        boolean willDiscardNow = game.getPhaseHandler().is(PhaseType.END_OF_TURN, ai) && !ai.isUnlimitedHandSize() && ai.getCardsIn(ZoneType.Hand).size() > ai.getMaxHandSize();
        boolean willDieNow = combat != null && ComputerUtilCombat.lifeInSeriousDanger(ai, combat);
        boolean willRespondToStack = canRespondToStack && MyRandom.percentTrue(chanceToRespondToStack);
        boolean willCastEarly = MyRandom.percentTrue(chanceToCastEarly);
        boolean willCastAtEOT = game.getPhaseHandler().is(PhaseType.END_OF_TURN) && game.getPhaseHandler().getNextTurn().equals(ai) && MyRandom.percentTrue(chanceToCastAtEOT);
        boolean bl2 = alternativeConsiderations = hasFloatMana || willDiscardNow || willDieNow || willRespondToStack || willCastAtEOT || willCastEarly;
        if (!alternativeConsiderations) {
            if (combat == null || game.getPhaseHandler().getPhase().isBefore(PhaseType.COMBAT_DECLARE_BLOCKERS)) {
                return false;
            }
            return combat.isAttacking(attachTarget) || combat.isBlocking(attachTarget);
        }
        return true;
    }

    private static Card acceptableChoice(Card c, boolean mandatory) {
        int eval;
        if (mandatory) {
            return c;
        }
        if (c.isCreature() && (eval = ComputerUtilCard.evaluateCreature(c)) < 130) {
            return null;
        }
        return c;
    }

    private static Card chooseUnpreferred(boolean mandatory, List<Card> list) {
        if (!mandatory) {
            return null;
        }
        return ComputerUtilCard.getWorstPermanentAI(list, true, true, true, false);
    }

    private static Card chooseLessPreferred(boolean mandatory, List<Card> list) {
        if (!mandatory) {
            return null;
        }
        return ComputerUtilCard.getBestAI(list);
    }

    private static Card attachAIChangeTypePreference(SpellAbility sa, List<Card> list, boolean mandatory, Card attachSource) {
        String type = "";
        for (StaticAbility stAb : attachSource.getStaticAbilities()) {
            Map<String, String> stab = stAb.getMapParams();
            if (!stab.get("Mode").equals("Continuous") || !stab.containsKey("AddType")) continue;
            type = stab.get("AddType");
        }
        if ("ChosenType".equals(type)) {
            type = "Island";
        }
        list = CardLists.getNotType(list, type);
        Card c2 = ComputerUtilCard.getBestAI(list = CardLists.filter((Iterable<Card>)list, c -> {
            for (SpellAbility ability : c.getAllSpellAbilities()) {
                if (!ability.isActivatedAbility()) continue;
                Cost cost = ability.getPayCosts();
                for (CostPart part : cost.getCostParts()) {
                    CostSacrifice sacCost;
                    if (!(part instanceof CostSacrifice) || !(sacCost = (CostSacrifice)part).payCostFromSource() || !ComputerUtilCost.canPayCost(ability, c.getController(), false)) continue;
                    return false;
                }
            }
            return true;
        }));
        if (c2 == null) {
            return AttachAi.chooseLessPreferred(mandatory, list);
        }
        return AttachAi.acceptableChoice(c2, mandatory);
    }

    private static Card attachAIKeepTappedPreference(SpellAbility sa, List<Card> list, boolean mandatory, Card attachSource) {
        CardCollection prefList = CardLists.filter(list, c -> {
            if (c.isCreature() && c.hasKeyword(Keyword.VIGILANCE) && c.isUntapped()) {
                return false;
            }
            if (!(mandatory || c.isCreature() || c.getType().hasSubtype("Vehicle") || c.isTapped())) {
                for (SpellAbility ab : c.getAllSpellAbilities()) {
                    if (!ab.getPayCosts().hasTapCost()) continue;
                    return true;
                }
                return false;
            }
            if (!c.isEnchanted()) {
                return true;
            }
            CardCollectionView auras = c.getEnchantedBy();
            for (Card aura : auras) {
                SpellAbility auraSA = aura.getSpells().get((SpellAbility)false);
                if (auraSA.getApi() != ApiType.Attach || !"KeepTapped".equals(auraSA.getParam("AILogic"))) continue;
                return false;
            }
            return true;
        });
        Card c2 = ComputerUtilCard.getBestAI(prefList);
        if (c2 == null) {
            return AttachAi.chooseLessPreferred(mandatory, list);
        }
        return AttachAi.acceptableChoice(c2, mandatory);
    }

    public static Player attachToPlayerAIPreferences(Player aiPlayer, SpellAbility sa, boolean mandatory, List<Player> targetable) {
        if ("Curse".equals(sa.getParam("AILogic"))) {
            if (!mandatory) {
                targetable.removeAll(aiPlayer.getAllies());
                targetable.remove(aiPlayer);
            }
            if (!targetable.isEmpty()) {
                if (targetable.contains(aiPlayer.getWeakestOpponent())) {
                    return aiPlayer.getWeakestOpponent();
                }
                for (Player curseChoice : targetable) {
                    if (!curseChoice.isOpponentOf(aiPlayer)) continue;
                    return curseChoice;
                }
                return targetable.get(0);
            }
        } else {
            if (!mandatory) {
                targetable.removeAll(aiPlayer.getOpponents());
            }
            if (!targetable.isEmpty()) {
                if (targetable.contains(aiPlayer)) {
                    return aiPlayer;
                }
                for (Player boonChoice : targetable) {
                    if (boonChoice.isOpponentOf(aiPlayer)) continue;
                    return boonChoice;
                }
                return targetable.get(0);
            }
        }
        return null;
    }

    private static Card attachAIAnimatePreference(SpellAbility sa, List<Card> list, boolean mandatory, Card attachSource) {
        if (list.isEmpty()) {
            return null;
        }
        Card card = null;
        CardCollection betterList = CardLists.getNotType(list, "Creature");
        if (ComputerUtilAbility.getAbilitySourceName(sa).equals("Animate Artifact")) {
            betterList = CardLists.filter((Iterable<Card>)betterList, c -> c.getCMC() > 0);
            card = ComputerUtilCard.getMostExpensivePermanentAI(betterList);
        } else {
            CardCollection evenBetterList = CardLists.filter((Iterable<Card>)betterList, c -> c.hasKeyword(Keyword.INDESTRUCTIBLE) || c.hasKeyword(Keyword.HEXPROOF));
            if (!evenBetterList.isEmpty()) {
                betterList = evenBetterList;
            }
            if (!(evenBetterList = CardLists.filter((Iterable<Card>)betterList, CardPredicates.Presets.UNTAPPED)).isEmpty()) {
                betterList = evenBetterList;
            }
            if (!(evenBetterList = CardLists.filter((Iterable<Card>)betterList, c -> c.getTurnInZone() != c.getGame().getPhaseHandler().getTurn())).isEmpty()) {
                betterList = evenBetterList;
            }
            if (!(evenBetterList = CardLists.filter((Iterable<Card>)betterList, c -> {
                for (SpellAbility sa1 : c.getSpellAbilities()) {
                    if (!sa1.isAbility() || !sa1.getPayCosts().hasTapCost()) continue;
                    return false;
                }
                return true;
            })).isEmpty()) {
                betterList = evenBetterList;
            }
            card = ComputerUtilCard.getWorstAI(betterList);
        }
        if (card == null && mandatory) {
            return AttachAi.chooseLessPreferred(mandatory, list);
        }
        return card;
    }

    private static Card attachAIReanimatePreference(SpellAbility sa, List<Card> list, boolean mandatory, Card attachSource) {
        Player ai = sa.getActivatingPlayer();
        Card attachSourceLki = CardCopyService.getLKICopy(attachSource);
        attachSourceLki.setLastKnownZone(ai.getZone(ZoneType.Battlefield));
        attachSourceLki.getFirstAttachSpell().setSuppressed(true);
        attachSourceLki.addSpellAbility(AbilityFactory.getAbility(attachSourceLki, "NewAttach"));
        CardCollection betterList = CardLists.filter(list, c -> {
            Card lki = CardCopyService.getLKICopy(c);
            lki.setLastKnownZone(ai.getZone(ZoneType.Battlefield));
            attachSourceLki.clearRemembered();
            attachSourceLki.addRemembered(lki);
            CardCollection preList = new CardCollection(lki);
            preList.add(attachSourceLki);
            c.getGame().getAction().checkStaticAbilities(false, Sets.newHashSet(preList), preList);
            boolean result = lki.canBeAttached(attachSourceLki, null);
            c.getGame().getAction().checkStaticAbilities(false);
            return result;
        });
        Card c2 = ComputerUtilCard.getBestCreatureAI(betterList);
        if (c2 == null && mandatory) {
            return AttachAi.chooseLessPreferred(mandatory, list);
        }
        return c2;
    }

    private static Card attachAICuriosityPreference(SpellAbility sa, List<Card> list, boolean mandatory, Card attachSource) {
        Card chosen = null;
        int priority = 0;
        for (Card card : list) {
            int cardPriority = 0;
            if (card.hasKeyword(Keyword.TRAMPLE)) {
                cardPriority += 10;
            }
            if (card.hasKeyword(Keyword.MENACE)) {
                cardPriority += 10;
            }
            if (card.hasKeyword(Keyword.FEAR)) {
                cardPriority += 15;
            }
            if (card.hasKeyword(Keyword.FLYING)) {
                cardPriority += 20;
            }
            if (card.hasKeyword(Keyword.SHADOW)) {
                cardPriority += 30;
            }
            if (card.hasKeyword(Keyword.HORSEMANSHIP)) {
                cardPriority += 40;
            }
            if (StaticAbilityCantAttackBlock.cantBlockBy(card, null)) {
                cardPriority += 50;
            }
            for (SpellAbility sa2 : card.getSpellAbilities()) {
                if (!ApiType.DealDamage.equals((Object)sa2.getApi()) || !sa2.usesTargeting() || !sa2.getTargetRestrictions().canTgtPlayer()) continue;
                cardPriority += 300;
            }
            cardPriority += card.getCurrentToughness() * 2;
            cardPriority += card.getCurrentPower();
            if (card.getCurrentPower() <= 0) {
                cardPriority = -100;
            }
            if (card.hasKeyword(Keyword.DEFENDER)) {
                cardPriority = -100;
            }
            if (card.hasKeyword(Keyword.INDESTRUCTIBLE)) {
                cardPriority += 15;
            }
            if (cardPriority <= priority) continue;
            priority = cardPriority;
            chosen = card;
        }
        return chosen;
    }

    private static Card attachAISpecificCardPreference(SpellAbility sa, List<Card> list, boolean mandatory, Card attachSource) {
        Player ai = sa.getActivatingPlayer();
        String sourceName = ComputerUtilAbility.getAbilitySourceName(sa);
        Card chosen = null;
        if ("Guilty Conscience".equals(sourceName)) {
            chosen = SpecialCardAi.GuiltyConscience.getBestAttachTarget(ai, sa, list);
        } else if (sa.hasParam("AIValid")) {
            chosen = AttachAi.doPumpOrCurseAILogic(ai, sa, list, sa.getParam("AIValid"));
        }
        if (chosen == null && mandatory) {
            return AttachAi.chooseLessPreferred(mandatory, list);
        }
        return chosen;
    }

    private static Card attachAIInstantReequipPreference(SpellAbility sa, Card attachSource) {
        PhaseHandler ph = attachSource.getGame().getPhaseHandler();
        Combat combat = attachSource.getGame().getCombat();
        Card equipped = sa.getHostCard().getEquipping();
        if (equipped == null) {
            return null;
        }
        int powerBuff = 0;
        for (StaticAbility stAb : sa.getHostCard().getStaticAbilities()) {
            if (!"Card.EquippedBy".equals(stAb.getParam("Affected")) || !stAb.hasParam("AddPower")) continue;
            powerBuff = AbilityUtils.calculateAmount(sa.getHostCard(), stAb.getParam("AddPower"), stAb);
        }
        if (combat != null && combat.isAttacking(equipped) && ph.is(PhaseType.COMBAT_DECLARE_BLOCKERS, sa.getActivatingPlayer())) {
            int damage = 0;
            for (Card c : combat.getUnblockedAttackers()) {
                damage += ComputerUtilCombat.predictDamageTo(combat.getDefenderPlayerByAttacker(equipped), c.getNetCombatDamage(), c, true);
            }
            if (combat.isBlocked(equipped)) {
                for (Card atk : combat.getAttackers()) {
                    if (combat.isBlocked(atk) || ComputerUtil.predictThreatenedObjects(sa.getActivatingPlayer(), null).contains(atk) || ComputerUtilCombat.predictDamageTo(combat.getDefenderPlayerByAttacker(atk), atk.getNetCombatDamage(), atk, true) <= 0 || damage + powerBuff < combat.getDefenderPlayerByAttacker(atk).getLife()) continue;
                    sa.resetTargets();
                    return atk;
                }
            }
        }
        return null;
    }

    private static Card attachAIControlPreference(SpellAbility sa, List<Card> list, boolean mandatory, Card attachSource) {
        Card c;
        if (sa.getTargetRestrictions().canTgtPermanent()) {
            // empty if block
        }
        if ((c = ComputerUtilCard.getBestAI(list)) == null) {
            return AttachAi.chooseLessPreferred(mandatory, list);
        }
        return AttachAi.acceptableChoice(c, mandatory);
    }

    private static Card attachAIHighestEvaluationPreference(List<Card> list) {
        return ComputerUtilCard.getBestAI(list);
    }

    private static Card attachAICursePreference(SpellAbility sa, List<Card> list, boolean mandatory, Card attachSource, Player ai) {
        String stCheck = null;
        if (attachSource.isAura()) {
            stCheck = "EnchantedBy";
        } else if (attachSource.isEquipment()) {
            stCheck = "EquippedBy";
        }
        int totToughness = 0;
        int totPower = 0;
        ArrayList<String> keywords = new ArrayList<String>();
        for (StaticAbility stAbility : attachSource.getStaticAbilities()) {
            String affected;
            Map<String, String> stabMap = stAbility.getMapParams();
            if (!stabMap.get("Mode").equals("Continuous") || (affected = stabMap.get("Affected")) == null || !affected.contains(stCheck) && !affected.contains("AttachedBy")) continue;
            totToughness += AbilityUtils.calculateAmount(attachSource, stabMap.get("AddToughness"), sa);
            totPower += AbilityUtils.calculateAmount(attachSource, stabMap.get("AddPower"), sa);
            String kws = stabMap.get("AddKeyword");
            if (kws != null) {
                keywords.addAll(Arrays.asList(kws.split(" & ")));
            }
            if ((kws = stabMap.get("AddHiddenKeyword")) == null) continue;
            keywords.addAll(Arrays.asList(kws.split(" & ")));
        }
        List<Card> prefList = null;
        if (totToughness < 0) {
            int tgh = totToughness;
            prefList = CardLists.filter(list, c -> {
                if (!c.hasKeyword(Keyword.INDESTRUCTIBLE) && c.getLethalDamage() <= Math.abs(tgh)) {
                    return true;
                }
                return c.getNetToughness() <= Math.abs(tgh);
            });
        }
        Card card = null;
        if (prefList == null || prefList.isEmpty()) {
            prefList = new ArrayList<Card>(list);
        } else {
            card = ComputerUtilCard.getBestAI((Iterable<Card>)prefList);
            if (card != null) {
                return card;
            }
        }
        if (!keywords.isEmpty()) {
            prefList = CardLists.filter(prefList, c -> AttachAi.containsUsefulCurseKeyword(keywords, c, sa));
        } else if (totPower < 0) {
            prefList = CardLists.filter(prefList, c -> c.getNetPower() > 0 && ComputerUtilCombat.canAttackNextTurn(c));
        }
        if (attachSource.hasSVar("NonStackingAttachEffect")) {
            prefList = CardLists.filter(prefList, Predicates.not(CardPredicates.isEnchantedBy(attachSource.getName())));
        }
        if (sa.getHostCard().getAttachedTo() != null && sa.getHostCard().getAttachedTo().isCreature() && sa.getPayCosts() != null && sa.getPayCosts().hasSpecificCostType(CostSacrifice.class)) {
            int oldEvalRating = ComputerUtilCard.evaluateCreature(sa.getHostCard().getAttachedTo());
            int threshold = ai.isAI() ? ((PlayerControllerAi)ai.getController()).getAi().getIntProperty(AiProps.SAC_TO_REATTACH_TARGET_EVAL_THRESHOLD) : Integer.MAX_VALUE;
            prefList = CardLists.filter(prefList, c -> {
                if (!c.isCreature()) {
                    return false;
                }
                return ComputerUtilCard.evaluateCreature(c) >= oldEvalRating + threshold;
            });
        }
        if ((card = ComputerUtilCard.getBestAI(prefList)) == null) {
            return AttachAi.chooseLessPreferred(mandatory, list);
        }
        return AttachAi.acceptableChoice(card, mandatory);
    }

    @Override
    protected boolean doTriggerAINoCost(Player ai, SpellAbility sa, boolean mandatory) {
        Card card = sa.getHostCard();
        List<Object> targets = new ArrayList();
        TargetRestrictions tgt = sa.getTargetRestrictions();
        if (tgt == null) {
            targets = AbilityUtils.getDefinedObjects(card, sa.getParam("Defined"), sa);
        } else {
            AttachAi.attachPreference(sa, tgt, mandatory);
            targets = sa.getTargets();
        }
        if (!mandatory && card.isEquipment() && !targets.isEmpty()) {
            Card newTarget = (Card)targets.get(0);
            if (newTarget.getController().isOpponentOf(ai)) {
                return false;
            }
            if (card.isEquipping()) {
                Card oldTarget = card.getEquipping();
                if (ComputerUtilCard.evaluateCreature(oldTarget) > ComputerUtilCard.evaluateCreature(newTarget)) {
                    return false;
                }
                return !card.hasSVar("NonStackingAttachEffect") || !newTarget.isEquippedBy(card.getName());
            }
        }
        return true;
    }

    private static boolean attachPreference(SpellAbility sa, TargetRestrictions tgt, boolean mandatory) {
        GameEntity o;
        if (tgt.canTgtPlayer()) {
            ArrayList<Player> targetable = new ArrayList<Player>();
            for (Player player : sa.getHostCard().getGame().getPlayers()) {
                if (!sa.canTarget(player)) continue;
                targetable.add(player);
            }
            o = AttachAi.attachToPlayerAIPreferences(sa.getActivatingPlayer(), sa, mandatory, targetable);
        } else {
            o = AttachAi.attachToCardAIPreferences(sa.getActivatingPlayer(), sa, mandatory);
        }
        if (o == null) {
            return false;
        }
        sa.getTargets().add(o);
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private static Card attachAIPumpPreference(Player ai, SpellAbility sa, List<Card> list, boolean mandatory, Card attachSource) {
        void var14_34;
        void var14_27;
        Card card = null;
        CardCollection magnetList = null;
        String stCheck = null;
        if (attachSource.isAura() || sa.isBestow()) {
            stCheck = "EnchantedBy";
            magnetList = CardLists.filter(list, c -> {
                if (!c.isCreature()) {
                    return false;
                }
                String sVar = c.getSVar("EnchantMe");
                return sVar.equals("Multiple") || sVar.equals("Once") && !c.isEnchanted();
            });
        } else if (attachSource.isEquipment()) {
            stCheck = "EquippedBy";
            magnetList = CardLists.filter(list, c -> {
                if (!c.isCreature()) {
                    return false;
                }
                String sVar = c.getSVar("EquipMe");
                return sVar.equals("Multiple") || sVar.equals("Once") && !c.isEquipped();
            });
        } else if (attachSource.isFortification()) {
            stCheck = "FortifiedBy";
            magnetList = CardLists.filter(list, c -> c.isCreature() && !c.isFortified());
        }
        CardCollection toRemove = new CardCollection();
        for (Trigger t2 : attachSource.getTriggers()) {
            SpellAbility trigSa;
            Object params;
            if (t2.getMode() != TriggerType.ChangesZone || !"Card.Self".equals((params = t2.getMapParams()).get("ValidCard")) || !"Battlefield".equals(params.get("Destination")) || (trigSa = t2.ensureAbility()) == null || trigSa.getApi() != ApiType.DealDamage || !"Enchanted".equals(trigSa.getParam("Defined"))) continue;
            for (Card card2 : list) {
                if (card2.getController().isOpponentOf(ai)) continue;
                int numDmg = AbilityUtils.calculateAmount(card2, trigSa.getParam("NumDmg"), trigSa);
                if (card2.getNetToughness() - card2.getDamage() > numDmg || card2.hasKeyword(Keyword.INDESTRUCTIBLE)) continue;
                toRemove.add(card2);
            }
        }
        list.removeAll(toRemove);
        if (magnetList != null) {
            if (magnetList.isEmpty() && sa.isSpell()) {
                block2: for (Card target : list) {
                    for (Trigger t3 : target.getTriggers()) {
                        if (t3.getMode() != TriggerType.SpellCast || !"Card.Self".equals(t3.getParam("TargetsValid")) || !"You".equals(t3.getParam("ValidActivatingPlayer"))) continue;
                        magnetList.add(target);
                        continue block2;
                    }
                }
            }
            if (!magnetList.isEmpty()) {
                CardCollection betterList = CardLists.filter((Iterable<Card>)magnetList, c -> CombatUtil.canAttack(c, ai.getWeakestOpponent()));
                if (!betterList.isEmpty()) {
                    return ComputerUtilCard.getBestAI(betterList);
                }
                betterList = CardLists.filter((Iterable<Card>)magnetList, c -> !ComputerUtilCard.isUselessCreature(ai, c));
                if (!betterList.isEmpty()) {
                    return ComputerUtilCard.getBestAI(betterList);
                }
            }
        }
        int totToughness = 0;
        int totPower = 0;
        ArrayList<String> keywords = new ArrayList<String>();
        boolean grantingAbilities = false;
        boolean grantingExtraBlock = false;
        for (StaticAbility stAbility : attachSource.getStaticAbilities()) {
            String affected;
            Map<String, String> stabMap = stAbility.getMapParams();
            if (!"Continuous".equals(stabMap.get("Mode")) || (affected = stabMap.get("Affected")) == null || !affected.contains(stCheck) && !affected.contains("AttachedBy")) continue;
            totToughness += AbilityUtils.calculateAmount(attachSource, stabMap.get("AddToughness"), stAbility);
            totPower += AbilityUtils.calculateAmount(attachSource, stabMap.get("AddPower"), stAbility);
            grantingAbilities |= stabMap.containsKey("AddAbility");
            grantingExtraBlock |= stabMap.containsKey("CanBlockAmount") || stabMap.containsKey("CanBlockAny");
            String kws = stabMap.get("AddKeyword");
            if (kws != null) {
                keywords.addAll(Arrays.asList(kws.split(" & ")));
            }
            if ((kws = stabMap.get("AddHiddenKeyword")) == null) continue;
            keywords.addAll(Arrays.asList(kws.split(" & ")));
        }
        CardCollection cardCollection2 = new CardCollection((Iterable<Card>)list);
        cardCollection2 = ComputerUtil.filterAITgts(sa, ai, cardCollection2, false);
        if (totToughness < 0) {
            int tgh = totToughness;
            CardCollection cardCollection3 = CardLists.filter((Iterable<Card>)cardCollection2, c -> c.getLethalDamage() > Math.abs(tgh));
        }
        if (totToughness + totPower < 4 && (!keywords.isEmpty() || grantingExtraBlock)) {
            void var14_23;
            int pow = totPower;
            boolean extraBlock = grantingExtraBlock;
            CardCollection cardCollection4 = CardLists.filter((Iterable<Card>)var14_23, c -> {
                if (!keywords.isEmpty()) {
                    for (String keyword : keywords) {
                        if (!AttachAi.isUsefulAttachKeyword(keyword, c, sa, pow)) continue;
                        return true;
                    }
                }
                if (c.hasKeyword(Keyword.INFECT) && pow >= 2) {
                    return true;
                }
                return extraBlock && CombatUtil.canBlock(c, true) && !c.canBlockAny();
            });
        }
        if (attachSource.hasSVar("NonStackingAttachEffect")) {
            void var14_25;
            CardCollection cardCollection5 = CardLists.filter((Iterable<Card>)var14_25, Predicates.not(Predicates.or(CardPredicates.isEquippedBy(attachSource.getName()), CardPredicates.isEnchantedBy(attachSource.getName()))));
        }
        CardCollection cardCollection6 = ComputerUtil.getSafeTargets(ai, sa, (CardCollectionView)var14_27);
        if (attachSource.isAura()) {
            void var14_30;
            if (!attachSource.getName().equals("Daybreak Coronet")) {
                CardCollection cardCollection7 = CardLists.filter((Iterable<Card>)cardCollection6, c -> !c.isEnchanted() || c.hasKeyword(Keyword.HEXPROOF));
            }
            CardCollection cardCollection8 = CardLists.filter((Iterable<Card>)var14_30, c -> !c.hasSVar("EndOfTurnLeavePlay"));
        }
        boolean canOnlyTargetCreatures = true;
        for (String valid : ObjectUtils.firstNonNull(attachSource.getFirstAttachSpell(), sa).getTargetRestrictions().getValidTgts()) {
            if (valid.startsWith("Creature")) continue;
            canOnlyTargetCreatures = false;
            break;
        }
        if (canOnlyTargetCreatures && (attachSource.isAura() || attachSource.isEquipment())) {
            void var14_32;
            CardCollection cardCollection9 = CardLists.filter((Iterable<Card>)var14_32, c -> c.getTimesCrewedThisTurn() == 0 || attachSource.isEquipment() && attachSource.getGame().getPhaseHandler().is(PhaseType.MAIN1, ai));
        }
        if (!grantingAbilities) {
            void var14_36;
            if (keywords.isEmpty()) {
                int powerBonus = totPower;
                CardCollection cardCollection10 = CardLists.filter((Iterable<Card>)var14_34, c -> {
                    if (!c.isCreature()) {
                        return true;
                    }
                    return powerBonus + c.getNetPower() > 0 && ComputerUtilCombat.canAttackNextTurn(c);
                });
            }
            card = ComputerUtilCard.getBestAI((Iterable<Card>)var14_36);
        } else {
            for (Card pref : var14_34) {
                if (!pref.isLand() || !pref.isUntapped()) continue;
                return pref;
            }
            card = ComputerUtilCard.getWorstPermanentAI((Iterable<Card>)var14_34, false, false, false, false);
        }
        if (card == null) {
            return AttachAi.chooseLessPreferred(mandatory, list);
        }
        return card;
    }

    private static Card attachToCardAIPreferences(Player aiPlayer, SpellAbility sa, boolean mandatory) {
        List<Card> list;
        Card attachSource = sa.getHostCard();
        if (sa.hasParam("Object")) {
            CardCollection objs = AbilityUtils.getDefinedCards(attachSource, sa.getParam("Object"), sa);
            if (objs.isEmpty()) {
                if (!mandatory) {
                    return null;
                }
            } else {
                attachSource = (Card)objs.get(false);
            }
        }
        if (attachSource.hasSVar("DontEquip")) {
            return null;
        }
        if (!mandatory && !attachSource.isAttachment()) {
            return null;
        }
        if ("MoveTgtAura".equals(sa.getParam("AILogic"))) {
            list = CardLists.filter(CardUtil.getValidCardsToTarget(sa), Predicates.or(CardPredicates.isControlledByAnyOf(aiPlayer.getOpponents()), card -> ComputerUtilCard.isUselessCreature(aiPlayer, card.getAttachedTo())));
            return !((FCollection)list).isEmpty() ? ComputerUtilCard.getBestAI((Iterable<Card>)list) : null;
        }
        if ("Unenchanted".equals(sa.getParam("AILogic"))) {
            list = CardUtil.getValidCardsToTarget(sa);
            CardCollection preferred = CardLists.filter((Iterable<Card>)list, card -> !card.hasCardAttachments());
            return preferred.isEmpty() ? Aggregates.random(list) : Aggregates.random(preferred);
        }
        if (attachSource.isFortification() && attachSource.getAttachedTo() != null && attachSource.getAttachedTo().getController() == aiPlayer) {
            return null;
        }
        list = null;
        list = sa.usesTargeting() ? CardUtil.getValidCardsToTarget(sa) : AbilityUtils.getDefinedCards(attachSource, sa.getParam("Defined"), sa);
        if (list.isEmpty()) {
            return null;
        }
        CardCollection prefList = CardLists.filter(list, CardPredicates.canBeAttached(attachSource, sa));
        prefList = ComputerUtil.filterAITgts(sa, aiPlayer, prefList, true);
        Card c = AttachAi.attachGeneralAI(aiPlayer, sa, prefList, mandatory, attachSource, sa.getParam("AILogic"));
        AiController aic = ((PlayerControllerAi)aiPlayer.getController()).getAi();
        if (c != null && attachSource.isEquipment() && attachSource.isEquipping() && attachSource.getEquipping().getController() == aiPlayer) {
            SpellAbility futureSpell;
            boolean decideMoveFromUseless;
            if (c.equals(attachSource.getEquipping()) && !mandatory) {
                return null;
            }
            if ("InstantReequipPowerBuff".equals(sa.getParam("AILogic"))) {
                return c;
            }
            boolean uselessCreature = ComputerUtilCard.isUselessCreature(aiPlayer, attachSource.getEquipping());
            if (aic.getProperty(AiProps.MOVE_EQUIPMENT_TO_BETTER_CREATURES).equals("never") && !mandatory) {
                return null;
            }
            if (aic.getProperty(AiProps.MOVE_EQUIPMENT_TO_BETTER_CREATURES).equals("from_useless_only") && !uselessCreature && !mandatory) {
                return null;
            }
            boolean bl = decideMoveFromUseless = uselessCreature && aic.getBooleanProperty(AiProps.PRIORITIZE_MOVE_EQUIPMENT_IF_USELESS);
            if (!decideMoveFromUseless && AiCardMemory.isMemorySetEmpty(aiPlayer, AiCardMemory.MemorySet.HELD_MANA_SOURCES_FOR_MAIN2) && (futureSpell = aic.predictSpellToCastInMain2(ApiType.Attach)) != null && futureSpell.getHostCard() != null) {
                aic.reserveManaSources(futureSpell);
            }
            if (AiCardMemory.isRememberedCard(aiPlayer, attachSource, AiCardMemory.MemorySet.ATTACHED_THIS_TURN) && !mandatory) {
                return null;
            }
            int evalT = aic.getIntProperty(AiProps.MOVE_EQUIPMENT_CREATURE_EVAL_THRESHOLD);
            if (!decideMoveFromUseless && ComputerUtilCard.evaluateCreature(c) - ComputerUtilCard.evaluateCreature(attachSource.getEquipping()) < evalT && !mandatory) {
                return null;
            }
        }
        AiCardMemory.rememberCard(aiPlayer, attachSource, AiCardMemory.MemorySet.ATTACHED_THIS_TURN);
        if (c == null && mandatory) {
            CardLists.shuffle(list);
            c = list.get(0);
        }
        return c;
    }

    public static Card attachGeneralAI(Player ai, SpellAbility sa, List<Card> list, boolean mandatory, Card attachSource, String logic) {
        if ("InstantReequipPowerBuff".equals(logic)) {
            return AttachAi.attachAIInstantReequipPreference(sa, attachSource);
        }
        Player prefPlayer = "Pump".equals(logic) || "Animate".equals(logic) || "Curiosity".equals(logic) || "MoveTgtAura".equals(logic) || "MoveAllAuras".equals(logic) ? ai : AiAttackController.choosePreferredDefenderPlayer(ai);
        CardCollection prefList = "Reanimate".equals(logic) || "SpecificCard".equals(logic) ? list : CardLists.filterControlledBy(list, prefPlayer);
        if (logic == null || prefList.isEmpty()) {
            return AttachAi.chooseUnpreferred(mandatory, list);
        }
        Card c = null;
        if ("GainControl".equals(logic)) {
            c = AttachAi.attachAIControlPreference(sa, prefList, mandatory, attachSource);
        } else if ("Curse".equals(logic)) {
            c = AttachAi.attachAICursePreference(sa, prefList, mandatory, attachSource, ai);
        } else if ("Pump".equals(logic) || logic.startsWith("Move")) {
            c = AttachAi.attachAIPumpPreference(ai, sa, prefList, mandatory, attachSource);
        } else if ("Curiosity".equals(logic)) {
            c = AttachAi.attachAICuriosityPreference(sa, prefList, mandatory, attachSource);
        } else if ("ChangeType".equals(logic)) {
            c = AttachAi.attachAIChangeTypePreference(sa, prefList, mandatory, attachSource);
        } else if ("KeepTapped".equals(logic)) {
            c = AttachAi.attachAIKeepTappedPreference(sa, prefList, mandatory, attachSource);
        } else if ("Animate".equals(logic)) {
            c = AttachAi.attachAIAnimatePreference(sa, prefList, mandatory, attachSource);
        } else if ("Reanimate".equals(logic)) {
            c = AttachAi.attachAIReanimatePreference(sa, prefList, mandatory, attachSource);
        } else if ("SpecificCard".equals(logic)) {
            c = AttachAi.attachAISpecificCardPreference(sa, prefList, mandatory, attachSource);
        } else if ("HighestEvaluation".equals(logic)) {
            c = AttachAi.attachAIHighestEvaluationPreference(prefList);
        }
        if (!AttachAi.isUsefulAttachAction(ai, c, sa)) {
            return null;
        }
        return c;
    }

    private static boolean containsUsefulCurseKeyword(List<String> keywords, Card card, SpellAbility sa) {
        for (String keyword : keywords) {
            if (!AttachAi.isUsefulCurseKeyword(keyword, card, sa)) continue;
            return true;
        }
        return false;
    }

    private static boolean isUsefulAttachKeyword(String keyword, Card card, SpellAbility sa, int powerBonus) {
        Player ai = sa.getActivatingPlayer();
        PhaseHandler ph = ai.getGame().getPhaseHandler();
        if (!CardUtil.isStackingKeyword(keyword) && card.hasKeyword(keyword)) {
            return false;
        }
        if (sa.getHostCard().hasSVar("ChosenProtection")) {
            CardCollection oppAllCards = ai.getOpponents().getCardsIn(ZoneType.Battlefield);
            String cc = ComputerUtilCard.getMostProminentColor(oppAllCards);
            if (card.hasKeyword("Protection from " + cc.toLowerCase())) {
                return false;
            }
            for (Card c : card.getEnchantedBy()) {
                if (!c.getController().equals(ai) || !c.isOfColor(cc)) continue;
                return false;
            }
        }
        boolean evasive = keyword.equals("Fear") || keyword.equals("Intimidate") || keyword.equals("Shadow") || keyword.equals("Flying") || keyword.equals("Horsemanship") || keyword.startsWith("Landwalk") || keyword.equals("All creatures able to block CARDNAME do so.");
        boolean canBeBlocked = false;
        for (Player opp : ai.getOpponents()) {
            if (!CombatUtil.canBeBlocked(card, null, opp)) continue;
            canBeBlocked = true;
            break;
        }
        if (evasive) {
            return card.getNetCombatDamage() + powerBonus > 0 && canBeBlocked && ComputerUtilCombat.canAttackNextTurn(card);
        }
        if (keyword.equals("Haste")) {
            return card.hasSickness() && ph.isPlayerTurn(ai) && !card.isTapped() && card.getNetCombatDamage() + powerBonus > 0 && !ph.getPhase().isAfter(PhaseType.COMBAT_DECLARE_ATTACKERS) && ComputerUtilCombat.canAttackNextTurn(card);
        }
        if (keyword.endsWith("Indestructible")) {
            return true;
        }
        if (keyword.endsWith("Deathtouch") || keyword.endsWith("Wither")) {
            return card.getNetCombatDamage() + powerBonus > 0 && (canBeBlocked && ComputerUtilCombat.canAttackNextTurn(card) || CombatUtil.canBlock(card, true));
        }
        if (keyword.equals("Double Strike") || keyword.equals("Lifelink")) {
            return card.getNetCombatDamage() + powerBonus > 0 && (ComputerUtilCombat.canAttackNextTurn(card) || CombatUtil.canBlock(card, true));
        }
        if (keyword.equals("First Strike")) {
            return card.getNetCombatDamage() + powerBonus > 0 && !card.hasDoubleStrike() && (ComputerUtilCombat.canAttackNextTurn(card) || CombatUtil.canBlock(card, true));
        }
        if (keyword.startsWith("Flanking")) {
            return card.getNetCombatDamage() + powerBonus > 0 && canBeBlocked && ComputerUtilCombat.canAttackNextTurn(card);
        }
        if (keyword.startsWith("Bushido")) {
            return canBeBlocked && ComputerUtilCombat.canAttackNextTurn(card) || CombatUtil.canBlock(card, true);
        }
        if (keyword.equals("Trample")) {
            return card.getNetCombatDamage() + powerBonus > 1 && canBeBlocked && ComputerUtilCombat.canAttackNextTurn(card);
        }
        if (keyword.equals("Infect")) {
            return card.getNetCombatDamage() + powerBonus > 0 && ComputerUtilCombat.canAttackNextTurn(card);
        }
        if (keyword.equals("Vigilance")) {
            return card.getNetCombatDamage() + powerBonus > 0 && ComputerUtilCombat.canAttackNextTurn(card) && CombatUtil.canBlock(card, true);
        }
        if (keyword.equals("Reach")) {
            return !card.hasKeyword(Keyword.FLYING) && CombatUtil.canBlock(card, true);
        }
        if (keyword.equals("Shroud") || keyword.equals("Hexproof")) {
            return !card.hasKeyword(Keyword.SHROUD) && !card.hasKeyword(Keyword.HEXPROOF);
        }
        return !keyword.equals("Defender");
    }

    private static boolean isUsefulCurseKeyword(String keyword, Card card, SpellAbility sa) {
        if (!CardUtil.isStackingKeyword(keyword) && card.hasKeyword(keyword)) {
            return false;
        }
        if (keyword.endsWith("CARDNAME can't attack.") || keyword.equals("Defender") || keyword.endsWith("CARDNAME can't attack or block.")) {
            return card.getNetCombatDamage() >= 1 && ComputerUtilCombat.canAttackNextTurn(card);
        }
        if (keyword.endsWith("CARDNAME can't block.")) {
            return CombatUtil.canBlock(card, true);
        }
        if (keyword.endsWith("CARDNAME's activated abilities can't be activated.")) {
            for (SpellAbility ability : card.getSpellAbilities()) {
                if (!ability.isAbility()) continue;
                return true;
            }
            return false;
        }
        if (keyword.endsWith("Prevent all combat damage that would be dealt by CARDNAME.")) {
            return card.getNetCombatDamage() >= 1 && ComputerUtilCombat.canAttackNextTurn(card);
        }
        if (keyword.endsWith("Prevent all combat damage that would be dealt to and dealt by CARDNAME.") || keyword.endsWith("Prevent all damage that would be dealt to and dealt by CARDNAME.")) {
            return card.getNetCombatDamage() >= 2 && ComputerUtilCombat.canAttackNextTurn(card);
        }
        if (keyword.endsWith("CARDNAME doesn't untap during your untap step.")) {
            return !card.isUntapped();
        }
        return true;
    }

    private static boolean isUsefulAttachAction(Player ai, Card c, SpellAbility sa) {
        if (c == null) {
            return false;
        }
        return !sa.getHostCard().isEquipment() || !ComputerUtilCard.isUselessCreature(ai, c);
    }

    public static Card doPumpOrCurseAILogic(Player ai, SpellAbility sa, List<Card> list, String type) {
        Card chosen = null;
        CardCollection aiType = CardLists.filter(list, c -> {
            if (!c.getController().equals(ai)) {
                return false;
            }
            return c.isValid(type, ai, sa.getHostCard(), (CardTraitBase)sa);
        });
        CardCollection oppNonType = CardLists.filter(list, c -> {
            if (c.getController().equals(ai)) {
                return false;
            }
            return !c.isValid(type, ai, sa.getHostCard(), (CardTraitBase)sa) && !ComputerUtilCard.isUselessCreature(ai, c);
        });
        if (!aiType.isEmpty() && !oppNonType.isEmpty()) {
            Card bestAi = ComputerUtilCard.getBestCreatureAI(aiType);
            Card bestOpp = ComputerUtilCard.getBestCreatureAI(oppNonType);
            chosen = ComputerUtilCard.evaluateCreature(bestAi) > ComputerUtilCard.evaluateCreature(bestOpp) ? bestAi : bestOpp;
        } else if (!aiType.isEmpty()) {
            chosen = ComputerUtilCard.getBestCreatureAI(aiType);
        } else if (!oppNonType.isEmpty()) {
            chosen = ComputerUtilCard.getBestCreatureAI(oppNonType);
        }
        return chosen;
    }

    @Override
    public boolean chkAIDrawback(SpellAbility sa, Player ai) {
        if (sa.isTrigger() && sa.usesTargeting()) {
            CardCollection targetables = CardLists.getTargetableCards(ai.getCardsIn(ZoneType.Battlefield), sa);
            CardCollection source = AbilityUtils.getDefinedCards(sa.getHostCard(), sa.getParam("Object"), sa);
            Card tgt = AttachAi.attachGeneralAI(ai, sa, targetables, !sa.getRootAbility().isOptionalTrigger(), (Card)source.getFirst(), null);
            if (tgt != null) {
                sa.resetTargets();
                sa.getTargets().add(tgt);
            }
            return sa.isTargetNumberValid();
        }
        return "Remembered".equals(sa.getParam("Defined")) && sa.getParent() != null && sa.getParent().getApi() == ApiType.Token && sa.getParent().hasParam("RememberTokens");
    }

    @Override
    public boolean confirmAction(Player player, SpellAbility sa, PlayerActionConfirmMode mode, String message, Map<String, Object> params) {
        return true;
    }

    @Override
    protected Card chooseSingleCard(Player ai, SpellAbility sa, Iterable<Card> options, boolean isOptional, Player targetedPlayer, Map<String, Object> params) {
        return AttachAi.attachGeneralAI(ai, sa, (List)options, !isOptional, sa.getHostCard(), sa.getParam("AILogic"));
    }

    @Override
    protected Player chooseSinglePlayer(Player ai, SpellAbility sa, Iterable<Player> options, Map<String, Object> params) {
        return AttachAi.attachToPlayerAIPreferences(ai, sa, true, (List)options);
    }
}

