/*
 * Decompiled with CFR 0.152.
 */
package forge.ai.ability;

import forge.ai.SpellAbilityAi;
import forge.game.ability.AbilityUtils;
import forge.game.card.Card;
import forge.game.card.CardCollection;
import forge.game.card.CardLists;
import forge.game.player.Player;
import forge.game.player.PlayerCollection;
import forge.game.spellability.SpellAbility;
import forge.game.spellability.TargetRestrictions;
import forge.game.zone.ZoneType;
import forge.util.MyRandom;
import java.util.List;
import java.util.Map;

public class ActivateAbilityAi
extends SpellAbilityAi {
    @Override
    protected boolean canPlayAI(Player ai, SpellAbility sa) {
        Card source = sa.getHostCard();
        Player opp = ai.getStrongestOpponent();
        CardCollection list = CardLists.getType(opp.getCardsIn(ZoneType.Battlefield), sa.getParamOrDefault("Type", "Card"));
        if (list.isEmpty()) {
            return false;
        }
        if (!sa.usesTargeting()) {
            PlayerCollection defined = AbilityUtils.getDefinedPlayers(source, sa.getParam("Defined"), sa);
            if (!defined.contains(opp)) {
                return false;
            }
        } else {
            sa.resetTargets();
            if (sa.canTarget(opp)) {
                sa.getTargets().add(opp);
            } else {
                return false;
            }
        }
        boolean randomReturn = (double)MyRandom.getRandom().nextFloat() <= Math.pow(0.6667, sa.getActivationsThisTurn());
        return randomReturn;
    }

    @Override
    protected boolean doTriggerAINoCost(Player ai, SpellAbility sa, boolean mandatory) {
        Player opp = ai.getStrongestOpponent();
        TargetRestrictions tgt = sa.getTargetRestrictions();
        Card source = sa.getHostCard();
        if (null == tgt) {
            if (mandatory) {
                return true;
            }
            PlayerCollection defined = AbilityUtils.getDefinedPlayers(source, sa.getParam("Defined"), sa);
            return defined.contains(opp);
        }
        sa.resetTargets();
        sa.getTargets().add(opp);
        return true;
    }

    @Override
    public boolean chkAIDrawback(SpellAbility sa, Player ai) {
        Card source = sa.getHostCard();
        boolean randomReturn = true;
        if (!sa.usesTargeting()) {
            PlayerCollection defined = AbilityUtils.getDefinedPlayers(source, sa.getParam("Defined"), sa);
            if (defined.contains(ai)) {
                return false;
            }
        } else {
            sa.resetTargets();
            sa.getTargets().add(ai.getWeakestOpponent());
        }
        return randomReturn;
    }

    @Override
    public SpellAbility chooseSingleSpellAbility(Player player, SpellAbility sa, List<SpellAbility> spells, Map<String, Object> params) {
        return spells.get(0);
    }
}

