/*
 * Decompiled with CFR 0.152.
 */
package forge.ai;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import forge.ai.ComputerUtil;
import forge.ai.ComputerUtilCost;
import forge.ai.ComputerUtilMana;
import forge.ai.SpellApiToAi;
import forge.card.CardStateName;
import forge.card.ICardFace;
import forge.card.mana.ManaCost;
import forge.card.mana.ManaCostParser;
import forge.game.GameEntity;
import forge.game.card.Card;
import forge.game.card.CardState;
import forge.game.card.CounterType;
import forge.game.cost.Cost;
import forge.game.mana.ManaCostBeingPaid;
import forge.game.phase.PhaseHandler;
import forge.game.phase.PhaseType;
import forge.game.player.Player;
import forge.game.player.PlayerActionConfirmMode;
import forge.game.player.PlayerController;
import forge.game.spellability.AbilitySub;
import forge.game.spellability.SpellAbility;
import forge.game.spellability.SpellAbilityCondition;
import forge.game.zone.ZoneType;
import forge.util.MyRandom;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public abstract class SpellAbilityAi {
    public final boolean canPlayAIWithSubs(Player aiPlayer, SpellAbility sa) {
        if (!this.canPlayAI(aiPlayer, sa)) {
            return false;
        }
        AbilitySub subAb = sa.getSubAbility();
        return subAb == null || this.chkDrawbackWithSubs(aiPlayer, subAb);
    }

    protected boolean canPlayAI(Player ai, SpellAbility sa) {
        Card source = sa.getHostCard();
        if (sa.getRestrictions() != null && !sa.getRestrictions().canPlay(source, sa)) {
            return false;
        }
        return this.canPlayWithoutRestrict(ai, sa);
    }

    protected boolean canPlayWithoutRestrict(Player ai, SpellAbility sa) {
        AbilitySub sub;
        Card source = sa.getHostCard();
        Cost cost = sa.getPayCosts();
        if (sa.hasParam("AICheckCanPlayWithDefinedX")) {
            sa.setXManaCostPaid(ComputerUtilCost.getMaxXValue(sa, ai, false));
        }
        if (!this.checkConditions(ai, sa, sa.getConditions()) && (sub = sa.getSubAbility()) != null && !this.checkConditions(ai, sub, sub.getConditions())) {
            return false;
        }
        if (sa.hasParam("AILogic")) {
            boolean alwaysOnDiscard;
            String logic = sa.getParam("AILogic");
            boolean bl = alwaysOnDiscard = "AlwaysOnDiscard".equals(logic) && ai.getGame().getPhaseHandler().is(PhaseType.END_OF_TURN, ai) && !ai.isUnlimitedHandSize() && ai.getCardsIn(ZoneType.Hand).size() > ai.getMaxHandSize();
            if (!this.checkAiLogic(ai, sa, logic)) {
                return false;
            }
            if (!alwaysOnDiscard && !this.checkPhaseRestrictions(ai, sa, ai.getGame().getPhaseHandler(), logic)) {
                return false;
            }
        } else if (!this.checkPhaseRestrictions(ai, sa, ai.getGame().getPhaseHandler())) {
            return false;
        }
        if (!this.checkApiLogic(ai, sa)) {
            return false;
        }
        return cost == null || this.willPayCosts(ai, sa, cost, source);
    }

    protected boolean checkConditions(Player ai, SpellAbility sa, SpellAbilityCondition con) {
        ManaCostBeingPaid paid;
        if (!(con = (SpellAbilityCondition)con.copy()).getManaSpent().isEmpty() && ComputerUtilMana.canPayManaCost(paid = new ManaCostBeingPaid(new ManaCost(new ManaCostParser(con.getManaSpent()))), sa, ai, sa.isTrigger())) {
            con.setManaSpent("");
        }
        return con.areMet(sa);
    }

    protected boolean checkAiLogic(Player ai, SpellAbility sa, String aiLogic) {
        if (aiLogic.equals("CheckCondition")) {
            SpellAbility saCopy = sa.copy();
            saCopy.setActivatingPlayer(ai, true);
            return saCopy.metConditions();
        }
        return !"Never".equals(aiLogic);
    }

    protected boolean willPayCosts(Player ai, SpellAbility sa, Cost cost, Card source) {
        if (!ComputerUtilCost.checkLifeCost(ai, cost, source, 4, sa)) {
            return false;
        }
        if (!ComputerUtilCost.checkDiscardCost(ai, cost, source, sa)) {
            return false;
        }
        if (!ComputerUtilCost.checkSacrificeCost(ai, cost, source, sa)) {
            return false;
        }
        return ComputerUtilCost.checkRemoveCounterCost(cost, source, sa);
    }

    protected boolean checkPhaseRestrictions(Player ai, SpellAbility sa, PhaseHandler ph) {
        return true;
    }

    protected boolean checkPhaseRestrictions(Player ai, SpellAbility sa, PhaseHandler ph, String logic) {
        return this.checkPhaseRestrictions(ai, sa, ph);
    }

    protected boolean checkApiLogic(Player ai, SpellAbility sa) {
        if (ComputerUtil.preventRunAwayActivations(sa)) {
            return false;
        }
        return MyRandom.getRandom().nextFloat() < 0.8f;
    }

    public final boolean doTriggerAI(Player aiPlayer, SpellAbility sa, boolean mandatory) {
        if (!ComputerUtilCost.canPayCost(sa, aiPlayer, true) && !mandatory) {
            return false;
        }
        if (sa.usesTargeting() && mandatory && sa.getTargetRestrictions().getNumCandidates(sa, true) == 0) {
            return sa.isTargetNumberValid();
        }
        return this.doTriggerNoCostWithSubs(aiPlayer, sa, mandatory);
    }

    public final boolean doTriggerNoCostWithSubs(Player aiPlayer, SpellAbility sa, boolean mandatory) {
        if (!this.doTriggerAINoCost(aiPlayer, sa, mandatory) && !"Always".equals(sa.getParam("AILogic"))) {
            return false;
        }
        AbilitySub subAb = sa.getSubAbility();
        return subAb == null || this.chkDrawbackWithSubs(aiPlayer, subAb) || mandatory;
    }

    protected boolean doTriggerAINoCost(Player aiPlayer, SpellAbility sa, boolean mandatory) {
        if (this.canPlayWithoutRestrict(aiPlayer, sa) && (!mandatory || sa.isTargetNumberValid())) {
            return true;
        }
        if (!mandatory) {
            return false;
        }
        if (sa.usesTargeting()) {
            ArrayList<Player> players = Lists.newArrayList();
            players.addAll(aiPlayer.getOpponents());
            players.addAll(aiPlayer.getAllies());
            players.add(aiPlayer);
            for (Player p : players) {
                if (!sa.canTarget(p)) continue;
                sa.resetTargets();
                sa.getTargets().add(p);
                return true;
            }
            return false;
        }
        return true;
    }

    public boolean chkAIDrawback(SpellAbility sa, Player aiPlayer) {
        if (sa.usesTargeting()) {
            if (!sa.getTargetRestrictions().hasCandidates(sa)) {
                return false;
            }
            System.err.println("Warning: default (ie. inherited from base class) implementation of chkAIDrawback is used by " + sa.getHostCard().getName() + " for " + this.getClass().getName() + ". Consider declaring an overloaded method");
            return false;
        }
        return true;
    }

    protected static boolean isSorcerySpeed(SpellAbility sa, Player ai) {
        return sa.getRootAbility().isSpell() && sa.getHostCard().isSorcery() || sa.getRootAbility().isActivatedAbility() && sa.getRootAbility().getRestrictions().isSorcerySpeed() || sa.getRootAbility().isAdventure() && sa.getHostCard().getState(CardStateName.Adventure).getType().isSorcery() || sa.isPwAbility() && !sa.withFlash(sa.getHostCard(), ai);
    }

    protected static boolean playReusable(Player ai, SpellAbility sa) {
        PhaseHandler phase = ai.getGame().getPhaseHandler();
        if (sa instanceof AbilitySub) {
            return true;
        }
        if (!sa.getPayCosts().isReusuableResource()) {
            return false;
        }
        if (ComputerUtil.playImmediately(ai, sa)) {
            return true;
        }
        if (sa.isPwAbility() && phase.is(PhaseType.MAIN2)) {
            return true;
        }
        if (sa.isSpell() && !sa.isBuyback()) {
            return false;
        }
        return phase.is(PhaseType.END_OF_TURN) && phase.getNextTurn().equals(ai);
    }

    public boolean chkDrawbackWithSubs(Player aiPlayer, AbilitySub ab) {
        AbilitySub subAb = ab.getSubAbility();
        return SpellApiToAi.Converter.get(ab.getApi()).chkAIDrawback(ab, aiPlayer) && (subAb == null || this.chkDrawbackWithSubs(aiPlayer, subAb));
    }

    public boolean confirmAction(Player player, SpellAbility sa, PlayerActionConfirmMode mode, String message, Map<String, Object> params) {
        System.err.println("Warning: default (ie. inherited from base class) implementation of confirmAction is used by " + sa.getHostCard().getName() + " for " + this.getClass().getName() + ". Consider declaring an overloaded method");
        return true;
    }

    public <T extends GameEntity> T chooseSingleEntity(Player ai, SpellAbility sa, Collection<T> options, boolean isOptional, Player targetedPlayer, Map<String, Object> params) {
        boolean hasPlayer = false;
        boolean hasCard = false;
        boolean hasAttackableCard = false;
        for (GameEntity ent : options) {
            if (ent instanceof Player) {
                hasPlayer = true;
                continue;
            }
            if (!(ent instanceof Card)) continue;
            hasCard = true;
            if (!((Card)ent).isPlaneswalker() && !((Card)ent).isBattle()) continue;
            hasAttackableCard = true;
        }
        if (hasPlayer && hasAttackableCard) {
            return (T)this.chooseSingleAttackableEntity(ai, sa, options, params);
        }
        if (hasCard) {
            return (T)this.chooseSingleCard(ai, sa, options, isOptional, targetedPlayer, params);
        }
        if (hasPlayer) {
            return (T)this.chooseSinglePlayer(ai, sa, options, params);
        }
        return null;
    }

    public SpellAbility chooseSingleSpellAbility(Player player, SpellAbility sa, List<SpellAbility> spells, Map<String, Object> params) {
        System.err.println("Warning: default (ie. inherited from base class) implementation of chooseSingleSpellAbility is used by " + sa.getHostCard().getName() + " for " + this.getClass().getName() + ". Consider declaring an overloaded method");
        return spells.get(0);
    }

    protected Card chooseSingleCard(Player ai, SpellAbility sa, Iterable<Card> options, boolean isOptional, Player targetedPlayer, Map<String, Object> params) {
        System.err.println("Warning: default (ie. inherited from base class) implementation of chooseSingleCard is used by " + sa.getHostCard().getName() + " for " + this.getClass().getName() + ". Consider declaring an overloaded method");
        return Iterables.getFirst(options, null);
    }

    protected Player chooseSinglePlayer(Player ai, SpellAbility sa, Iterable<Player> options, Map<String, Object> params) {
        System.err.println("Warning: default (ie. inherited from base class) implementation of chooseSinglePlayer is used by " + sa.getHostCard().getName() + " for " + this.getClass().getName() + ". Consider declaring an overloaded method");
        return Iterables.getFirst(options, null);
    }

    protected GameEntity chooseSingleAttackableEntity(Player ai, SpellAbility sa, Iterable<GameEntity> options, Map<String, Object> params) {
        System.err.println("Warning: default (ie. inherited from base class) implementation of chooseSinglePlayerOrPlaneswalker is used for " + this.getClass().getName() + ". Consider declaring an overloaded method");
        return Iterables.getFirst(options, null);
    }

    public String chooseCardName(Player ai, SpellAbility sa, List<ICardFace> faces) {
        System.err.println("Warning: default (ie. inherited from base class) implementation of chooseCardName is used for " + this.getClass().getName() + ". Consider declaring an overloaded method");
        ICardFace face = Iterables.getFirst(faces, null);
        return face == null ? "" : face.getName();
    }

    public ICardFace chooseCardFace(Player ai, SpellAbility sa, List<ICardFace> faces) {
        System.err.println("Warning: default (ie. inherited from base class) implementation of chooseCardFace is used for " + this.getClass().getName() + ". Consider declaring an overloaded method");
        return Iterables.getFirst(faces, null);
    }

    public CardState chooseCardState(Player ai, SpellAbility sa, List<CardState> faces, Map<String, Object> params) {
        System.err.println("Warning: default (ie. inherited from base class) implementation of chooseCardState is used for " + this.getClass().getName() + ". Consider declaring an overloaded method");
        return Iterables.getFirst(faces, null);
    }

    public int chooseNumber(Player player, SpellAbility sa, int min2, int max, Map<String, Object> params) {
        return max;
    }

    public CounterType chooseCounterType(List<CounterType> options, SpellAbility sa, Map<String, Object> params) {
        return Iterables.getFirst(options, null);
    }

    public boolean chooseBinary(PlayerController.BinaryChoiceType kindOfChoice, SpellAbility sa, Map<String, Object> params) {
        return MyRandom.getRandom().nextBoolean();
    }
}

