/*
 * Decompiled with CFR 0.152.
 */
package forge.ai;

import forge.LobbyPlayer;
import forge.ai.AIOption;
import forge.ai.AiProfileUtil;
import forge.ai.PlayerControllerAi;
import forge.game.Game;
import forge.game.player.IGameEntitiesFactory;
import forge.game.player.Player;
import forge.game.player.PlayerController;
import java.util.Set;

public class LobbyPlayerAi
extends LobbyPlayer
implements IGameEntitiesFactory {
    private String aiProfile = "";
    private boolean rotateProfileEachGame;
    private boolean allowCheatShuffle;
    private boolean useSimulation;

    public LobbyPlayerAi(String name, Set<AIOption> options) {
        super(name);
        if (options != null && options.contains((Object)AIOption.USE_SIMULATION)) {
            this.useSimulation = true;
        }
    }

    public boolean isAllowCheatShuffle() {
        return this.allowCheatShuffle;
    }

    public void setAllowCheatShuffle(boolean allowCheatShuffle) {
        this.allowCheatShuffle = allowCheatShuffle;
    }

    public void setAiProfile(String profileName) {
        this.aiProfile = profileName;
    }

    public String getAiProfile() {
        return this.aiProfile;
    }

    public void setRotateProfileEachGame(boolean rotateProfileEachGame) {
        this.rotateProfileEachGame = rotateProfileEachGame;
    }

    private PlayerControllerAi createControllerFor(Player ai) {
        PlayerControllerAi result = new PlayerControllerAi(ai.getGame(), ai, this);
        result.setUseSimulation(this.useSimulation);
        result.allowCheatShuffle(this.allowCheatShuffle);
        return result;
    }

    @Override
    public PlayerController createMindSlaveController(Player master, Player slave) {
        return this.createControllerFor(slave);
    }

    @Override
    public Player createIngamePlayer(Game game, int id) {
        Player ai = new Player(this.getName(), game, id);
        ai.setFirstController(this.createControllerFor(ai));
        if (this.rotateProfileEachGame) {
            this.setAiProfile(AiProfileUtil.getRandomProfile());
        }
        return ai;
    }

    @Override
    public void hear(LobbyPlayer player, String message) {
    }
}

