/*
 * Decompiled with CFR 0.152.
 */
package forge.ai;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import forge.ai.AiProps;
import forge.ai.ComputerUtil;
import forge.ai.ComputerUtilCard;
import forge.ai.ComputerUtilCost;
import forge.ai.PlayerControllerAi;
import forge.game.CardTraitBase;
import forge.game.Game;
import forge.game.GameEntity;
import forge.game.ability.AbilityKey;
import forge.game.ability.AbilityUtils;
import forge.game.ability.ApiType;
import forge.game.card.Card;
import forge.game.card.CardCollection;
import forge.game.card.CardCollectionView;
import forge.game.card.CardCopyService;
import forge.game.card.CardLists;
import forge.game.card.CardPredicates;
import forge.game.card.CounterEnumType;
import forge.game.combat.AttackingBand;
import forge.game.combat.Combat;
import forge.game.combat.CombatUtil;
import forge.game.cost.CostPayment;
import forge.game.keyword.Keyword;
import forge.game.phase.Untap;
import forge.game.player.Player;
import forge.game.replacement.ReplacementEffect;
import forge.game.replacement.ReplacementLayer;
import forge.game.replacement.ReplacementType;
import forge.game.spellability.SpellAbility;
import forge.game.staticability.StaticAbility;
import forge.game.staticability.StaticAbilityAssignCombatDamageAsUnblocked;
import forge.game.staticability.StaticAbilityMustAttack;
import forge.game.trigger.Trigger;
import forge.game.trigger.TriggerType;
import forge.game.zone.ZoneType;
import forge.util.MyRandom;
import forge.util.TextUtil;
import forge.util.collect.FCollection;
import forge.util.collect.FCollectionView;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class ComputerUtilCombat {
    private static boolean dontTestRegen = false;

    public static void setCombatRegenTestSuppression(boolean shouldSuppress) {
        dontTestRegen = shouldSuppress;
    }

    public static boolean canAttackNextTurn(Card attacker) {
        FCollectionView<GameEntity> defenders = CombatUtil.getAllPossibleDefenders(attacker.getController());
        return Iterables.any(defenders, input -> ComputerUtilCombat.canAttackNextTurn(attacker, input));
    }

    public static boolean canAttackNextTurn(Card attacker, GameEntity defender) {
        if (!attacker.isCreature()) {
            return false;
        }
        if (!CombatUtil.canAttackNextTurn(attacker, defender)) {
            return false;
        }
        if (attacker.getGame().getReplacementHandler().wouldPhaseBeSkipped(attacker.getController(), "BeginCombat")) {
            return false;
        }
        List<GameEntity> mustAttack = StaticAbilityMustAttack.entitiesMustAttack(attacker);
        mustAttack.removeAll(new CardCollection(attacker));
        if (!mustAttack.isEmpty() && !mustAttack.contains(defender)) {
            return false;
        }
        return !attacker.isTapped() || attacker.getCounters(CounterEnumType.STUN) == 0 && Untap.canUntap(attacker);
    }

    public static int getTotalFirstStrikeBlockPower(Card attacker, Player player) {
        CardCollection list = player.getCreaturesInPlay();
        list = CardLists.filter((Iterable<Card>)list, c -> (c.hasFirstStrike() || c.hasDoubleStrike()) && CombatUtil.canBlock(attacker, c));
        return ComputerUtilCombat.totalFirstStrikeDamageOfBlockers(attacker, list);
    }

    public static int getAttack(Card c) {
        int n = c.getNetCombatDamage();
        if (c.hasDoubleStrike()) {
            n *= 2;
        }
        return n;
    }

    public static int damageIfUnblocked(Card attacker, GameEntity attacked, Combat combat, boolean withoutAbilities) {
        int damage = attacker.getNetCombatDamage();
        int sum = 0;
        if (attacked instanceof Player && !((Player)attacked).canLoseLife()) {
            return 0;
        }
        if (ComputerUtilCombat.isCombatDamagePrevented(attacker, attacked, damage)) {
            return 0;
        }
        if (!attacker.hasKeyword(Keyword.INFECT)) {
            sum = ComputerUtilCombat.predictDamageTo(attacked, damage += ComputerUtilCombat.predictPowerBonusOfAttacker(attacker, null, combat, withoutAbilities), attacker, true);
            if (attacker.hasDoubleStrike()) {
                sum *= 2;
            }
        }
        return sum;
    }

    public static int poisonIfUnblocked(Card attacker, Player attacked) {
        if (!attacked.canReceiveCounters(CounterEnumType.POISON)) {
            return 0;
        }
        int damage = attacker.getNetCombatDamage();
        int poison = 0;
        damage += ComputerUtilCombat.predictPowerBonusOfAttacker(attacker, null, null, false);
        if (attacker.hasKeyword(Keyword.INFECT)) {
            int pd = ComputerUtilCombat.predictDamageTo(attacked, damage, attacker, true);
            if (pd == 1 && Iterables.any(attacker.getController().getOpponents().getCardsIn(ZoneType.Battlefield), CardPredicates.nameEquals("Vorinclex, Monstrous Raider"))) {
                pd = 0;
            }
            poison += pd;
            if (attacker.hasDoubleStrike()) {
                poison += pd;
            }
        }
        if (damage > 0) {
            poison += ComputerUtilCombat.predictExtraPoisonWithDamage(attacker, attacked, damage);
        }
        return poison;
    }

    public static int sumDamageIfUnblocked(Iterable<Card> attackers, Player attacked) {
        return ComputerUtilCombat.sumDamageIfUnblocked(attackers, attacked, false);
    }

    public static int sumDamageIfUnblocked(Iterable<Card> attackers, Player attacked, boolean onlyPreventable) {
        int sum = 0;
        for (Card attacker : attackers) {
            if (onlyPreventable && !attacker.canDamagePrevented(true)) continue;
            sum += ComputerUtilCombat.damageIfUnblocked(attacker, attacked, null, false);
        }
        return sum;
    }

    public static int sumPoisonIfUnblocked(List<Card> attackers, Player attacked) {
        int sum = 0;
        for (Card attacker : attackers) {
            sum += ComputerUtilCombat.poisonIfUnblocked(attacker, attacked);
        }
        return sum;
    }

    public static boolean wouldLoseLife(Player ai, Combat combat) {
        return ComputerUtilCombat.lifeThatWouldRemain(ai, combat) < ai.getLife();
    }

    public static int lifeThatWouldRemain(Player ai, Combat combat) {
        int damage = 0;
        if (ai.canLoseLife()) {
            CardCollection attackers = combat.getAttackersOf(ai);
            ArrayList<Card> unblocked = Lists.newArrayList();
            for (Card attacker : attackers) {
                int dmgAfterShielding;
                CardCollection blockers = combat.getBlockers(attacker);
                if (blockers.size() == 0 || StaticAbilityAssignCombatDamageAsUnblocked.assignCombatDamageAsUnblocked(attacker)) {
                    unblocked.add(attacker);
                    continue;
                }
                if (!attacker.hasKeyword(Keyword.TRAMPLE) || attacker.hasKeyword(Keyword.INFECT) || (dmgAfterShielding = ComputerUtilCombat.getAttack(attacker) - ComputerUtilCombat.totalShieldDamage(attacker, blockers)) <= 0) continue;
                damage += dmgAfterShielding;
            }
            damage += ComputerUtilCombat.sumDamageIfUnblocked(unblocked, ai);
        }
        return ai.getLife() - damage;
    }

    public static int resultingPoison(Player ai, Combat combat) {
        if (!ai.canReceiveCounters(CounterEnumType.POISON)) {
            return ai.getPoisonCounters();
        }
        int poison = 0;
        CardCollection attackers = combat.getAttackersOf(ai);
        ArrayList<Card> unblocked = Lists.newArrayList();
        for (Card attacker : attackers) {
            int trampleDamage;
            CardCollection blockers = combat.getBlockers(attacker);
            if (blockers.size() == 0 || StaticAbilityAssignCombatDamageAsUnblocked.assignCombatDamageAsUnblocked(attacker)) {
                unblocked.add(attacker);
                continue;
            }
            if (!attacker.hasKeyword(Keyword.TRAMPLE) || (trampleDamage = ComputerUtilCombat.getAttack(attacker) - ComputerUtilCombat.totalShieldDamage(attacker, blockers)) <= 0) continue;
            if (attacker.hasKeyword(Keyword.INFECT)) {
                poison += trampleDamage;
            }
            poison += ComputerUtilCombat.predictExtraPoisonWithDamage(attacker, ai, trampleDamage);
        }
        return ai.getPoisonCounters() + (poison += ComputerUtilCombat.sumPoisonIfUnblocked(unblocked, ai));
    }

    public static List<Card> getLifeThreateningCommanders(Player ai, Combat combat) {
        ArrayList<Card> res = Lists.newArrayList();
        for (Card c : combat.getAttackers()) {
            if (!c.isCommander() || !combat.isAttacking(c, ai)) continue;
            int currentCommanderDamage = ai.getCommanderDamage(c);
            if (ComputerUtilCombat.damageIfUnblocked(c, ai, combat, false) + currentCommanderDamage < 21) continue;
            res.add(c);
        }
        return res;
    }

    public static boolean lifeInDanger(Player ai, Combat combat) {
        return ComputerUtilCombat.lifeInDanger(ai, combat, 0);
    }

    public static boolean lifeInDanger(Player ai, Combat combat, int payment) {
        if (ai.cantLose() || combat == null || combat.getAttackingPlayer() == ai) {
            return false;
        }
        CardCollectionView otb = ai.getCardsIn(ZoneType.Battlefield);
        if (Iterables.any(otb, CardPredicates.nameEquals("Worship")) && !ai.getCreaturesInPlay().isEmpty()) {
            return false;
        }
        if (Iterables.any(otb, CardPredicates.nameEquals("Elderscale Wurm")) && ai.getLife() >= 7) {
            return false;
        }
        CardCollection attackers = combat.getAttackersOf(ai);
        List<Card> threateningCommanders = ComputerUtilCombat.getLifeThreateningCommanders(ai, combat);
        for (Card attacker : attackers) {
            CardCollection blockers = combat.getBlockers(attacker);
            if (blockers.isEmpty() && !attacker.getSVar("MustBeBlocked").isEmpty()) {
                boolean cond = false;
                String condVal = attacker.getSVar("MustBeBlocked");
                boolean isAttackingPlayer = combat.getDefenderByAttacker(attacker) instanceof Player;
                cond |= "true".equalsIgnoreCase(condVal);
                cond |= "attackingplayer".equalsIgnoreCase(condVal) && isAttackingPlayer;
                if (cond |= "attackingplayerconservative".equalsIgnoreCase(condVal) && isAttackingPlayer && ai.getCreaturesInPlay().size() >= 3 && ai.getCreaturesInPlay().size() > attacker.getController().getCreaturesInPlay().size()) {
                    return true;
                }
            }
            if (!threateningCommanders.contains(attacker)) continue;
            return true;
        }
        int threshold = 0;
        int maxTreshold = 0;
        if (ai.getController().isAI()) {
            threshold = ((PlayerControllerAi)ai.getController()).getAi().getIntProperty(AiProps.AI_IN_DANGER_THRESHOLD);
            maxTreshold = ((PlayerControllerAi)ai.getController()).getAi().getIntProperty(AiProps.AI_IN_DANGER_MAX_THRESHOLD) - threshold;
        }
        int chance = MyRandom.getRandom().nextInt(80) + 5;
        while (maxTreshold > 0) {
            if (MyRandom.getRandom().nextInt(100) < chance) {
                ++threshold;
            }
            --maxTreshold;
        }
        if (!ai.cantLoseForZeroOrLessLife() && ComputerUtilCombat.lifeThatWouldRemain(ai, combat) - payment < Math.min(threshold, ai.getLife())) {
            return true;
        }
        return ComputerUtilCombat.resultingPoison(ai, combat) > Math.max(7, ai.getPoisonCounters());
    }

    public static boolean lifeInSeriousDanger(Player ai, Combat combat) {
        return ComputerUtilCombat.lifeInSeriousDanger(ai, combat, 0);
    }

    public static boolean lifeInSeriousDanger(Player ai, Combat combat, int payment) {
        if (ai.cantLose() || combat == null) {
            return false;
        }
        List<Card> threateningCommanders = ComputerUtilCombat.getLifeThreateningCommanders(ai, combat);
        CardCollection attackers = combat.getAttackersOf(ai);
        for (Card attacker : attackers) {
            CardCollection blockers = combat.getBlockers(attacker);
            if (blockers.isEmpty() && !attacker.getSVar("MustBeBlocked").isEmpty()) {
                return true;
            }
            if (!threateningCommanders.contains(attacker)) continue;
            return true;
        }
        if (!ai.cantLoseForZeroOrLessLife() && ComputerUtilCombat.lifeThatWouldRemain(ai, combat) - payment < 1) {
            return true;
        }
        return ComputerUtilCombat.resultingPoison(ai, combat) >= ai.getGame().getRules().getPoisonCountersToLose();
    }

    public static int totalDamageOfBlockers(Card attacker, List<Card> defenders) {
        int damage = 0;
        if (attacker.isEquippedBy("Godsend") && !defenders.isEmpty()) {
            defenders.remove(0);
        }
        for (Card defender : defenders) {
            damage += ComputerUtilCombat.dealsDamageAsBlocker(attacker, defender);
        }
        return damage;
    }

    public static int totalFirstStrikeDamageOfBlockers(Card attacker, List<Card> defenders) {
        int damage = 0;
        if (attacker.isEquippedBy("Godsend") && !defenders.isEmpty()) {
            defenders.remove(0);
        }
        for (Card defender : defenders) {
            damage += ComputerUtilCombat.predictDamageByBlockerWithoutDoubleStrike(attacker, defender);
        }
        return damage;
    }

    public static int dealsDamageAsBlocker(Card attacker, Card defender) {
        int defenderDamage = ComputerUtilCombat.predictDamageByBlockerWithoutDoubleStrike(attacker, defender);
        if (defender.hasDoubleStrike()) {
            defenderDamage += ComputerUtilCombat.predictDamageTo(attacker, defenderDamage, defender, true);
        }
        return defenderDamage;
    }

    private static int predictDamageByBlockerWithoutDoubleStrike(Card attacker, Card defender) {
        if (attacker.getName().equals("Sylvan Basilisk") && !defender.hasKeyword(Keyword.INDESTRUCTIBLE)) {
            return 0;
        }
        int flankingMagnitude = 0;
        if (attacker.hasKeyword(Keyword.FLANKING) && !defender.hasKeyword(Keyword.FLANKING)) {
            flankingMagnitude = attacker.getAmountOfKeyword(Keyword.FLANKING);
            if (flankingMagnitude >= defender.getNetToughness()) {
                return 0;
            }
            if (flankingMagnitude >= defender.getNetToughness() - defender.getDamage() && !defender.hasKeyword(Keyword.INDESTRUCTIBLE)) {
                return 0;
            }
        }
        if (attacker.hasKeyword(Keyword.INDESTRUCTIBLE) && !defender.isWitherDamage()) {
            return 0;
        }
        int defenderDamage = defender.toughnessAssignsDamage() ? defender.getNetToughness() + ComputerUtilCombat.predictToughnessBonusOfBlocker(attacker, defender, true) : defender.getNetPower() + ComputerUtilCombat.predictPowerBonusOfBlocker(attacker, defender, true);
        defenderDamage = ComputerUtilCombat.predictDamageTo(attacker, defenderDamage, defender, true);
        return defenderDamage;
    }

    public static int totalShieldDamage(Card attacker, List<Card> defenders) {
        int defenderDefense = 0;
        for (Card defender : defenders) {
            defenderDefense += ComputerUtilCombat.shieldDamage(attacker, defender);
        }
        return defenderDefense;
    }

    public static int shieldDamage(Card attacker, Card blocker) {
        if (ComputerUtilCombat.canDestroyBlockerBeforeFirstStrike(blocker, attacker, false)) {
            return 0;
        }
        int flankingMagnitude = 0;
        if (attacker.hasKeyword(Keyword.FLANKING) && !blocker.hasKeyword(Keyword.FLANKING)) {
            flankingMagnitude = attacker.getAmountOfKeyword(Keyword.FLANKING);
            if (flankingMagnitude >= blocker.getNetToughness()) {
                return 0;
            }
            if (flankingMagnitude >= blocker.getNetToughness() - blocker.getDamage() && !blocker.hasKeyword(Keyword.INDESTRUCTIBLE)) {
                return 0;
            }
        }
        int defBushidoMagnitude = blocker.getKeywordMagnitude(Keyword.BUSHIDO);
        int defenderDefense = blocker.getLethalDamage() - flankingMagnitude + defBushidoMagnitude;
        return defenderDefense;
    }

    public static boolean combatantWouldBeDestroyed(Player ai, Card combatant, Combat combat) {
        if (combat.isAttacking(combatant)) {
            return ComputerUtilCombat.attackerWouldBeDestroyed(ai, combatant, combat);
        }
        if (combat.isBlocking(combatant)) {
            return ComputerUtilCombat.blockerWouldBeDestroyed(ai, combatant, combat);
        }
        return false;
    }

    public static boolean attackerWouldBeDestroyed(Player ai, Card attacker, Combat combat) {
        CardCollection blockers = combat.getBlockers(attacker);
        int firstStrikeBlockerDmg = 0;
        for (Card defender : blockers) {
            if (!defender.isWitherDamage() && ComputerUtilCombat.canDestroyAttacker(ai, attacker, defender, combat, true)) {
                return true;
            }
            if (!defender.hasFirstStrike() && !defender.hasDoubleStrike()) continue;
            firstStrikeBlockerDmg += defender.getNetCombatDamage();
        }
        if (attacker.hasFirstStrike() || attacker.hasDoubleStrike()) {
            return firstStrikeBlockerDmg >= ComputerUtilCombat.getDamageToKill(attacker, true);
        }
        return ComputerUtilCombat.totalDamageOfBlockers(attacker, blockers) >= ComputerUtilCombat.getDamageToKill(attacker, false);
    }

    public static boolean combatTriggerWillTrigger(Card attacker, Card defender, Trigger trigger, Combat combat) {
        return ComputerUtilCombat.combatTriggerWillTrigger(attacker, defender, trigger, combat, null);
    }

    public static boolean combatTriggerWillTrigger(Card attacker, Card defender, Trigger trigger, Combat combat, List<Card> plannedAttackers) {
        Game game = attacker.getGame();
        boolean willTrigger = false;
        Card source = trigger.getHostCard();
        if (combat == null && (combat = game.getCombat()) == null) {
            return false;
        }
        if (!trigger.zonesCheck(game.getZoneOf(trigger.getHostCard()))) {
            return false;
        }
        if (!trigger.requirementsCheck(game)) {
            return false;
        }
        TriggerType mode = trigger.getMode();
        if (mode == TriggerType.Attacks) {
            willTrigger = true;
            if (combat.isAttacking(attacker)) {
                return false;
            }
            if (!(!trigger.hasParam("ValidCard") || trigger.matchesValidParam("ValidCard", attacker) || combat.isAttacking(source) && trigger.matchesValidParam("ValidCard", source) && !trigger.hasParam("Alone"))) {
                return false;
            }
            if (trigger.hasParam("Attacked") && (combat.isAttacking(attacker) ? !trigger.matchesValidParam("Attacked", combat.getDefenderByAttacker(attacker)) : "You,Planeswalker.YouCtrl".equals(trigger.getParam("Attacked")) && source.getController() == attacker.getController())) {
                return false;
            }
            if (trigger.hasParam("Alone") && plannedAttackers != null && plannedAttackers.size() != 1) {
                return false;
            }
        }
        if (defender == null && mode == TriggerType.AttackerUnblocked) {
            willTrigger = true;
            if (!trigger.matchesValidParam("ValidCard", attacker)) {
                return false;
            }
        }
        if (defender == null) {
            return willTrigger;
        }
        if (mode == TriggerType.Blocks) {
            willTrigger = true;
            if (trigger.hasParam("ValidBlocked")) {
                String validBlocked = trigger.getParam("ValidBlocked");
                if (validBlocked.contains(".withLesserPower")) {
                    validBlocked = TextUtil.fastReplace(validBlocked, ".withLesserPower", "");
                    if (defender.getCurrentPower() <= attacker.getCurrentPower()) {
                        return false;
                    }
                }
                if (!trigger.matchesValid(attacker, validBlocked.split(","))) {
                    return false;
                }
            }
            if (trigger.hasParam("ValidCard")) {
                String validBlocker = trigger.getParam("ValidCard");
                if (validBlocker.contains(".withLesserPower")) {
                    validBlocker = TextUtil.fastReplace(validBlocker, ".withLesserPower", "");
                    if (defender.getCurrentPower() >= attacker.getCurrentPower()) {
                        return false;
                    }
                }
                if (!trigger.matchesValid(defender, validBlocker.split(","))) {
                    return false;
                }
            }
        } else if (mode == TriggerType.AttackerBlocked || mode == TriggerType.AttackerBlockedByCreature) {
            willTrigger = true;
            if (!trigger.matchesValidParam("ValidBlocker", defender)) {
                return false;
            }
            if (!trigger.matchesValidParam("ValidCard", attacker)) {
                return false;
            }
        } else if (mode == TriggerType.DamageDone) {
            willTrigger = true;
            if (trigger.hasParam("ValidSource") && !"False".equals(trigger.getParam("CombatDamage"))) {
                if (!trigger.matchesValidParam("ValidSource", defender) || defender.getNetCombatDamage() <= 0 || !trigger.matchesValidParam("ValidTarget", attacker)) {
                    return false;
                }
                if (!trigger.matchesValidParam("ValidSource", attacker) || attacker.getNetCombatDamage() <= 0 || !trigger.matchesValidParam("ValidTarget", defender)) {
                    return false;
                }
            }
        }
        return willTrigger;
    }

    public static int predictPowerBonusOfBlocker(Card attacker, Card blocker, boolean withoutAbilities) {
        int power = 0;
        if (blocker.getName().equals("Serene Master")) {
            power += attacker.getNetPower() - blocker.getNetPower();
        } else if (blocker.getName().equals("Shape Stealer")) {
            power += attacker.getNetPower() - blocker.getNetPower();
        }
        if (ComputerUtilCombat.dealsFirstStrikeDamage(attacker, withoutAbilities, null) && attacker.isWitherDamage() && !ComputerUtilCombat.dealsFirstStrikeDamage(blocker, withoutAbilities, null) && blocker.canReceiveCounters(CounterEnumType.M1M1)) {
            power -= attacker.getNetCombatDamage();
        }
        Game game = attacker.getGame();
        CardCollectionView cardList = CardCollection.combine(game.getCardsIn(ZoneType.Battlefield), game.getCardsIn(ZoneType.Command));
        for (Card card : cardList) {
            for (StaticAbility stAb : card.getStaticAbilities()) {
                String valid;
                if (!stAb.checkMode("Continuous") || !stAb.hasParam("Affected") || !stAb.getParam("Affected").contains("blocking") || !blocker.isValid(valid = TextUtil.fastReplace(stAb.getParam("Affected"), "blocking", "Creature"), card.getController(), card, (CardTraitBase)stAb) || !stAb.hasParam("AddPower")) continue;
                power += AbilityUtils.calculateAmount(card, stAb.getParam("AddPower"), stAb);
            }
        }
        FCollection<Trigger> theTriggers = new FCollection<Trigger>();
        for (Card card : game.getCardsIn(ZoneType.Battlefield)) {
            theTriggers.addAll(card.getTriggers());
        }
        for (Card card : game.getCardsIn(ZoneType.Command)) {
            theTriggers.addAll(card.getTriggers());
        }
        theTriggers.addAll(attacker.getTriggers());
        for (Trigger trigger : theTriggers) {
            SpellAbility sa;
            Card source = trigger.getHostCard();
            if (!ComputerUtilCombat.combatTriggerWillTrigger(attacker, blocker, trigger, null) || (sa = trigger.ensureAbility()) == null || !ApiType.Pump.equals((Object)sa.getApi()) || sa.usesTargeting() || !sa.hasParam("NumAtt")) continue;
            String defined = sa.getParam("Defined");
            CardCollection list = AbilityUtils.getDefinedCards(source, defined, sa);
            if (defined != null && defined.startsWith("TriggeredBlocker")) {
                list.add(blocker);
            }
            if (!list.contains(blocker)) continue;
            power += AbilityUtils.calculateAmount(source, sa.getParam("NumAtt"), sa, true);
        }
        if (withoutAbilities) {
            return power;
        }
        for (SpellAbility ability : blocker.getAllSpellAbilities()) {
            int pBonus;
            if (!ability.isActivatedAbility() || ability.hasParam("ActivationPhases") || ability.hasParam("SorcerySpeed") || ability.hasParam("ActivationZone") || ability.usesTargeting() && !ability.canTarget(blocker)) continue;
            if (ability.getApi() == ApiType.Pump) {
                if (!ability.hasParam("NumAtt") || !ComputerUtilCost.canPayCost(ability, blocker.getController(), false) || (pBonus = AbilityUtils.calculateAmount(ability.getHostCard(), ability.getParam("NumAtt"), ability)) <= 0) continue;
                power += pBonus;
                continue;
            }
            if (ability.getApi() != ApiType.PutCounter || !ability.hasParam("CounterType") || !ability.getParam("CounterType").equals("P1P1") || ability.hasParam("Monstrosity") && blocker.isMonstrous() || ability.hasParam("Adapt") && blocker.getCounters(CounterEnumType.P1P1) > 0 || !ComputerUtilCost.canPayCost(ability, blocker.getController(), false) || (pBonus = AbilityUtils.calculateAmount(ability.getHostCard(), ability.getParamOrDefault("CounterNum", "1"), ability)) <= 0) continue;
            power += pBonus;
        }
        return power;
    }

    public static int predictToughnessBonusOfBlocker(Card attacker, Card blocker, boolean withoutAbilities) {
        int toughness = 0;
        if (blocker.getName().equals("Shape Stealer")) {
            toughness += attacker.getNetToughness() - blocker.getNetToughness();
        }
        Game game = attacker.getGame();
        FCollection<Trigger> theTriggers = new FCollection<Trigger>();
        for (Card card : game.getCardsIn(ZoneType.Battlefield)) {
            theTriggers.addAll(card.getTriggers());
        }
        for (Card card : game.getCardsIn(ZoneType.Command)) {
            theTriggers.addAll(card.getTriggers());
        }
        theTriggers.addAll(attacker.getTriggers());
        for (Trigger trigger : theTriggers) {
            SpellAbility sa;
            Card source = trigger.getHostCard();
            if (!ComputerUtilCombat.combatTriggerWillTrigger(attacker, blocker, trigger, null) || (sa = trigger.ensureAbility()) == null) continue;
            String defined = sa.getParam("Defined");
            if (ApiType.DealDamage.equals((Object)sa.getApi())) {
                if (defined == null || !defined.startsWith("TriggeredBlocker")) continue;
                int damage = AbilityUtils.calculateAmount(source, sa.getParam("NumDmg"), sa);
                toughness -= ComputerUtilCombat.predictDamageTo(blocker, damage, source, false);
                continue;
            }
            if (ApiType.PutCounter.equals((Object)sa.getApi())) {
                if (defined == null || !defined.startsWith("TriggeredBlocker") || !"M1M1".equals(sa.getParam("CounterType"))) continue;
                toughness -= AbilityUtils.calculateAmount(source, sa.getParamOrDefault("CounterNum", "1"), sa);
                continue;
            }
            if (!ApiType.Pump.equals((Object)sa.getApi()) || sa.usesTargeting()) continue;
            CardCollection list = AbilityUtils.getDefinedCards(source, defined, null);
            if (defined != null && defined.startsWith("TriggeredBlocker")) {
                list.add(blocker);
            }
            if (list.isEmpty() || !list.contains(blocker) || !sa.hasParam("NumDef")) continue;
            toughness += AbilityUtils.calculateAmount(source, sa.getParam("NumDef"), sa, true);
        }
        if (withoutAbilities) {
            return toughness;
        }
        for (SpellAbility ability : blocker.getAllSpellAbilities()) {
            int tBonus;
            if (!ability.isActivatedAbility() || ability.hasParam("ActivationPhases") || ability.hasParam("SorcerySpeed") || ability.hasParam("ActivationZone") || ability.usesTargeting() && !ability.canTarget(blocker)) continue;
            if (ability.getApi() == ApiType.Pump) {
                if (!ability.hasParam("NumDef") || !ComputerUtilCost.canPayCost(ability, blocker.getController(), false) || (tBonus = AbilityUtils.calculateAmount(ability.getHostCard(), ability.getParam("NumDef"), ability)) <= 0) continue;
                toughness += tBonus;
                continue;
            }
            if (ability.getApi() != ApiType.PutCounter || !ability.hasParam("CounterType") || !ability.getParam("CounterType").equals("P1P1") || ability.hasParam("Monstrosity") && blocker.isMonstrous() || ability.hasParam("Adapt") && blocker.getCounters(CounterEnumType.P1P1) > 0 || !ComputerUtilCost.canPayCost(ability, blocker.getController(), false) || (tBonus = AbilityUtils.calculateAmount(ability.getHostCard(), ability.getParamOrDefault("CounterNum", "1"), ability)) <= 0) continue;
            toughness += tBonus;
        }
        return toughness;
    }

    public static int predictPowerBonusOfAttacker(Card attacker, Card blocker, Combat combat, boolean withoutAbilities) {
        return ComputerUtilCombat.predictPowerBonusOfAttacker(attacker, blocker, combat, withoutAbilities, false);
    }

    public static int predictPowerBonusOfAttacker(Card attacker, Card blocker, Combat combat, boolean withoutAbilities, boolean withoutCombatStaticAbilities) {
        int power = 0;
        if (blocker != null && blocker.getName().equals("Serene Master")) {
            power += blocker.getNetPower() - attacker.getNetPower();
        } else if (blocker != null && attacker.getName().equals("Shape Stealer")) {
            power += blocker.getNetPower() - attacker.getNetPower();
        }
        Game game = attacker.getGame();
        FCollection<Trigger> theTriggers = new FCollection<Trigger>();
        for (Object card : game.getCardsIn(ZoneType.Battlefield)) {
            theTriggers.addAll(((Card)card).getTriggers());
        }
        for (Object card : game.getCardsIn(ZoneType.Command)) {
            theTriggers.addAll(((Card)card).getTriggers());
        }
        if (null != blocker) {
            if (ComputerUtilCombat.dealsFirstStrikeDamage(blocker, withoutAbilities, combat) && blocker.isWitherDamage() && !ComputerUtilCombat.dealsFirstStrikeDamage(attacker, withoutAbilities, combat) && attacker.canReceiveCounters(CounterEnumType.M1M1)) {
                power -= blocker.getNetCombatDamage();
            }
            theTriggers.addAll(blocker.getTriggers());
        }
        if (!withoutCombatStaticAbilities) {
            CardCollectionView cardList = CardCollection.combine(game.getCardsIn(ZoneType.Battlefield), game.getCardsIn(ZoneType.Command));
            for (Card card : cardList) {
                for (StaticAbility stAb : card.getStaticAbilities()) {
                    String valid;
                    if (!stAb.checkMode("Continuous") || !stAb.hasParam("Affected") || !stAb.getParam("Affected").contains("attacking") || !attacker.isValid(valid = TextUtil.fastReplace(stAb.getParam("Affected"), "attacking", "Creature"), card.getController(), card, (CardTraitBase)stAb) || !stAb.hasParam("AddPower")) continue;
                    power += AbilityUtils.calculateAmount(card, stAb.getParam("AddPower"), stAb);
                }
            }
        }
        for (Trigger trigger : theTriggers) {
            SpellAbility sa;
            Card source = trigger.getHostCard();
            if (!ComputerUtilCombat.combatTriggerWillTrigger(attacker, blocker, trigger, combat) || combat != null && trigger.isKeyword(Keyword.EXALTED) && !combat.getAttackers().isEmpty() && !combat.getAttackers().contains(attacker) || (sa = trigger.ensureAbility()) == null || sa.usesTargeting() || !ApiType.Pump.equals((Object)sa.getApi()) && !ApiType.PumpAll.equals((Object)sa.getApi()) || !sa.hasParam("NumAtt")) continue;
            sa.setActivatingPlayer(source.getController(), true);
            if (sa.hasParam("Cost") && !CostPayment.canPayAdditionalCosts(sa.getPayCosts(), sa, true)) continue;
            List<Card> list = Lists.newArrayList();
            if (sa.hasParam("ValidCards")) {
                if (attacker.isValid(sa.getParam("ValidCards").split(","), source.getController(), source, null) || attacker.isValid(sa.getParam("ValidCards").replace("attacking+", "").split(","), source.getController(), source, null)) {
                    list.add(attacker);
                }
            } else {
                list = AbilityUtils.getDefinedCards(source, sa.getParam("Defined"), null);
            }
            if (sa.hasParam("Defined") && sa.getParam("Defined").startsWith("TriggeredAttacker")) {
                list.add(attacker);
            }
            if (!list.contains(attacker)) continue;
            String att = sa.getParam("NumAtt");
            if (att.startsWith("+")) {
                att = att.substring(1);
            }
            if (att.matches("[0-9][0-9]?") || att.matches("-[0-9][0-9]?")) {
                power += Integer.parseInt(att);
                continue;
            }
            String bonus = AbilityUtils.getSVar(sa, att);
            if (bonus.contains("Count$Valid Creature.blockingTriggeredAttacker")) {
                bonus = TextUtil.fastReplace(bonus, "Count$Valid Creature.blockingTriggeredAttacker", "Number$1");
            } else if (bonus.contains("TriggeredPlayersDefenders$Amount")) {
                bonus = TextUtil.fastReplace(bonus, "TriggeredPlayersDefenders$Amount", "Number$1");
            } else if (bonus.contains("TriggeredAttacker$CardPower")) {
                bonus = TextUtil.fastReplace(bonus, "TriggeredAttacker$CardPower", TextUtil.concatNoSpace("Number$", String.valueOf(attacker.getNetPower())));
            } else if (bonus.contains("TriggeredAttacker$CardToughness")) {
                bonus = TextUtil.fastReplace(bonus, "TriggeredAttacker$CardToughness", TextUtil.concatNoSpace("Number$", String.valueOf(attacker.getNetToughness())));
            }
            power += AbilityUtils.calculateAmount(source, bonus, sa);
        }
        if (withoutAbilities) {
            return power;
        }
        for (SpellAbility ability : attacker.getAllSpellAbilities()) {
            int pBonus;
            if (!ability.isActivatedAbility() || ability.hasParam("ActivationPhases") || ability.hasParam("SorcerySpeed") || ability.hasParam("ActivationZone") || ability.usesTargeting() && !ability.canTarget(attacker)) continue;
            if (ability.getApi() == ApiType.Pump) {
                if (!ability.hasParam("NumAtt") || ComputerUtilCost.isSacrificeSelfCost(ability.getPayCosts()) || ability.getPayCosts().hasTapCost() || !ComputerUtilCost.canPayCost(ability, attacker.getController(), false) || (pBonus = AbilityUtils.calculateAmount(ability.getHostCard(), ability.getParam("NumAtt"), ability)) <= 0) continue;
                power += pBonus;
                continue;
            }
            if (ability.getApi() != ApiType.PutCounter || !ability.hasParam("CounterType") || !ability.getParam("CounterType").equals("P1P1") || ability.hasParam("Monstrosity") && attacker.isMonstrous() || ability.hasParam("Adapt") && attacker.getCounters(CounterEnumType.P1P1) > 0 || ability.getPayCosts().hasTapCost() || !ComputerUtilCost.canPayCost(ability, attacker.getController(), false) || (pBonus = AbilityUtils.calculateAmount(ability.getHostCard(), ability.getParamOrDefault("CounterNum", "1"), ability)) <= 0) continue;
            power += pBonus;
        }
        return power;
    }

    public static int predictToughnessBonusOfAttacker(Card attacker, Card blocker, Combat combat, boolean withoutAbilities) {
        return ComputerUtilCombat.predictToughnessBonusOfAttacker(attacker, blocker, combat, withoutAbilities, false);
    }

    public static int predictToughnessBonusOfAttacker(Card attacker, Card blocker, Combat combat, boolean withoutAbilities, boolean withoutCombatStaticAbilities) {
        int toughness = 0;
        if (blocker != null && attacker.getName().equals("Shape Stealer")) {
            toughness += blocker.getNetToughness() - attacker.getNetToughness();
        }
        Game game = attacker.getGame();
        FCollection<Trigger> theTriggers = new FCollection<Trigger>();
        for (Object card : game.getCardsIn(ZoneType.Battlefield)) {
            theTriggers.addAll(((Card)card).getTriggers());
        }
        for (Object card : game.getCardsIn(ZoneType.Command)) {
            theTriggers.addAll(((Card)card).getTriggers());
        }
        if (blocker != null) {
            theTriggers.addAll(blocker.getTriggers());
        }
        if (!withoutCombatStaticAbilities) {
            CardCollectionView cardList = game.getCardsIn(ZoneType.Battlefield);
            for (Card card : cardList) {
                for (StaticAbility stAb : card.getStaticAbilities()) {
                    String valid;
                    if (!"Continuous".equals(stAb.getParam("Mode")) || !stAb.hasParam("Affected") || !stAb.hasParam("AddToughness")) continue;
                    String affected = stAb.getParam("Affected");
                    String addT = stAb.getParam("AddToughness");
                    if (affected.contains("attacking")) {
                        valid = TextUtil.fastReplace(affected, "attacking", "Creature");
                        if (!attacker.isValid(valid, card.getController(), card, null)) continue;
                        toughness += AbilityUtils.calculateAmount(card, addT, stAb, true);
                        continue;
                    }
                    if (!affected.contains("untapped") || !attacker.isValid(valid = TextUtil.fastReplace(affected, "untapped", "Creature"), card.getController(), card, null) || attacker.hasKeyword(Keyword.VIGILANCE)) continue;
                    toughness -= AbilityUtils.calculateAmount(card, addT, stAb, true);
                }
            }
        }
        for (Trigger trigger : theTriggers) {
            SpellAbility sa;
            Card source = trigger.getHostCard();
            if (!ComputerUtilCombat.combatTriggerWillTrigger(attacker, blocker, trigger, combat) || (sa = trigger.ensureAbility()) == null) continue;
            sa.setActivatingPlayer(source.getController(), true);
            if (sa.usesTargeting()) continue;
            if (ApiType.DealDamage.equals((Object)sa.getApi())) {
                if (!sa.hasParam("Defined") || !sa.getParam("Defined").startsWith("TriggeredAttacker")) continue;
                int damage = AbilityUtils.calculateAmount(source, sa.getParam("NumDmg"), sa);
                toughness -= ComputerUtilCombat.predictDamageTo(attacker, damage, source, false);
                continue;
            }
            if (ApiType.Pump.equals((Object)sa.getApi())) {
                if (!sa.hasParam("NumDef") || sa.hasParam("Cost") && !CostPayment.canPayAdditionalCosts(sa.getPayCosts(), sa, true)) continue;
                String defined = sa.getParam("Defined");
                CardCollection list = AbilityUtils.getDefinedCards(source, defined, sa);
                if (defined != null && defined.startsWith("TriggeredAttacker")) {
                    list.add(attacker);
                }
                if (!list.contains(attacker)) continue;
                String def = sa.getParam("NumDef");
                if (def.startsWith("+")) {
                    def = def.substring(1);
                }
                if (def.matches("[0-9][0-9]?") || def.matches("-[0-9][0-9]?")) {
                    toughness += Integer.parseInt(def);
                    continue;
                }
                String bonus = AbilityUtils.getSVar(sa, def);
                if (bonus.contains("Count$Valid Creature.blockingTriggeredAttacker")) {
                    bonus = TextUtil.fastReplace(bonus, "Count$Valid Creature.blockingTriggeredAttacker", "Number$1");
                } else if (bonus.contains("TriggeredPlayersDefenders$Amount")) {
                    bonus = TextUtil.fastReplace(bonus, "TriggeredPlayersDefenders$Amount", "Number$1");
                }
                toughness += AbilityUtils.calculateAmount(source, bonus, sa);
                continue;
            }
            if (!ApiType.PumpAll.equals((Object)sa.getApi()) || !sa.hasParam("NumDef") || sa.hasParam("Cost") && !CostPayment.canPayAdditionalCosts(sa.getPayCosts(), sa, true) || !sa.hasParam("ValidCards") || !attacker.isValid(sa.getParam("ValidCards").replace("attacking+", "").split(","), source.getController(), source, (CardTraitBase)sa)) continue;
            String def = sa.getParam("NumDef");
            if (def.startsWith("+")) {
                def = def.substring(1);
            }
            if (def.matches("[0-9][0-9]?") || def.matches("-[0-9][0-9]?")) {
                toughness += Integer.parseInt(def);
                continue;
            }
            String bonus = AbilityUtils.getSVar(sa, def);
            if (bonus.contains("Count$Valid Creature.blockingTriggeredAttacker")) {
                bonus = TextUtil.fastReplace(bonus, "Count$Valid Creature.blockingTriggeredAttacker", "Number$1");
            } else if (bonus.contains("TriggeredPlayersDefenders$Amount")) {
                bonus = TextUtil.fastReplace(bonus, "TriggeredPlayersDefenders$Amount", "Number$1");
            }
            toughness += AbilityUtils.calculateAmount(source, bonus, sa);
        }
        if (withoutAbilities) {
            return toughness;
        }
        for (SpellAbility ability : attacker.getAllSpellAbilities()) {
            int tBonus;
            if (!ability.isActivatedAbility() || ability.hasParam("ActivationPhases") || ability.hasParam("SorcerySpeed") || ability.hasParam("ActivationZone") || ability.usesTargeting() && !ability.canTarget(attacker) || ability.getPayCosts().hasTapCost() && !attacker.hasKeyword(Keyword.VIGILANCE) || !ComputerUtilCost.canPayCost(ability, attacker.getController(), false)) continue;
            if (ability.getApi() == ApiType.Pump) {
                if (!ability.hasParam("NumDef")) continue;
                toughness += AbilityUtils.calculateAmount(ability.getHostCard(), ability.getParam("NumDef"), ability, true);
                continue;
            }
            if (ability.getApi() != ApiType.PutCounter || !ability.hasParam("CounterType") || !ability.getParam("CounterType").equals("P1P1") || ability.hasParam("Monstrosity") && attacker.isMonstrous() || ability.hasParam("Adapt") && attacker.getCounters(CounterEnumType.P1P1) > 0 || (tBonus = AbilityUtils.calculateAmount(ability.getHostCard(), ability.getParamOrDefault("CounterNum", "1"), ability)) <= 0) continue;
            toughness += tBonus;
        }
        return toughness;
    }

    public static boolean canDestroyAttackerBeforeFirstStrike(Card attacker, Card blocker, Combat combat, boolean withoutAbilities) {
        if (blocker.isEquippedBy("Godsend")) {
            return true;
        }
        if (ComputerUtilCombat.combatantCantBeDestroyed(attacker.getController(), attacker)) {
            return false;
        }
        if (ComputerUtilCombat.getDamageToKill(attacker, false) + ComputerUtilCombat.predictToughnessBonusOfAttacker(attacker, blocker, combat, withoutAbilities) <= 0) {
            return true;
        }
        FCollection<Trigger> theTriggers = new FCollection<Trigger>();
        for (Card card : attacker.getGame().getCardsIn(ZoneType.Battlefield)) {
            theTriggers.addAll(card.getTriggers());
        }
        for (Trigger trigger : theTriggers) {
            SpellAbility sa;
            Card source = trigger.getHostCard();
            if (!ComputerUtilCombat.combatTriggerWillTrigger(attacker, blocker, trigger, null) || (sa = trigger.ensureAbility()) == null || !ApiType.Destroy.equals((Object)sa.getApi()) || !sa.hasParam("Defined")) continue;
            if (sa.getParam("Defined").startsWith("TriggeredAttacker")) {
                return true;
            }
            if (sa.getParam("Defined").equals("Self") && source.equals(attacker)) {
                return true;
            }
            if (!sa.getParam("Defined").equals("TriggeredTarget") || !source.equals(blocker)) continue;
            return true;
        }
        return false;
    }

    public static boolean combatantCantBeDestroyed(Player ai, Card combatant) {
        if (combatant.getCounters(CounterEnumType.SHIELD) > 0) {
            return true;
        }
        if (combatant.getShieldCount() > 0 && combatant.canBeShielded()) {
            return true;
        }
        return combatant.hasKeyword(Keyword.INDESTRUCTIBLE) || ComputerUtil.canRegenerate(ai, combatant);
    }

    public static boolean canDestroyAttacker(Player ai, Card attacker, Card blocker, Combat combat, boolean withoutAbilities) {
        return ComputerUtilCombat.canDestroyAttacker(ai, attacker, blocker, combat, withoutAbilities, false);
    }

    public static boolean canDestroyAttacker(Player ai, Card attacker, Card blocker, Combat combat, boolean withoutAbilities, boolean withoutAttackerStaticAbilities) {
        if (!withoutAbilities) {
            attacker = ComputerUtilCombat.canTransform(attacker);
            blocker = ComputerUtilCombat.canTransform(blocker);
        }
        if (ComputerUtilCombat.canDestroyAttackerBeforeFirstStrike(attacker, blocker, combat, withoutAbilities)) {
            return true;
        }
        if (ComputerUtilCombat.canDestroyBlockerBeforeFirstStrike(blocker, attacker, withoutAbilities)) {
            return false;
        }
        int flankingMagnitude = 0;
        if (attacker.hasKeyword(Keyword.FLANKING) && !blocker.hasKeyword(Keyword.FLANKING)) {
            flankingMagnitude = attacker.getAmountOfKeyword(Keyword.FLANKING);
            if (flankingMagnitude >= blocker.getNetToughness()) {
                return false;
            }
            if (flankingMagnitude >= blocker.getNetToughness() - blocker.getDamage() && !blocker.hasKeyword(Keyword.INDESTRUCTIBLE)) {
                return false;
            }
        }
        if ((attacker.hasKeyword(Keyword.INDESTRUCTIBLE) || !withoutAbilities && ComputerUtil.canRegenerate(ai, attacker)) && !blocker.isWitherDamage() || attacker.hasKeyword(Keyword.PERSIST) && !attacker.canReceiveCounters(CounterEnumType.M1M1) && attacker.getCounters(CounterEnumType.M1M1) == 0 || attacker.hasKeyword(Keyword.UNDYING) && !attacker.canReceiveCounters(CounterEnumType.P1P1) && attacker.getCounters(CounterEnumType.P1P1) == 0) {
            return false;
        }
        int defenderDamage = blocker.toughnessAssignsDamage() ? blocker.getNetToughness() + ComputerUtilCombat.predictToughnessBonusOfBlocker(attacker, blocker, withoutAbilities) : blocker.getNetPower() + ComputerUtilCombat.predictPowerBonusOfBlocker(attacker, blocker, withoutAbilities);
        int possibleDefenderPrevention = 0;
        int possibleAttackerPrevention = 0;
        if (!withoutAbilities) {
            possibleDefenderPrevention = ComputerUtil.possibleDamagePrevention(blocker);
            possibleAttackerPrevention = ComputerUtil.possibleDamagePrevention(attacker);
        }
        if ((defenderDamage = ComputerUtilCombat.predictDamageTo(attacker, defenderDamage, possibleAttackerPrevention, blocker, true)) > 0 && ComputerUtilCombat.isCombatDamagePrevented(blocker, attacker, defenderDamage)) {
            return false;
        }
        int attackerDamage = attacker.toughnessAssignsDamage() ? attacker.getNetToughness() + ComputerUtilCombat.predictToughnessBonusOfAttacker(attacker, blocker, combat, withoutAbilities, withoutAttackerStaticAbilities) : attacker.getNetPower() + ComputerUtilCombat.predictPowerBonusOfAttacker(attacker, blocker, combat, withoutAbilities, withoutAttackerStaticAbilities);
        attackerDamage = ComputerUtilCombat.predictDamageTo(blocker, attackerDamage, possibleDefenderPrevention, attacker, true);
        int defenderLife = ComputerUtilCombat.getDamageToKill(blocker, false) + ComputerUtilCombat.predictToughnessBonusOfBlocker(attacker, blocker, withoutAbilities);
        int attackerLife = ComputerUtilCombat.getDamageToKill(attacker, false) + ComputerUtilCombat.predictToughnessBonusOfAttacker(attacker, blocker, combat, withoutAbilities, withoutAttackerStaticAbilities);
        if (blocker.hasDoubleStrike()) {
            if (defenderDamage > 0 && (ComputerUtilCombat.hasKeyword(blocker, "Deathtouch", withoutAbilities, combat) || attacker.hasSVar("DestroyWhenDamaged"))) {
                return true;
            }
            if (defenderDamage >= attackerLife) {
                return true;
            }
            if (ComputerUtilCombat.dealsFirstStrikeDamage(attacker, withoutAbilities, combat) && !blocker.hasKeyword(Keyword.INDESTRUCTIBLE)) {
                if (attackerDamage >= defenderLife) {
                    return false;
                }
                if (attackerDamage > 0 && (ComputerUtilCombat.hasKeyword(attacker, "Deathtouch", withoutAbilities, combat) || blocker.hasSVar("DestroyWhenDamaged"))) {
                    return false;
                }
            }
            return attackerLife <= 2 * defenderDamage;
        }
        if (ComputerUtilCombat.dealsFirstStrikeDamage(attacker, withoutAbilities, combat) && !blocker.hasKeyword(Keyword.INDESTRUCTIBLE) && !ComputerUtilCombat.dealsFirstStrikeDamage(blocker, withoutAbilities, combat)) {
            if (attackerDamage >= defenderLife) {
                return false;
            }
            if (attackerDamage > 0 && (ComputerUtilCombat.hasKeyword(attacker, "Deathtouch", withoutAbilities, combat) || blocker.hasSVar("DestroyWhenDamaged"))) {
                return false;
            }
        }
        if (defenderDamage > 0 && (ComputerUtilCombat.hasKeyword(blocker, "Deathtouch", withoutAbilities, combat) || attacker.hasSVar("DestroyWhenDamaged"))) {
            return true;
        }
        return defenderDamage >= attackerLife;
    }

    public static boolean blockerWouldBeDestroyed(Player ai, Card blocker, Combat combat) {
        CardCollection attackers = combat.getAttackersBlockedBy(blocker);
        for (Card attacker : attackers) {
            if (attacker.isWitherDamage() || !ComputerUtilCombat.canDestroyBlocker(ai, blocker, attacker, combat, true)) continue;
            return true;
        }
        return false;
    }

    public static boolean canDestroyBlockerBeforeFirstStrike(Card blocker, Card attacker, boolean withoutAbilities) {
        if (attacker.isEquippedBy("Godsend")) {
            return true;
        }
        if (attacker.getName().equals("Elven Warhounds")) {
            return true;
        }
        int flankingMagnitude = 0;
        if (attacker.hasKeyword(Keyword.FLANKING) && !blocker.hasKeyword(Keyword.FLANKING)) {
            flankingMagnitude = attacker.getAmountOfKeyword(Keyword.FLANKING);
            if (flankingMagnitude >= blocker.getNetToughness()) {
                return true;
            }
            if (flankingMagnitude >= ComputerUtilCombat.getDamageToKill(blocker, false) && !blocker.hasKeyword(Keyword.INDESTRUCTIBLE)) {
                return true;
            }
        }
        if (blocker.hasKeyword(Keyword.INDESTRUCTIBLE) || dontTestRegen || ComputerUtil.canRegenerate(blocker.getController(), blocker)) {
            return false;
        }
        if (ComputerUtilCombat.getDamageToKill(blocker, false) + ComputerUtilCombat.predictToughnessBonusOfBlocker(attacker, blocker, withoutAbilities) <= 0) {
            return true;
        }
        Game game = blocker.getGame();
        FCollection<Trigger> theTriggers = new FCollection<Trigger>();
        for (Card card : game.getCardsIn(ZoneType.Battlefield)) {
            theTriggers.addAll(card.getTriggers());
        }
        for (Trigger trigger : theTriggers) {
            SpellAbility sa;
            Card source = trigger.getHostCard();
            if (!ComputerUtilCombat.combatTriggerWillTrigger(attacker, blocker, trigger, null) || (sa = trigger.ensureAbility()) == null || !ApiType.Destroy.equals((Object)sa.getApi()) || !sa.hasParam("Defined")) continue;
            if (sa.getParam("Defined").startsWith("TriggeredBlocker")) {
                return true;
            }
            if (sa.getParam("Defined").equals("Self") && source.equals(blocker)) {
                return true;
            }
            if (!sa.getParam("Defined").equals("TriggeredTarget") || !source.equals(attacker)) continue;
            return true;
        }
        return false;
    }

    public static boolean canDestroyBlocker(Player ai, Card blocker, Card attacker, Combat combat, boolean withoutAbilities) {
        return ComputerUtilCombat.canDestroyBlocker(ai, blocker, attacker, combat, withoutAbilities, false);
    }

    public static boolean canDestroyBlocker(Player ai, Card blocker, Card attacker, Combat combat, boolean withoutAbilities, boolean withoutAttackerStaticAbilities) {
        if (!withoutAbilities) {
            attacker = ComputerUtilCombat.canTransform(attacker);
            blocker = ComputerUtilCombat.canTransform(blocker);
        }
        if (ComputerUtilCombat.canDestroyBlockerBeforeFirstStrike(blocker, attacker, withoutAbilities)) {
            return true;
        }
        if ((blocker.hasKeyword(Keyword.INDESTRUCTIBLE) || !withoutAbilities && ComputerUtil.canRegenerate(ai, blocker)) && !attacker.isWitherDamage() || blocker.hasKeyword(Keyword.PERSIST) && !blocker.canReceiveCounters(CounterEnumType.M1M1) && blocker.getCounters(CounterEnumType.M1M1) == 0 || blocker.hasKeyword(Keyword.UNDYING) && !blocker.canReceiveCounters(CounterEnumType.P1P1) && blocker.getCounters(CounterEnumType.P1P1) == 0) {
            return false;
        }
        if (ComputerUtilCombat.canDestroyAttackerBeforeFirstStrike(attacker, blocker, combat, withoutAbilities)) {
            return false;
        }
        int defenderDamage = blocker.toughnessAssignsDamage() ? blocker.getNetToughness() + ComputerUtilCombat.predictToughnessBonusOfBlocker(attacker, blocker, withoutAbilities) : blocker.getNetPower() + ComputerUtilCombat.predictPowerBonusOfBlocker(attacker, blocker, withoutAbilities);
        int attackerDamage = attacker.toughnessAssignsDamage() ? attacker.getNetToughness() + ComputerUtilCombat.predictToughnessBonusOfAttacker(attacker, blocker, combat, withoutAbilities, withoutAttackerStaticAbilities) : attacker.getNetPower() + ComputerUtilCombat.predictPowerBonusOfAttacker(attacker, blocker, combat, withoutAbilities, withoutAttackerStaticAbilities);
        int possibleDefenderPrevention = 0;
        int possibleAttackerPrevention = 0;
        if (!withoutAbilities) {
            possibleDefenderPrevention = ComputerUtil.possibleDamagePrevention(blocker);
            possibleAttackerPrevention = ComputerUtil.possibleDamagePrevention(attacker);
        }
        defenderDamage = ComputerUtilCombat.predictDamageTo(attacker, defenderDamage, possibleAttackerPrevention, blocker, true);
        if (ComputerUtilCombat.isCombatDamagePrevented(attacker, blocker, attackerDamage = ComputerUtilCombat.predictDamageTo(blocker, attackerDamage, possibleDefenderPrevention, attacker, true))) {
            attackerDamage = 0;
        }
        if (ComputerUtilCombat.isCombatDamagePrevented(blocker, attacker, defenderDamage)) {
            defenderDamage = 0;
        }
        if (combat != null) {
            for (Card atkr : combat.getAttackersBlockedBy(blocker)) {
                if (atkr.equals(attacker)) continue;
                attackerDamage += ComputerUtilCombat.predictDamageTo(blocker, atkr.getNetCombatDamage(), atkr, true);
            }
        }
        int defenderLife = ComputerUtilCombat.getDamageToKill(blocker, false) + ComputerUtilCombat.predictToughnessBonusOfBlocker(attacker, blocker, withoutAbilities);
        int attackerLife = ComputerUtilCombat.getDamageToKill(attacker, false) + ComputerUtilCombat.predictToughnessBonusOfAttacker(attacker, blocker, combat, withoutAbilities, withoutAttackerStaticAbilities);
        if (attacker.hasDoubleStrike()) {
            if (attackerDamage >= defenderLife) {
                return true;
            }
            if (attackerDamage > 0 && (ComputerUtilCombat.hasKeyword(attacker, "Deathtouch", withoutAbilities, combat) || blocker.hasSVar("DestroyWhenDamaged"))) {
                return true;
            }
            if (ComputerUtilCombat.dealsFirstStrikeDamage(blocker, withoutAbilities, combat) && !attacker.hasKeyword(Keyword.INDESTRUCTIBLE)) {
                if (defenderDamage >= attackerLife) {
                    return false;
                }
                if (defenderDamage > 0 && (ComputerUtilCombat.hasKeyword(blocker, "Deathtouch", withoutAbilities, combat) || attacker.hasSVar("DestroyWhenDamaged"))) {
                    return false;
                }
            }
            return defenderLife <= 2 * attackerDamage;
        }
        if (ComputerUtilCombat.dealsFirstStrikeDamage(blocker, withoutAbilities, combat) && !attacker.hasKeyword(Keyword.INDESTRUCTIBLE) && !ComputerUtilCombat.dealsFirstStrikeDamage(attacker, withoutAbilities, combat)) {
            if (defenderDamage >= attackerLife) {
                return false;
            }
            if (defenderDamage > 0 && (ComputerUtilCombat.hasKeyword(blocker, "Deathtouch", withoutAbilities, combat) || attacker.hasSVar("DestroyWhenDamaged"))) {
                return false;
            }
        }
        if (attackerDamage > 0 && (ComputerUtilCombat.hasKeyword(attacker, "Deathtouch", withoutAbilities, combat) || blocker.hasSVar("DestroyWhenDamaged"))) {
            return true;
        }
        return attackerDamage >= defenderLife;
    }

    public static Map<Card, Integer> distributeAIDamage(Player self, Card attacker, CardCollectionView block, CardCollectionView remaining, int dmgCanDeal, GameEntity defender, boolean overrideOrder) {
        HashMap<Card, Integer> damageMap = Maps.newHashMap();
        Combat combat = attacker.getGame().getCombat();
        boolean isAttacking = defender != null;
        boolean isAttackingMe = isAttacking && combat.getDefenderPlayerByAttacker(attacker).equals(self);
        boolean isBlockingMyBand = attacker.getController().isOpponentOf(self) && AttackingBand.isValidBand(block, true);
        boolean aiDistributesBandingDmg = isAttackingMe || isBlockingMyBand;
        boolean hasTrample = attacker.hasKeyword(Keyword.TRAMPLE);
        if (combat != null && remaining != null && hasTrample && attacker.isAttacking() && !aiDistributesBandingDmg) {
            for (Card c : remaining) {
                if (c == attacker || c.hasKeyword(Keyword.TRAMPLE)) continue;
                CardCollection sharedBlockers = new CardCollection(block);
                sharedBlockers.retainAll(combat.getBlockers(c));
                if (sharedBlockers.isEmpty()) continue;
                return null;
            }
        }
        if (block.size() == 1) {
            Card blocker = (Card)block.getFirst();
            int dmgToBlocker = dmgCanDeal;
            if (hasTrample && isAttacking && !aiDistributesBandingDmg) {
                int remainingDmg;
                dmgToBlocker = ComputerUtilCombat.getEnoughDamageToKill(blocker, dmgCanDeal, attacker, true);
                if (dmgCanDeal < dmgToBlocker) {
                    dmgToBlocker = Math.min(blocker.getLethalDamage(), dmgCanDeal);
                }
                if ((remainingDmg = dmgCanDeal - dmgToBlocker) > 0) {
                    damageMap.put(null, remainingDmg);
                }
            }
            damageMap.put(blocker, dmgToBlocker);
        } else if (!aiDistributesBandingDmg) {
            Card lastBlocker = null;
            Iterator dmgToBlocker = block.iterator();
            while (dmgToBlocker.hasNext()) {
                Card b;
                lastBlocker = b = (Card)dmgToBlocker.next();
                int dmgToKill = ComputerUtilCombat.getEnoughDamageToKill(b, dmgCanDeal, attacker, true);
                if (dmgToKill <= dmgCanDeal) {
                    damageMap.put(b, dmgToKill);
                    dmgCanDeal -= dmgToKill;
                    continue;
                }
                int dmg = Math.min(b.getLethalDamage(), dmgCanDeal);
                damageMap.put(b, dmg);
                if ((dmgCanDeal -= dmg) > 0) continue;
                break;
            }
            if (dmgCanDeal > 0) {
                if (hasTrample && isAttacking) {
                    damageMap.put(null, dmgCanDeal);
                } else if (lastBlocker != null) {
                    damageMap.put(lastBlocker, dmgCanDeal + (Integer)damageMap.get(lastBlocker));
                }
            }
        } else {
            for (Card b : block) {
                int dmgToKill = ComputerUtilCombat.getEnoughDamageToKill(b, dmgCanDeal, attacker, true);
                if (dmgToKill <= dmgCanDeal) continue;
                damageMap.put(b, dmgCanDeal);
                break;
            }
            if (damageMap.isEmpty()) {
                damageMap.put(ComputerUtilCard.getWorstCreatureAI(block), dmgCanDeal);
            }
        }
        return damageMap;
    }

    public static final int getEnoughDamageToKill(Card c, int maxDamage, Card source, boolean isCombat) {
        return ComputerUtilCombat.getEnoughDamageToKill(c, maxDamage, source, isCombat, false);
    }

    public static final int getEnoughDamageToKill(Card c, int maxDamage, Card source, boolean isCombat, boolean noPrevention) {
        int killDamage = ComputerUtilCombat.getDamageToKill(c, false);
        if (c.hasKeyword(Keyword.INDESTRUCTIBLE) || c.getCounters(CounterEnumType.SHIELD) > 0 || c.getShieldCount() > 0 && c.canBeShielded()) {
            if (!source.isWitherDamage()) {
                return maxDamage + 1;
            }
        } else if (source.hasKeyword(Keyword.DEATHTOUCH) && c.isCreature()) {
            killDamage = 1;
        }
        for (int i = 1; i <= maxDamage; ++i) {
            if (!(noPrevention ? c.staticReplaceDamage(i, source, isCombat) >= killDamage : ComputerUtilCombat.predictDamageTo(c, i, source, isCombat) >= killDamage)) continue;
            return i;
        }
        return maxDamage + 1;
    }

    public static final int getDamageToKill(Card c, boolean withShields) {
        int damageShield = withShields ? c.getPreventNextDamageTotalShields() : 0;
        int killDamage = c.getExcessDamageValue(false);
        if (killDamage > damageShield && c.hasSVar("DestroyWhenDamaged")) {
            killDamage = 1;
        }
        return killDamage + damageShield;
    }

    public static final int predictDamageTo(GameEntity target, int damage, Card source, boolean isCombat) {
        return ComputerUtilCombat.predictDamageTo(target, damage, 0, source, isCombat);
    }

    public static final int predictDamageTo(GameEntity target, int damage, int possiblePrevention, Card source, boolean isCombat) {
        int restDamage = damage;
        restDamage = target.staticReplaceDamage(restDamage, source, isCombat);
        restDamage = target.staticDamagePrevention(restDamage, possiblePrevention, source, isCombat);
        return restDamage;
    }

    public static final boolean dealsFirstStrikeDamage(Card combatant, boolean withoutAbilities, Combat combat) {
        if (combatant.hasFirstStrike() || combatant.hasDoubleStrike()) {
            return true;
        }
        if (!withoutAbilities) {
            return ComputerUtilCombat.canGainKeyword(combatant, Lists.newArrayList("Double Strike", "First Strike"), combat);
        }
        return false;
    }

    public static final boolean hasKeyword(Card combatant, String keyword, boolean withoutAbilities, Combat combat) {
        if (combatant.hasKeyword(keyword)) {
            return true;
        }
        if (!withoutAbilities) {
            return ComputerUtilCombat.canGainKeyword(combatant, Lists.newArrayList(keyword), combat);
        }
        return false;
    }

    public static final boolean canGainKeyword(Card combatant, List<String> keywords, Combat combat) {
        Player controller = combatant.getController();
        for (Card c : controller.getCardsIn(ZoneType.Battlefield)) {
            for (SpellAbility ability : c.getAllSpellAbilities()) {
                if (!ability.isActivatedAbility() || ability.getApi() != ApiType.Pump || ability.hasParam("ActivationPhases") || ability.hasParam("SorcerySpeed") || !ability.hasParam("KW") || !ComputerUtilCost.canPayCost(ability, controller, false) || c != combatant && (!ability.usesTargeting() || !ability.canTarget(combatant) || controller.getGame().getPhaseHandler().isPlayerTurn(controller) && (combat == null || !combat.isAttacking(combatant) || combat.isAttacking(c)))) continue;
                for (String keyword : keywords) {
                    if (!ability.getParam("KW").contains(keyword)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static final Card canTransform(Card original) {
        if (original.isTransformable() && !original.isInAlternateState()) {
            for (SpellAbility sa : original.getSpellAbilities()) {
                if (sa.getApi() != ApiType.SetState || !ComputerUtilCost.canPayCost(sa, original.getController(), false)) continue;
                Card transformed = CardCopyService.getLKICopy(original);
                transformed.getCurrentState().copyFrom(original.getAlternateState(), true);
                transformed.updateStateForView();
                return transformed;
            }
        }
        return original;
    }

    public static boolean isCombatDamagePrevented(Card attacker, GameEntity target, int damage) {
        if (!attacker.canDamagePrevented(true)) {
            return false;
        }
        Game game = attacker.getGame();
        Map<AbilityKey, Object> repParams = AbilityKey.mapFromAffected(target);
        repParams.put(AbilityKey.DamageSource, attacker);
        repParams.put(AbilityKey.DamageAmount, damage);
        repParams.put(AbilityKey.IsCombat, true);
        List<ReplacementEffect> list = game.getReplacementHandler().getReplacementList(ReplacementType.DamageDone, repParams, ReplacementLayer.Other);
        for (ReplacementEffect re : list) {
            Map<String, String> params = re.getMapParams();
            if (!params.containsKey("Prevent") && (re.getOverridingAbility() == null || re.getOverridingAbility().getApi() == ApiType.ReplaceDamage || re.getOverridingAbility().getApi() == ApiType.ReplaceEffect)) continue;
            return true;
        }
        return false;
    }

    public static boolean attackerHasThreateningAfflict(Card attacker, Player aiDefender) {
        int afflictDmg = attacker.getKeywordMagnitude(Keyword.AFFLICT);
        return afflictDmg > attacker.getNetPower() || afflictDmg >= aiDefender.getLife();
    }

    public static List<Card> categorizeAttackersByEvasion(List<Card> attackers) {
        ArrayList<Card> categorizedAttackers = Lists.newArrayList();
        CardCollection withEvasion = new CardCollection();
        CardCollection withoutEvasion = new CardCollection();
        for (Card atk : attackers) {
            if (atk.hasKeyword(Keyword.FLYING) || atk.hasKeyword(Keyword.SHADOW) || atk.hasKeyword(Keyword.HORSEMANSHIP) || atk.hasKeyword(Keyword.FEAR) || atk.hasKeyword(Keyword.INTIMIDATE) || atk.hasKeyword(Keyword.SKULK) || atk.hasKeyword(Keyword.PROTECTION)) {
                withEvasion.add(atk);
                continue;
            }
            withoutEvasion.add(atk);
        }
        categorizedAttackers.addAll(withEvasion);
        categorizedAttackers.addAll(withoutEvasion);
        return categorizedAttackers;
    }

    public static Card mostDangerousAttacker(CardCollection list, Player ai, Combat combat, boolean withAbilities) {
        int poisonLife;
        double percentPoison;
        Card damageCard = null;
        Card poisonCard = null;
        int damageScore = 0;
        int poisonScore = 0;
        for (Card c : list) {
            int estimatedDmg = ComputerUtilCombat.damageIfUnblocked(c, ai, combat, withAbilities);
            int estimatedPoison = ComputerUtilCombat.poisonIfUnblocked(c, ai);
            if (combat.isBlocked(c)) {
                if (!c.hasKeyword(Keyword.TRAMPLE)) continue;
                int absorbedByToughness = 0;
                for (Card blocker : combat.getBlockers(c)) {
                    absorbedByToughness += blocker.getNetToughness();
                }
                estimatedPoison -= absorbedByToughness;
                estimatedDmg -= absorbedByToughness;
            }
            if (estimatedDmg > damageScore) {
                damageScore = estimatedDmg;
                damageCard = c;
            }
            if (estimatedPoison <= poisonScore) continue;
            poisonScore = estimatedPoison;
            poisonCard = c;
        }
        if (damageCard == null && poisonCard == null) {
            return null;
        }
        if (damageCard == null) {
            return poisonCard;
        }
        if (poisonCard == null) {
            return damageCard;
        }
        int life = ai.getLife();
        double percentLife = (double)life * 1.0 / (double)damageScore;
        if (percentLife >= (percentPoison = (double)(poisonLife = 10 - ai.getPoisonCounters()) * 1.0 / (double)poisonScore)) {
            return damageCard;
        }
        return poisonCard;
    }

    public static Card applyPotentialAttackCloneTriggers(Card attacker) {
        Card attackerAfterTrigs = attacker;
        for (Trigger t2 : attacker.getTriggers()) {
            SpellAbility exec;
            if (t2.getMode() != TriggerType.Attacks || (exec = t2.ensureAbility()) == null || exec.getApi() != ApiType.Clone || !"Self".equals(exec.getParam("CloneTarget")) || !exec.hasParam("ValidTgts") || !exec.getParam("ValidTgts").contains("Creature") || !exec.getParam("ValidTgts").contains("attacking") || exec.getParam("ValidTgts").contains("nonLegendary") && attacker.getType().isLegendary()) continue;
            int maxPwr = 0;
            for (Card c : attacker.getController().getCreaturesInPlay()) {
                if (c.getNetPower() <= maxPwr && (c.getNetPower() != maxPwr || ComputerUtilCard.evaluateCreature(c) <= ComputerUtilCard.evaluateCreature(attackerAfterTrigs))) continue;
                maxPwr = c.getNetPower();
                attackerAfterTrigs = c;
            }
        }
        return attackerAfterTrigs;
    }

    public static boolean willKillAtLeastOne(Player ai, Card c, Combat combat) {
        block4: {
            block3: {
                if (combat == null) {
                    return false;
                }
                if (!combat.isBlocked(c)) break block3;
                for (Card blk : combat.getBlockers(c)) {
                    if (!ComputerUtilCombat.blockerWouldBeDestroyed(ai, blk, combat)) continue;
                    return true;
                }
                break block4;
            }
            if (!combat.isBlocking(c)) break block4;
            for (Card atk : combat.getAttackersBlockedBy(c)) {
                if (!ComputerUtilCombat.attackerWouldBeDestroyed(ai, atk, combat)) continue;
                return true;
            }
        }
        return false;
    }

    public static int predictExtraPoisonWithDamage(Card attacker, Player attacked, int damage) {
        int pd = 0;
        int poison = 0;
        int damageAfterRepl = ComputerUtilCombat.predictDamageTo(attacked, damage, attacker, true);
        if (damageAfterRepl > 0) {
            CardCollectionView trigCards = attacker.getController().getCardsIn(ZoneType.Battlefield);
            for (Card c : trigCards) {
                for (Trigger t2 : c.getTriggers()) {
                    SpellAbility ab;
                    if (t2.getMode() != TriggerType.DamageDone || "False".equals(t2.getParam("CombatDamage")) || !t2.matchesValidParam("ValidSource", attacker) || (ab = t2.getOverridingAbility()).getApi() != ApiType.Poison || !"TriggeredTarget".equals(ab.getParam("Defined"))) continue;
                    pd += AbilityUtils.calculateAmount(attacker, ab.getParam("Num"), ab);
                }
                poison += pd;
            }
            poison += attacker.getKeywordMagnitude(Keyword.TOXIC);
        }
        if (attacker.hasDoubleStrike()) {
            poison *= 2;
        }
        return poison;
    }

    public static GameEntity addAttackerToCombat(SpellAbility sa, Card attacker, Iterable<? extends GameEntity> defenders) {
        Combat combat = sa.getHostCard().getGame().getCombat();
        if (combat != null) {
            GameEntity def = combat.getDefenderByAttacker(sa.getHostCard());
            if (def instanceof Card && Iterables.contains(defenders, def)) {
                if (((Card)def).isPlaneswalker()) {
                    return def;
                }
                if (((Card)def).isBattle()) {
                    return def;
                }
            }
            for (GameEntity gameEntity : defenders) {
                if (gameEntity instanceof Player && !ComputerUtilCard.canBeBlockedProfitably((Player)gameEntity, attacker, true)) {
                    return gameEntity;
                }
                if (!(gameEntity instanceof Card) || ComputerUtilCard.canBeBlockedProfitably(((Card)gameEntity).getController(), attacker, true)) continue;
                return gameEntity;
            }
        }
        return Iterables.getFirst(defenders, null);
    }

    public static int checkAttackerLifelinkDamage(Combat combat) {
        if (combat == null) {
            return 0;
        }
        int totalLifeLinkDamage = 0;
        for (Card attacker : combat.getAttackers()) {
            int netDamage = attacker.getNetCombatDamage();
            if (!attacker.hasKeyword(Keyword.LIFELINK) && !attacker.hasSVar("LikeLifeLink") || netDamage <= 0) continue;
            int damage = ComputerUtilCombat.predictDamageTo(combat.getDefenderByAttacker(attacker), netDamage, attacker, true);
            boolean prevented = ComputerUtilCombat.isCombatDamagePrevented(attacker, combat.getDefenderByAttacker(attacker), damage);
            if (prevented) continue;
            totalLifeLinkDamage += damage;
        }
        return totalLifeLinkDamage;
    }

    public static boolean willOpposingCreatureDieInCombat(Player ai, Card combatant, Combat combat) {
        block2: {
            block3: {
                if (combat == null) break block2;
                if (!combat.isBlocking(combatant)) break block3;
                for (Card atk : combat.getAttackersBlockedBy(combatant)) {
                    if (!ComputerUtilCombat.combatantWouldBeDestroyed(ai, atk, combat)) continue;
                    return true;
                }
                break block2;
            }
            if (!combat.isBlocked(combatant)) break block2;
            for (Card blk : combat.getBlockers(combatant)) {
                if (!ComputerUtilCombat.combatantWouldBeDestroyed(ai, blk, combat)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isDangerousToSacInCombat(Player ai, Card combatant, Combat combat) {
        if (combat != null) {
            if (combat.isBlocking(combatant)) {
                if (combatant.hasKeyword(Keyword.BANDING)) {
                    return true;
                }
                for (Card atk : combat.getAttackersBlockedBy(combatant)) {
                    if (!atk.hasKeyword(Keyword.TRAMPLE)) continue;
                    return true;
                }
            } else if (combat.isBlocked(combatant) && combatant.hasKeyword(Keyword.BANDING)) {
                return true;
            }
        }
        return false;
    }
}

