/*
 * Decompiled with CFR 0.152.
 */
package forge.ai;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import forge.ai.AiAttackController;
import forge.ai.AiBlockController;
import forge.ai.AiCardMemory;
import forge.ai.AiController;
import forge.ai.AiCostDecision;
import forge.ai.AiPlayDecision;
import forge.ai.AiProps;
import forge.ai.ComputerUtilAbility;
import forge.ai.ComputerUtilCard;
import forge.ai.ComputerUtilCombat;
import forge.ai.ComputerUtilCost;
import forge.ai.ComputerUtilMana;
import forge.ai.PlayerControllerAi;
import forge.ai.SpecialAiLogic;
import forge.ai.SpecialCardAi;
import forge.ai.SpellApiToAi;
import forge.ai.ability.ProtectAi;
import forge.ai.ability.TokenAi;
import forge.card.CardStateName;
import forge.card.CardType;
import forge.card.ColorSet;
import forge.card.MagicColor;
import forge.card.mana.ManaAtom;
import forge.game.CardTraitBase;
import forge.game.CardTraitPredicates;
import forge.game.Game;
import forge.game.GameActionUtil;
import forge.game.GameEntity;
import forge.game.GameEntityCounterTable;
import forge.game.GameObject;
import forge.game.GameType;
import forge.game.ability.AbilityKey;
import forge.game.ability.AbilityUtils;
import forge.game.ability.ApiType;
import forge.game.ability.effects.CharmEffect;
import forge.game.card.Card;
import forge.game.card.CardCollection;
import forge.game.card.CardCollectionView;
import forge.game.card.CardCopyService;
import forge.game.card.CardLists;
import forge.game.card.CardPredicates;
import forge.game.card.CardState;
import forge.game.card.CardUtil;
import forge.game.card.CounterEnumType;
import forge.game.card.CounterType;
import forge.game.combat.Combat;
import forge.game.combat.CombatUtil;
import forge.game.cost.Cost;
import forge.game.cost.CostCollectEvidence;
import forge.game.cost.CostDiscard;
import forge.game.cost.CostExile;
import forge.game.cost.CostPart;
import forge.game.cost.CostPayment;
import forge.game.cost.CostPutCounter;
import forge.game.cost.CostSacrifice;
import forge.game.keyword.Keyword;
import forge.game.phase.PhaseHandler;
import forge.game.phase.PhaseType;
import forge.game.player.GameLossReason;
import forge.game.player.Player;
import forge.game.replacement.ReplacementEffect;
import forge.game.replacement.ReplacementLayer;
import forge.game.replacement.ReplacementType;
import forge.game.spellability.AbilitySub;
import forge.game.spellability.SpellAbility;
import forge.game.spellability.SpellAbilityStackInstance;
import forge.game.spellability.TargetRestrictions;
import forge.game.staticability.StaticAbility;
import forge.game.trigger.Trigger;
import forge.game.trigger.TriggerType;
import forge.game.trigger.WrappedAbility;
import forge.game.zone.Zone;
import forge.game.zone.ZoneType;
import forge.util.Aggregates;
import forge.util.MyRandom;
import forge.util.TextUtil;
import forge.util.collect.FCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class ComputerUtil {
    public static boolean handlePlayingSpellAbility(Player ai, SpellAbility sa, Game game) {
        return ComputerUtil.handlePlayingSpellAbility(ai, sa, game, null);
    }

    public static boolean handlePlayingSpellAbility(Player ai, SpellAbility sa, Game game, Runnable chooseTargets) {
        Card source = sa.getHostCard();
        source.setSplitStateToPlayAbility(sa);
        if (sa.isSpell() && !source.isCopiedSpell()) {
            if ((sa = AbilityUtils.addSpliceEffects(sa)).getSplicedCards() != null && !sa.getSplicedCards().isEmpty() && ai.getController().isAI()) {
                sa.resetTargets();
                if (((PlayerControllerAi)ai.getController()).getAi().canPlaySa(sa) != AiPlayDecision.WillPlay) {
                    return false;
                }
            }
            sa.setHostCard(game.getAction().moveToStack(source, sa));
        }
        if (!sa.isCopied()) {
            sa.resetPaidHash();
            sa.setPaidLife(0);
        }
        if ((sa = GameActionUtil.addExtraKeywordCost(sa)).getApi() == ApiType.Charm && !CharmEffect.makeChoices(sa)) {
            return false;
        }
        if (chooseTargets != null) {
            chooseTargets.run();
            if (!sa.isTargetNumberValid()) {
                return false;
            }
        }
        Cost cost = sa.getPayCosts();
        game.getStack().freezeStack(sa);
        if (cost == null) {
            if (ComputerUtilMana.payManaCost(ai, sa, false)) {
                game.getStack().addAndUnfreeze(sa);
                return true;
            }
        } else {
            CostPayment pay = new CostPayment(cost, sa);
            if (pay.payComputerCosts(new AiCostDecision(ai, sa, false))) {
                game.getStack().addAndUnfreeze(sa);
                if (sa.getSplicedCards() != null && !sa.getSplicedCards().isEmpty()) {
                    game.getAction().reveal(sa.getSplicedCards(), ai, true, "Computer reveals spliced cards from ");
                }
                return true;
            }
        }
        System.out.println("AI failed to play " + sa.getHostCard());
        return false;
    }

    private static boolean hasDiscardHandCost(Cost cost) {
        if (cost == null) {
            return false;
        }
        for (CostPart part : cost.getCostParts()) {
            CostDiscard disc;
            if (!(part instanceof CostDiscard) || !(disc = (CostDiscard)part).getType().equals("Hand")) continue;
            return true;
        }
        return false;
    }

    public static int counterSpellRestriction(Player ai, SpellAbility sa) {
        String tgtType;
        String[] validTgts;
        String unless;
        int restrict = 0;
        Card source = sa.getHostCard();
        TargetRestrictions tgt = sa.getTargetRestrictions();
        Cost cost = sa.getPayCosts();
        if (ComputerUtil.hasDiscardHandCost(cost)) {
            restrict -= ai.getCardsIn(ZoneType.Hand).size() * 20;
        }
        if (sa.isActivatedAbility()) {
            restrict += 40;
        }
        if (tgt.getSAValidTargeting() != null) {
            restrict += 35;
        }
        if ((unless = sa.getParam("UnlessCost")) != null && !unless.endsWith(">")) {
            int usableManaSources;
            int amount = AbilityUtils.calculateAmount(source, unless, sa);
            restrict = amount > (usableManaSources = ComputerUtilMana.getAvailableManaSources(ComputerUtilAbility.getTopSpellAbilityOnStack(ai.getGame(), sa).getActivatingPlayer(), true).size()) ? (restrict += 20 - 2 * amount) : (restrict -= 10 - 2 * amount);
        }
        if ((validTgts = tgt.getValidTgts()).length != 1 || !validTgts[0].equals("Card")) {
            restrict += 10;
        }
        if ((tgtType = sa.getParam("TargetType")) != null) {
            restrict -= 5 * tgtType.split(",").length;
        }
        return restrict;
    }

    public static final boolean playStack(SpellAbility sa, Player ai, Game game) {
        sa.setActivatingPlayer(ai, true);
        if (!ComputerUtilCost.canPayCost(sa, ai, false)) {
            return false;
        }
        Card source = sa.getHostCard();
        Zone fromZone = game.getZoneOf(source);
        int zonePosition = 0;
        if (fromZone != null) {
            zonePosition = fromZone.getCards().indexOf(source);
        }
        if (sa.isSpell() && !source.isCopiedSpell()) {
            sa.setHostCard(game.getAction().moveToStack(source, sa));
        }
        sa = GameActionUtil.addExtraKeywordCost(sa);
        Cost cost = sa.getPayCosts();
        CostPayment pay = new CostPayment(cost, sa);
        if (!sa.checkRestrictions(ai)) {
            GameActionUtil.rollbackAbility(sa, fromZone, zonePosition, pay, source);
            return false;
        }
        if (cost == null) {
            ComputerUtilMana.payManaCost(ai, sa, false);
            game.getStack().add(sa);
        } else if (pay.payComputerCosts(new AiCostDecision(ai, sa, false))) {
            game.getStack().add(sa);
        }
        return true;
    }

    public static final void playSpellAbilityForFree(Player ai, SpellAbility sa) {
        Game game = ai.getGame();
        sa.setActivatingPlayer(ai, true);
        Card source = sa.getHostCard();
        if (sa.isSpell() && !source.isCopiedSpell()) {
            sa.setHostCard(game.getAction().moveToStack(source, sa));
        }
        game.getStack().add(sa);
    }

    public static final boolean playSpellAbilityWithoutPayingManaCost(Player ai, SpellAbility sa, Game game) {
        SpellAbility newSA = sa.copyWithNoManaCost();
        newSA.setActivatingPlayer(ai, true);
        if (!CostPayment.canPayAdditionalCosts(newSA.getPayCosts(), newSA, false) || !ComputerUtilMana.canPayManaCost(newSA, ai, 0, false)) {
            return false;
        }
        newSA = GameActionUtil.addExtraKeywordCost(newSA);
        Card source = newSA.getHostCard();
        Zone fromZone = game.getZoneOf(source);
        int zonePosition = 0;
        if (fromZone != null) {
            zonePosition = fromZone.getCards().indexOf(source);
        }
        if (newSA.isSpell() && !source.isCopiedSpell()) {
            newSA.setHostCard(game.getAction().moveToStack(source, newSA));
            if (newSA.getApi() == ApiType.Charm && !CharmEffect.makeChoices(newSA)) {
                return false;
            }
        }
        CostPayment pay = new CostPayment(newSA.getPayCosts(), newSA);
        if (!newSA.checkRestrictions(ai)) {
            GameActionUtil.rollbackAbility(newSA, fromZone, zonePosition, pay, source);
            return false;
        }
        pay.payComputerCosts(new AiCostDecision(ai, newSA, false));
        game.getStack().add(newSA);
        return true;
    }

    public static final boolean playNoStack(Player ai, SpellAbility sa, Game game, boolean effect) {
        Cost cost;
        sa.setActivatingPlayer(ai, true);
        if (!ComputerUtilCost.canPayCost(sa, ai, effect)) {
            return false;
        }
        Card source = sa.getHostCard();
        if (sa.isSpell() && !source.isCopiedSpell()) {
            sa.setHostCard(game.getAction().moveToStack(source, sa));
        }
        if ((cost = (sa = GameActionUtil.addExtraKeywordCost(sa)).getPayCosts()) == null) {
            ComputerUtilMana.payManaCost(ai, sa, effect);
        } else {
            CostPayment pay = new CostPayment(cost, sa);
            pay.payComputerCosts(new AiCostDecision(ai, sa, effect));
        }
        AbilityUtils.resolve(sa);
        return true;
    }

    public static Card getCardPreference(Player ai, Card activate, String pref, CardCollection typeList) {
        return ComputerUtil.getCardPreference(ai, activate, pref, typeList, null);
    }

    public static Card getCardPreference(Player ai, Card activate, String pref, CardCollection typeList, SpellAbility sa) {
        int highestCMC;
        Game game = ai.getGame();
        String prefDef = "";
        if (activate != null) {
            String[] prefGroups;
            prefDef = activate.getSVar("AIPreference");
            for (String prefGroup : prefGroups = prefDef.split("\\|")) {
                String[] prefValid = prefGroup.trim().split("\\$");
                if (!prefValid[0].equals(pref) || prefValid[1].startsWith("Special:")) continue;
                CardCollection overrideList = null;
                if (activate.hasSVar("AIPreferenceOverride")) {
                    overrideList = CardLists.getValidCards((Iterable<Card>)typeList, activate.getSVar("AIPreferenceOverride"), activate.getController(), activate, null);
                }
                for (String validItem : prefValid[1].split(",")) {
                    CardCollection prefList = CardLists.getValidCards((Iterable<Card>)typeList, validItem, activate.getController(), activate, null);
                    int threshold = ComputerUtil.getAIPreferenceParameter(activate, "CreatureEvalThreshold", sa);
                    int minNeeded = ComputerUtil.getAIPreferenceParameter(activate, "MinCreaturesBelowThreshold", sa);
                    if (threshold != -1) {
                        ArrayList<Card> toRemove = Lists.newArrayList();
                        for (Card c2 : prefList) {
                            if (!c2.isCreature() || ComputerUtilCard.isUselessCreature(ai, c2) || ComputerUtilCard.evaluateCreature(c2) <= threshold || ComputerUtilCard.hasActiveUndyingOrPersist(c2)) continue;
                            toRemove.add(c2);
                        }
                        prefList.removeAll((Collection<?>)toRemove);
                    }
                    if (minNeeded != -1 && prefList.size() < minNeeded) {
                        return null;
                    }
                    if (prefList.isEmpty() && (overrideList == null || overrideList.isEmpty())) continue;
                    boolean isBestAI = "true".equalsIgnoreCase(activate.getSVar("AIPreferBestCard"));
                    if (isBestAI) {
                        return ComputerUtilCard.getBestAI(overrideList == null ? prefList : overrideList);
                    }
                    return ComputerUtilCard.getWorstAI(overrideList == null ? prefList : overrideList);
                }
            }
        }
        if (pref.contains("SacCost")) {
            for (int ip = 0; ip < 6; ++ip) {
                List<String> dontSac;
                boolean allowTokens;
                AiController aic;
                boolean enableDefaultPref;
                CardCollection landsInPlay;
                int priority = 6 - ip;
                if (priority == 2 && ai.isCardInPlay("Crucible of Worlds") && !(landsInPlay = CardLists.getType(typeList, "Land")).isEmpty()) {
                    return ComputerUtilCard.getWorstLand(landsInPlay);
                }
                CardCollection sacMeList = CardLists.filter((Iterable<Card>)typeList, c -> c.hasSVar("SacMe") && Integer.parseInt(c.getSVar("SacMe")) == priority || priority == 1 && ComputerUtil.shouldSacrificeThreatenedCard(ai, c, sa));
                if (!sacMeList.isEmpty()) {
                    CardLists.shuffle(sacMeList);
                    return (Card)sacMeList.getFirst();
                }
                if (!ai.getController().isAI() || !(enableDefaultPref = (aic = ((PlayerControllerAi)ai.getController()).getAi()).getBooleanProperty(AiProps.SACRIFICE_DEFAULT_PREF_ENABLE))) continue;
                int minCMC = aic.getIntProperty(AiProps.SACRIFICE_DEFAULT_PREF_MIN_CMC);
                int maxCMC = aic.getIntProperty(AiProps.SACRIFICE_DEFAULT_PREF_MAX_CMC);
                int maxCreatureEval = aic.getIntProperty(AiProps.SACRIFICE_DEFAULT_PREF_MAX_CREATURE_EVAL);
                CardCollection allowList = CardLists.filter((Iterable<Card>)typeList, arg_0 -> ComputerUtil.lambda$getCardPreference$1(maxCreatureEval, allowTokens = aic.getBooleanProperty(AiProps.SACRIFICE_DEFAULT_PREF_ALLOW_TOKENS), minCMC, maxCMC, dontSac = Arrays.asList("Black Lotus", "Mox Pearl", "Mox Jet", "Mox Emerald", "Mox Ruby", "Mox Sapphire", "Lotus Petal"), arg_0));
                if (allowList.isEmpty()) continue;
                CardLists.sortByCmcDesc(allowList);
                return (Card)allowList.getLast();
            }
            CardCollection landsInPlay = CardLists.getType(typeList, "Land");
            if (!landsInPlay.isEmpty()) {
                int landsInHand = Math.min(2, CardLists.getType(ai.getCardsIn(ZoneType.Hand), "Land").size());
                CardCollection nonLandsInHand = CardLists.getNotType(ai.getCardsIn(ZoneType.Hand), "Land");
                nonLandsInHand.addAll(ai.getCardsIn(ZoneType.Library));
                highestCMC = Math.max(6, Aggregates.max(nonLandsInHand, Card::getCMC));
                if (landsInPlay.size() + landsInHand >= highestCMC) {
                    return ComputerUtilCard.getWorstLand(landsInPlay);
                }
            }
            if (game.getPhaseHandler().getPhase().equals((Object)PhaseType.COMBAT_DECLARE_BLOCKERS)) {
                boolean preventReturn;
                boolean bl = preventReturn = sa != null && sa.isManaAbility();
                if (preventReturn) {
                    AiCardMemory.rememberCard(ai, sa.getHostCard(), AiCardMemory.MemorySet.HELD_MANA_SOURCES_FOR_NEXT_SPELL);
                }
                boolean danger = ComputerUtilCombat.lifeInSeriousDanger(ai, game.getCombat());
                if (preventReturn) {
                    AiCardMemory.forgetCard(ai, sa.getHostCard(), AiCardMemory.MemorySet.HELD_MANA_SOURCES_FOR_NEXT_SPELL);
                }
                if (danger) {
                    CardCollection nonCreatures = CardLists.getNotType(typeList, "Creature");
                    if (!nonCreatures.isEmpty()) {
                        return ComputerUtilCard.getWorstAI(nonCreatures);
                    }
                    if (!typeList.isEmpty()) {
                        return ComputerUtilCard.getWorstAI(typeList);
                    }
                }
            }
        } else if (pref.contains("DiscardCost")) {
            CardCollection nonLandsInHand;
            int numLandsInPlay;
            for (int ip = 0; ip < 6; ++ip) {
                int priority = 6 - ip;
                for (Card c3 : typeList) {
                    if (priority == 3 && c3.isLand() && ai.isCardInPlay("Crucible of Worlds")) {
                        return c3;
                    }
                    if (!c3.hasSVar("DiscardMe") || Integer.parseInt(c3.getSVar("DiscardMe")) != priority) continue;
                    return c3;
                }
            }
            if (activate != null && ComputerUtilCost.isFreeCastAllowedByPermanent(ai, "Discard")) {
                boolean wrongColor;
                int mana = ComputerUtilMana.getAvailableManaEstimate(ai, false);
                boolean cantAffordSoon = activate.getCMC() > mana + 1;
                boolean bl = wrongColor = !activate.getColor().hasNoColorsExcept(ColorSet.fromNames(ComputerUtilCost.getAvailableManaColors(ai, ImmutableList.of())).getColor());
                if (!activate.isInPlay() && (cantAffordSoon || wrongColor)) {
                    CardCollection options = new CardCollection();
                    for (Card c4 : typeList) {
                        if (c4.isCreature() && activate.isCreature()) {
                            if (ComputerUtilCard.evaluateCreature(c4) >= ComputerUtilCard.evaluateCreature(activate)) continue;
                            options.add(c4);
                            continue;
                        }
                        if (c4.getCMC() > activate.getCMC()) continue;
                        options.add(c4);
                    }
                    if (!options.isEmpty()) {
                        return ComputerUtilCard.getWorstAI(options);
                    }
                }
            }
            if (prefDef.contains("DiscardCost$Special:SurvivalOfTheFittest")) {
                return SpecialCardAi.SurvivalOfTheFittest.considerDiscardTarget(ai);
            }
            CardCollection landsInHand = CardLists.getType(typeList, "Land");
            if (!landsInHand.isEmpty() && ((numLandsInPlay = CardLists.count(ai.getCardsIn(ZoneType.Battlefield), CardPredicates.Presets.LANDS_PRODUCING_MANA)) >= (highestCMC = Math.max(6, Aggregates.max(nonLandsInHand = CardLists.getNotType(ai.getCardsIn(ZoneType.Hand), "Land"), Card::getCMC))) || numLandsInPlay + landsInHand.size() > 6 && landsInHand.size() > 1)) {
                return ComputerUtilCard.getWorstLand(landsInHand);
            }
            if ((activate != null && "Reality Smasher".equals(activate.getName()) || game.getPhaseHandler().getPhase().equals((Object)PhaseType.COMBAT_DECLARE_BLOCKERS) && ComputerUtilCombat.lifeInSeriousDanger(ai, game.getCombat())) && !typeList.isEmpty()) {
                return ComputerUtilCard.getWorstAI(typeList);
            }
        } else if (pref.contains("DonateMe")) {
            for (int ip = 0; ip < 6; ++ip) {
                int priority = 6 - ip;
                for (Card c5 : typeList) {
                    if (!c5.hasSVar("DonateMe") || Integer.parseInt(c5.getSVar("DonateMe")) != priority) continue;
                    return c5;
                }
            }
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int getAIPreferenceParameter(Card c, String paramName, SpellAbility sa) {
        String[] params;
        if (!c.hasSVar("AIPreferenceParams")) {
            return -1;
        }
        String[] stringArray = params = StringUtils.split(c.getSVar("AIPreferenceParams"), '|');
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String param = stringArray[n2];
            String[] props = StringUtils.split(param, "$");
            String parName = props[0].trim();
            String parValue = props[1].trim();
            switch (parName) {
                case "CreatureEvalThreshold": {
                    if (!paramName.equals(parName)) break;
                    int num = 0;
                    try {
                        return Integer.parseInt(parValue);
                    }
                    catch (NumberFormatException nfe) {
                        String[] valParts = StringUtils.split(parValue, "/");
                        CardCollection foundCards = AbilityUtils.getDefinedCards(c, valParts[0], sa);
                        if (!foundCards.isEmpty()) {
                            num = ComputerUtilCard.evaluateCreature((Card)foundCards.get(false));
                        }
                        valParts[0] = Integer.toString(num);
                        if (valParts.length <= 1) return num;
                        return AbilityUtils.doXMath(num, valParts[1], c, sa);
                    }
                }
                case "MinCreaturesBelowThreshold": {
                    if (!paramName.equals(parName)) break;
                    return Integer.parseInt(parValue);
                }
                default: {
                    System.err.println("Warning: unknown parameter " + parName + " in AIPreferenceParams for card " + c);
                }
            }
            ++n2;
        }
        return -1;
    }

    public static CardCollection chooseSacrificeType(Player ai, String type, SpellAbility ability, Card target, boolean effect, int amount, CardCollectionView exclude) {
        Card source = ability.getHostCard();
        boolean differentNames = false;
        if (type.contains("+WithDifferentNames")) {
            differentNames = true;
            type = type.replace("+WithDifferentNames", "");
        }
        CardCollection typeList = CardLists.getValidCards((Iterable<Card>)ai.getCardsIn(ZoneType.Battlefield), type.split(";"), source.getController(), source, (CardTraitBase)ability);
        if (differentNames) {
            HashSet<Card> uniqueNameCards = Sets.newHashSet();
            for (Card card : typeList) {
                if (card.hasNoName()) continue;
                uniqueNameCards.add(card);
            }
            typeList.clear();
            typeList.addAll(uniqueNameCards);
        }
        if (exclude != null) {
            typeList.removeAll(exclude);
        }
        typeList = CardLists.filter((Iterable<Card>)typeList, CardPredicates.canBeSacrificedBy(ability, effect));
        typeList = ComputerUtilCost.paymentChoicesWithoutTargets(typeList, ability, ai);
        if (source.hasKeyword(Keyword.CASUALTY)) {
            typeList = CardLists.filter((Iterable<Card>)typeList, Predicates.not(CardPredicates.hasSVar("AIDontSacToCasualty")));
        }
        if (typeList.size() < amount) {
            return null;
        }
        CardCollection sacList = new CardCollection();
        for (int count = 0; count < amount; ++count) {
            Card prefCard = ComputerUtil.getCardPreference(ai, source, "SacCost", typeList, ability);
            if (prefCard == null) {
                prefCard = ComputerUtilCard.getWorstAI(typeList);
            }
            if (prefCard == null) {
                return null;
            }
            sacList.add(prefCard);
            typeList.remove(prefCard);
        }
        return sacList;
    }

    public static CardCollection chooseCollectEvidence(Player ai, CostCollectEvidence cost, Card activate, int amount, SpellAbility sa, boolean effect) {
        CardCollection typeList = CardLists.filter((Iterable<Card>)ai.getCardsIn(ZoneType.Graveyard), CardPredicates.canExiledBy(sa, effect));
        if (CardLists.getTotalCMC(typeList) < amount) {
            return null;
        }
        CardLists.sortByCmcDesc(typeList);
        Collections.reverse(typeList);
        CardCollection exileList = new CardCollection();
        while (amount > 0) {
            Card c = (Card)typeList.remove(0);
            amount -= c.getCMC();
            exileList.add(c);
        }
        return exileList;
    }

    public static CardCollection chooseExileFrom(Player ai, CostExile cost, Card activate, int amount, SpellAbility sa, boolean effect) {
        CardCollection typeList = cost.zoneRestriction != 1 ? new CardCollection(ai.getGame().getCardsIn(cost.from)) : new CardCollection(ai.getCardsIn(cost.from));
        typeList = CardLists.getValidCards((Iterable<Card>)typeList, cost.getType().split(";"), activate.getController(), activate, (CardTraitBase)sa);
        return ComputerUtil.chooseExileFromList(ai, typeList, activate, amount, sa, effect);
    }

    public static CardCollection chooseExileFromList(Player ai, CardCollection typeList, Card activate, int amount, SpellAbility sa, boolean effect) {
        typeList = CardLists.filter((Iterable<Card>)typeList, CardPredicates.canExiledBy(sa, effect));
        if ((typeList = ComputerUtilCost.paymentChoicesWithoutTargets(typeList, sa, ai)).size() < amount) {
            return null;
        }
        CardLists.sortByPowerAsc(typeList);
        if (sa.isCraft()) {
            CardCollection toRemove = new CardCollection();
            for (Card exileTgt : typeList) {
                if (!exileTgt.isInPlay() || exileTgt.getCMC() < 3) continue;
                toRemove.add(exileTgt);
            }
            typeList.removeAll(toRemove);
            if (typeList.size() < amount) {
                return null;
            }
            CardLists.sortByCmcDesc(typeList);
            Collections.reverse(typeList);
            typeList.sort((a, b) -> {
                if (!a.isInPlay() && b.isInPlay()) {
                    return -1;
                }
                if (!b.isInPlay() && a.isInPlay()) {
                    return 1;
                }
                return 0;
            });
        }
        CardCollection exileList = new CardCollection();
        for (int i = 0; i < amount; ++i) {
            exileList.add((Card)typeList.get(i));
        }
        return exileList;
    }

    public static CardCollection choosePutToLibraryFrom(Player ai, ZoneType zone, String type, Card activate, Card target, int amount, SpellAbility sa) {
        CardCollection typeList = CardLists.getValidCards((Iterable<Card>)ai.getCardsIn(zone), type.split(";"), activate.getController(), activate, (CardTraitBase)sa);
        if ((typeList = ComputerUtilCost.paymentChoicesWithoutTargets(typeList, sa, ai)).size() < amount) {
            return null;
        }
        CardLists.sortByPowerAsc(typeList);
        CardCollection list = new CardCollection();
        if (zone != ZoneType.Hand) {
            Collections.reverse(typeList);
        }
        for (int i = 0; i < amount; ++i) {
            list.add((Card)typeList.get(i));
        }
        return list;
    }

    public static CardCollection chooseTapType(Player ai, String type, Card activate, boolean tap, int amount, CardCollectionView exclude, SpellAbility sa) {
        CardCollection all = new CardCollection(ai.getCardsIn(ZoneType.Battlefield));
        all.removeAll(exclude);
        CardCollection typeList = CardLists.getValidCards((Iterable<Card>)all, type.split(";"), activate.getController(), activate, (CardTraitBase)sa);
        typeList = CardLists.filter((Iterable<Card>)typeList, CardPredicates.Presets.CAN_TAP);
        if (tap) {
            typeList.remove(activate);
        }
        if (typeList.size() < amount) {
            return null;
        }
        CardLists.sortByPowerAsc(typeList);
        CardCollection tapList = new CardCollection();
        for (int i = 0; i < amount; ++i) {
            tapList.add((Card)typeList.get(i));
        }
        return tapList;
    }

    public static CardCollection chooseTapTypeAccumulatePower(Player ai, String type, SpellAbility sa, boolean tap, int amount, CardCollectionView exclude) {
        int totalPower = 0;
        Card activate = sa.getHostCard();
        CardCollection all = new CardCollection(ai.getCardsIn(ZoneType.Battlefield));
        all.removeAll(exclude);
        CardCollection typeList = CardLists.getValidCards((Iterable<Card>)all, type.split(";"), activate.getController(), activate, (CardTraitBase)sa);
        typeList = CardLists.filter((Iterable<Card>)typeList, sa.isCrew() ? CardPredicates.Presets.CAN_CREW : CardPredicates.Presets.CAN_TAP);
        if (tap) {
            typeList.remove(activate);
        }
        ComputerUtilCard.sortByEvaluateCreature(typeList);
        Collections.reverse(typeList);
        CardCollection tapList = new CardCollection();
        for (Card next : typeList) {
            int pow = next.getNetPower();
            if (pow <= 0) continue;
            if (pow >= amount) {
                tapList.clear();
            }
            tapList.add(next);
            totalPower = CardLists.getTotalPower(tapList, true, sa.isCrew());
            if (totalPower < amount) continue;
            break;
        }
        if (totalPower < amount) {
            return null;
        }
        return tapList;
    }

    public static CardCollection chooseUntapType(Player ai, String type, Card activate, boolean untap, int amount, SpellAbility sa) {
        CardCollection typeList = CardLists.getValidCards((Iterable<Card>)ai.getCardsIn(ZoneType.Battlefield), type.split(";"), activate.getController(), activate, (CardTraitBase)sa);
        typeList = CardLists.filter(typeList, CardPredicates.Presets.TAPPED, c -> c.getCounters(CounterEnumType.STUN) == 0 || c.canRemoveCounters(CounterType.get(CounterEnumType.STUN)));
        if (untap) {
            typeList.remove(activate);
        }
        if (typeList.size() < amount) {
            return null;
        }
        CardLists.sortByPowerDesc(typeList);
        return typeList.subList(0, amount);
    }

    public static CardCollection chooseReturnType(Player ai, String type, Card activate, Card target, int amount, SpellAbility sa) {
        CardCollection typeList = CardLists.getValidCards((Iterable<Card>)ai.getCardsIn(ZoneType.Battlefield), type.split(";"), activate.getController(), activate, (CardTraitBase)sa);
        if ((typeList = ComputerUtilCost.paymentChoicesWithoutTargets(typeList, sa, ai)).size() < amount) {
            return new CardCollection();
        }
        CardLists.sortByPowerAsc(typeList);
        CardCollection returnList = new CardCollection();
        for (int i = 0; i < amount; ++i) {
            returnList.add((Card)typeList.get(i));
        }
        return returnList;
    }

    public static CardCollection choosePermanentsToSacrifice(Player ai, CardCollectionView cardlist, int amount, SpellAbility source, boolean destroy, boolean isOptional) {
        CardCollection remaining = new CardCollection(cardlist);
        CardCollection sacrificed = new CardCollection();
        Card host = source.getHostCard();
        int considerSacThreshold = ComputerUtil.getAIPreferenceParameter(host, "CreatureEvalThreshold", source);
        if ("OpponentOnly".equals(source.getParam("AILogic"))) {
            if (!source.getActivatingPlayer().isOpponentOf(ai)) {
                return sacrificed;
            }
        } else if ("DesecrationDemon".equals(source.getParam("AILogic"))) {
            if (!SpecialCardAi.DesecrationDemon.considerSacrificingCreature(ai, source)) {
                return sacrificed;
            }
        } else if ("Lethal".equals(source.getParam("AILogic"))) {
            for (Card c2 : cardlist) {
                boolean isLethal = false;
                for (Player opp : ai.getOpponents()) {
                    if (!opp.canLoseLife() || opp.cantLoseForZeroOrLessLife() || c2.getNetPower() < opp.getLife()) continue;
                    isLethal = true;
                    break;
                }
                for (Card creature : ai.getOpponents().getCreaturesInPlay()) {
                    if (!creature.canBeDestroyed() || c2.getNetPower() < creature.getNetToughness()) continue;
                    isLethal = true;
                    break;
                }
                if (!c2.hasSVar("SacMe") && !isLethal) continue;
                sacrificed.add(c2);
                if (sacrificed.size() != amount) continue;
                return sacrificed;
            }
            if (sacrificed.size() < amount) {
                System.err.println("Warning: AILogic Lethal could not meaningfully select enough cards for the AF Sacrifice on " + source.getHostCard());
            }
        } else if (isOptional && source.getActivatingPlayer().isOpponentOf(ai)) {
            if ("Pillar Tombs of Aku".equals(host.getName())) {
                if (!ai.canLoseLife() || ai.cantLoseForZeroOrLessLife()) {
                    return sacrificed;
                }
            } else {
                return sacrificed;
            }
        }
        boolean exceptSelf = "ExceptSelf".equals(source.getParam("AILogic"));
        boolean removedSelf = false;
        if (isOptional && (source.isKeyword(Keyword.DEVOUR) || source.isKeyword(Keyword.EXPLOIT))) {
            if (source.isKeyword(Keyword.EXPLOIT)) {
                for (Trigger t2 : host.getTriggers()) {
                    if (t2.getMode() != TriggerType.Exploited) continue;
                    SpellAbility exSA = t2.ensureAbility().copy(ai);
                    exSA.setTrigger(t2);
                    if (!(exSA instanceof AbilitySub) || SpellApiToAi.Converter.get(exSA.getApi()).doTriggerAI(ai, exSA, false)) continue;
                    return sacrificed;
                }
            }
            remaining = CardLists.filter((Iterable<Card>)remaining, c -> {
                int sacThreshold = 190;
                String logic = source.getParamOrDefault("AILogic", "");
                if (logic.startsWith("SacForDamage")) {
                    int damageAmt;
                    int n = damageAmt = logic.contains("cmc") ? c.getManaCost().getCMC() : c.getNetPower();
                    if (damageAmt <= 0) {
                        return false;
                    }
                    if (damageAmt >= ai.getOpponentsSmallestLifeTotal()) {
                        return true;
                    }
                    if (logic.endsWith(".GiantX2") && c.getType().hasCreatureType("Giant") && damageAmt * 2 >= ai.getOpponentsSmallestLifeTotal()) {
                        return true;
                    }
                }
                if ("DesecrationDemon".equals(logic)) {
                    sacThreshold = SpecialCardAi.DesecrationDemon.getSacThreshold();
                } else if (considerSacThreshold != -1) {
                    sacThreshold = considerSacThreshold;
                }
                if (c.hasSVar("SacMe") || ComputerUtilCard.evaluateCreature(c) < sacThreshold) {
                    return true;
                }
                return ComputerUtilCard.hasActiveUndyingOrPersist(c);
            });
        }
        int max = Math.min(remaining.size(), amount);
        if (exceptSelf && max < remaining.size()) {
            removedSelf = remaining.remove(host);
        }
        for (int i = 0; i < max; ++i) {
            Card c3 = ComputerUtil.chooseCardToSacrifice(source, remaining, ai, destroy);
            remaining.remove(c3);
            if (c3 == null) continue;
            sacrificed.add(c3);
        }
        if (sacrificed.isEmpty() && removedSelf) {
            sacrificed.add(host);
        }
        return sacrificed;
    }

    private static Card chooseCardToSacrifice(SpellAbility source, CardCollection remaining, Player ai, boolean destroy) {
        CardCollection indestructibles;
        for (Card c : remaining) {
            if (!ai.isOpponentOf(c.getController())) continue;
            return c;
        }
        if (destroy && !(indestructibles = CardLists.getKeyword((Iterable<Card>)remaining, Keyword.INDESTRUCTIBLE)).isEmpty()) {
            return (Card)indestructibles.get(false);
        }
        for (int ip = 0; ip < 6; ++ip) {
            int priority = 6 - ip;
            for (Card card : remaining) {
                if (!card.hasSVar("SacMe") || Integer.parseInt(card.getSVar("SacMe")) != priority) continue;
                return card;
            }
        }
        if (source.isEmerge() || source.isOffering()) {
            remaining = CardLists.filter((Iterable<Card>)remaining, CardPredicates.greaterCMC(1));
        }
        Card c = null;
        c = CardLists.getNotType(remaining, "Creature").isEmpty() ? ComputerUtilCard.getWorstCreatureAI(remaining) : (CardLists.getNotType(remaining, "Land").isEmpty() ? ComputerUtilCard.getWorstLand(CardLists.filter((Iterable<Card>)remaining, CardPredicates.Presets.LANDS)) : ComputerUtilCard.getWorstPermanentAI(remaining, false, false, false, false));
        if (c != null && c.isEnchanted()) {
            for (Card aura : c.getEnchantedBy()) {
                if (!aura.getController().equals(c.getController()) || !remaining.contains(aura)) continue;
                return aura;
            }
        }
        return c;
    }

    public static boolean canRegenerate(Player ai, Card card) {
        if (!card.canBeShielded()) {
            return false;
        }
        boolean canRegen = false;
        ComputerUtilCombat.setCombatRegenTestSuppression(true);
        Player controller = card.getController();
        Game game = controller.getGame();
        CardCollectionView l = controller.getCardsIn(ZoneType.Battlefield);
        for (Card c : l) {
            for (SpellAbility sa : c.getSpellAbilities()) {
                try {
                    Cost abCost;
                    if (!sa.isActivatedAbility() || sa.getApi() != ApiType.Regenerate) continue;
                    sa.setActivatingPlayer(controller, true);
                    if (!sa.canPlay() || !ComputerUtilCost.canPayCost(sa, controller, false) || controller == ai && (abCost = sa.getPayCosts()) != null && (!ComputerUtilCost.checkLifeCost(controller, abCost, c, 4, sa) || !ComputerUtilCost.checkSacrificeCost(controller, abCost, c, sa) || !ComputerUtilCost.checkCreatureSacrificeCost(controller, abCost, c, sa))) continue;
                    TargetRestrictions tgt = sa.getTargetRestrictions();
                    if (tgt != null) {
                        if (!CardLists.getValidCards((Iterable<Card>)game.getCardsIn(ZoneType.Battlefield), tgt.getValidTgts(), controller, sa.getHostCard(), (CardTraitBase)sa).contains(card)) continue;
                        canRegen = true;
                        continue;
                    }
                    if (!AbilityUtils.getDefinedCards(sa.getHostCard(), sa.getParam("Defined"), sa).contains(card)) continue;
                    canRegen = true;
                }
                catch (Exception ex) {
                    throw new RuntimeException(TextUtil.concatNoSpace("There is an error in the card code for ", c.getName(), ":", ex.getMessage()), ex);
                }
            }
        }
        ComputerUtilCombat.setCombatRegenTestSuppression(false);
        return canRegen;
    }

    public static int possibleDamagePrevention(Card card) {
        int prevented = 0;
        Player controller = card.getController();
        Game game = controller.getGame();
        CardCollectionView l = controller.getCardsIn(ZoneType.Battlefield);
        for (Card c : l) {
            for (SpellAbility sa : c.getSpellAbilities()) {
                try {
                    TargetRestrictions tgt;
                    if (sa.getApi() == null || !sa.isActivatedAbility() || sa.getApi() != ApiType.PreventDamage || !sa.canPlay() || !ComputerUtilCost.canPayCost(sa, controller, false)) continue;
                    if (AbilityUtils.getDefinedCards(sa.getHostCard(), sa.getParam("Defined"), sa).contains(card)) {
                        prevented += AbilityUtils.calculateAmount(sa.getHostCard(), sa.getParam("Amount"), sa);
                    }
                    if ((tgt = sa.getTargetRestrictions()) == null || !CardLists.getValidCards((Iterable<Card>)game.getCardsIn(ZoneType.Battlefield), tgt.getValidTgts(), controller, sa.getHostCard(), (CardTraitBase)sa).contains(card)) continue;
                    prevented += AbilityUtils.calculateAmount(sa.getHostCard(), sa.getParam("Amount"), sa);
                }
                catch (Exception ex) {
                    throw new RuntimeException(TextUtil.concatNoSpace("There is an error in the card code for ", c.getName(), ":", ex.getMessage()), ex);
                }
            }
        }
        return prevented;
    }

    public static boolean castPermanentInMain1(Player ai, SpellAbility sa) {
        CardCollectionView vengevines;
        CardState cardState;
        Card card = sa.getHostCard();
        CardState cardState2 = cardState = card.isFaceDown() ? card.getState(CardStateName.Original) : card.getCurrentState();
        if (card.hasSVar("PlayMain1")) {
            if (card.getSVar("PlayMain1").equals("ALWAYS") || sa.getPayCosts().hasNoManaCost()) {
                return true;
            }
            if (card.getSVar("PlayMain1").equals("OPPONENTCREATURES") ? !ai.getOpponents().getCreaturesInPlay().isEmpty() : !card.getController().getCreaturesInPlay().isEmpty()) {
                return true;
            }
        }
        if (cardState.hasKeyword(Keyword.BACKUP)) {
            for (Object potentialAtkr : ai.getCreaturesInPlay()) {
                if (!ComputerUtilCard.doesCreatureAttackAI(ai, (Card)potentialAtkr)) continue;
                return true;
            }
        }
        if (sa.isBlitz() && ComputerUtilCard.doesSpecifiedCreatureAttackAI(ai, card)) {
            return true;
        }
        if ("Count$AttackersDeclared".equals(card.getSVar("RaidTest")) && !cardState.hasKeyword(Keyword.HASTE)) {
            for (Object potentialAtkr : ai.getCreaturesInPlay()) {
                if (!ComputerUtilCard.doesCreatureAttackAI(ai, (Card)potentialAtkr)) continue;
                return false;
            }
        }
        if (card.getManaCost().isZero()) {
            return true;
        }
        if (cardState.hasKeyword(Keyword.EXALTED) || cardState.hasKeyword(Keyword.EXTORT)) {
            return true;
        }
        if (cardState.hasKeyword(Keyword.RIOT) && SpecialAiLogic.preferHasteForRiot(sa, ai)) {
            return true;
        }
        if (ai.getManaPool().willManaBeLostAtEndOfPhase()) {
            boolean canUseToPayCost = false;
            for (Iterator color : (Object)ManaAtom.MANATYPES) {
                if (ai.getManaPool().getAmountOfColor((byte)color) <= 0 || !card.getManaCost().canBePaidWithAvailable((byte)color)) continue;
                canUseToPayCost = true;
                break;
            }
            if (canUseToPayCost) {
                return true;
            }
        }
        if (card.isCreature() && !cardState.hasKeyword(Keyword.DEFENDER) && (cardState.hasKeyword(Keyword.HASTE) || ComputerUtil.hasACardGivingHaste(ai, true) || sa.isDash())) {
            return true;
        }
        if (card.isEquipment()) {
            boolean playNow = false;
            for (Card c : card.getController().getCardsIn(ZoneType.Battlefield)) {
                if (c.isEquipment() && !c.isEquipping()) {
                    playNow = false;
                    break;
                }
                if (playNow || !c.isCreature() || !ComputerUtilCombat.canAttackNextTurn(c) || !c.canBeAttached(card, null)) continue;
                playNow = true;
            }
            if (playNow) {
                return true;
            }
        }
        CardCollectionView buffed = ai.getCardsIn(ZoneType.Battlefield);
        for (Card buffedcard : buffed) {
            String buffedby;
            String[] bffdby;
            if (buffedcard.hasSVar("BuffedBy") && card.isValid(bffdby = (buffedby = buffedcard.getSVar("BuffedBy")).split(","), buffedcard.getController(), buffedcard, (CardTraitBase)sa)) {
                return true;
            }
            if (card.isCreature()) {
                if (buffedcard.hasKeyword(Keyword.SOULBOND) && !buffedcard.isPaired()) {
                    return true;
                }
                if (buffedcard.hasKeyword(Keyword.EVOLVE) && (buffedcard.getNetPower() < card.getNetPower() || buffedcard.getNetToughness() < card.getNetToughness())) {
                    return true;
                }
            }
            if (ApiType.PermanentNoncreature.equals((Object)sa.getApi()) && buffedcard.hasKeyword(Keyword.PROWESS)) {
                return true;
            }
            if (!cardState.hasKeyword(Keyword.SOULBOND) || !buffedcard.isCreature() || buffedcard.isPaired()) continue;
            return true;
        }
        CardCollectionView antibuffed = ai.getWeakestOpponent().getCardsIn(ZoneType.Battlefield);
        for (Card buffedcard : antibuffed) {
            String buffedby;
            String[] bffdby;
            if (!buffedcard.hasSVar("AntiBuffedBy") || !card.isValid(bffdby = (buffedby = buffedcard.getSVar("AntiBuffedBy")).split(","), buffedcard.getController(), buffedcard, (CardTraitBase)sa)) continue;
            return true;
        }
        if (ai.getGame().getRules().hasAppliedVariant(GameType.Planechase)) {
            for (Card c : ai.getGame().getActivePlanes()) {
                for (StaticAbility s2 : c.getStaticAbilities()) {
                    if (!s2.hasParam("AddKeyword") || !s2.getParam("AddKeyword").contains("Haste") || !"Creature".equals(s2.getParam("Affected")) || !card.isCreature()) continue;
                    return true;
                }
            }
        }
        if (!(vengevines = ai.getCardsIn(ZoneType.Graveyard, "Vengevine")).isEmpty()) {
            CardCollectionView creatures = ai.getCardsIn(ZoneType.Hand);
            CardCollection creatures2 = new CardCollection();
            for (int i = 0; i < creatures.size(); ++i) {
                if (!((Card)creatures.get(i)).isCreature() || ((Card)creatures.get(i)).getManaCost().getCMC() > 3) continue;
                creatures2.add((Card)creatures.get(i));
            }
            if (creatures2.size() + CardUtil.getThisTurnCast("Creature.YouCtrl", (Card)vengevines.get(false), null, ai).size() > 1 && card.isCreature() && card.getManaCost().getCMC() <= 3) {
                return true;
            }
        }
        return false;
    }

    public static boolean shouldCastLessThanMax(Player ai, Card source) {
        if (source.getXManaCostPaid() > 0) {
            return true;
        }
        return ComputerUtil.aiLifeInDanger(ai, false, 0);
    }

    public static boolean isWorseThanDraw(Player ai, Card discard) {
        if (discard.hasSVar("DiscardMe")) {
            return true;
        }
        Game game = ai.getGame();
        CardCollection landsInPlay = CardLists.filter((Iterable<Card>)ai.getCardsIn(ZoneType.Battlefield), CardPredicates.Presets.LANDS_PRODUCING_MANA);
        CardCollection landsInHand = CardLists.filter((Iterable<Card>)ai.getCardsIn(ZoneType.Hand), CardPredicates.Presets.LANDS);
        CardCollection nonLandsInHand = CardLists.getNotType(ai.getCardsIn(ZoneType.Hand), "Land");
        int highestCMC = Math.max(6, Aggregates.max(nonLandsInHand, Card::getCMC));
        int discardCMC = discard.getCMC();
        if (discard.isLand()) {
            if (landsInPlay.size() >= highestCMC || landsInPlay.size() + landsInHand.size() > 6 && landsInHand.size() > 1 || landsInPlay.size() > 3 && nonLandsInHand.size() == 0) {
                return true;
            }
        } else {
            if (discardCMC > landsInPlay.size() + landsInHand.size() + 2) {
                return true;
            }
            if (!game.getPhaseHandler().isPlayerTurn(ai) && game.getPhaseHandler().getPhase().isAfter(PhaseType.MAIN2) && discardCMC > landsInPlay.size() + landsInHand.size() && discardCMC > landsInPlay.size() + 1 && nonLandsInHand.size() > 1) {
                return true;
            }
            if (landsInPlay.size() > 5 && discard.getCMC() <= 1 && !discard.hasProperty("hasXCost", ai, null, null)) {
                return true;
            }
        }
        return false;
    }

    public static boolean waitForBlocking(SpellAbility sa) {
        Game game = sa.getActivatingPlayer().getGame();
        PhaseHandler ph = game.getPhaseHandler();
        return sa.getHostCard().isCreature() && sa.getPayCosts().hasTapCost() && ph.getPhase().isBefore(PhaseType.COMBAT_DECLARE_BLOCKERS) && !ph.getNextTurn().equals(sa.getActivatingPlayer()) && !sa.getHostCard().hasSVar("EndOfTurnLeavePlay") && !sa.hasParam("ActivationPhases");
    }

    public static boolean castSpellInMain1(Player ai, SpellAbility sa) {
        Card source = sa.getHostCard();
        AbilitySub sub = sa.getSubAbility();
        if (source != null && "ALWAYS".equals(source.getSVar("PlayMain1"))) {
            return true;
        }
        if (sub != null) {
            ApiType api = sub.getApi();
            if (ApiType.Encode == api && !ai.getCreaturesInPlay().isEmpty()) {
                return true;
            }
            if (ApiType.PumpAll == api && !ai.getCreaturesInPlay().isEmpty()) {
                return true;
            }
            if (ApiType.Pump == api) {
                return true;
            }
        }
        CardCollectionView buffed = ai.getCardsIn(ZoneType.Battlefield);
        boolean checkThreshold = sa.isSpell() && !ai.hasThreshold() && !source.isInZone(ZoneType.Graveyard);
        for (Card buffedCard : buffed) {
            Object buffedby;
            String[] bffdby;
            if (buffedCard.hasSVar("BuffedBy") && source.isValid(bffdby = ((String)(buffedby = buffedCard.getSVar("BuffedBy"))).split(","), buffedCard.getController(), buffedCard, (CardTraitBase)sa)) {
                return true;
            }
            if (ApiType.PermanentNoncreature.equals((Object)sa.getApi()) && buffedCard.hasKeyword(Keyword.PROWESS)) {
                return true;
            }
            if (!checkThreshold) continue;
            buffedby = buffedCard.getStaticAbilities().iterator();
            while (buffedby.hasNext()) {
                StaticAbility stAb = (StaticAbility)buffedby.next();
                if (!"Threshold".equals(stAb.getParam("Condition"))) continue;
                return true;
            }
        }
        CardCollectionView antibuffed = ai.getWeakestOpponent().getCardsIn(ZoneType.Battlefield);
        for (Card buffedcard : antibuffed) {
            String buffedby;
            String[] bffdby;
            if (!buffedcard.hasSVar("AntiBuffedBy") || !source.isValid(bffdby = (buffedby = buffedcard.getSVar("AntiBuffedBy")).split(","), buffedcard.getController(), buffedcard, (CardTraitBase)sa)) continue;
            return true;
        }
        if (sub != null) {
            return ComputerUtil.castSpellInMain1(ai, sub);
        }
        return false;
    }

    public static boolean preventRunAwayActivations(SpellAbility sa) {
        int activations = sa.getActivationsThisTurn();
        if (!sa.isIntrinsic()) {
            return (double)MyRandom.getRandom().nextFloat() >= 0.95;
        }
        if (activations < 10) {
            return false;
        }
        return (double)MyRandom.getRandom().nextFloat() >= Math.pow(0.95, activations);
    }

    public static boolean activateForCost(SpellAbility sa, Player ai) {
        Cost abCost = sa.getPayCosts();
        Card source = sa.getHostCard();
        if (abCost == null) {
            return false;
        }
        if (abCost.hasTapCost() && source.hasSVar("AITapDown")) {
            return true;
        }
        if (sa.getRootAbility().isPwAbility() && ai.getGame().getPhaseHandler().is(PhaseType.MAIN2)) {
            for (CostPart part : sa.getRootAbility().getPayCosts().getCostParts()) {
                if (!(part instanceof CostPutCounter)) continue;
                return part.convertAmount() == null || part.convertAmount() > 0 || ai.isCardInPlay("Carth the Lion");
            }
        }
        for (CostPart part : abCost.getCostParts()) {
            if (!(part instanceof CostSacrifice)) continue;
            CostSacrifice sac = (CostSacrifice)part;
            String type = sac.getType();
            if (type.equals("CARDNAME")) {
                if (source.getSVar("SacMe").equals("6")) {
                    return true;
                }
                if (!ComputerUtil.shouldSacrificeThreatenedCard(ai, source, sa)) continue;
                return true;
            }
            CardCollection typeList = CardLists.getValidCards((Iterable<Card>)ai.getCardsIn(ZoneType.Battlefield), type, source.getController(), source, (CardTraitBase)sa);
            for (Card c : typeList) {
                if (c.getSVar("SacMe").equals("6")) {
                    return true;
                }
                if (!ComputerUtil.shouldSacrificeThreatenedCard(ai, c, sa)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean hasACardGivingHaste(Player ai, boolean checkOpponentCards) {
        CardCollection all = new CardCollection(ai.getCardsIn(Lists.newArrayList(ZoneType.Battlefield, ZoneType.Command)));
        if (!(ai.getGame().isCardInPlay("Yixlid Jailer") || ai.getCardsIn(ZoneType.Graveyard, "Anger").isEmpty() || CardLists.getType(all, "Mountain").isEmpty())) {
            return true;
        }
        if (ai.isCardInPlay("Odric, Lunarch Marshal") && !CardLists.getKeyword((Iterable<Card>)all, Keyword.HASTE).isEmpty()) {
            return true;
        }
        for (Card c : all) {
            Map<String, String> params;
            for (StaticAbility stAb : c.getStaticAbilities()) {
                params = stAb.getMapParams();
                if (!"Continuous".equals(params.get("Mode")) || !params.containsKey("AddKeyword") || !params.get("AddKeyword").contains("Haste")) continue;
                if (c.isEquipment() && c.getEquipping() == null) {
                    return true;
                }
                String affected = params.get("Affected");
                if (affected.contains("Creature.YouCtrl") || affected.contains("Other+YouCtrl")) {
                    return true;
                }
                if (!affected.contains("Creature.PairedWith") || c.isPaired()) continue;
                return true;
            }
            for (Trigger t2 : c.getTriggers()) {
                SpellAbility sa;
                String valid;
                params = t2.getMapParams();
                if (!"ChangesZone".equals(params.get("Mode")) || !"Battlefield".equals(params.get("Destination")) || !params.containsKey("ValidCard") || !(valid = params.get("ValidCard")).contains("Creature.YouCtrl") && !valid.contains("Other+YouCtrl") || (sa = t2.getOverridingAbility()) == null || sa.getApi() != ApiType.Pump || !sa.hasParam("KW") || !sa.getParam("KW").contains("Haste")) continue;
                return true;
            }
        }
        all.addAll(ai.getCardsActivatableInExternalZones(true));
        all.addAll(ai.getCardsIn(ZoneType.Hand));
        for (Card c : all) {
            if (c.getZone().getPlayer() != null && c.getZone().getPlayer() != ai && c.mayPlay(ai).isEmpty()) continue;
            for (SpellAbility sa : c.getSpellAbilities()) {
                if (sa.getApi() != ApiType.Pump || !sa.hasParam("KW") || !sa.getParam("KW").contains("Haste")) continue;
                return true;
            }
        }
        if (checkOpponentCards) {
            CardCollection opp = new CardCollection();
            opp.addAll(ai.getOpponents().getCardsIn(ZoneType.Battlefield));
            opp.addAll(ai.getOpponents().getCardsIn(ZoneType.Command));
            for (Card c : opp) {
                for (StaticAbility stAb : c.getStaticAbilities()) {
                    ArrayList<String> affected;
                    Map<String, String> params = stAb.getMapParams();
                    if (!"Continuous".equals(params.get("Mode")) || !params.containsKey("AddKeyword") || !params.get("AddKeyword").contains("Haste") || !(affected = Lists.newArrayList(params.get("Affected").split(","))).contains("Creature")) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean hasAFogEffect(Player defender, Player ai, boolean checkingOther) {
        Set<Card> revealed;
        CardCollection all = new CardCollection(defender.getCardsIn(ZoneType.Battlefield));
        all.addAll(defender.getCardsActivatableInExternalZones(true));
        if (!checkingOther) {
            all.addAll(defender.getCardsIn(ZoneType.Hand));
        }
        if ((revealed = AiCardMemory.getMemorySet(ai, AiCardMemory.MemorySet.REVEALED_CARDS)) != null) {
            for (Card c : revealed) {
                if (!c.isInZone(ZoneType.Hand) || c.getOwner() != defender) continue;
                all.add(c);
            }
        }
        for (Card c : all) {
            if (c.getZone().getPlayer() != null && c.getZone().getPlayer() != defender && c.mayPlay(defender).isEmpty()) continue;
            for (SpellAbility sa : c.getSpellAbilities()) {
                if (sa.getApi() != ApiType.Fog) continue;
                if (c.hasKeyword(Keyword.CONVOKE) || c.hasKeyword(Keyword.IMPROVISE)) {
                    if (!c.getController().isAI() || AiCardMemory.isRememberedCard(defender, c, AiCardMemory.MemorySet.MARKED_TO_AVOID_REENTRY)) continue;
                    AiCardMemory.rememberCard(defender, c, AiCardMemory.MemorySet.MARKED_TO_AVOID_REENTRY);
                }
                if (!ComputerUtilCost.canPayCost(sa, defender, false)) continue;
                return true;
            }
        }
        return false;
    }

    public static int possibleNonCombatDamage(Player ai, Player enemy) {
        int damage = 0;
        CardCollection all = new CardCollection(ai.getCardsIn(ZoneType.Battlefield));
        all.addAll(ai.getCardsActivatableInExternalZones(true));
        all.addAll(CardLists.filter((Iterable<Card>)ai.getCardsIn(ZoneType.Hand), Predicates.not(CardPredicates.Presets.PERMANENTS)));
        for (Card c : all) {
            if (c.getZone().getPlayer() != null && c.getZone().getPlayer() != ai && c.mayPlay(ai).isEmpty()) continue;
            for (SpellAbility sa : c.getSpellAbilities()) {
                if (sa.getApi() != ApiType.DealDamage) continue;
                sa.setActivatingPlayer(ai, true);
                String numDam = sa.getParam("NumDmg");
                int dmg = AbilityUtils.calculateAmount(sa.getHostCard(), numDam, sa);
                if (dmg <= damage || !sa.usesTargeting() || !sa.canTarget(enemy) || !ComputerUtilCost.canPayCost(sa, ai, false) || !GameActionUtil.getOptionalCostValues(sa).isEmpty()) continue;
                damage = dmg;
            }
            if (!c.isCreature() || !c.isInPlay() || !CombatUtil.canAttack(c)) continue;
            for (Trigger t2 : c.getTriggers()) {
                SpellAbility sa;
                if (!TriggerType.Attacks.equals((Object)t2.getMode()) || (sa = t2.ensureAbility()) == null || sa.getApi() != ApiType.LoseLife || !sa.getParamOrDefault("Defined", "").contains("Opponent")) continue;
                damage += AbilityUtils.calculateAmount(sa.getHostCard(), sa.getParam("LifeAmount"), sa);
            }
        }
        return damage;
    }

    public static List<GameObject> predictThreatenedObjects(Player ai, SpellAbility sa) {
        return ComputerUtil.predictThreatenedObjects(ai, sa, false);
    }

    public static List<GameObject> predictThreatenedObjects(Player ai, SpellAbility sa, boolean top) {
        Game game = ai.getGame();
        ArrayList<GameObject> objects = new ArrayList<GameObject>();
        if (game.getStack().isEmpty()) {
            return objects;
        }
        for (SpellAbilityStackInstance si : game.getStack()) {
            SpellAbility spell = si.getSpellAbility();
            AbilitySub sub = spell.getSubAbility();
            if (spell.isWrapper()) {
                spell = ((WrappedAbility)spell).getWrappedAbility();
            }
            if (spell.getOriginalAbility() != null && spell.getOriginalAbility().getHostCard().equals(spell.getHostCard())) {
                spell = spell.getOriginalAbility();
            }
            while (sub != null && sub != sa) {
                sub = sub.getSubAbility();
            }
            if (sa == null || sa != spell && sa != sub) {
                Iterables.addAll(objects, ComputerUtil.predictThreatenedObjects(ai, sa, spell));
            }
            if (!top) continue;
            break;
        }
        Collections.reverse(objects);
        return objects;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Iterable<? extends GameObject> predictThreatenedObjects(Player aiPlayer, SpellAbility saviour, SpellAbility topStack) {
        SpellAbility saviorWithSubs;
        ApiType saviorWithSubsApi;
        List<Object> objects = new ArrayList();
        ArrayList<GameEntity> threatened = new ArrayList<GameEntity>();
        ApiType saviourApi = saviour == null ? null : saviour.getApi();
        int toughness = 0;
        boolean grantIndestructible = false;
        boolean grantShroud = false;
        if (topStack == null) {
            return objects;
        }
        Card source = topStack.getHostCard();
        ApiType threatApi = topStack.getApi();
        if (threatApi == null) {
            return threatened;
        }
        if (!topStack.usesTargeting()) {
            if (topStack.hasParam("Defined")) {
                objects = AbilityUtils.getDefinedObjects(source, topStack.getParam("Defined"), topStack);
            } else {
                if (!topStack.hasParam("ValidCards")) return threatened;
                CardCollectionView battleField = aiPlayer.getCardsIn(ZoneType.Battlefield);
                objects = CardLists.getValidCards((Iterable<Card>)battleField, topStack.getParam("ValidCards"), source.getController(), source, (CardTraitBase)topStack);
            }
        } else {
            ArrayList<GameEntity> canBeTargeted = new ArrayList<GameEntity>();
            for (GameEntity ge : topStack.getTargets().getTargetEntities()) {
                if (!ge.canBeTargetedBy(topStack)) continue;
                canBeTargeted.add(ge);
            }
            if (canBeTargeted.isEmpty()) {
                return threatened;
            }
            objects = canBeTargeted;
        }
        ApiType apiType = saviorWithSubsApi = saviorWithSubs == null ? null : saviorWithSubs.getApi();
        for (saviorWithSubs = saviour; saviorWithSubs != null; saviorWithSubs = saviorWithSubs.getSubAbility()) {
            ArrayList arrayList;
            ApiType curApi = saviorWithSubs.getApi();
            if (curApi != ApiType.Pump && curApi != ApiType.PumpAll) continue;
            toughness = saviorWithSubs.hasParam("NumDef") ? AbilityUtils.calculateAmount(saviorWithSubs.getHostCard(), saviorWithSubs.getParam("NumDef"), saviour) : 0;
            List<Object> list = arrayList = saviorWithSubs.hasParam("KW") ? Arrays.asList(saviorWithSubs.getParam("KW").split(" & ")) : new ArrayList();
            if (arrayList.contains("Indestructible")) {
                grantIndestructible = true;
            }
            if (!arrayList.contains("Hexproof") && !arrayList.contains("Shroud")) break;
            grantShroud = true;
            break;
        }
        if (saviourApi == ApiType.PutCounter || saviourApi == ApiType.PutCounterAll) {
            if (saviour == null || !saviour.hasParam("CounterType") || !saviour.getParam("CounterType").equals("P1P1")) return threatened;
            toughness = AbilityUtils.calculateAmount(saviour.getHostCard(), saviour.getParamOrDefault("CounterNum", "1"), saviour);
        }
        if (threatApi == ApiType.DealDamage || threatApi == ApiType.DamageAll) {
            boolean bl;
            int dmg = AbilityUtils.calculateAmount(source, topStack.getParam("NumDmg"), topStack);
            AbilitySub abilitySub = topStack.getSubAbility();
            boolean bl2 = false;
            if (abilitySub != null && abilitySub.getApi() == ApiType.Effect && abilitySub.hasParam("AILogic") && abilitySub.getParam("AILogic").equals("CantRegenerate")) {
                bl = true;
            }
            for (Object t2 : objects) {
                if (t2 instanceof Card) {
                    boolean canSave;
                    Card c = (Card)t2;
                    if (c.hasKeyword(Keyword.INDESTRUCTIBLE) || c.getCounters(CounterEnumType.SHIELD) > 0 || c.getShieldCount() > 0 || saviourApi == ApiType.Regenerate && (!c.canBeShielded() || bl)) continue;
                    if (saviourApi == ApiType.Pump || saviourApi == ApiType.PumpAll) {
                        if (saviour.usesTargeting() && !saviour.canTarget(c) || saviour.getPayCosts() != null && saviour.getPayCosts().hasSpecificCostType(CostSacrifice.class) && !ComputerUtilCost.isSacrificeSelfCost(saviour.getPayCosts()) || c == source) continue;
                        boolean bl3 = canSave = ComputerUtilCombat.predictDamageTo(c, dmg - toughness, source, false) < ComputerUtilCombat.getDamageToKill(c, false);
                        if (!topStack.usesTargeting() && !grantIndestructible && !canSave || !grantIndestructible && !grantShroud && !canSave) continue;
                    }
                    if ((saviourApi == ApiType.PutCounter || saviourApi == ApiType.PutCounterAll) && (saviour.usesTargeting() && !saviour.canTarget(c) || saviour.getPayCosts() != null && saviour.getPayCosts().hasSpecificCostType(CostSacrifice.class) && !ComputerUtilCost.isSacrificeSelfCost(saviour.getPayCosts()) || c == source || !(canSave = ComputerUtilCombat.predictDamageTo(c, dmg - toughness, source, false) < ComputerUtilCombat.getDamageToKill(c, false))) || saviourApi == ApiType.Protection && ProtectAi.toProtectFrom(source, saviour) == null || saviourApi == ApiType.ChangeZone && (c.getOwner().isOpponentOf(aiPlayer) || c.isToken()) || ComputerUtilCombat.predictDamageTo(c, dmg, source, false) < ComputerUtilCombat.getDamageToKill(c, false)) continue;
                    threatened.add(c);
                    continue;
                }
                if (!(t2 instanceof Player)) continue;
                Player p = (Player)t2;
                if (source.hasKeyword(Keyword.INFECT)) {
                    if (!p.canReceiveCounters(CounterEnumType.POISON) || ComputerUtilCombat.predictDamageTo(p, dmg, source, false) < 10 - p.getPoisonCounters()) continue;
                    threatened.add(p);
                    continue;
                }
                if (ComputerUtilCombat.predictDamageTo(p, dmg, source, false) < p.getLife()) continue;
                threatened.add(p);
            }
        } else if ((threatApi == ApiType.Pump || threatApi == ApiType.PumpAll && topStack.isCurse()) && (saviourApi == ApiType.ChangeZone || saviourApi == ApiType.Pump || saviourApi == ApiType.PumpAll || saviourApi == ApiType.Protection || saviourApi == ApiType.PutCounter || saviourApi == ApiType.PutCounterAll || saviourApi == null)) {
            int dmg = -AbilityUtils.calculateAmount(source, topStack.getParam("NumDef"), topStack);
            for (Object t3 : objects) {
                boolean canSave;
                Card card;
                boolean bl;
                if (!(t3 instanceof Card) || !(bl = (card = (Card)t3).getNetToughness() <= dmg || !card.hasKeyword(Keyword.INDESTRUCTIBLE) && card.getShieldCount() == 0 && dmg >= ComputerUtilCombat.getDamageToKill(card, false))) continue;
                if (saviourApi == ApiType.Pump || saviourApi == ApiType.PumpAll) {
                    boolean cantSave;
                    boolean bl4 = cantSave = card.getNetToughness() + toughness <= dmg || !card.hasKeyword(Keyword.INDESTRUCTIBLE) && card.getShieldCount() == 0 && !grantIndestructible && dmg >= toughness + ComputerUtilCombat.getDamageToKill(card, false);
                    if (cantSave && (!topStack.usesTargeting() || !grantShroud)) continue;
                }
                if ((saviourApi == ApiType.PutCounter || saviourApi == ApiType.PutCounterAll) && !(canSave = card.getNetToughness() + toughness > dmg) || saviourApi == ApiType.Protection && (!topStack.usesTargeting() || ProtectAi.toProtectFrom(source, saviour) == null) || saviourApi == ApiType.ChangeZone && (card.getOwner().isOpponentOf(aiPlayer) || card.isToken())) continue;
                threatened.add(card);
            }
        } else if (!(threatApi != ApiType.Destroy && threatApi != ApiType.DestroyAll || (saviourApi != ApiType.Regenerate || topStack.hasParam("NoRegen")) && saviourApi != ApiType.ChangeZone && saviourApi != ApiType.Pump && saviourApi != ApiType.PumpAll && saviourApi != ApiType.Protection && saviourApi != null && saviorWithSubsApi != ApiType.Pump && saviorWithSubsApi != ApiType.PumpAll)) {
            for (Object t4 : objects) {
                Card card;
                if (!(t4 instanceof Card) || (card = (Card)t4).hasKeyword(Keyword.INDESTRUCTIBLE) || card.getCounters(CounterEnumType.SHIELD) > 0 || card.getShieldCount() > 0 || (saviourApi == ApiType.Pump || saviourApi == ApiType.PumpAll || saviorWithSubsApi == ApiType.Pump || saviorWithSubsApi == ApiType.PumpAll) && (!topStack.usesTargeting() && !grantIndestructible || !grantShroud && !grantIndestructible) || saviourApi == ApiType.Protection && (!topStack.usesTargeting() || ProtectAi.toProtectFrom(source, saviour) == null) || saviourApi == ApiType.ChangeZone && (card.getOwner().isOpponentOf(aiPlayer) || card.isToken()) || saviourApi == ApiType.Regenerate && !card.canBeShielded()) continue;
                threatened.add(card);
            }
        } else if ((threatApi == ApiType.ChangeZone || threatApi == ApiType.ChangeZoneAll) && (saviourApi == ApiType.ChangeZone || saviourApi == ApiType.Pump || saviourApi == ApiType.PumpAll || saviourApi == ApiType.Protection || saviourApi == null) && topStack.hasParam("Destination") && topStack.getParam("Destination").equals("Exile")) {
            for (Object t5 : objects) {
                if (!(t5 instanceof Card)) continue;
                Card card = (Card)t5;
                if ((saviourApi == ApiType.Pump || saviourApi == ApiType.PumpAll) && (!topStack.usesTargeting() || !grantShroud) || saviourApi == ApiType.Protection && (!topStack.usesTargeting() || ProtectAi.toProtectFrom(source, saviour) == null) || saviourApi == ApiType.ChangeZone && (card.getOwner().isOpponentOf(aiPlayer) || card.isToken())) continue;
                threatened.add(card);
            }
        } else if ((threatApi == ApiType.GainControl || threatApi == ApiType.Attach && topStack.hasParam("AILogic") && topStack.getParam("AILogic").equals("GainControl")) && (saviourApi == ApiType.ChangeZone || saviourApi == ApiType.Pump || saviourApi == ApiType.PumpAll || saviourApi == ApiType.Protection || saviourApi == null)) {
            for (Object t6 : objects) {
                if (!(t6 instanceof Card)) continue;
                Card card = (Card)t6;
                if ((saviourApi == ApiType.Pump || saviourApi == ApiType.PumpAll) && (!topStack.usesTargeting() || !grantShroud) || saviourApi == ApiType.Protection && (!topStack.usesTargeting() || ProtectAi.toProtectFrom(source, saviour) == null)) continue;
                threatened.add(card);
            }
        } else if (threatApi == ApiType.Attach && (topStack.isCurse() || "Curse".equals(topStack.getParam("AILogic"))) && (saviourApi == ApiType.Pump || saviourApi == ApiType.PumpAll || saviourApi == ApiType.Protection || saviourApi == null)) {
            boolean bl;
            AiController aic = aiPlayer.isAI() ? ((PlayerControllerAi)aiPlayer.getController()).getAi() : null;
            boolean bl5 = bl = aic != null ? aic.getBooleanProperty(AiProps.ACTIVELY_DESTROY_IMMEDIATELY_UNBLOCKABLE) : false;
            if (bl) {
                for (Object t7 : objects) {
                    if (!(t7 instanceof Card)) continue;
                    Card card = (Card)t7;
                    if ((saviourApi == ApiType.Pump || saviourApi == ApiType.PumpAll) && (!topStack.usesTargeting() || !grantShroud) || saviourApi == ApiType.Protection && (!topStack.usesTargeting() || ProtectAi.toProtectFrom(source, saviour) == null)) continue;
                    threatened.add(card);
                }
            }
        }
        Iterables.addAll(threatened, ComputerUtil.predictThreatenedObjects(aiPlayer, saviour, topStack.getSubAbility()));
        return threatened;
    }

    public static boolean predictCreatureWillDieThisTurn(Player ai, Card creature, SpellAbility excludeSa) {
        return ComputerUtil.predictCreatureWillDieThisTurn(ai, creature, excludeSa, false);
    }

    public static boolean predictCreatureWillDieThisTurn(Player ai, Card creature, SpellAbility excludeSa, boolean nonCombatOnly) {
        AiController aic;
        Game game = ai.getGame();
        boolean willDieFromSpell = false;
        boolean noStackCheck = false;
        if (ai.getController().isAI() && (aic = ((PlayerControllerAi)ai.getController()).getAi()).getBooleanProperty(AiProps.DONT_EVAL_KILLSPELLS_ON_STACK_WITH_PERMISSION)) {
            for (SpellAbilityStackInstance si : game.getStack()) {
                SpellAbility sa = si.getSpellAbility();
                if (sa.getApi() != ApiType.Counter) continue;
                noStackCheck = true;
                break;
            }
        }
        boolean bl = willDieFromSpell = !noStackCheck && ComputerUtil.predictThreatenedObjects(creature.getController(), excludeSa).contains(creature);
        if (nonCombatOnly) {
            return willDieFromSpell;
        }
        boolean willDieInCombat = !willDieFromSpell && game.getPhaseHandler().inCombat() && ComputerUtilCombat.combatantWouldBeDestroyed(creature.getController(), creature, game.getCombat());
        return willDieInCombat || willDieFromSpell;
    }

    public static CardCollection filterCreaturesThatWillDieThisTurn(Player ai, CardCollection list, SpellAbility excludeSa) {
        AiController aic = ((PlayerControllerAi)ai.getController()).getAi();
        if (aic.getBooleanProperty(AiProps.AVOID_TARGETING_CREATS_THAT_WILL_DIE)) {
            CardCollection willBeKilled = CardLists.filter((Iterable<Card>)list, card -> card.isCreature() && ComputerUtil.predictCreatureWillDieThisTurn(ai, card, excludeSa));
            list.removeAll(willBeKilled);
        }
        return list;
    }

    public static boolean playImmediately(Player ai, SpellAbility sa) {
        Card source = sa.getHostCard();
        Zone zone = source.getZone();
        Game game = source.getGame();
        if (sa.isTrigger() || zone == null || sa.isCopied()) {
            return true;
        }
        if (zone.getZoneType() == ZoneType.Battlefield) {
            if (ComputerUtil.predictThreatenedObjects(ai, null).contains(source)) {
                return true;
            }
            if (game.getPhaseHandler().inCombat() && ComputerUtilCombat.combatantWouldBeDestroyed(ai, source, game.getCombat())) {
                return true;
            }
        } else if (zone.getZoneType() == ZoneType.Exile && sa.getMayPlay() != null && game.getPhaseHandler().getPhase() == PhaseType.MAIN2 && source.mayPlay(sa.getMayPlay()) != null) {
            return true;
        }
        return false;
    }

    public static int scoreHand(CardCollectionView handList, Player ai, int cardsToReturn) {
        AiController aic = ((PlayerControllerAi)ai.getController()).getAi();
        int currentHandSize = handList.size();
        int finalHandSize = currentHandSize - cardsToReturn;
        if (finalHandSize < aic.getIntProperty(AiProps.MULLIGAN_THRESHOLD)) {
            return finalHandSize;
        }
        CardCollectionView library = ai.getCardsIn(ZoneType.Library);
        int landsInDeck = CardLists.count(library, CardPredicates.isType("Land"));
        if (landsInDeck == 0) {
            return finalHandSize;
        }
        CardCollection lands = CardLists.filter((Iterable<Card>)handList, c -> c.getManaCost().getCMC() <= 0 && !c.hasSVar("NeedsToPlay") && (c.isLand() || c.isArtifact()));
        int handSize = handList.size();
        int landSize = lands.size();
        int score = handList.size();
        CardCollection livingEnd = CardLists.filter((Iterable<Card>)handList, c -> "Living End".equalsIgnoreCase(c.getName()));
        if (livingEnd.size() > 0) {
            score = -(livingEnd.size() * 10);
        }
        if (handSize / 2 == landSize || handSize / 2 == landSize + 1) {
            score += 10;
        }
        CardCollection castables = CardLists.filter((Iterable<Card>)handList, c -> c.getManaCost().getCMC() <= 0 || c.getManaCost().getCMC() <= landSize);
        score += castables.size() * 2;
        if (handSize == aic.getIntProperty(AiProps.MULLIGAN_THRESHOLD) && landSize > 0) {
            return score;
        }
        if (landSize < 2) {
            if (landsInDeck == 0 || library.size() / landsInDeck > 6) {
                return handSize;
            }
            return 0;
        }
        if (landSize == handSize) {
            if (library.size() / landsInDeck < 2) {
                return handSize;
            }
            return 0;
        }
        if (handSize >= 7 && landSize >= handSize - 1) {
            if (library.size() / landsInDeck < 2) {
                return handSize;
            }
            return 0;
        }
        return score;
    }

    public static boolean wantMulligan(Player ai, int cardsToReturn) {
        CardCollectionView handList = ai.getCardsIn(ZoneType.Hand);
        return !handList.isEmpty() && ComputerUtil.scoreHand(handList, ai, cardsToReturn) <= 0;
    }

    public static CardCollection getPartialParisCandidates(Player ai) {
        CardCollection candidates = new CardCollection();
        CardCollectionView handList = ai.getCardsIn(ZoneType.Hand);
        CardCollection lands = CardLists.getValidCards((Iterable<Card>)handList, "Card.Land", ai, null, null);
        CardCollection nonLands = CardLists.getValidCards((Iterable<Card>)handList, "Card.nonLand", ai, null, null);
        CardLists.sortByCmcDesc(nonLands);
        if (lands.size() >= 3 && lands.size() <= 4) {
            return candidates;
        }
        if (lands.size() < 3) {
            int tgtCandidates = Math.max(Math.abs(lands.size() - nonLands.size()), 3);
            System.out.println("Partial Paris: " + ai.getName() + " lacks lands, aiming to exile " + tgtCandidates + " cards.");
            for (int i = 0; i < tgtCandidates; ++i) {
                candidates.add((Card)nonLands.get(i));
            }
        } else {
            int cntColors = MagicColor.WUBRG.length;
            ArrayList<CardCollection> numProducers = new ArrayList<CardCollection>(cntColors);
            for (byte col : MagicColor.WUBRG) {
                numProducers.add(col, new CardCollection());
            }
            Object object = lands.iterator();
            while (object.hasNext()) {
                Card c = (Card)object.next();
                for (SpellAbility sa : c.getManaAbilities()) {
                    for (byte col : MagicColor.WUBRG) {
                        if (!sa.canProduce(MagicColor.toLongString(col))) continue;
                        ((CardCollection)numProducers.get(col)).add(c);
                    }
                }
            }
        }
        System.out.print("Partial Paris: " + ai.getName() + " may exile ");
        for (Card c : candidates) {
            System.out.print(c.toString() + ", ");
        }
        System.out.println();
        if (candidates.size() < 2) {
            candidates.clear();
        }
        return candidates;
    }

    public static boolean scryWillMoveCardToBottomOfLibrary(Player player, Card c) {
        int maxCastable;
        int cmc;
        boolean bottom = false;
        int maxLandsToScryLandsToTop = 3;
        int minLandsToScryLandsAway = 8;
        int minCreatsToScryCreatsAway = 5;
        int minCreatEvalThreshold = 160;
        int lowCMCThreshold = 3;
        int maxCreatsToScryLowCMCAway = 3;
        boolean uncastablesToBottom = false;
        int uncastableCMCThreshold = 1;
        if (player.getController().isAI()) {
            AiController aic = ((PlayerControllerAi)player.getController()).getAi();
            maxLandsToScryLandsToTop = aic.getIntProperty(AiProps.SCRY_NUM_LANDS_TO_STILL_NEED_MORE);
            minLandsToScryLandsAway = aic.getIntProperty(AiProps.SCRY_NUM_LANDS_TO_NOT_NEED_MORE);
            minCreatsToScryCreatsAway = aic.getIntProperty(AiProps.SCRY_NUM_CREATURES_TO_NOT_NEED_SUBPAR_ONES);
            minCreatEvalThreshold = aic.getIntProperty(AiProps.SCRY_EVALTHR_TO_SCRY_AWAY_LOWCMC_CREATURE);
            lowCMCThreshold = aic.getIntProperty(AiProps.SCRY_EVALTHR_CMC_THRESHOLD);
            maxCreatsToScryLowCMCAway = aic.getIntProperty(AiProps.SCRY_EVALTHR_CREATCOUNT_TO_SCRY_AWAY_LOWCMC);
            uncastablesToBottom = aic.getBooleanProperty(AiProps.SCRY_IMMEDIATELY_UNCASTABLE_TO_BOTTOM);
            uncastableCMCThreshold = aic.getIntProperty(AiProps.SCRY_IMMEDIATELY_UNCASTABLE_CMC_DIFF);
        }
        CardCollectionView allCards = player.getAllCards();
        CardCollectionView cardsInHand = player.getCardsIn(ZoneType.Hand);
        CardCollectionView cardsOTB = player.getCardsIn(ZoneType.Battlefield);
        CardCollection landsOTB = CardLists.filter((Iterable<Card>)cardsOTB, CardPredicates.Presets.LANDS_PRODUCING_MANA);
        CardCollection thisLandOTB = CardLists.filter((Iterable<Card>)cardsOTB, CardPredicates.nameEquals(c.getName()));
        CardCollection landsInHand = CardLists.filter((Iterable<Card>)cardsInHand, CardPredicates.Presets.LANDS_PRODUCING_MANA);
        List<String> manaArts = Arrays.asList("Mox Pearl", "Mox Sapphire", "Mox Jet", "Mox Ruby", "Mox Emerald");
        CardCollection allCreatures = CardLists.filter(allCards, CardPredicates.Presets.CREATURES, CardPredicates.isOwner(player));
        int numCards = allCreatures.size();
        if (landsOTB.size() < maxLandsToScryLandsToTop && landsInHand.isEmpty() && (!c.isLand() && !manaArts.contains(c.getName()) || c.getManaAbilities().isEmpty() && !c.hasABasicLandType())) {
            bottom = true;
        }
        if (c.isLand()) {
            if (landsOTB.size() >= minLandsToScryLandsAway) {
                bottom = true;
            } else if (landsInHand.size() >= Math.max(cardsInHand.size() / 2, 2)) {
                bottom = true;
            }
            if (c.isBasicLand() && landsOTB.size() > 5 && thisLandOTB.size() >= 2) {
                bottom = true;
            }
        } else if (c.isCreature()) {
            CardCollection creaturesOTB = CardLists.filter((Iterable<Card>)cardsOTB, CardPredicates.Presets.CREATURES);
            int avgCreatureValue = numCards != 0 ? ComputerUtilCard.evaluateCreatureList(allCreatures) / numCards : 0;
            int maxControlledCMC = Aggregates.max(creaturesOTB, Card::getCMC);
            if (ComputerUtilCard.evaluateCreature(c) < avgCreatureValue) {
                if (creaturesOTB.size() > minCreatsToScryCreatsAway) {
                    bottom = true;
                } else if (creaturesOTB.size() > maxCreatsToScryLowCMCAway && c.getCMC() <= lowCMCThreshold && maxControlledCMC >= lowCMCThreshold + 1 && ComputerUtilCard.evaluateCreature(c) <= minCreatEvalThreshold) {
                    bottom = true;
                }
            }
        }
        if (uncastablesToBottom && !c.isLand() && (cmc = c.isSplitCard() ? Math.min(c.getCMC(Card.SplitCMCMode.LeftSplitCMC), c.getCMC(Card.SplitCMCMode.RightSplitCMC)) : c.getCMC()) - (maxCastable = ComputerUtilMana.getAvailableManaEstimate(player, false) + landsInHand.size()) >= uncastableCMCThreshold) {
            bottom = true;
        }
        return bottom;
    }

    public static CardCollection getCardsToDiscardFromOpponent(Player chooser, Player discarder, SpellAbility sa, CardCollection validCards, int min2, int max) {
        Card c2;
        String validString;
        CardCollection goodChoices = CardLists.filter((Iterable<Card>)validCards, c -> !c.hasSVar("DiscardMeByOpp") && !c.hasSVar("DiscardMe"));
        if (goodChoices.isEmpty()) {
            goodChoices = validCards;
        }
        if (min2 == 1 && max == 1 && sa.hasParam("DiscardValid") && (validString = sa.getParam("DiscardValid")).contains("Creature") && !validString.contains("nonCreature") && (c2 = ComputerUtilCard.getBestCreatureAI(goodChoices)) != null) {
            return new CardCollection(c2);
        }
        int minDiff = min2 - goodChoices.size();
        if (minDiff > 0) {
            goodChoices.addAll(Aggregates.random(CardLists.filter((Iterable<Card>)validCards, Predicates.not(Predicates.in(goodChoices))), minDiff));
            return goodChoices;
        }
        goodChoices.sort(CardLists.TextLenComparator);
        CardLists.sortByCmcDesc(goodChoices);
        return goodChoices.subList(0, max);
    }

    public static CardCollection getCardsToDiscardFromFriend(Player aiChooser, Player p, SpellAbility sa, CardCollection validCards, int min2, int max) {
        if (p == aiChooser) {
            AiController aic = ((PlayerControllerAi)p.getController()).getAi();
            return aic.getCardsToDiscard(min2, max, validCards, sa);
        }
        return ComputerUtil.getCardsToDiscardFromOpponent(aiChooser, p, sa, validCards, min2, max);
    }

    public static String chooseSomeType(Player ai, String kindOfType, SpellAbility sa, Collection<String> validTypes, List<String> invalidTypes) {
        String logic = sa.getParam("AILogic");
        if (invalidTypes == null) {
            invalidTypes = ImmutableList.of();
        }
        if (validTypes == null) {
            validTypes = ImmutableList.of();
        }
        Game game = ai.getGame();
        String chosen = "";
        if (kindOfType.equals("Card")) {
            if (game.getPhaseHandler().is(PhaseType.UNTAP) && logic == null) {
                double amount = 0.0;
                for (String type : CardType.getAllCardTypes()) {
                    if (invalidTypes.contains(type)) continue;
                    CardCollection list = CardLists.filter(ai.getCardsIn(ZoneType.Battlefield), CardPredicates.isType(type), CardPredicates.Presets.TAPPED);
                    double d = type.equals("Creature") ? (double)list.size() * 1.5 : (double)list.size();
                    double i = d;
                    if (!(i > amount)) continue;
                    amount = i;
                    chosen = type;
                }
            } else if ("ProtectionFromType".equals(logic)) {
                ImmutableList<String> choices = ImmutableList.of("Creature", "Planeswalker");
                CardCollection evalList = new CardCollection();
                evalList.addAll(ai.getOpponents().getCardsIn(ZoneType.Battlefield));
                chosen = ComputerUtilCard.getMostProminentCardType(evalList, choices);
                if (StringUtils.isEmpty(chosen)) {
                    chosen = "Creature";
                }
            } else {
                boolean reducingCost = false;
                for (StaticAbility s2 : sa.getHostCard().getStaticAbilities()) {
                    if (!"ReduceCost".equals(s2.getParam("Mode")) || !"Card.ChosenType".equals(s2.getParam("ValidCard"))) continue;
                    reducingCost = true;
                    break;
                }
                if (reducingCost) {
                    ArrayList<String> valid = Lists.newArrayList(validTypes);
                    valid.removeAll(invalidTypes);
                    valid.remove("Land");
                    chosen = ComputerUtilCard.getMostProminentCardType(ai.getAllCards(), valid);
                }
            }
            if (StringUtils.isEmpty(chosen)) {
                chosen = validTypes.isEmpty() ? "Creature" : Aggregates.random(validTypes);
            }
        } else if (kindOfType.equals("Creature")) {
            if (logic != null) {
                ArrayList<String> valid = Lists.newArrayList(CardType.getAllCreatureTypes());
                valid.removeAll(invalidTypes);
                if (logic.equals("MostProminentOnBattlefield")) {
                    chosen = ComputerUtilCard.getMostProminentType(game.getCardsIn(ZoneType.Battlefield), valid);
                } else if (logic.equals("MostProminentComputerControls")) {
                    chosen = ComputerUtilCard.getMostProminentType(ai.getCardsIn(ZoneType.Battlefield), valid);
                } else if (logic.equals("MostProminentComputerControlsOrOwns")) {
                    CardCollectionView list = ai.getCardsIn(Arrays.asList(ZoneType.Battlefield, ZoneType.Hand));
                    if (list.isEmpty()) {
                        list = ai.getCardsIn(Arrays.asList(ZoneType.Library));
                    }
                    chosen = ComputerUtilCard.getMostProminentType(list, valid);
                } else if (logic.equals("MostProminentOppControls")) {
                    CardCollection list = ai.getOpponents().getCardsIn(ZoneType.Battlefield);
                    chosen = ComputerUtilCard.getMostProminentType(list, valid);
                    if (!CardType.isACreatureType(chosen) || invalidTypes.contains(chosen)) {
                        list = CardLists.filterControlledBy((Iterable<Card>)game.getCardsInGame(), ai.getOpponents());
                        chosen = ComputerUtilCard.getMostProminentType(list, valid);
                    }
                } else if (logic.startsWith("MostProminentInComputerDeck")) {
                    boolean includeTokens = !logic.endsWith("NonToken");
                    chosen = ComputerUtilCard.getMostProminentType(ai.getAllCards(), valid, includeTokens);
                } else if (logic.equals("MostProminentInComputerGraveyard")) {
                    chosen = ComputerUtilCard.getMostProminentType(ai.getCardsIn(ZoneType.Graveyard), valid);
                }
            }
            if (!CardType.isACreatureType(chosen) || invalidTypes.contains(chosen)) {
                chosen = "Sliver";
            }
        } else if (kindOfType.equals("Basic Land")) {
            if (logic != null) {
                if (logic.equals("MostProminentOppControls")) {
                    CardCollection list = ai.getOpponents().getCardsIn(ZoneType.Battlefield);
                    ArrayList<String> valid = Lists.newArrayList(CardType.getBasicTypes());
                    valid.removeAll(invalidTypes);
                    chosen = ComputerUtilCard.getMostProminentType(list, valid);
                } else if (logic.equals("MostNeededType")) {
                    ArrayList<String> basics = new ArrayList<String>(CardType.Constant.BASIC_TYPES);
                    CardCollectionView presentCards = CardCollection.combine(ai.getCardsIn(ZoneType.Battlefield), ai.getCardsIn(ZoneType.Hand));
                    CardCollectionView possibleCards = ai.getAllCards();
                    for (String b : basics) {
                        if (Iterables.any(presentCards, CardPredicates.isType(b)) || !Iterables.any(possibleCards, CardPredicates.isType(b))) continue;
                        chosen = b;
                    }
                    if (chosen.isEmpty()) {
                        for (String b : basics) {
                            if (!Iterables.any(possibleCards, CardPredicates.isType(b))) continue;
                            chosen = b;
                        }
                    }
                } else if (logic.equals("ChosenLandwalk")) {
                    block4: for (Card c : AiAttackController.choosePreferredDefenderPlayer(ai).getLandsInPlay()) {
                        for (String t2 : c.getType()) {
                            if (invalidTypes.contains(t2) || !CardType.isABasicLandType(t2)) continue;
                            chosen = t2;
                            continue block4;
                        }
                    }
                }
            }
            if (!CardType.isABasicLandType(chosen) || invalidTypes.contains(chosen)) {
                chosen = "Island";
            }
        } else if (kindOfType.equals("Land")) {
            if (logic != null && logic.equals("ChosenLandwalk")) {
                block6: for (Card c : AiAttackController.choosePreferredDefenderPlayer(ai).getLandsInPlay()) {
                    for (String t3 : c.getType().getLandTypes()) {
                        if (invalidTypes.contains(t3)) continue;
                        chosen = t3;
                        continue block6;
                    }
                }
            }
            if (StringUtils.isEmpty(chosen)) {
                chosen = "Island";
            }
        }
        return chosen;
    }

    public static Object vote(Player ai, List<Object> options, SpellAbility sa, Multimap<Object, Player> votes, Player forPlayer) {
        String logic;
        Card source = sa.getHostCard();
        Player controller = source.getController();
        Game game = controller.getGame();
        boolean opponent = controller.isOpponentOf(ai);
        CounterType p1p1Type = CounterType.get(CounterEnumType.P1P1);
        if (!sa.hasParam("AILogic")) {
            return Aggregates.random(options);
        }
        switch (logic = sa.getParam("AILogic")) {
            case "Torture": {
                return "Torture";
            }
            case "GraceOrCondemnation": {
                ArrayList<ZoneType> graceZones = new ArrayList<ZoneType>();
                graceZones.add(ZoneType.Battlefield);
                graceZones.add(ZoneType.Graveyard);
                CardCollection graceCreatures = CardLists.getType(game.getCardsIn(graceZones), "Creature");
                int humanGrace = CardLists.filterControlledBy((Iterable<Card>)graceCreatures, ai.getOpponents()).size();
                int aiGrace = CardLists.filterControlledBy((Iterable<Card>)graceCreatures, ai).size();
                return aiGrace > humanGrace ? "Grace" : "Condemnation";
            }
            case "CarnageOrHomage": {
                CardCollection cardsInPlay = CardLists.getNotType(game.getCardsIn(ZoneType.Battlefield), "Land");
                CardCollection humanlist = CardLists.filterControlledBy((Iterable<Card>)cardsInPlay, ai.getOpponents());
                CardCollection computerlist = ai.getCreaturesInPlay();
                return ComputerUtilCard.evaluatePermanentList(computerlist) + 3 < ComputerUtilCard.evaluatePermanentList(humanlist) ? "Carnage" : "Homage";
            }
            case "Judgment": {
                if (votes.isEmpty()) {
                    CardCollection list = new CardCollection();
                    for (Object o : options) {
                        if (!(o instanceof Card)) continue;
                        list.add((Card)o);
                    }
                    return ComputerUtilCard.getBestAI(list);
                }
                return Iterables.getFirst(votes.keySet(), null);
            }
            case "Protection": {
                if (votes.isEmpty()) {
                    ArrayList<String> restrictedToColors = Lists.newArrayList();
                    for (Object o : options) {
                        if (!(o instanceof String)) continue;
                        restrictedToColors.add((String)o);
                    }
                    CardCollection lists = CardLists.filterControlledBy((Iterable<Card>)game.getCardsInGame(), ai.getOpponents());
                    return StringUtils.capitalize(ComputerUtilCard.getMostProminentColor(lists, restrictedToColors));
                }
                return Iterables.getFirst(votes.keySet(), null);
            }
            case "FeatherOrQuill": {
                CardCollectionView aiCardsInHand;
                int numQuill;
                if (opponent && !controller.cantLoseCheck(GameLossReason.Milled) && (numQuill = votes.get("Quill").size()) + 1 >= controller.getCardsIn(ZoneType.Library).size()) {
                    return controller.isCardInPlay("Laboratory Maniac") ? "Feather" : "Quill";
                }
                if (!source.canReceiveCounters(p1p1Type)) {
                    return opponent ? "Feather" : "Quill";
                }
                if (!game.getCardState(source).isInPlay()) {
                    return opponent ? "Feather" : "Quill";
                }
                if (controller.getCardsIn(ZoneType.Hand).isEmpty()) {
                    return opponent ? "Quill" : "Feather";
                }
                if (ai.equals(controller) && CardLists.count(aiCardsInHand = ai.getCardsIn(ZoneType.Hand), CardPredicates.hasSVar("DiscardMe")) >= 1) {
                    return "Quill";
                }
                return opponent ? "Feather" : "Quill";
            }
            case "StrengthOrNumbers": {
                SpellAbility saToken = sa.findSubAbilityByType(ApiType.Token);
                int numStrength = votes.get("Strength").size();
                int numNumbers = votes.get("Numbers").size();
                Card token = TokenAi.spawnToken(controller, saToken);
                if (!source.canReceiveCounters(p1p1Type)) {
                    return opponent ? "Strength" : "Numbers";
                }
                if (!game.getCardState(source).isInPlay()) {
                    return opponent ? "Strength" : "Numbers";
                }
                if (token == null || !token.isCreature() || token.getNetToughness() < 1) {
                    return opponent ? "Numbers" : "Strength";
                }
                int tokenScore = ComputerUtilCard.evaluateCreature(token);
                Card sourceNumbers = CardCopyService.getLKICopy(source);
                Card sourceStrength = CardCopyService.getLKICopy(source);
                sourceNumbers.setCounters(p1p1Type, (Integer)(sourceNumbers.getCounters(p1p1Type) + numStrength));
                sourceNumbers.setZone(source.getZone());
                sourceStrength.setCounters(p1p1Type, (Integer)(sourceStrength.getCounters(p1p1Type) + numStrength + 1));
                sourceStrength.setZone(source.getZone());
                int scoreStrength = ComputerUtilCard.evaluateCreature(sourceStrength) + tokenScore * numNumbers;
                int scoreNumbers = ComputerUtilCard.evaluateCreature(sourceNumbers) + tokenScore * (numNumbers + 1);
                return scoreNumbers >= scoreStrength != opponent ? "Numbers" : "Strength";
            }
            case "SproutOrHarvest": {
                if (opponent) {
                    if (ComputerUtil.lifegainNegative(controller, source)) {
                        return "Harvest";
                    }
                } else if (ComputerUtil.lifegainNegative(controller, source)) {
                    return "Sprout";
                }
                if (!source.canReceiveCounters(p1p1Type)) {
                    return opponent ? "Sprout" : "Harvest";
                }
                if (!game.getCardState(source).isInPlay()) {
                    return opponent ? "Sprout" : "Harvest";
                }
                return opponent ? "Harvest" : "Sprout";
            }
            case "DeathOrTaxes": {
                int numDeath = votes.get("Death").size();
                int numTaxes = votes.get("Taxes").size();
                if (opponent) {
                    CardCollection aiCreatures = ai.getCreaturesInPlay();
                    CardCollectionView aiCardsInHand = ai.getCardsIn(ZoneType.Hand);
                    if (aiCreatures.size() <= numDeath) {
                        return "Death";
                    }
                    if (aiCardsInHand.size() <= numTaxes) {
                        return "Taxes";
                    }
                    if (CardLists.count(aiCreatures, Predicates.or(CardPredicates.hasSVar("SacMe"), CardPredicates.Presets.TOKEN)) >= numDeath) {
                        return "Death";
                    }
                    if (CardLists.count(aiCardsInHand, CardPredicates.hasSVar("DiscardMe")) >= numTaxes) {
                        return "Taxes";
                    }
                    return "Taxes";
                }
                return controller.getOpponents().getCreaturesInPlay().isEmpty() ? "Taxes" : "Death";
            }
        }
        return Iterables.getFirst(options, null);
    }

    public static CardCollection getSafeTargets(Player ai, SpellAbility sa, CardCollectionView validCards) {
        CardCollection safeCards = CardLists.filter((Iterable<Card>)validCards, c -> {
            if (c.getController() == ai) {
                return !c.getSVar("Targeting").equals("Dies") && !c.getSVar("Targeting").equals("Counter");
            }
            return true;
        });
        return safeCards;
    }

    public static Card getKilledByTargeting(SpellAbility sa, CardCollectionView validCards) {
        CardCollection killables = CardLists.filter((Iterable<Card>)validCards, c -> c.getController() != sa.getActivatingPlayer() && c.getSVar("Targeting").equals("Dies"));
        return ComputerUtilCard.getBestCreatureAI(killables);
    }

    public static int predictDamageFromSpell(SpellAbility ab, Player targetPlayer) {
        int damage = -1;
        Card card = ab.getHostCard();
        while (ab != null && targetPlayer.canLoseLife()) {
            if (ab.getApi() == ApiType.DealDamage) {
                if (damage == -1) {
                    damage = 0;
                }
                if (!ab.hasParam("NumDmg")) continue;
                damage += ComputerUtilCombat.predictDamageTo(targetPlayer, AbilityUtils.calculateAmount(card, ab.getParam("NumDmg"), ab), card, false);
            } else if (ab.getApi() == ApiType.LoseLife) {
                if (damage == -1) {
                    damage = 0;
                }
                if (!ab.hasParam("LifeAmount")) continue;
                damage += AbilityUtils.calculateAmount(card, ab.getParam("LifeAmount"), ab);
            }
            ab = ab.getSubAbility();
        }
        return damage;
    }

    public static int getDamageForPlaying(Player player, SpellAbility sa) {
        int damage = 0;
        Game game = player.getGame();
        Card card = sa.getHostCard();
        FCollection<Trigger> theTriggers = new FCollection<Trigger>();
        for (Card c : game.getCardsIn(ZoneType.Battlefield)) {
            theTriggers.addAll(c.getTriggers());
        }
        for (Trigger trigger : theTriggers) {
            SpellAbility trigSa;
            Card source = trigger.getHostCard();
            if (trigger.getMode() != TriggerType.SpellCast || !trigger.zonesCheck(game.getZoneOf(source)) || !trigger.requirementsCheck(game) || trigger.hasParam("ValidCard") && !card.isValid(trigger.getParam("ValidCard").split(","), source.getController(), source, (CardTraitBase)sa) || trigger.hasParam("ValidActivatingPlayer") && !player.isValid(trigger.getParam("ValidActivatingPlayer"), source.getController(), source, (CardTraitBase)sa) || (trigSa = trigger.ensureAbility()) == null) continue;
            if (trigSa.getApi() == ApiType.DealDamage) {
                if (!"TriggeredActivator".equals(trigSa.getParam("Defined")) || !trigSa.hasParam("NumDmg")) continue;
                damage += ComputerUtilCombat.predictDamageTo(player, AbilityUtils.calculateAmount(source, trigSa.getParam("NumDmg"), trigSa), source, false);
                continue;
            }
            if (trigSa.getApi() != ApiType.LoseLife || !"TriggeredActivator".equals(trigSa.getParam("Defined")) || !trigSa.hasParam("LifeAmount")) continue;
            damage += AbilityUtils.calculateAmount(source, trigSa.getParam("LifeAmount"), trigSa);
        }
        return damage;
    }

    public static int getDamageFromETB(Player player, Card permanent) {
        int damage = 0;
        Game game = player.getGame();
        FCollection<Trigger> theTriggers = new FCollection<Trigger>();
        for (Card card : game.getCardsIn(ZoneType.Battlefield)) {
            theTriggers.addAll(card.getTriggers());
        }
        for (Trigger trigger : theTriggers) {
            SpellAbility trigSa;
            Card source = trigger.getHostCard();
            if (trigger.getMode() != TriggerType.ChangesZone || !"Battlefield".equals(trigger.getParam("Destination")) || !trigger.zonesCheck(game.getZoneOf(source)) || !trigger.requirementsCheck(game) || trigger.hasParam("CheckOnTriggeredCard") && AbilityUtils.getDefinedCards(permanent, source.getSVar(trigger.getParam("CheckOnTriggeredCard").split(" ")[0]), null).isEmpty() || trigger.hasParam("ValidCard") && !permanent.isValid(trigger.getParam("ValidCard"), source.getController(), source, null) || (trigSa = trigger.ensureAbility()) == null) continue;
            if (trigSa.getApi() == ApiType.DealDamage) {
                if (!"TriggeredCardController".equals(trigSa.getParam("Defined")) || !trigSa.hasParam("NumDmg")) continue;
                damage += ComputerUtilCombat.predictDamageTo(player, AbilityUtils.calculateAmount(source, trigSa.getParam("NumDmg"), trigSa), source, false);
                continue;
            }
            if (trigSa.getApi() != ApiType.LoseLife || !"TriggeredCardController".equals(trigSa.getParam("Defined")) || !trigSa.hasParam("LifeAmount")) continue;
            damage += AbilityUtils.calculateAmount(source, trigSa.getParam("LifeAmount"), trigSa);
        }
        return damage;
    }

    public static boolean isNegativeCounter(CounterType type, Card c) {
        return type.is(CounterEnumType.AGE) || type.is(CounterEnumType.BRIBERY) || type.is(CounterEnumType.DOOM) || type.is(CounterEnumType.M1M1) || type.is(CounterEnumType.M0M2) || type.is(CounterEnumType.M0M1) || type.is(CounterEnumType.M1M0) || type.is(CounterEnumType.M2M1) || type.is(CounterEnumType.M2M2) || type.is(CounterEnumType.BLAZE) && c.isLand() || type.is(CounterEnumType.ICE) && !"Iceberg".equals(c.getName()) || type.is(CounterEnumType.DEPLETION) && c.hasKeyword("CARDNAME doesn't untap during your untap step.") || type.is(CounterEnumType.TIME) && (!c.isInPlay() || "Chronozoa".equals(c.getName())) || type.is(CounterEnumType.GOLD) || type.is(CounterEnumType.MUSIC) || type.is(CounterEnumType.PUPA) || type.is(CounterEnumType.PARALYZATION) || type.is(CounterEnumType.SHELL) || type.is(CounterEnumType.SLEEP) || type.is(CounterEnumType.SLUMBER) || type.is(CounterEnumType.SLEIGHT) || type.is(CounterEnumType.WAGE) || type.is(CounterEnumType.INCARNATION) || type.is(CounterEnumType.RUST) || type.is(CounterEnumType.STUN) || type.is(CounterEnumType.FINALITY);
    }

    public static boolean isUselessCounter(CounterType type, Card c) {
        if (type.is(CounterEnumType.QUEST)) {
            int e = 0;
            if (c.hasSVar("MaxQuestEffect")) {
                e = Integer.parseInt(c.getSVar("MaxQuestEffect"));
            }
            return c.getCounters(type) > e;
        }
        if (type.isKeywordCounter() && c.hasKeyword(type.toString())) {
            return true;
        }
        return type.is(CounterEnumType.AWAKENING) || type.is(CounterEnumType.MANIFESTATION) || type.is(CounterEnumType.PETRIFICATION) || type.is(CounterEnumType.TRAINING) || type.is(CounterEnumType.GHOSTFORM);
    }

    public static Player evaluateBoardPosition(List<Player> listToEvaluate) {
        Player bestBoardPosition = listToEvaluate.get(0);
        int bestBoardRating = 0;
        for (Player p : listToEvaluate) {
            int pRating = p.getLife() * 3;
            pRating += p.getLandsInPlay().size() * 2;
            for (Card c : p.getCardsIn(ZoneType.Battlefield)) {
                pRating += ComputerUtilCard.evaluateCreature(c) / 3;
            }
            if (p.getCardsIn(ZoneType.Library).size() < 3) {
                pRating /= 5;
            }
            if (pRating <= bestBoardRating) continue;
            bestBoardRating = pRating;
            bestBoardPosition = p;
        }
        return bestBoardPosition;
    }

    public static boolean hasReasonToPlayCardThisTurn(Player ai, Card c) {
        if (ai == null || c == null) {
            return false;
        }
        if (!(ai.getController() instanceof PlayerControllerAi)) {
            System.err.println("Unexpected behavior: ComputerUtil::getReasonToPlayCard called with the non-AI player as a parameter.");
            return false;
        }
        for (SpellAbility sa : c.getAllPossibleAbilities(ai, true)) {
            if (sa.getApi() == ApiType.Counter) {
                return true;
            }
            AiPlayDecision decision = ((PlayerControllerAi)ai.getController()).getAi().canPlaySa(sa);
            if (decision != AiPlayDecision.WillPlay && decision != AiPlayDecision.WaitForMain2) continue;
            return true;
        }
        return false;
    }

    public static boolean lifegainPositive(Player player, Card source) {
        if (!player.canGainLife()) {
            return false;
        }
        Map<AbilityKey, Object> repParams = AbilityKey.mapFromAffected(player);
        repParams.put(AbilityKey.LifeGained, 1);
        repParams.put(AbilityKey.Source, source);
        List<ReplacementEffect> list = player.getGame().getReplacementHandler().getReplacementList(ReplacementType.GainLife, repParams, ReplacementLayer.Other);
        if (Iterables.any(list, CardTraitPredicates.hasParam("AILogic", "NoLife"))) {
            return false;
        }
        if (Iterables.any(list, CardTraitPredicates.hasParam("AILogic", "LoseLife"))) {
            return false;
        }
        return !Iterables.any(list, CardTraitPredicates.hasParam("AILogic", "LichDraw"));
    }

    public static boolean lifegainNegative(Player player, Card source) {
        return ComputerUtil.lifegainNegative(player, source, 1);
    }

    public static boolean lifegainNegative(Player player, Card source, int n) {
        if (!player.canGainLife()) {
            return false;
        }
        Map<AbilityKey, Object> repParams = AbilityKey.mapFromAffected(player);
        repParams.put(AbilityKey.LifeGained, n);
        repParams.put(AbilityKey.Source, source);
        List<ReplacementEffect> list = player.getGame().getReplacementHandler().getReplacementList(ReplacementType.GainLife, repParams, ReplacementLayer.Other);
        if (Iterables.any(list, CardTraitPredicates.hasParam("AILogic", "NoLife"))) {
            return false;
        }
        if (Iterables.any(list, CardTraitPredicates.hasParam("AILogic", "LoseLife"))) {
            return player.canLoseLife();
        }
        if (Iterables.any(list, CardTraitPredicates.hasParam("AILogic", "LichDraw"))) {
            return player.getCardsIn(ZoneType.Library).size() <= n;
        }
        return false;
    }

    public static boolean targetPlayableSpellCard(Player ai, Iterable<Card> options, SpellAbility sa, boolean withoutPayingManaCost, boolean mandatory) {
        AiController aic = ((PlayerControllerAi)ai.getController()).getAi();
        sa.resetTargets();
        CardCollection targets = new CardCollection();
        for (Card c : options) {
            if (withoutPayingManaCost && c.getManaCost() != null && c.getManaCost().countX() > 0) continue;
            for (SpellAbility ab : c.getSpellAbilities()) {
                if (ab.getApi() == null || ab.getApi() == ApiType.Mana && "ManaRitual".equals(ab.getParam("AILogic"))) continue;
                SpellAbility abTest = withoutPayingManaCost ? ab.copyWithNoManaCost() : ab.copy();
                abTest.setActivatingPlayer(ai, true);
                abTest.getRestrictions().setZone(c.getZone().getZoneType());
                if (AiPlayDecision.WillPlay != aic.canPlaySa(abTest) || !ComputerUtilCost.canPayCost(abTest, ai, false)) continue;
                targets.add(c);
            }
        }
        if (targets.isEmpty()) {
            if (mandatory && !Iterables.isEmpty(options)) {
                targets.addAll(options);
            } else {
                return false;
            }
        }
        sa.getTargets().add(ComputerUtilCard.getBestAI(targets));
        return true;
    }

    public static int countUsefulCreatures(Player p) {
        CardCollection creats = p.getCreaturesInPlay();
        int count = 0;
        for (Card c : creats) {
            if (ComputerUtilCard.isUselessCreature(p, c)) continue;
            ++count;
        }
        return count;
    }

    public static boolean isPlayingReanimator(Player ai) {
        CardCollectionView inHand = ai.getCardsIn(ZoneType.Hand);
        CardCollectionView inDeck = ai.getCardsIn(ZoneType.Library);
        Predicate markedAsReanimator = card -> "true".equalsIgnoreCase(card.getSVar("IsReanimatorCard"));
        int numInHand = CardLists.count(inHand, markedAsReanimator);
        int numInDeck = CardLists.count(inDeck, markedAsReanimator);
        return numInHand > 0 || numInDeck >= 3;
    }

    public static CardCollection filterAITgts(SpellAbility sa, Player ai, CardCollection srcList, boolean alwaysStrict) {
        Card source = sa.getHostCard();
        if (source == null) {
            return srcList;
        }
        if (sa.hasParam("AITgts")) {
            CardCollection list;
            String aiTgts = sa.getParam("AITgts");
            if (aiTgts.startsWith("BetterThan")) {
                int value = 0;
                if (aiTgts.endsWith("Source")) {
                    value = ComputerUtilCard.evaluateCreature(source);
                    if (source.isEnchanted()) {
                        for (Card enc : source.getEnchantedBy()) {
                            if (!enc.getController().equals(ai)) continue;
                            value += 100;
                        }
                    }
                } else if (aiTgts.contains("EvalRating.")) {
                    value = AbilityUtils.calculateAmount(source, aiTgts.substring(aiTgts.indexOf(".") + 1), sa);
                } else {
                    System.err.println("Warning: Unspecified AI target evaluation rating for SA " + sa);
                    value = ComputerUtilCard.evaluateCreature(source);
                }
                int totalValue = value;
                list = CardLists.filter((Iterable<Card>)srcList, c -> ComputerUtilCard.evaluateCreature(c) > totalValue + 30);
            } else {
                list = CardLists.getValidCards((Iterable<Card>)srcList, sa.getParam("AITgts"), sa.getActivatingPlayer(), source, (CardTraitBase)sa);
            }
            if (!list.isEmpty() || sa.hasParam("AITgtsStrict") || alwaysStrict) {
                return list;
            }
            return srcList;
        }
        return srcList;
    }

    public static boolean aiLifeInDanger(Player ai, boolean serious, int payment) {
        return ComputerUtil.predictNextCombatsRemainingLife(ai, serious, false, payment, null) == Integer.MIN_VALUE;
    }

    public static int predictNextCombatsRemainingLife(Player ai, boolean serious, boolean checkDiff, int payment, CardCollection excludedBlockers) {
        int remainingLife = Integer.MAX_VALUE;
        if (ai.cantLoseForZeroOrLessLife()) {
            return remainingLife;
        }
        for (Player opp : ai.getOpponents()) {
            Combat combat = new Combat(opp);
            boolean containsAttacker = false;
            boolean thisCombat = ai.getGame().getPhaseHandler().isPlayerTurn(opp) && ai.getGame().getPhaseHandler().getPhase().isBefore(PhaseType.COMBAT_BEGIN);
            for (Card att : opp.getCreaturesInPlay()) {
                if ((!thisCombat || !CombatUtil.canAttack(att, ai)) && (thisCombat || !ComputerUtilCombat.canAttackNextTurn(att, ai))) continue;
                combat.addAttacker(att, ai);
                containsAttacker = true;
            }
            if (!containsAttacker) continue;
            AiBlockController block = new AiBlockController(ai, false);
            block.assignBlockersForCombat(combat, excludedBlockers);
            if (serious && ComputerUtilCombat.lifeInSeriousDanger(ai, combat, payment)) {
                return Integer.MIN_VALUE;
            }
            if (!serious && ComputerUtilCombat.lifeInDanger(ai, combat, payment)) {
                return Integer.MIN_VALUE;
            }
            if (!checkDiff || ai.cantLoseForZeroOrLessLife()) continue;
            remainingLife = Math.min(ComputerUtilCombat.lifeThatWouldRemain(ai, combat), remainingLife);
        }
        return remainingLife;
    }

    public static boolean isETBprevented(Card c) {
        Map<AbilityKey, Object> repParams = AbilityKey.mapFromAffected(c);
        repParams.put(AbilityKey.CardLKI, c);
        repParams.put(AbilityKey.Origin, (Object)c.getLastKnownZone().getZoneType());
        repParams.put(AbilityKey.Destination, (Object)ZoneType.Battlefield);
        GameEntityCounterTable table = new GameEntityCounterTable();
        repParams.put(AbilityKey.EffectOnly, true);
        repParams.put(AbilityKey.CounterTable, table);
        repParams.put(AbilityKey.CounterMap, table.column(c));
        return c.getGame().getReplacementHandler().cantHappenCheck(ReplacementType.Moved, repParams);
    }

    public static boolean shouldSacrificeThreatenedCard(Player ai, Card c, SpellAbility sa) {
        if (!ai.getController().isAI()) {
            return false;
        }
        if (sa != null && sa.getApi() == ApiType.Regenerate && sa.getHostCard().equals(c)) {
            return false;
        }
        ComputerUtilCost.setSuppressRecursiveSacCostCheck(true);
        Game game = ai.getGame();
        Combat combat = game.getCombat();
        boolean isThreatened = c.isCreature() && ComputerUtil.predictCreatureWillDieThisTurn(ai, c, sa, false) && !ComputerUtilCombat.willOpposingCreatureDieInCombat(ai, c, combat) && !ComputerUtilCombat.isDangerousToSacInCombat(ai, c, combat) || !c.isCreature() && ComputerUtil.predictThreatenedObjects(ai, sa).contains(c);
        ComputerUtilCost.setSuppressRecursiveSacCostCheck(false);
        return isThreatened;
    }

    private static /* synthetic */ boolean lambda$getCardPreference$1(int maxCreatureEval, boolean allowTokens, int minCMC, int maxCMC, List dontSac, Card card) {
        if (card.isCreature() && ComputerUtilCard.evaluateCreature(card) > maxCreatureEval) {
            return false;
        }
        return allowTokens && card.isToken() || card.getCMC() >= minCMC && card.getCMC() <= maxCMC && !dontSac.contains(card.getName());
    }
}

