/*
 * Decompiled with CFR 0.152.
 */
package forge.adventure.world;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.graphics.glutils.FrameBuffer;
import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.utils.Disposable;
import forge.Forge;
import forge.Graphics;
import forge.adventure.scene.Scene;
import forge.adventure.util.Config;
import forge.adventure.util.Serializer;
import forge.util.BlurUtils;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Date;

public class WorldSaveHeader
implements Serializable,
Disposable {
    public static int previewImageWidth = 512;
    public Pixmap preview;
    public String name;
    public Date saveDate;

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeUTF(this.name);
        if (this.preview == null) {
            this.preview = new Pixmap(1, 1, Pixmap.Format.RGBA8888);
        }
        Serializer.WritePixmap(out, this.preview, true);
        out.writeObject(this.saveDate);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.name = in.readUTF();
        if (this.preview != null) {
            this.preview.dispose();
        }
        this.preview = Serializer.ReadPixmap(in);
        this.saveDate = (Date)in.readObject();
    }

    @Override
    public void dispose() {
        this.preview.dispose();
    }

    public void createPreview() {
        TextureRegion tr = Forge.takeScreenshot();
        Matrix4 m4 = new Matrix4();
        Graphics g2 = new Graphics();
        FrameBuffer frameBuffer = new FrameBuffer(Pixmap.Format.RGBA8888, Gdx.graphics.getWidth(), Gdx.graphics.getHeight(), false);
        frameBuffer.begin();
        m4.setToOrtho2D(0.0f, 0.0f, Gdx.graphics.getWidth(), Gdx.graphics.getHeight());
        g2.begin(Gdx.graphics.getWidth(), Gdx.graphics.getHeight());
        g2.setProjectionMatrix(m4);
        g2.startClip();
        g2.drawImage(tr, 0.0f, 0.0f, (float)Gdx.graphics.getWidth(), (float)Gdx.graphics.getHeight());
        g2.end();
        g2.endClip();
        Pixmap pixmap = Pixmap.createFromFrameBuffer(0, 0, Gdx.graphics.getWidth(), Gdx.graphics.getHeight());
        if (Forge.lastPreview != null) {
            Forge.lastPreview.dispose();
        }
        Pixmap blurred = BlurUtils.blur(pixmap, 4, 2, false, Config.instance().getBlurDivisor());
        Forge.lastPreview = new Texture(blurred);
        Pixmap scaled = new Pixmap(previewImageWidth, (int)((float)previewImageWidth / ((float)Scene.getIntendedWidth() / (float)Scene.getIntendedHeight())), Pixmap.Format.RGBA8888);
        scaled.drawPixmap(pixmap, 0, 0, pixmap.getWidth(), pixmap.getHeight(), 0, 0, scaled.getWidth(), scaled.getHeight());
        pixmap.dispose();
        blurred.dispose();
        if (this.preview != null) {
            this.preview.dispose();
        }
        this.preview = scaled;
        frameBuffer.end();
        g2.dispose();
        frameBuffer.dispose();
    }
}

