/*
 * Decompiled with CFR 0.152.
 */
package forge.adventure.world;

import forge.adventure.data.DifficultyData;
import forge.adventure.player.AdventurePlayer;
import forge.adventure.pointofintrest.PointOfInterestChanges;
import forge.adventure.scene.SaveLoadScene;
import forge.adventure.stage.WorldStage;
import forge.adventure.util.AdventureModes;
import forge.adventure.util.Config;
import forge.adventure.util.SaveFileData;
import forge.adventure.util.SignalList;
import forge.adventure.world.World;
import forge.adventure.world.WorldSaveHeader;
import forge.card.CardEdition;
import forge.card.ColorSet;
import forge.deck.Deck;
import forge.localinstance.properties.ForgeConstants;
import forge.player.GamePlayerUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Date;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;

public class WorldSave {
    public static final int AUTO_SAVE_SLOT = -1;
    public static final int QUICK_SAVE_SLOT = -2;
    public static final int INVALID_SAVE_SLOT = -3;
    static final WorldSave currentSave = new WorldSave();
    public WorldSaveHeader header = new WorldSaveHeader();
    private final AdventurePlayer player = new AdventurePlayer();
    private final World world = new World();
    private final PointOfInterestChanges.Map pointOfInterestChanges = new PointOfInterestChanges.Map();
    private final SignalList onLoadList = new SignalList();

    public final World getWorld() {
        return this.world;
    }

    public AdventurePlayer getPlayer() {
        return this.player;
    }

    public void onLoad(Runnable run) {
        this.onLoadList.add(run);
    }

    public PointOfInterestChanges getPointOfInterestChanges(String id) {
        if (!this.pointOfInterestChanges.containsKey(id)) {
            this.pointOfInterestChanges.put(id, new PointOfInterestChanges());
        }
        return (PointOfInterestChanges)this.pointOfInterestChanges.get(id);
    }

    public static boolean load(int currentSlot) {
        String fileName = WorldSave.getSaveFile(currentSlot);
        if (!new File(fileName).exists()) {
            return false;
        }
        new File(WorldSave.getSaveDir()).mkdirs();
        try (FileInputStream fos = new FileInputStream(fileName);
             InflaterInputStream inf = new InflaterInputStream(fos);
             ObjectInputStream oos = new ObjectInputStream(inf);){
            WorldSave.currentSave.header = (WorldSaveHeader)oos.readObject();
            SaveFileData mainData = (SaveFileData)oos.readObject();
            WorldSave.currentSave.player.load(mainData.readSubData("player"));
            GamePlayerUtil.getGuiPlayer().setName(WorldSave.currentSave.player.getName());
            try {
                WorldSave.currentSave.world.load(mainData.readSubData("world"));
                WorldSave.currentSave.pointOfInterestChanges.load(mainData.readSubData("pointOfInterestChanges"));
                WorldStage.getInstance().load(mainData.readSubData("worldStage"));
            }
            catch (Exception e) {
                System.err.println("Generating New World");
                WorldSave.currentSave.world.generateNew(0L);
            }
            WorldSave.currentSave.onLoadList.emit();
        }
        catch (IOException | ClassNotFoundException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public static boolean isSafeFile(String name) {
        return WorldSave.filenameToSlot(name) != -3;
    }

    public static int filenameToSlot(String name) {
        if (name.equals("auto_save.sav")) {
            return -1;
        }
        if (name.equals("quick_save.sav")) {
            return -2;
        }
        if (!name.contains("_") || !name.endsWith(".sav")) {
            return -3;
        }
        return Integer.parseInt(name.split("_")[0]);
    }

    public static String filename(int slot) {
        if (slot == -1) {
            return "auto_save.sav";
        }
        if (slot == -2) {
            return "quick_save.sav";
        }
        return slot + "_save_slot.sav";
    }

    public static String getSaveDir() {
        return ForgeConstants.USER_ADVENTURE_DIR + Config.instance().getPlane();
    }

    public static String getSaveFile(int slot) {
        return ForgeConstants.USER_ADVENTURE_DIR + Config.instance().getPlane() + File.separator + WorldSave.filename(slot);
    }

    public static WorldSave getCurrentSave() {
        return currentSave;
    }

    public static WorldSave generateNewWorld(String name, boolean male, int race, int avatarIndex, ColorSet startingColorIdentity, DifficultyData diff, AdventureModes mode, int customDeckIndex, CardEdition starterEdition, long seed) {
        WorldSave.currentSave.world.generateNew(seed);
        WorldSave.currentSave.pointOfInterestChanges.clear();
        boolean chaos = mode == AdventureModes.Chaos;
        boolean custom = mode == AdventureModes.Custom;
        Deck starterDeck = Config.instance().starterDeck(startingColorIdentity, diff, mode, customDeckIndex, starterEdition);
        WorldSave.currentSave.player.create(name, starterDeck, male, race, avatarIndex, chaos, custom, diff);
        WorldSave.currentSave.player.setWorldPosY((int)(WorldSave.currentSave.world.getData().playerStartPosY * (float)WorldSave.currentSave.world.getData().height * (float)WorldSave.currentSave.world.getTileSize()));
        WorldSave.currentSave.player.setWorldPosX((int)(WorldSave.currentSave.world.getData().playerStartPosX * (float)WorldSave.currentSave.world.getData().width * (float)WorldSave.currentSave.world.getTileSize()));
        WorldSave.currentSave.onLoadList.emit();
        return currentSave;
    }

    public boolean autoSave() {
        return this.save("auto save" + SaveLoadScene.instance().getSaveFileSuffix(), -1);
    }

    public boolean quickSave() {
        return this.save("quick save" + SaveLoadScene.instance().getSaveFileSuffix(), -2);
    }

    public boolean quickLoad() {
        return WorldSave.load(-2);
    }

    public boolean save(String text, int currentSlot) {
        this.header.name = text;
        String fileName = WorldSave.getSaveFile(currentSlot);
        new File(WorldSave.getSaveDir()).mkdirs();
        try (FileOutputStream fos = new FileOutputStream(fileName);
             DeflaterOutputStream def = new DeflaterOutputStream(fos);
             ObjectOutputStream oos = new ObjectOutputStream(def);){
            this.header.saveDate = new Date();
            oos.writeObject(this.header);
            SaveFileData mainData = new SaveFileData();
            mainData.store("player", WorldSave.currentSave.player.save());
            mainData.store("world", WorldSave.currentSave.world.save());
            mainData.store("worldStage", WorldStage.getInstance().save());
            mainData.store("pointOfInterestChanges", WorldSave.currentSave.pointOfInterestChanges.save());
            oos.writeObject(mainData);
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        Config.instance().getSettingData().lastActiveSave = WorldSave.filename(currentSlot);
        Config.instance().saveSettings();
        return true;
    }

    public void clearChanges() {
        this.pointOfInterestChanges.clear();
    }
}

