/*
 * Decompiled with CFR 0.152.
 */
package forge.adventure.world;

import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.TextureData;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Disposable;
import com.badlogic.gdx.utils.Json;
import forge.Forge;
import forge.adventure.data.BiomeData;
import forge.adventure.data.BiomeSpriteData;
import forge.adventure.data.BiomeStructureData;
import forge.adventure.data.BiomeTerrainData;
import forge.adventure.data.PointOfInterestData;
import forge.adventure.data.WorldData;
import forge.adventure.pointofintrest.PointOfInterest;
import forge.adventure.pointofintrest.PointOfInterestMap;
import forge.adventure.scene.Scene;
import forge.adventure.stage.WorldStage;
import forge.adventure.util.Config;
import forge.adventure.util.SaveFileContent;
import forge.adventure.util.SaveFileData;
import forge.adventure.world.BiomeStructure;
import forge.adventure.world.BiomeTexture;
import forge.adventure.world.OpenSimplexNoise;
import forge.adventure.world.SpritesDataMap;
import forge.gui.GuiBase;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.apache.commons.lang3.tuple.Pair;

public class World
implements Disposable,
SaveFileContent {
    private WorldData data;
    private Pixmap biomeImage;
    private long[][] biomeMap;
    public int[][] terrainMap;
    private static final int collisionBit = Integer.MIN_VALUE;
    private static final int isStructureBit = 0x40000000;
    private static final int terrainMask = -1073741824;
    private int width;
    private int height;
    private SpritesDataMap mapObjectIds;
    private PointOfInterestMap mapPoiIds;
    private BiomeTexture[] biomeTexture;
    private long seed;
    private final Random random = new Random();
    private boolean worldDataLoaded = false;
    private Texture globalTexture = null;
    HashMap<String, Pair<Pixmap, HashMap<String, Pixmap>>> pixmapHash = new HashMap();
    final Array<DrawInfo> storedInfo = new Array();

    public Random getRandom() {
        return this.random;
    }

    public static int highestBiome(long biome) {
        return (int)(Math.log(Long.highestOneBit(biome)) / Math.log(2.0));
    }

    public boolean collidingTile(Rectangle boundingRect) {
        int xLeft = (int)boundingRect.getX() / this.getTileSize();
        int yTop = (int)boundingRect.getY() / this.getTileSize();
        int xRight = (int)((boundingRect.getX() + boundingRect.getWidth()) / (float)this.getTileSize());
        int yBottom = (int)((boundingRect.getY() + boundingRect.getHeight()) / (float)this.getTileSize());
        if (this.isColliding(xLeft, yTop)) {
            return true;
        }
        if (this.isColliding(xLeft, yBottom)) {
            return true;
        }
        if (this.isColliding(xRight, yBottom)) {
            return true;
        }
        return this.isColliding(xRight, yTop);
    }

    public void loadWorldData() {
        if (this.worldDataLoaded) {
            return;
        }
        FileHandle handle = Config.instance().getFile("world/world.json");
        String rawJson = handle.readString();
        this.data = new Json().fromJson(WorldData.class, rawJson);
        this.biomeTexture = new BiomeTexture[this.data.GetBiomes().size() + 1];
        int biomeIndex = 0;
        for (BiomeData biome : this.data.GetBiomes()) {
            this.biomeTexture[biomeIndex] = new BiomeTexture(biome, this.data.tileSize);
            ++biomeIndex;
        }
        this.biomeTexture[biomeIndex] = new BiomeTexture(this.data.roadTileset, this.data.tileSize);
        this.worldDataLoaded = true;
    }

    @Override
    public void load(SaveFileData saveFileData) {
        if (this.biomeImage != null) {
            this.biomeImage.dispose();
        }
        this.loadWorldData();
        this.biomeImage = saveFileData.readPixmap("biomeImage");
        this.biomeMap = (long[][])saveFileData.readObject("biomeMap");
        this.terrainMap = (int[][])saveFileData.readObject("terrainMap");
        this.width = saveFileData.readInt("width");
        this.height = saveFileData.readInt("height");
        this.mapObjectIds = new SpritesDataMap(this.getChunkSize(), this.data.tileSize, this.data.width / this.getChunkSize());
        this.mapObjectIds.load(saveFileData.readSubData("mapObjectIds"));
        this.mapPoiIds = new PointOfInterestMap(this.getChunkSize(), this.data.tileSize, this.data.width / this.getChunkSize(), this.data.height / this.getChunkSize());
        this.mapPoiIds.load(saveFileData.readSubData("mapPoiIds"));
        this.seed = saveFileData.readLong("seed");
    }

    @Override
    public SaveFileData save() {
        SaveFileData data = new SaveFileData();
        data.store("biomeImage", this.biomeImage);
        data.storeObject("biomeMap", this.biomeMap);
        data.storeObject("terrainMap", this.terrainMap);
        data.store("width", this.width);
        data.store("height", this.height);
        data.store("mapObjectIds", this.mapObjectIds.save());
        data.store("mapPoiIds", this.mapPoiIds.save());
        data.store("seed", this.seed);
        return data;
    }

    public BiomeSpriteData getObject(int id) {
        return this.mapObjectIds.get(id);
    }

    public Pixmap getBiomeSprite(int x, int y) {
        if (x < 0 || y <= 0 || x >= this.width || y > this.height) {
            return new Pixmap(this.data.tileSize, this.data.tileSize, Pixmap.Format.RGBA8888);
        }
        long biomeIndex = this.getBiome(x, y);
        int biomeTerrain = this.getTerrainIndex(x, y);
        Pixmap drawingPixmap = new Pixmap(this.data.tileSize, this.data.tileSize, Pixmap.Format.RGBA8888);
        ArrayList<DrawingInformation> information = new ArrayList<DrawingInformation>();
        for (int i = 0; i < this.biomeTexture.length; ++i) {
            if ((biomeIndex & 1L << i) == 0L) continue;
            BiomeTexture regions = this.biomeTexture[i];
            if (x <= 0 || y <= 1 || x >= this.width - 1 || y >= this.height) {
                return regions.getPixmap(biomeTerrain);
            }
            int neighbors = 0;
            int bitIndex = 8;
            for (int ny = 1; ny > -2; --ny) {
                for (int nx = -1; nx < 2; ++nx) {
                    long otherBiome = this.getBiome(x + nx, y + ny);
                    int otherTerrain = this.getTerrainIndex(x + nx, y + ny);
                    if ((otherBiome & 1L << i) != 0L && biomeTerrain == otherTerrain | biomeTerrain == 0) {
                        neighbors |= 1 << bitIndex;
                    }
                    --bitIndex;
                }
            }
            if (biomeTerrain != 0 && neighbors != 511) {
                bitIndex = 8;
                int baseNeighbors = 0;
                for (int ny = 1; ny > -2; --ny) {
                    for (int nx = -1; nx < 2; ++nx) {
                        if ((this.getBiome(x + nx, y + ny) & 1L << i) != 0L) {
                            baseNeighbors |= 1 << bitIndex;
                        }
                        --bitIndex;
                    }
                }
                information.add(new DrawingInformation(baseNeighbors, regions, 0));
            }
            information.add(new DrawingInformation(neighbors, regions, biomeTerrain));
        }
        int lastFullNeighbour = -1;
        int counter = 0;
        for (DrawingInformation info : information) {
            if (info.neighbors == 511) {
                lastFullNeighbour = counter;
            }
            ++counter;
        }
        counter = 0;
        if (lastFullNeighbour < 0 && information.size() != 0) {
            ((DrawingInformation)information.get(0)).neighbors = 511;
        }
        for (DrawingInformation info : information) {
            if (counter < lastFullNeighbour) {
                ++counter;
                continue;
            }
            info.draw(drawingPixmap);
        }
        return drawingPixmap;
    }

    public int getTerrainIndex(int x, int y) {
        try {
            return this.terrainMap[x][this.height - y - 1] & 0x3FFFFFFF;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return 0;
        }
    }

    public long getBiomeMapXY(int x, int y) {
        try {
            return this.biomeMap[x][this.height - y - 1] & (long)(~(1 << this.data.GetBiomes().size()));
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return this.biomeMap[this.biomeMap.length - 1][this.biomeMap[this.biomeMap.length - 1].length - 1];
        }
    }

    public boolean isStructure(int x, int y) {
        try {
            return (this.terrainMap[x][this.height - y - 1] & 0xBFFFFFFF) != 0;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return false;
        }
    }

    public long getBiome(int x, int y) {
        try {
            return this.biomeMap[x][this.height - y - 1];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return this.biomeMap[this.biomeMap.length - 1][this.biomeMap[this.biomeMap.length - 1].length - 1];
        }
    }

    public boolean isColliding(int x, int y) {
        try {
            return (this.terrainMap[x][this.height - y - 1] & Integer.MIN_VALUE) != 0;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return true;
        }
    }

    public WorldData getData() {
        return this.data;
    }

    private void clearTerrain(int x, int y, int size) {
        for (int xclear = -size; xclear < size; ++xclear) {
            for (int yclear = -size; yclear < size; ++yclear) {
                try {
                    this.terrainMap[x + xclear][this.height - 1 - (y + yclear)] = 0;
                    continue;
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    // empty catch block
                }
            }
        }
    }

    private long measureGenerationTime(String msg, long lastTime) {
        long currentTime = System.currentTimeMillis();
        System.out.println(msg + " :\t\t" + (float)(currentTime - lastTime) / 1000.0f + " s");
        return currentTime;
    }

    /*
     * WARNING - void declaration
     */
    public World generateNew(long seed) {
        void var21_64;
        void var21_59;
        if (GuiBase.isAndroid()) {
            GuiBase.getInterface().preventSystemSleep(true);
        }
        long[] currentTime = new long[]{System.currentTimeMillis()};
        long startTime = System.currentTimeMillis();
        this.loadWorldData();
        if (seed == 0L) {
            seed = this.random.nextLong();
        }
        this.seed = seed;
        this.random.setSeed(seed);
        OpenSimplexNoise noise = new OpenSimplexNoise(seed);
        float noiseZoom = this.data.noiseZoomBiome;
        this.width = this.data.width;
        this.height = this.data.height;
        this.biomeMap = new long[this.width][this.height];
        this.terrainMap = new int[this.width][this.height];
        for (int x = 0; x < this.width; ++x) {
            for (int y = 0; y < this.height; ++y) {
                this.biomeMap[x][y] = 0L;
                this.terrainMap[x][y] = 0;
            }
        }
        int[] biomeIndex = new int[]{-1};
        currentTime[0] = this.measureGenerationTime("loading data", currentTime[0]);
        HashMap<BiomeStructureData, BiomeStructure> structureDataMap = new HashMap<BiomeStructureData, BiomeStructure>();
        for (BiomeData biome : this.data.GetBiomes()) {
            if (biome.structures == null) continue;
            int biomeWidth = (int)Math.round((double)biome.width * (double)this.width);
            int biomeHeight = (int)Math.round((double)biome.height * (double)this.height);
            for (BiomeStructureData data : biome.structures) {
                long localSeed = seed;
                long threadStartTime = System.currentTimeMillis();
                BiomeStructure structure = new BiomeStructure(data, localSeed, biomeWidth, biomeHeight);
                structure.initialize();
                structureDataMap.put(data, structure);
                this.measureGenerationTime("wavefunctioncollapse " + data.sourcePath, threadStartTime);
            }
        }
        for (BiomeData biome : this.data.GetBiomes()) {
            biomeIndex[0] = biomeIndex[0] + 1;
            int biomeXStart = (int)Math.round((double)biome.startPointX * (double)this.width);
            int biomeYStart = (int)Math.round((double)biome.startPointY * (double)this.height);
            int biomeWidth = (int)Math.round((double)biome.width * (double)this.width);
            int biomeHeight = (int)Math.round((double)biome.height * (double)this.height);
            int beginX = Math.max(biomeXStart - biomeWidth / 2, 0);
            int beginY = Math.max(biomeYStart - biomeHeight / 2, 0);
            int endX = Math.min(biomeXStart + biomeWidth / 2, this.width);
            int endY = Math.min(biomeYStart + biomeHeight / 2, this.height);
            if ((double)biome.width == 1.0 && (double)biome.height == 1.0) {
                beginX = 0;
                beginY = 0;
                endX = this.width;
                endY = this.height;
            }
            for (int x = beginX; x < endX; ++x) {
                for (int i = beginY; i < endY; ++i) {
                    float noiseValue = ((float)noise.eval((float)x / (float)this.width * noiseZoom, (float)i / (float)this.height * noiseZoom) + 1.0f) / 2.0f;
                    float distanceValue = (float)Math.sqrt((x - biomeXStart) * (x - biomeXStart) + (i - biomeYStart) * (i - biomeYStart)) / ((float)Math.max(biomeWidth, biomeHeight) / 2.0f);
                    if (!((double)((noiseValue *= biome.noiseWeight) + (distanceValue *= biome.distWeight)) < 1.0) && (!biome.invertHeight || !((double)(1.0f - noiseValue + distanceValue) < 1.0))) continue;
                    Color color = biome.GetColor();
                    float[] hsv = new float[3];
                    color.toHsv(hsv);
                    int count = (int)(((double)noiseValue - 0.5) * 10.0 / 4.0);
                    long[] lArray = this.biomeMap[x];
                    int n = i;
                    lArray[n] = lArray[n] | 1L << biomeIndex[0];
                    int terrainCounter = 1;
                    this.terrainMap[x][i] = 0;
                    if (biome.terrain != null) {
                        for (BiomeTerrainData terrain : biome.terrain) {
                            float terrainNoise = ((float)noise.eval((float)x / (float)this.width * (noiseZoom * terrain.resolution), (float)i / (float)this.height * (noiseZoom * terrain.resolution)) + 1.0f) / 2.0f;
                            if (terrainNoise >= terrain.min && terrainNoise <= terrain.max) {
                                this.terrainMap[x][i] = terrainCounter;
                            }
                            ++terrainCounter;
                        }
                    }
                    if (biome.collision) {
                        int[] nArray = this.terrainMap[x];
                        int n2 = i;
                        nArray[n2] = nArray[n2] | Integer.MIN_VALUE;
                    }
                    if (biome.structures == null) continue;
                    for (BiomeStructureData data : biome.structures) {
                        int structureYStart;
                        int structureXStart;
                        while (!structureDataMap.containsKey(data)) {
                            try {
                                Thread.sleep(10L);
                            }
                            catch (InterruptedException e) {
                                throw new RuntimeException(e);
                            }
                        }
                        BiomeStructure structure = (BiomeStructure)structureDataMap.get(data);
                        int structureIndex = structure.objectID(structureXStart = x - (biomeXStart - biomeWidth / 2) - (int)(data.x * (float)biomeWidth - data.width * (float)biomeWidth / 2.0f), structureYStart = i - (biomeYStart - biomeHeight / 2) - (int)(data.y * (float)biomeHeight - data.height * (float)biomeHeight / 2.0f));
                        if (structureIndex >= 0) {
                            this.terrainMap[x][i] = terrainCounter + structureIndex;
                            if (structure.collision(structureXStart, structureYStart)) {
                                int[] nArray = this.terrainMap[x];
                                int n3 = i;
                                nArray[n3] = nArray[n3] | Integer.MIN_VALUE;
                            }
                            int[] nArray = this.terrainMap[x];
                            int n4 = i;
                            nArray[n4] = nArray[n4] | 0x40000000;
                        }
                        terrainCounter += structure.structureObjectCount();
                    }
                }
            }
        }
        currentTime[0] = this.measureGenerationTime("biomes in total", currentTime[0]);
        ArrayList<PointOfInterest> towns = new ArrayList<PointOfInterest>();
        ArrayList<PointOfInterest> notTowns = new ArrayList<PointOfInterest>();
        ArrayList<Rectangle> otherPoints = new ArrayList<Rectangle>();
        TextureAtlas mapMarker = Config.instance().getAtlas("sprites/map_marker.atlas");
        TextureData texture = mapMarker.getTextures().first().getTextureData();
        if (!texture.isPrepared()) {
            texture.prepare();
        }
        Pixmap mapMarkerPixmap = texture.consumePixmap();
        this.clearTerrain((int)((float)this.data.width * this.data.playerStartPosX), (int)((float)this.data.height * this.data.playerStartPosY), 10);
        boolean running = true;
        block18: while (running) {
            this.mapPoiIds = new PointOfInterestMap(this.getChunkSize(), this.data.tileSize, this.data.width / this.getChunkSize(), this.data.height / this.getChunkSize());
            int biomeIndex2 = -1;
            running = false;
            for (BiomeData biome : this.data.GetBiomes()) {
                ++biomeIndex2;
                for (PointOfInterestData pointOfInterestData : biome.getPointsOfInterest()) {
                    block21: for (int i = 0; i < pointOfInterestData.count; ++i) {
                        for (int counter = 0; counter < 500; ++counter) {
                            float radius = (float)Math.sqrt(this.random.nextDouble() / 2.0 * (double)pointOfInterestData.radiusFactor);
                            float theta = (float)(this.random.nextDouble() * 2.0 * Math.PI);
                            float x = (float)((double)radius * Math.cos(theta));
                            x *= biome.width * (float)this.width / 2.0f;
                            x += biome.startPointX * (float)this.width;
                            float y = (float)((double)radius * Math.sin(theta));
                            y *= biome.height * (float)this.height / 2.0f;
                            y += (float)this.height - biome.startPointY * (float)this.height;
                            if ((int)(x += pointOfInterestData.offsetX * (biome.width * (float)this.width)) < 0 || (int)(y += pointOfInterestData.offsetY * (biome.height * (float)this.height)) <= 0 || (int)y >= this.height || (int)x >= this.width || biomeIndex2 != World.highestBiome(this.getBiome((int)x, (int)y))) continue;
                            x *= (float)this.data.tileSize;
                            y *= (float)this.data.tileSize;
                            boolean breakNextLoop = false;
                            for (Rectangle rect : otherPoints) {
                                if (!rect.contains(x, y)) continue;
                                breakNextLoop = true;
                                break;
                            }
                            if (breakNextLoop) {
                                boolean foundSolution = false;
                                boolean noSolution = false;
                                breakNextLoop = false;
                                for (int xi = -1; xi < 2 && !foundSolution; ++xi) {
                                    for (int yi = -1; yi < 2 && !foundSolution; ++yi) {
                                        for (Rectangle rect : otherPoints) {
                                            if (!rect.contains(x + (float)(xi * this.data.tileSize), y + (float)(yi * this.data.tileSize))) continue;
                                            noSolution = true;
                                            break;
                                        }
                                        if (noSolution) continue;
                                        foundSolution = true;
                                        x += (float)(xi * this.data.tileSize);
                                        y += (float)(yi * this.data.tileSize);
                                    }
                                }
                                if (!foundSolution) {
                                    if (counter != 499) continue;
                                    System.err.print("Can not place POI " + pointOfInterestData.name + "...Rerunning..\n");
                                    running = true;
                                    towns.clear();
                                    notTowns.clear();
                                    otherPoints.clear();
                                    this.clearTerrain((int)((float)this.data.width * this.data.playerStartPosX), (int)((float)this.data.height * this.data.playerStartPosY), 10);
                                    this.storedInfo.clear();
                                    continue block18;
                                }
                            }
                            otherPoints.add(new Rectangle(x - (float)(this.data.tileSize * 4), y - (float)(this.data.tileSize * 4), this.data.tileSize * 8, this.data.tileSize * 8));
                            PointOfInterest newPoint = new PointOfInterest(pointOfInterestData, new Vector2(x, y), this.random);
                            this.clearTerrain((int)(x / (float)this.data.tileSize), (int)(y / (float)this.data.tileSize), 3);
                            this.mapPoiIds.add(newPoint);
                            TextureAtlas.AtlasRegion marker = mapMarker.findRegion(pointOfInterestData.type);
                            if (marker != null) {
                                int xInPixels = (int)(x / (float)this.data.tileSize * (float)this.data.miniMapTileSize);
                                int yInPixels = (int)(((float)this.height - y / (float)this.data.tileSize) * (float)this.data.miniMapTileSize);
                                this.drawPixmapLater(mapMarkerPixmap, marker.getRegionX(), marker.getRegionY(), marker.getRegionWidth(), marker.getRegionHeight(), xInPixels -= marker.getRegionWidth() / 2, yInPixels -= marker.getRegionHeight() / 2, marker.getRegionWidth(), marker.getRegionHeight());
                            }
                            if (pointOfInterestData.type != null && (pointOfInterestData.type.equals("town") || pointOfInterestData.type.equals("capital"))) {
                                if (!newPoint.hasDisplayName()) {
                                    if (pointOfInterestData.displayName == null || pointOfInterestData.displayName.isEmpty()) {
                                        newPoint.setDisplayName(biome.getNewTownName());
                                    } else {
                                        newPoint.setDisplayName(pointOfInterestData.getDisplayName());
                                    }
                                }
                                towns.add(newPoint);
                                continue block21;
                            }
                            notTowns.add(newPoint);
                            continue block21;
                        }
                    }
                }
            }
        }
        currentTime[0] = this.measureGenerationTime("poi placement", currentTime[0]);
        ArrayList<Pair<PointOfInterest, PointOfInterest>> allSortedTowns = new ArrayList<Pair<PointOfInterest, PointOfInterest>>();
        HashSet<Long> usedEdges = new HashSet<Long>();
        for (int i = 0; i < towns.size() - 1; ++i) {
            PointOfInterest current = (PointOfInterest)towns.get(i);
            int n = -1;
            int secondSmallestIndex = -1;
            float smallestDistance = Float.MAX_VALUE;
            for (int j = 0; j < towns.size(); ++j) {
                float dist;
                if (i == j || usedEdges.contains((long)i | (long)j << 32) || (dist = current.getPosition().dst(((PointOfInterest)towns.get(j)).getPosition())) > this.data.maxRoadDistance || !(dist < smallestDistance)) continue;
                smallestDistance = dist;
                secondSmallestIndex = n;
                n = j;
            }
            if (n < 0) continue;
            usedEdges.add((long)i | (long)n << 32);
            usedEdges.add((long)i << 32 | (long)n);
            allSortedTowns.add(Pair.of(current, (PointOfInterest)towns.get(n)));
            if (secondSmallestIndex < 0) continue;
            usedEdges.add((long)i | (long)secondSmallestIndex << 32);
            usedEdges.add((long)i << 32 | (long)secondSmallestIndex);
        }
        ArrayList<Pair<PointOfInterest, PointOfInterest>> allPOIPathsToNextTown = new ArrayList<Pair<PointOfInterest, PointOfInterest>>();
        for (int i = 0; i < notTowns.size() - 1; ++i) {
            PointOfInterest pointOfInterest = (PointOfInterest)notTowns.get(i);
            int smallestIndex = -1;
            float smallestDistance = Float.MAX_VALUE;
            for (int j = 0; j < towns.size(); ++j) {
                float dist = pointOfInterest.getPosition().dst(((PointOfInterest)towns.get(j)).getPosition());
                if (!(dist < smallestDistance)) continue;
                smallestDistance = dist;
                smallestIndex = j;
            }
            if (smallestIndex < 0) continue;
            allPOIPathsToNextTown.add(Pair.of(pointOfInterest, (PointOfInterest)towns.get(smallestIndex)));
        }
        biomeIndex[0] = biomeIndex[0] + 1;
        block31: for (Pair pair : allPOIPathsToNextTown) {
            int startX = (int)((PointOfInterest)pair.getKey()).getTilePosition((int)this.data.tileSize).x;
            int startY = (int)((PointOfInterest)pair.getKey()).getTilePosition((int)this.data.tileSize).y;
            int x1 = (int)((PointOfInterest)pair.getValue()).getTilePosition((int)this.data.tileSize).x;
            int y1 = (int)((PointOfInterest)pair.getValue()).getTilePosition((int)this.data.tileSize).y;
            int dx = Math.abs(x1 - startX);
            int dy = Math.abs(y1 - startY);
            int sx = startX < x1 ? 1 : -1;
            int sy = startY < y1 ? 1 : -1;
            int err = dx - dy;
            for (int i = 0; i < 1000; ++i) {
                if (startX < 0 || startY <= 0 || startX >= this.width || startY > this.height) continue;
                if ((this.terrainMap[startX][this.height - startY] & Integer.MIN_VALUE) != 0) {
                    this.terrainMap[startX][this.height - startY] = 0;
                }
                if (startX == x1 && startY == y1) continue block31;
                int e2 = 2 * err;
                if (e2 > -dy) {
                    err -= dy;
                    startX += sx;
                    continue;
                }
                if (e2 >= dx) continue;
                err += dx;
                startY += sy;
            }
        }
        block33: for (Pair pair : allSortedTowns) {
            int startX = (int)((PointOfInterest)pair.getKey()).getTilePosition((int)this.data.tileSize).x;
            int startY = (int)((PointOfInterest)pair.getKey()).getTilePosition((int)this.data.tileSize).y;
            int x1 = (int)((PointOfInterest)pair.getValue()).getTilePosition((int)this.data.tileSize).x;
            int y1 = (int)((PointOfInterest)pair.getValue()).getTilePosition((int)this.data.tileSize).y;
            for (int x = startX - 1; x < startX + 2; ++x) {
                for (int y = startY - 1; y < startY + 2; ++y) {
                    if (x < 0 || y < 0 || x >= this.width || y >= this.height) continue;
                    long[] lArray = this.biomeMap[x];
                    int n = this.height - y - 1;
                    lArray[n] = lArray[n] | 1L << biomeIndex[0];
                    this.terrainMap[x][this.height - y - 1] = 0;
                }
            }
            int dx = Math.abs(x1 - startX);
            int dy = Math.abs(y1 - startY);
            int sx = startX < x1 ? 1 : -1;
            int sy = startY < y1 ? 1 : -1;
            int err = dx - dy;
            for (int i = 0; i < 1000; ++i) {
                if (startX < 0 || startY <= 0 || startX >= this.width || startY > this.height) continue;
                long[] lArray = this.biomeMap[startX];
                int n = this.height - startY;
                lArray[n] = lArray[n] | 1L << biomeIndex[0];
                this.terrainMap[startX][this.height - startY] = 0;
                if (startX == x1 && startY == y1) continue block33;
                int e2 = 2 * err;
                if (e2 > -dy) {
                    err -= dy;
                    startX += sx;
                    continue;
                }
                if (e2 >= dx) continue;
                err += dx;
                startY += sy;
            }
        }
        currentTime[0] = this.measureGenerationTime("roads", currentTime[0]);
        Pixmap pix = new Pixmap(this.width * this.data.miniMapTileSize, this.height * this.data.miniMapTileSize, Pixmap.Format.RGBA8888);
        pix.setColor(1.0f, 0.0f, 0.0f, 1.0f);
        pix.fill();
        boolean bl = false;
        while (var21_59 < this.width) {
            block38: for (int y = 0; y < this.height; ++y) {
                Pixmap smallPixmap;
                if (World.highestBiome(this.biomeMap[var21_59][y]) >= this.data.GetBiomes().size()) {
                    Pixmap smallPixmap2 = this.createSmallPixmap(this.data.roadTileset.tilesetAtlas, this.data.roadTileset.tilesetName, 0);
                    pix.drawPixmap(smallPixmap2, (int)(var21_59 * this.data.miniMapTileSize), y * this.data.miniMapTileSize);
                    continue;
                }
                BiomeData biome = this.data.GetBiomes().get(World.highestBiome(this.biomeMap[var21_59][y]));
                int terrainIndex = this.terrainMap[var21_59][y] & 0x3FFFFFFF;
                if (terrainIndex > biome.terrain.length) {
                    smallPixmap = this.createSmallPixmap(biome.tilesetAtlas, biome.tilesetName, 0);
                    pix.drawPixmap(smallPixmap, (int)(var21_59 * this.data.miniMapTileSize), y * this.data.miniMapTileSize);
                    terrainIndex -= biome.terrain.length;
                    --terrainIndex;
                    for (BiomeStructureData structData : biome.structures) {
                        if (terrainIndex >= structData.mappingInfo.length) {
                            terrainIndex -= structData.mappingInfo.length;
                            continue;
                        }
                        smallPixmap = this.createSmallPixmap(structData.structureAtlasPath, structData.mappingInfo[terrainIndex].name, 0);
                        pix.drawPixmap(smallPixmap, (int)(var21_59 * this.data.miniMapTileSize), y * this.data.miniMapTileSize);
                        continue block38;
                    }
                    continue;
                }
                smallPixmap = this.createSmallPixmap(biome.tilesetAtlas, biome.tilesetName, terrainIndex);
                pix.drawPixmap(smallPixmap, (int)(var21_59 * this.data.miniMapTileSize), y * this.data.miniMapTileSize);
            }
            ++var21_59;
        }
        for (Map.Entry<String, Pair<Pixmap, HashMap<String, Pixmap>>> entry : this.pixmapHash.entrySet()) {
            try {
                entry.getValue().getLeft().dispose();
            }
            catch (Exception biome) {
                // empty catch block
            }
            for (Map.Entry<String, Pixmap> pairEntry : entry.getValue().getRight().entrySet()) {
                try {
                    pairEntry.getValue().dispose();
                }
                catch (Exception smallPixmap) {}
            }
        }
        this.pixmapHash.clear();
        try {
            this.drawPixmapNow(pix);
        }
        catch (Exception exception) {
            // empty catch block
        }
        currentTime[0] = this.measureGenerationTime("mini map", currentTime[0]);
        this.mapObjectIds = new SpritesDataMap(this.getChunkSize(), this.data.tileSize, this.data.width / this.getChunkSize());
        boolean bl2 = false;
        while (var21_64 < this.width) {
            block43: for (int y = 0; y < this.height; ++y) {
                int invertedHeight = this.height - y - 1;
                int currentBiome = World.highestBiome(this.biomeMap[var21_64][invertedHeight]);
                if (currentBiome >= this.data.GetBiomes().size() || this.isStructure((int)var21_64, y)) continue;
                BiomeData biome = this.data.GetBiomes().get(currentBiome);
                for (String name : biome.spriteNames) {
                    BiomeSpriteData sprite = this.data.GetBiomeSprites().getSpriteData(name);
                    double spriteNoise = (noise.eval((double)var21_64 / (double)this.width * (double)noiseZoom * sprite.resolution, (double)y / (double)invertedHeight * (double)noiseZoom * sprite.resolution) + 1.0) / 2.0;
                    if (!(spriteNoise >= sprite.startArea) || !(spriteNoise <= sprite.endArea) || !((double)this.random.nextFloat() <= sprite.density)) continue;
                    String spriteKey = sprite.key();
                    int key = !this.mapObjectIds.containsKey(spriteKey) ? this.mapObjectIds.put(sprite.key(), sprite, this.data.GetBiomeSprites()) : this.mapObjectIds.intKey(spriteKey);
                    this.mapObjectIds.putPosition(key, new Vector2(((float)var21_64 + 0.25f + this.random.nextFloat() / 2.0f) * (float)this.data.tileSize, ((float)y + 0.25f - this.random.nextFloat() / 2.0f) * (float)this.data.tileSize));
                    continue block43;
                }
            }
            ++var21_64;
        }
        mapMarkerPixmap.dispose();
        this.biomeImage = pix;
        this.measureGenerationTime("sprites", currentTime[0]);
        System.out.println("Generating world took :\t\t" + (float)(System.currentTimeMillis() - startTime) / 1000.0f + " s");
        WorldStage.getInstance().clearCache();
        if (GuiBase.isAndroid()) {
            GuiBase.getInterface().preventSystemSleep(false);
        }
        return this;
    }

    private Pixmap createSmallPixmap(String tilesetName, String key, int i) {
        Pair<Pixmap, HashMap<String, Pixmap>> pair;
        TextureAtlas atlas;
        if (i > 2) {
            i = 2;
        }
        String tileSetNameWithIndex = i == 0 ? key : key + "_" + i;
        if (!this.pixmapHash.containsKey(tilesetName)) {
            atlas = Config.instance().getAtlas(tilesetName);
            TextureAtlas.AtlasRegion region = atlas.findRegion(tileSetNameWithIndex);
            TextureData data = region.getTexture().getTextureData();
            if (!data.isPrepared()) {
                data.prepare();
            }
            this.pixmapHash.put(tilesetName, Pair.of(data.consumePixmap(), new HashMap()));
        }
        if (!(pair = this.pixmapHash.get(tilesetName)).getRight().containsKey(tileSetNameWithIndex)) {
            atlas = Config.instance().getAtlas(tilesetName);
            TextureAtlas.AtlasRegion region = atlas.findRegion(tileSetNameWithIndex);
            int tileSize = this.data.tileSize;
            Pixmap smallPixmap = new Pixmap(this.data.miniMapTileSize, this.data.miniMapTileSize, Pixmap.Format.RGBA8888);
            smallPixmap.setColor(0.0f, 0.0f, 0.0f, 0.0f);
            smallPixmap.fill();
            smallPixmap.drawPixmap(pair.getLeft(), 0, 0, region.getRegionX(), region.getRegionY(), this.data.miniMapTileSize, this.data.miniMapTileSize);
            pair.getRight().put(tileSetNameWithIndex, smallPixmap);
        }
        return pair.getRight().get(tileSetNameWithIndex);
    }

    private void drawPixmapLater(Pixmap mapMarkerPixmap, int regionX, int regionY, int regionWidth, int regionHeight, int x, int y, int regionWidth1, int regionHeight1) {
        DrawInfo info = new DrawInfo();
        info.mapMarkerPixmap = mapMarkerPixmap;
        info.regionX = regionX;
        info.regionY = regionY;
        info.regionWidth = regionWidth;
        info.regionHeight = regionHeight;
        info.x = x;
        info.y = y;
        info.regionWidth1 = regionWidth1;
        info.regionHeight1 = regionHeight1;
        this.storedInfo.add(info);
    }

    private void drawPixmapNow(Pixmap map) {
        for (DrawInfo info : this.storedInfo) {
            map.drawPixmap(info.mapMarkerPixmap, info.regionX, info.regionY, info.regionWidth, info.regionHeight, info.x, info.y, info.regionWidth1, info.regionHeight1);
        }
        this.storedInfo.clear();
    }

    public int getWidthInTiles() {
        return this.width;
    }

    public int getHeightInTiles() {
        return this.height;
    }

    public int getWidthInPixels() {
        return this.width * this.data.tileSize;
    }

    public int getHeightInPixels() {
        return this.height * this.data.tileSize;
    }

    public int getWidthInChunks() {
        return this.width / this.getChunkSize();
    }

    public int getHeightInChunks() {
        return this.height / this.getChunkSize();
    }

    public int getTileSize() {
        return this.data.tileSize;
    }

    public Pixmap getBiomeImage() {
        return this.biomeImage;
    }

    public List<Pair<Vector2, Integer>> GetMapObjects(int chunkX, int chunkY) {
        return this.mapObjectIds.positions(chunkX, chunkY);
    }

    public List<PointOfInterest> getPointsOfInterest(Actor player) {
        return this.mapPoiIds.pointsOfInterest((int)player.getX() / this.data.tileSize / this.getChunkSize(), (int)player.getY() / this.data.tileSize / this.getChunkSize());
    }

    public List<PointOfInterest> getPointsOfInterest(int chunkX, int chunkY) {
        return this.mapPoiIds.pointsOfInterest(chunkX, chunkY);
    }

    public PointOfInterest findPointsOfInterest(String name) {
        return this.mapPoiIds.findPointsOfInterest(name);
    }

    public List<PointOfInterest> getAllPointOfInterest() {
        return this.mapPoiIds.getAllPointOfInterest();
    }

    public int getChunkSize() {
        return (Scene.getIntendedWidth() > Scene.getIntendedHeight() ? Scene.getIntendedWidth() : Scene.getIntendedHeight()) / this.data.tileSize;
    }

    @Override
    public void dispose() {
        if (this.biomeImage != null) {
            this.biomeImage.dispose();
        }
    }

    public void setSeed(long seedOffset) {
        this.random.setSeed(seedOffset + this.seed);
    }

    public Texture getGlobalTexture() {
        if (this.globalTexture == null) {
            this.globalTexture = Forge.getAssets().getTexture(Config.instance().getFile("ui/sprite_markers.png"), true, true);
            System.out.print("Loading auxiliary sprites.\n");
        }
        return this.globalTexture;
    }

    static class DrawInfo {
        Pixmap mapMarkerPixmap;
        int regionX;
        int regionY;
        int regionWidth;
        int regionHeight;
        int x;
        int y;
        int regionWidth1;
        int regionHeight1;

        DrawInfo() {
        }
    }

    private static class DrawingInformation {
        private int neighbors;
        private final BiomeTexture regions;
        private final int terrain;

        public DrawingInformation(int neighbors, BiomeTexture regions, int terrain) {
            this.neighbors = neighbors;
            this.regions = regions;
            this.terrain = terrain;
        }

        public void draw(Pixmap drawingPixmap) {
            this.regions.drawPixmapOn(this.terrain, this.neighbors, drawingPixmap);
        }
    }
}

