/*
 * Decompiled with CFR 0.152.
 */
package forge.adventure.world;

import com.badlogic.gdx.math.Vector2;
import forge.adventure.data.BiomeSpriteData;
import forge.adventure.util.SaveFileContent;
import forge.adventure.util.SaveFileData;
import forge.adventure.world.BiomeSprites;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.tuple.Pair;

public class SpritesDataMap
implements SaveFileContent {
    private final int numberOfChunks;
    BiomeSpriteDataMap objectData = new BiomeSpriteDataMap();
    HashMap<String, Integer> objectKeys = new HashMap();
    int tileSize;
    int chunkSize;
    private List<Pair<Vector2, Integer>>[][] mapObjects;

    SpritesDataMap(int chunkSize, int tiles, int numberOfChunks) {
        this.tileSize = tiles;
        this.chunkSize = chunkSize;
        this.numberOfChunks = numberOfChunks;
        this.mapObjects = new List[numberOfChunks][numberOfChunks];
        for (int x = 0; x < numberOfChunks; ++x) {
            for (int y = 0; y < numberOfChunks; ++y) {
                this.mapObjects[x][y] = new ArrayList<Pair<Vector2, Integer>>();
            }
        }
    }

    public BiomeSpriteData get(int id) {
        return (BiomeSpriteData)this.objectData.get(id);
    }

    public boolean containsKey(String spriteKey) {
        return this.objectKeys.containsKey(spriteKey);
    }

    public int put(String key, BiomeSpriteData mapObject, BiomeSprites sprites) {
        int retInt = this.objectData.size();
        this.objectData.put(retInt, mapObject);
        this.objectKeys.put(key, retInt);
        return retInt;
    }

    public int intKey(String spriteKey) {
        return this.objectKeys.get(spriteKey);
    }

    public void putPosition(int key, Vector2 vector2) {
        int chunkX = (int)(vector2.x / (float)this.tileSize / (float)this.chunkSize);
        int chunkY = (int)(vector2.y / (float)this.tileSize / (float)this.chunkSize);
        if (chunkX >= this.numberOfChunks || chunkY >= this.numberOfChunks || chunkX < 0 || chunkY < 0) {
            return;
        }
        this.mapObjects[chunkX][chunkY].add(Pair.of(vector2, key));
    }

    public List<Pair<Vector2, Integer>> positions(int chunkX, int chunkY) {
        if (chunkX >= this.numberOfChunks || chunkY >= this.numberOfChunks || chunkX < 0 || chunkY < 0) {
            return new ArrayList<Pair<Vector2, Integer>>();
        }
        return this.mapObjects[chunkX][chunkY];
    }

    @Override
    public void load(SaveFileData data) {
        this.objectData.load(data.readSubData("objectData"));
        this.mapObjects = (List[][])data.readObject("mapObjects");
        this.objectKeys = (HashMap)data.readObject("objectKeys");
        this.tileSize = data.readInt("tileSize");
        this.chunkSize = data.readInt("chunkSize");
    }

    @Override
    public SaveFileData save() {
        SaveFileData data = new SaveFileData();
        data.store("objectData", this.objectData.save());
        data.storeObject("mapObjects", this.mapObjects);
        data.storeObject("objectKeys", this.objectKeys);
        data.store("tileSize", this.tileSize);
        data.store("chunkSize", this.chunkSize);
        return data;
    }

    public static class BiomeSpriteDataMap
    extends HashMap<Integer, BiomeSpriteData>
    implements SaveFileContent {
        @Override
        public void load(SaveFileData data) {
            this.clear();
            List keyList = (List)data.readObject("keyList");
            for (Integer key : keyList) {
                BiomeSpriteData biomeData = new BiomeSpriteData();
                biomeData.load(data.readSubData(key.toString()));
                this.put(key, biomeData);
            }
        }

        @Override
        public SaveFileData save() {
            SaveFileData data = new SaveFileData();
            ArrayList<Integer> keyList = new ArrayList<Integer>();
            for (Map.Entry entry : this.entrySet()) {
                keyList.add((Integer)entry.getKey());
                data.store(((Integer)entry.getKey()).toString(), ((BiomeSpriteData)entry.getValue()).save());
            }
            data.storeObject("keyList", keyList);
            return data;
        }
    }
}

