/*
 * Decompiled with CFR 0.152.
 */
package forge.adventure.world;

import forge.adventure.world.ColorMap;
import java.util.Random;

abstract class Model {
    protected boolean[][] wave;
    protected int[][][] propagator;
    int[][][] compatible;
    protected int[] observed;
    int[] stack;
    int stacksize;
    protected Random random;
    protected int FMX;
    protected int FMY;
    protected int T;
    protected boolean periodic;
    protected Double[] weights;
    double[] weightLogWeights;
    int[] sumsOfOnes;
    double sumOfWeights;
    double sumOfWeightLogWeights;
    double startingEntropy;
    double[] sumsOfWeights;
    double[] sumsOfWeightLogWeights;
    double[] entropies;
    private double[] distribution;
    protected static int[] DX = new int[]{-1, 0, 1, 0};
    protected static int[] DY = new int[]{0, 1, 0, -1};
    static int[] oppposite = new int[]{2, 3, 0, 1};

    protected Model(int width, int height) {
        this.FMX = width;
        this.FMY = height;
    }

    protected abstract boolean onBoundary(int var1, int var2);

    public abstract ColorMap graphics();

    static int randomIndice(double[] arr, double r) {
        double sum = 0.0;
        for (double v : arr) {
            sum += v;
        }
        int j = 0;
        while (j < arr.length) {
            int n = j++;
            arr[n] = arr[n] / sum;
        }
        double x = 0.0;
        for (int i = 0; i < arr.length; ++i) {
            if (!(r <= (x += arr[i]))) continue;
            return i;
        }
        return 0;
    }

    public static long toPower(int a, int n) {
        long product = 1L;
        for (int i = 0; i < n; ++i) {
            product *= (long)a;
        }
        return product;
    }

    void init() {
        this.wave = new boolean[this.FMX * this.FMY][];
        this.compatible = new int[this.wave.length][][];
        for (int i = 0; i < this.wave.length; ++i) {
            this.wave[i] = new boolean[this.T];
            this.compatible[i] = new int[this.T][];
            for (int t2 = 0; t2 < this.T; ++t2) {
                this.compatible[i][t2] = new int[4];
            }
        }
        this.weightLogWeights = new double[this.T];
        this.distribution = new double[this.T];
        this.sumOfWeights = 0.0;
        this.sumOfWeightLogWeights = 0.0;
        for (int t3 = 0; t3 < this.T; ++t3) {
            this.weightLogWeights[t3] = this.weights[t3] * Math.log(this.weights[t3]);
            this.sumOfWeights += this.weights[t3].doubleValue();
            this.sumOfWeightLogWeights += this.weightLogWeights[t3];
        }
        this.startingEntropy = Math.log(this.sumOfWeights) - this.sumOfWeightLogWeights / this.sumOfWeights;
        this.sumsOfOnes = new int[this.FMX * this.FMY];
        this.sumsOfWeights = new double[this.FMX * this.FMY];
        this.sumsOfWeightLogWeights = new double[this.FMX * this.FMY];
        this.entropies = new double[this.FMX * this.FMY];
        this.stack = new int[this.wave.length * this.T * 2];
        this.stacksize = 0;
    }

    Boolean observe() {
        int i;
        double min2 = 1000.0;
        int argmin = -1;
        for (i = 0; i < this.wave.length; ++i) {
            double noise;
            if (this.onBoundary(i % this.FMX, i / this.FMX)) continue;
            int amount = this.sumsOfOnes[i];
            if (amount == 0) {
                return false;
            }
            double entropy = this.entropies[i];
            if (amount <= 1 || !(entropy <= min2) || !(entropy + (noise = 1.0E-6 * this.random.nextDouble()) < min2)) continue;
            min2 = entropy + noise;
            argmin = i;
        }
        if (argmin == -1) {
            this.observed = new int[this.FMX * this.FMY];
            block1: for (i = 0; i < this.wave.length; ++i) {
                for (int t2 = 0; t2 < this.T; ++t2) {
                    if (!this.wave[i][t2]) continue;
                    this.observed[i] = t2;
                    continue block1;
                }
            }
            return true;
        }
        for (int t3 = 0; t3 < this.T; ++t3) {
            this.distribution[t3] = this.wave[argmin][t3] ? this.weights[t3] : 0.0;
        }
        int r = Model.randomIndice(this.distribution, this.random.nextDouble());
        boolean[] w = this.wave[argmin];
        for (int t4 = 0; t4 < this.T; ++t4) {
            if (w[t4] == (t4 == r)) continue;
            this.ban(argmin, t4);
        }
        return null;
    }

    protected void ban(int i, int t2) {
        this.wave[i][t2] = false;
        int[] comp = this.compatible[i][t2];
        for (int d = 0; d < 4; ++d) {
            comp[d] = 0;
        }
        this.stack[this.stacksize] = i;
        this.stack[this.stacksize + 1] = t2;
        this.stacksize += 2;
        int n = i;
        this.sumsOfOnes[n] = this.sumsOfOnes[n] - 1;
        int n2 = i;
        this.sumsOfWeights[n2] = this.sumsOfWeights[n2] - this.weights[t2];
        int n3 = i;
        this.sumsOfWeightLogWeights[n3] = this.sumsOfWeightLogWeights[n3] - this.weightLogWeights[t2];
        double sum = this.sumsOfWeights[i];
        this.entropies[i] = Math.log(sum) - this.sumsOfWeightLogWeights[i] / sum;
    }

    protected void propagate() {
        while (this.stacksize >= 2) {
            int i1 = this.stack[this.stacksize - 2];
            int x1 = i1 % this.FMX;
            int y1 = i1 / this.FMX;
            int stack2 = this.stack[this.stacksize - 1];
            this.stacksize -= 2;
            for (int d = 0; d < 4; ++d) {
                int dx = DX[d];
                int x2 = x1 + dx;
                int dy = DY[d];
                int y2 = y1 + dy;
                if (this.onBoundary(x2, y2)) continue;
                if (x2 < 0) {
                    x2 += this.FMX;
                } else if (x2 >= this.FMX) {
                    x2 -= this.FMX;
                }
                if (y2 < 0) {
                    y2 += this.FMY;
                } else if (y2 >= this.FMY) {
                    y2 -= this.FMY;
                }
                int i2 = x2 + y2 * this.FMX;
                int[] p = this.propagator[d][stack2];
                int[][] compat = this.compatible[i2];
                for (int t2 : p) {
                    int[] comp = compat[t2];
                    int n = d;
                    comp[n] = comp[n] - 1;
                    if (comp[d] != 0) continue;
                    this.ban(i2, t2);
                }
            }
        }
    }

    public boolean run(int seed, int limit) {
        if (this.wave == null) {
            this.init();
        }
        this.Clear();
        this.random = new Random(seed);
        for (int l = 0; l < limit || limit == 0; ++l) {
            Boolean result = this.observe();
            if (result != null) {
                return result;
            }
            this.propagate();
        }
        return true;
    }

    protected void Clear() {
        for (int i = 0; i < this.wave.length; ++i) {
            for (int t2 = 0; t2 < this.T; ++t2) {
                this.wave[i][t2] = true;
                for (int d = 0; d < 4; ++d) {
                    this.compatible[i][t2][d] = this.propagator[oppposite[d]][t2].length;
                }
            }
            this.sumsOfOnes[i] = this.weights.length;
            this.sumsOfWeights[i] = this.sumOfWeights;
            this.sumsOfWeightLogWeights[i] = this.sumOfWeightLogWeights;
            this.entropies[i] = this.startingEntropy;
        }
    }
}

