/*
 * Decompiled with CFR 0.152.
 */
package forge.adventure.world;

import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Pixmap;

public class ColorMap {
    private final int width;
    private final int height;
    private final Color[] data;

    public ColorMap(int w, int h2) {
        this.width = w;
        this.height = h2;
        this.data = new Color[w * h2];
        for (int i = 0; i < w * h2; ++i) {
            this.data[i] = new Color();
        }
    }

    public ColorMap(FileHandle file) {
        Pixmap pdata = new Pixmap(file);
        this.width = pdata.getWidth();
        this.height = pdata.getHeight();
        this.data = new Color[this.width * this.height];
        for (int y = 0; y < this.height; ++y) {
            for (int x = 0; x < this.width; ++x) {
                this.data[x + y * this.width] = new Color(pdata.getPixel(x, y));
            }
        }
        pdata.dispose();
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public Color getColor(int x, int y) {
        return this.data[x + y * this.width];
    }

    public void setColor(int x, int y, Color c) {
        this.data[x + y * this.width].set(c);
    }
}

