/*
 * Decompiled with CFR 0.152.
 */
package forge.adventure.util.pathfinding;

import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.physics.box2d.Body;
import com.badlogic.gdx.physics.box2d.BodyDef;
import com.badlogic.gdx.physics.box2d.Fixture;
import com.badlogic.gdx.physics.box2d.FixtureDef;
import com.badlogic.gdx.physics.box2d.PolygonShape;
import com.badlogic.gdx.physics.box2d.RayCastCallback;
import com.badlogic.gdx.utils.Array;
import forge.adventure.stage.MapStage;
import forge.adventure.util.pathfinding.NavigationGraph;
import forge.adventure.util.pathfinding.NavigationVertex;
import forge.adventure.util.pathfinding.ProgressableGraphPath;
import java.util.ArrayList;
import java.util.Comparator;

public class NavigationMap {
    float spriteSize = 16.0f;
    boolean rayCollided = false;
    public NavigationGraph navGraph = new NavigationGraph();
    Array<Rectangle> navBounds = new Array();
    float half = this.spriteSize / 2.0f;
    RayCastCallback callback = (fixture, vector2, vector21, v) -> {
        if ((double)v < 1.0) {
            this.rayCollided = true;
        }
        return 0.0f;
    };

    public NavigationMap(float spriteSize) {
        this.spriteSize = spriteSize;
        this.half = spriteSize / 2.0f;
    }

    public void initializeGeometryGraph() {
        this.navGraph = new NavigationGraph();
        for (int i = 0; i < MapStage.getInstance().collisionRect.size; ++i) {
            Rectangle r1 = MapStage.getInstance().collisionRect.get(i);
            if (r1.width < 3.0f && r1.height < 3.0f) continue;
            int offsetX = -8;
            boolean offsetY = false;
            BodyDef bodyDef = new BodyDef();
            bodyDef.type = BodyDef.BodyType.StaticBody;
            bodyDef.position.set(r1.x + r1.getWidth() / 2.0f + (float)offsetX, r1.y + r1.getHeight() / 2.0f + (float)offsetY);
            Body body = MapStage.getInstance().gdxWorld.createBody(bodyDef);
            PolygonShape polygonShape = new PolygonShape();
            polygonShape.setAsBox((r1.getWidth() + this.spriteSize) / 2.0f, (r1.getHeight() + this.spriteSize) / 2.0f);
            FixtureDef fixture = new FixtureDef();
            fixture.shape = polygonShape;
            fixture.density = 1.0f;
            body.createFixture(fixture);
            polygonShape.dispose();
        }
        float width = Float.parseFloat(MapStage.getInstance().tiledMap.getProperties().get("width").toString());
        float height = Float.parseFloat(MapStage.getInstance().tiledMap.getProperties().get("height").toString());
        float tileHeight = Float.parseFloat(MapStage.getInstance().tiledMap.getProperties().get("tileheight").toString());
        float tileWidth = Float.parseFloat(MapStage.getInstance().tiledMap.getProperties().get("tilewidth").toString());
        NavigationVertex[][] points = new NavigationVertex[(int)width][(int)height];
        int i = 0;
        while ((float)i < width) {
            int j = 0;
            while ((float)j < height) {
                points[i][j] = this.navGraph.addVertex((float)i * tileWidth + tileWidth / 2.0f, (float)j * tileHeight + tileHeight / 2.0f);
                if (i > 0) {
                    this.navGraph.addEdgeUnchecked(points[i][j], points[i - 1][j]);
                }
                if (j > 0) {
                    this.navGraph.addEdgeUnchecked(points[i][j], points[i][j - 1]);
                }
                if (i > 0 && j > 0) {
                    this.navGraph.addEdgeUnchecked(points[i][j], points[i - 1][j - 1]);
                }
                if (i > 0 && (float)(j + 1) < height) {
                    this.navGraph.addEdgeUnchecked(points[i][j], points[i - 1][j + 1]);
                }
                ++j;
            }
            ++i;
        }
        Array<Fixture> fixtures = new Array<Fixture>();
        if (MapStage.getInstance().gdxWorld != null) {
            MapStage.getInstance().gdxWorld.getFixtures(fixtures);
            for (Fixture fix : fixtures) {
                this.navGraph.removeVertexIf(vertex -> fix.testPoint(vertex.pos));
            }
        }
        this.navGraph.removeVertexIf(v -> this.navGraph.getConnections((NavigationVertex)v).isEmpty());
        for (Vector2 waypointVector : MapStage.getInstance().waypoints.values()) {
            NavigationVertex waypointVertex = this.navGraph.addVertex(waypointVector);
            ArrayList<NavigationVertex> vertices = new ArrayList<NavigationVertex>(this.navGraph.nodes.values());
            vertices.sort(Comparator.comparingInt(o -> Math.round((o.pos.x - waypointVector.x) * (o.pos.x - waypointVector.x) + (o.pos.y - waypointVector.y) * (o.pos.y - waypointVector.y))));
            int j = 0;
            for (int i2 = 0; i2 < vertices.size() && j < 4; ++i2) {
                if (waypointVector.epsilonEquals(vertices.get((int)i2).pos)) continue;
                this.rayCollided = false;
                MapStage.getInstance().gdxWorld.rayCast(this.callback, waypointVector, vertices.get((int)i2).pos);
                if (this.rayCollided) continue;
                this.navGraph.addEdgeUnchecked(waypointVertex, vertices.get(i2));
                ++j;
            }
        }
    }

    public ProgressableGraphPath<NavigationVertex> findShortestPath(Float spriteSize, Vector2 origin, Vector2 destination) {
        Array<Fixture> fixtures = new Array<Fixture>();
        MapStage.getInstance().gdxWorld.getFixtures(fixtures);
        boolean originPrecalculated = this.navGraph.containsNode(origin);
        boolean destinationPrecalculated = this.navGraph.containsNode(destination);
        try {
            int i;
            int j;
            if (!originPrecalculated) {
                this.navGraph.addVertex(origin);
            }
            if (!destinationPrecalculated) {
                this.navGraph.addVertex(destination);
            }
            ArrayList<NavigationVertex> vertices = new ArrayList<NavigationVertex>();
            if (!originPrecalculated || !destinationPrecalculated) {
                vertices.addAll(this.navGraph.nodes.values());
                vertices.sort(Comparator.comparingInt(o -> Math.round((o.pos.x - origin.x) * (o.pos.x - origin.x) + (o.pos.y - origin.y) * (o.pos.y - origin.y))));
            }
            if (!originPrecalculated) {
                j = 0;
                for (i = 0; i < vertices.size() && j < 10; ++i) {
                    if (origin.epsilonEquals(((NavigationVertex)vertices.get((int)i)).pos)) continue;
                    this.rayCollided = false;
                    MapStage.getInstance().gdxWorld.rayCast(this.callback, origin, ((NavigationVertex)vertices.get((int)i)).pos);
                    if (this.rayCollided) continue;
                    this.navGraph.addEdge(origin, (NavigationVertex)vertices.get(i));
                    ++j;
                }
            }
            if (!destinationPrecalculated) {
                j = 0;
                for (i = 0; i < vertices.size() && j < 10; ++i) {
                    if (destination.epsilonEquals(((NavigationVertex)vertices.get((int)i)).pos)) continue;
                    this.rayCollided = false;
                    MapStage.getInstance().gdxWorld.rayCast(this.callback, ((NavigationVertex)vertices.get((int)i)).pos, destination);
                    if (this.rayCollided) continue;
                    this.navGraph.addEdge(destination, (NavigationVertex)vertices.get(i));
                    ++j;
                }
            }
            ProgressableGraphPath<NavigationVertex> shortestPath = this.navGraph.findPath(origin, destination);
            if (!originPrecalculated) {
                this.navGraph.removeVertex(origin);
            }
            if (!destinationPrecalculated) {
                this.navGraph.removeVertex(destination);
            }
            return shortestPath;
        }
        catch (Exception e) {
            if (!originPrecalculated && this.navGraph.lookupIndex(origin) > -1) {
                this.navGraph.removeVertex(origin);
            }
            if (!destinationPrecalculated && this.navGraph.lookupIndex(destination) > -1) {
                this.navGraph.removeVertex(destination);
            }
            throw e;
        }
    }
}

