/*
 * Decompiled with CFR 0.152.
 */
package forge.adventure.util.pathfinding;

import com.badlogic.gdx.math.Vector2;
import forge.adventure.stage.MapStage;
import forge.util.Aggregates;

public class MovementBehavior {
    public float duration = 0.0f;
    float x = 0.0f;
    float y = 0.0f;
    public String destination = "";
    public Vector2 currentTargetVector;

    public float getX() {
        return this.x;
    }

    public float getY() {
        return this.y;
    }

    public float getDuration() {
        return this.duration;
    }

    public Vector2 getNextTargetVector(int objectID, Vector2 currentPosition) {
        if (this.currentTargetVector != null) {
            return this.currentTargetVector;
        }
        if (this.destination.isEmpty()) {
            this.currentTargetVector = new Vector2(currentPosition);
        } else if (this.destination.startsWith("r")) {
            String[] randomWaypoints = this.destination.replaceAll("r", "").split("-");
            if (randomWaypoints.length > 0) {
                int selectedWaypoint = Integer.parseInt(Aggregates.random(randomWaypoints));
                if (MapStage.getInstance().waypoints.containsKey(selectedWaypoint)) {
                    this.currentTargetVector = new Vector2(MapStage.getInstance().waypoints.get(selectedWaypoint));
                }
            } else {
                this.currentTargetVector = new Vector2(currentPosition);
            }
        } else if (this.destination.startsWith("w")) {
            this.currentTargetVector = new Vector2(currentPosition);
            this.duration = Float.parseFloat(this.destination.replaceAll("w", ""));
        } else if (MapStage.getInstance().waypoints.containsKey(Integer.parseInt(this.destination))) {
            this.currentTargetVector = new Vector2(MapStage.getInstance().waypoints.get(Integer.parseInt(this.destination)));
        } else {
            System.err.println("Navigation error for object ID" + objectID + ", waypoint could not be parsed or does not exist: " + this.destination);
            this.destination = "";
        }
        return this.currentTargetVector == null ? currentPosition : this.currentTargetVector;
    }

    public void setX(float newVal) {
        this.x = newVal;
    }

    public void setY(float newVal) {
        this.y = newVal;
    }
}

