/*
 * Decompiled with CFR 0.152.
 */
package forge.adventure.util;

import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.maps.ImageResolver;
import com.badlogic.gdx.maps.MapObjects;
import com.badlogic.gdx.maps.tiled.TiledMap;
import com.badlogic.gdx.maps.tiled.TiledMapTileSet;
import com.badlogic.gdx.maps.tiled.TmxMapLoader;
import com.badlogic.gdx.maps.tiled.tiles.AnimatedTiledMapTile;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.GdxRuntimeException;
import com.badlogic.gdx.utils.ObjectMap;
import com.badlogic.gdx.utils.SerializationException;
import com.badlogic.gdx.utils.XmlReader;
import forge.Forge;
import java.io.File;
import java.util.Iterator;

public class TemplateTmxMapLoader
extends TmxMapLoader {
    FileHandle tmxFile;

    @Override
    public TiledMap load(String fileName) {
        TmxMapLoader.Parameters parameter = new TmxMapLoader.Parameters();
        File f = new File(fileName);
        FileHandle tmxFile = new FileHandle(f);
        this.root = this.xml.parse(tmxFile);
        parameter.generateMipMaps = true;
        parameter.textureMinFilter = Texture.TextureFilter.Nearest;
        parameter.textureMagFilter = Texture.TextureFilter.Nearest;
        Array<FileHandle> textureFiles = this.getDependencyFileHandles(tmxFile);
        for (FileHandle textureFile : textureFiles) {
            Texture texture = new Texture(textureFile, parameter.generateMipMaps);
            texture.setFilter(parameter.textureMinFilter, parameter.textureMagFilter);
            Forge.getAssets().tmxMap().put(textureFile.path(), texture);
        }
        TiledMap map = this.loadTiledMap(tmxFile, parameter, (ImageResolver)new ImageResolver.DirectImageResolver(Forge.getAssets().tmxMap()));
        map.setOwnedResources(Forge.getAssets().tmxMap().values().toArray());
        return map;
    }

    @Override
    protected Array<FileHandle> getDependencyFileHandles(FileHandle tmxFile) {
        Array<FileHandle> fileHandles = new Array<FileHandle>();
        for (XmlReader.Element tileset : this.root.getChildrenByName("tileset")) {
            String source = tileset.getAttribute("source", null);
            if (source != null) {
                FileHandle tsxFile = TemplateTmxMapLoader.getRelativeFileHandle(tmxFile, source);
                tileset = this.xml.parse(tsxFile);
                XmlReader.Element imageElement = tileset.getChildByName("image");
                if (imageElement != null) {
                    String imageSource = tileset.getChildByName("image").getAttribute("source");
                    FileHandle image = TemplateTmxMapLoader.getRelativeFileHandle(tsxFile, imageSource);
                    fileHandles.add(image);
                    continue;
                }
                for (XmlReader.Element tile : tileset.getChildrenByName("tile")) {
                    String imageSource = tile.getChildByName("image").getAttribute("source");
                    FileHandle image = TemplateTmxMapLoader.getRelativeFileHandle(tsxFile, imageSource);
                    fileHandles.add(image);
                }
                continue;
            }
            XmlReader.Element imageElement = tileset.getChildByName("image");
            if (imageElement != null) {
                String imageSource = tileset.getChildByName("image").getAttribute("source");
                FileHandle image = TemplateTmxMapLoader.getRelativeFileHandle(tmxFile, imageSource);
                fileHandles.add(image);
                continue;
            }
            for (XmlReader.Element tile : tileset.getChildrenByName("tile")) {
                String imageSource = tile.getChildByName("image").getAttribute("source");
                FileHandle image = TemplateTmxMapLoader.getRelativeFileHandle(tmxFile, imageSource);
                fileHandles.add(image);
            }
        }
        for (XmlReader.Element imageLayer : this.root.getChildrenByName("imagelayer")) {
            XmlReader.Element image = imageLayer.getChildByName("image");
            String source = image.getAttribute("source", null);
            if (source == null) continue;
            FileHandle handle = TemplateTmxMapLoader.getRelativeFileHandle(tmxFile, source);
            fileHandles.add(handle);
        }
        return fileHandles;
    }

    @Override
    protected TiledMap loadTiledMap(FileHandle tmxFile, TmxMapLoader.Parameters parameter, ImageResolver imageResolver) {
        this.tmxFile = tmxFile;
        return super.loadTiledMap(tmxFile, parameter, imageResolver);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    protected void loadTileSet(XmlReader.Element element, FileHandle tmxFile, ImageResolver imageResolver) {
        if (element.getName().equals("tileset")) {
            firstgid = element.getIntAttribute("firstgid", 1);
            imageSource = "";
            imageWidth = 0;
            imageHeight = 0;
            image = null;
            source = element.getAttribute("source", null);
            if (source != null) {
                tsx = TemplateTmxMapLoader.getRelativeFileHandle(tmxFile, source);
                try {
                    element = this.xml.parse(tsx);
                    imageElement = element.getChildByName("image");
                    if (imageElement == null) ** GOTO lbl27
                    imageSource = imageElement.getAttribute("source");
                    imageWidth = imageElement.getIntAttribute("width", 0);
                    imageHeight = imageElement.getIntAttribute("height", 0);
                    image = TemplateTmxMapLoader.getRelativeFileHandle(tsx, imageSource);
                }
                catch (SerializationException e) {
                    throw new GdxRuntimeException("Error parsing external tileset.");
                }
            } else {
                imageElement = element.getChildByName("image");
                if (imageElement != null) {
                    imageSource = imageElement.getAttribute("source");
                    imageWidth = imageElement.getIntAttribute("width", 0);
                    imageHeight = imageElement.getIntAttribute("height", 0);
                    image = TemplateTmxMapLoader.getRelativeFileHandle(tmxFile, imageSource);
                }
            }
lbl27:
            // 5 sources

            name = element.get("name", null);
            tilewidth = element.getIntAttribute("tilewidth", 0);
            tileheight = element.getIntAttribute("tileheight", 0);
            spacing = element.getIntAttribute("spacing", 0);
            margin = element.getIntAttribute("margin", 0);
            offset = element.getChildByName("tileoffset");
            offsetX = 0;
            offsetY = 0;
            if (offset != null) {
                offsetX = offset.getIntAttribute("x", 0);
                offsetY = offset.getIntAttribute("y", 0);
            }
            tileSet = new TiledMapTileSet();
            tileSet.setName(name);
            tileSetProperties = tileSet.getProperties();
            properties = element.getChildByName("properties");
            if (properties != null) {
                this.loadProperties(tileSetProperties, properties);
            }
            tileSetProperties.put("firstgid", firstgid);
            tileElements = element.getChildrenByName("tile");
            this.addStaticTiles(tmxFile, imageResolver, tileSet, element, tileElements, name, firstgid, tilewidth, tileheight, spacing, margin, source, offsetX, offsetY, imageSource, imageWidth, imageHeight, image);
            animatedTiles = new Array<AnimatedTiledMapTile>();
            for (XmlReader.Element tileElement : tileElements) {
                localtid = tileElement.getIntAttribute("id", 0);
                tile = tileSet.getTile(firstgid + localtid);
                if (tile == null) continue;
                animatedTile = this.createAnimatedTile(tileSet, tile, tileElement, firstgid);
                if (animatedTile != null) {
                    animatedTiles.add(animatedTile);
                    tile = animatedTile;
                }
                this.addTileProperties(tile, tileElement);
                this.addTileObjectGroup(tile, tileElement);
            }
            for (AnimatedTiledMapTile animatedTile : animatedTiles) {
                tileSet.putTile(animatedTile.getId(), animatedTile);
            }
            this.map.getTileSets().addTileSet(tileSet);
        }
    }

    @Override
    protected void loadObject(TiledMap map, MapObjects objects, XmlReader.Element element, float heightInPixels) {
        if (element.getName().equals("object")) {
            if (element.hasAttribute("class") && !element.hasAttribute("type")) {
                element.setAttribute("type", element.getAttribute("class"));
            }
            if (!element.hasAttribute("template")) {
                super.loadObject(map, objects, element, heightInPixels);
                return;
            }
            String source = element.getAttribute("template");
            FileHandle template = TemplateTmxMapLoader.getRelativeFileHandle(this.tmxFile, source);
            XmlReader.Element el = this.xml.parse(template);
            Iterator iterator = new Array.ArrayIterator<XmlReader.Element>(el.getChildrenByName("object")).iterator();
            if (iterator.hasNext()) {
                XmlReader.Element obj = (XmlReader.Element)iterator.next();
                for (ObjectMap.Entry entry : new ObjectMap.Entries<String, String>(element.getAttributes())) {
                    obj.setAttribute((String)entry.key, (String)entry.value);
                }
                XmlReader.Element properties = element.getChildByName("properties");
                XmlReader.Element element2 = obj.getChildByName("properties");
                if (properties != null && element2 != null) {
                    for (XmlReader.Element propertyElements : new Array.ArrayIterator<XmlReader.Element>(properties.getChildrenByName("property"))) {
                        element2.addChild(propertyElements);
                    }
                }
                super.loadObject(map, objects, obj, heightInPixels);
                return;
            }
        }
    }
}

