/*
 * Decompiled with CFR 0.152.
 */
package forge.adventure.util;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.GlyphLayout;
import com.badlogic.gdx.graphics.g2d.Sprite;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.graphics.glutils.FrameBuffer;
import com.badlogic.gdx.graphics.glutils.ShaderProgram;
import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.Tooltip;
import com.badlogic.gdx.scenes.scene2d.utils.ActorGestureListener;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;
import com.badlogic.gdx.scenes.scene2d.utils.TextureRegionDrawable;
import com.badlogic.gdx.utils.Disposable;
import com.badlogic.gdx.utils.Scaling;
import com.github.tommyettinger.textra.TextraButton;
import com.github.tommyettinger.textra.TextraLabel;
import forge.Forge;
import forge.Graphics;
import forge.ImageKeys;
import forge.StaticData;
import forge.adventure.data.ItemData;
import forge.adventure.scene.RewardScene;
import forge.adventure.scene.Scene;
import forge.adventure.scene.UIScene;
import forge.adventure.util.Config;
import forge.adventure.util.Controls;
import forge.adventure.util.Reward;
import forge.assets.FSkin;
import forge.assets.FSkinImage;
import forge.assets.ImageCache;
import forge.card.CardImageRenderer;
import forge.card.CardRenderer;
import forge.game.card.CardView;
import forge.gui.GuiBase;
import forge.item.PaperCard;
import forge.item.SealedProduct;
import forge.sound.SoundEffectType;
import forge.sound.SoundSystem;
import forge.util.Aggregates;
import forge.util.CardTranslation;
import forge.util.ImageFetcher;
import forge.util.ImageUtil;
import java.io.File;
import org.apache.commons.lang3.StringUtils;

public class RewardActor
extends Actor
implements Disposable,
ImageFetcher.Callback {
    ImageToolTip tooltip;
    HoldTooltip holdTooltip;
    Reward reward;
    public TextraButton autoSell;
    ShaderProgram shaderGrayscale = Forge.getGraphics().getShaderGrayscale();
    ShaderProgram shaderRoundRect = Forge.getGraphics().getShaderRoundedRect();
    final int preview_w = 488;
    final int preview_h = 680;
    TextureRegion backTexture;
    Texture image;
    Texture T;
    Texture Talt;
    Graphics graphics;
    Texture generatedTooltip = null;
    boolean needsToBeDisposed;
    float flipProcess = 0.0f;
    boolean clicked = false;
    boolean sold = false;
    boolean flipOnClick;
    private boolean hover;
    private boolean hasbackface;
    boolean loaded = true;
    boolean alternate = false;
    boolean shown = false;
    boolean isRewardShop;
    boolean showOverlay;
    boolean isLoot;
    TextraLabel overlayLabel;
    public int renderedCount = 0;
    static final ImageFetcher fetcher = GuiBase.getInterface().getImageFetcher();
    RewardImage toolTipImage;
    String description = "";
    private final Matrix4 computedTransform = new Matrix4();
    private final Matrix4 oldTransform = new Matrix4();
    private final Matrix4 oldProjectionTransform = new Matrix4();

    @Override
    public void dispose() {
        if (this.needsToBeDisposed) {
            this.needsToBeDisposed = false;
            if (!Reward.Type.Card.equals((Object)this.reward.type)) {
                this.image.dispose();
            }
            if (this.generatedTooltip != null) {
                this.generatedTooltip.dispose();
            }
        }
        if (this.T != null) {
            this.T.dispose();
        }
        if (this.Talt != null) {
            this.Talt.dispose();
        }
    }

    public boolean toolTipIsVisible() {
        if (this.holdTooltip != null) {
            return this.holdTooltip.tooltip_actor.getStage() != null;
        }
        return false;
    }

    public Reward getReward() {
        return this.reward;
    }

    @Override
    public void onImageFetched() {
        ImageCache.clear();
        String imageKey = this.reward.getCard().getImageKey(false);
        PaperCard card = ImageUtil.getPaperCardFromImageKey(imageKey);
        imageKey = card.getCardImageKey();
        int count = 0;
        if (StringUtils.isBlank(imageKey)) {
            return;
        }
        File imageFile = ImageKeys.getImageFile(imageKey);
        if (imageFile == null || !imageFile.exists()) {
            return;
        }
        Texture replacement = Forge.getAssets().manager().get(imageFile.getPath(), Texture.class, false);
        if (replacement == null) {
            try {
                Forge.getAssets().manager().load(imageFile.getPath(), Texture.class, Forge.getAssets().getTextureFilter());
                Forge.getAssets().manager().finishLoadingAsset(imageFile.getPath());
                replacement = Forge.getAssets().manager().get(imageFile.getPath(), Texture.class, false);
            }
            catch (Exception e) {
                return;
            }
        }
        if (replacement == null) {
            return;
        }
        ++count;
        this.image = replacement;
        this.loaded = true;
        if (this.toolTipImage != null) {
            if (this.toolTipImage.getDrawable() instanceof TextureRegionDrawable) {
                ((TextureRegionDrawable)this.toolTipImage.getDrawable()).getRegion().getTexture().dispose();
            }
            this.toolTipImage.remove();
            this.toolTipImage = new RewardImage(this.processDrawable(this.image));
            if (GuiBase.isAndroid() || Forge.hasGamepad()) {
                if (this.holdTooltip != null) {
                    if (this.shown) {
                        this.holdTooltip.getTouchDownTarget().fire(RewardScene.eventTouchUp());
                        Gdx.input.setInputProcessor(null);
                    }
                    if (this.holdTooltip.getImage() != null && this.holdTooltip.getImage().getDrawable() instanceof TextureRegionDrawable) {
                        try {
                            ((TextureRegionDrawable)this.holdTooltip.getImage().getDrawable()).getRegion().getTexture().dispose();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    this.holdTooltip.hide();
                    this.holdTooltip.tooltip_actor = new ComplexTooltip(this.toolTipImage);
                }
            } else {
                this.tooltip.setActor(new ComplexTooltip(this.toolTipImage));
            }
        }
        if (this.T != null) {
            this.T.dispose();
        }
        if (this.alternate && this.Talt != null) {
            this.Talt.dispose();
        }
        ImageCache.updateSynqCount(imageFile, count);
        if (Forge.getCurrentScene() instanceof RewardScene) {
            RewardScene.instance().reactivateInputs();
        } else if (Forge.getCurrentScene() instanceof UIScene) {
            Forge.getCurrentScene().updateInput();
        }
        Gdx.graphics.requestRendering();
    }

    /*
     * Unable to fully structure code
     */
    public RewardActor(final Reward reward, boolean flippable, RewardScene.Type type, boolean showOverlay) {
        super();
        this.flipOnClick = flippable;
        this.reward = reward;
        this.isRewardShop = RewardScene.Type.Shop.equals((Object)type);
        this.isLoot = RewardScene.Type.Loot.equals((Object)type);
        this.showOverlay = showOverlay;
        if (this.backTexture == null) {
            this.backTexture = FSkin.getSleeves().get(0);
        }
        switch (4.$SwitchMap$forge$adventure$util$Reward$Type[reward.type.ordinal()]) {
            case 1: {
                if (!reward.isNoSell) {
                    this.autoSell = Controls.newTextButton("[%85][GRAY]\uff04");
                    scale = this.autoSell.getWidth();
                    this.autoSell.setSize(scale, scale * 1.2f);
                    this.autoSell.addListener(new ClickListener(){

                        @Override
                        public void clicked(InputEvent event, float x, float y) {
                            reward.setAutoSell(!reward.isAutoSell());
                            String c = reward.isAutoSell() ? "[%85][GREEN]" : "[%85][GRAY]";
                            RewardActor.this.autoSell.setText(c + "\uff04");
                        }
                    });
                }
                this.hasbackface = reward.getCard().hasBackFace();
                if (!ImageCache.imageKeyFileExists(reward.getCard().getImageKey(false)) || Forge.enableUIMask.equals("Art")) ** GOTO lbl81
                count = 0;
                card = ImageUtil.getPaperCardFromImageKey(reward.getCard().getImageKey(false));
                frontFace = ImageKeys.getImageFile(card.getCardImageKey());
                if (frontFace == null) ** GOTO lbl56
                try {
                    front = Forge.getAssets().manager().get(frontFace.getPath(), Texture.class, false);
                    if (front == null) {
                        Forge.getAssets().manager().load(frontFace.getPath(), Texture.class, Forge.getAssets().getTextureFilter());
                        Forge.getAssets().manager().finishLoadingAsset(frontFace.getPath());
                        front = Forge.getAssets().manager().get(frontFace.getPath(), Texture.class, false);
                    }
                    if (front == null) ** GOTO lbl50
                    ++count;
                    this.setCardImage(front);
                    ** GOTO lbl57
lbl50:
                    // 1 sources

                    this.loaded = false;
                }
                catch (Exception e) {
                    System.err.println("Failed to load image: " + frontFace.getPath());
                    this.loaded = false;
                }
                ** GOTO lbl57
lbl56:
                // 1 sources

                this.loaded = false;
lbl57:
                // 4 sources

                ImageCache.updateSynqCount(frontFace, count);
                if (!this.hasbackface) break;
                if (ImageCache.imageKeyFileExists(reward.getCard().getImageKey(true))) {
                    cardBack = ImageUtil.getPaperCardFromImageKey(reward.getCard().getImageKey(true));
                    backFace = ImageKeys.getImageFile(cardBack.getCardAltImageKey());
                    if (backFace == null) break;
                    try {
                        back = Forge.getAssets().manager().get(backFace.getPath(), Texture.class, false);
                        if (back == null) {
                            Forge.getAssets().manager().load(backFace.getPath(), Texture.class, Forge.getAssets().getTextureFilter());
                            Forge.getAssets().manager().finishLoadingAsset(backFace.getPath());
                            back = Forge.getAssets().manager().get(backFace.getPath(), Texture.class, false);
                        }
                        if (back != null) {
                            ImageCache.updateSynqCount(backFace, 1);
                            this.generateBackFace(reward, back);
                            break;
                        }
                        this.generateBackFace(reward, this.getRenderedBackface(reward));
                    }
                    catch (Exception e) {
                        System.err.println("Failed to load image: " + backFace.getPath());
                    }
                    break;
                }
                this.generateBackFace(reward, this.getRenderedBackface(reward));
                break;
lbl81:
                // 1 sources

                imagePath = ImageUtil.getImageRelativePath(reward.getCard(), "", true, false);
                lookup = ImageKeys.hasSetLookup(imagePath) != false ? ImageKeys.setLookUpFile(imagePath, imagePath + "border") : null;
                count = 0;
                if (lookup != null && !Forge.enableUIMask.equals("Art")) {
                    try {
                        replacement = Forge.getAssets().manager().get(lookup.getPath(), Texture.class, false);
                        if (replacement == null) {
                            Forge.getAssets().manager().load(lookup.getPath(), Texture.class, Forge.getAssets().getTextureFilter());
                            Forge.getAssets().manager().finishLoadingAsset(lookup.getPath());
                            replacement = Forge.getAssets().manager().get(lookup.getPath(), Texture.class, false);
                        }
                        if (replacement != null) {
                            ++count;
                            this.setCardImage(replacement);
                        } else {
                            this.loaded = false;
                        }
                        ImageCache.updateSynqCount(lookup, count);
                    }
                    catch (Exception e) {
                        System.err.println("Failed to load image: " + lookup.getPath());
                        this.loaded = false;
                    }
                    break;
                }
                imageRelativePath = ImageUtil.getImageRelativePath(reward.getCard(), "", true, false);
                if (imageRelativePath != null) {
                    file = ImageKeys.getImageFile(imagePath);
                    try {
                        if (file != null) {
                            check = Forge.getAssets().manager().get(file.getPath(), Texture.class, false);
                            if (check == null) {
                                Forge.getAssets().manager().load(file.getPath(), Texture.class, Forge.getAssets().getTextureFilter());
                                Forge.getAssets().manager().finishLoadingAsset(file.getPath());
                            }
                            ImageCache.updateSynqCount(file, 1);
                        }
                    }
                    catch (Exception check) {
                        // empty catch block
                    }
                }
                this.T = this.renderPlaceholder(new Graphics(), reward.getCard(), false);
                this.setCardImage(this.T);
                this.loaded = false;
                if (!ImageCache.imageKeyFileExists(reward.getCard().getImageKey(false))) {
                    RewardActor.fetcher.fetchImage(reward.getCard().getImageKey(false), this);
                }
                if (!this.hasbackface || ImageCache.imageKeyFileExists(reward.getCard().getImageKey(true))) break;
                RewardActor.fetcher.fetchImage(reward.getCard().getImageKey(true), null);
                break;
            }
            case 2: {
                backSprite = Config.instance().getItemSprite("CardBack");
                if (reward.getItem() == null) {
                    this.needsToBeDisposed = true;
                    this.processSprite(backSprite, null, null, 0, 0, false);
                    break;
                }
                item = reward.getItem().sprite();
                this.setItemTooltips(item, backSprite, false);
                isQuestItemLoot = RewardScene.Type.Loot.equals((Object)type) != false && reward.getItem().questItem != false;
                this.processSprite(backSprite, item, isQuestItemLoot != false ? Controls.newTextraLabel("[%200]" + reward.getItem().name) : null, 0, isQuestItemLoot != false ? -10 : 0, false);
                this.needsToBeDisposed = true;
                break;
            }
            case 3: {
                backSprite = Config.instance().getItemSprite("CardBack");
                if (reward.getDeck() == null) {
                    this.needsToBeDisposed = true;
                    this.processSprite(backSprite, null, null, 0, 0, false);
                    break;
                }
                imageKey = "";
                editionCode = "";
                try {
                    editionCode = reward.getDeck().getComment();
                    artIndex = 1;
                    if (SealedProduct.specialSets.contains(editionCode) || editionCode.equals("?")) {
                        imageKey = "b:" + this.getName().substring(0, this.getName().indexOf("Booster Pack") - 1);
                    } else {
                        maxIdx = StaticData.instance().getEditions().get(editionCode).getCntBoosterPictures();
                        artIndex = Aggregates.randomInt(1, 2);
                        imageKey = "b:" + editionCode + (1 >= maxIdx ? "" : "_" + artIndex);
                    }
                }
                catch (Exception artIndex) {
                    // empty catch block
                }
                isBooster = false;
                t = ImageCache.getImage(imageKey, false, true);
                if (t != null) {
                    item = new Sprite(new TextureRegion(t));
                    isBooster = true;
                } else {
                    item = Config.instance().getItemSprite("Deck");
                }
                this.setItemTooltips(item, backSprite, isBooster);
                if (isBooster) {
                    this.processSprite(backSprite, item, Controls.newTextraLabel("[%200]" + editionCode + " Booster"), 0, -10, isBooster);
                } else {
                    this.processSprite(backSprite, item, Controls.newTextraLabel("[%200]Event Reward Pack"), 0, -10, isBooster);
                }
                this.needsToBeDisposed = true;
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                backSprite = Config.instance().getItemSprite("CardBack");
                item = Config.instance().getItemSprite(reward.type.toString());
                this.setItemTooltips(item, backSprite, false);
                this.processSprite(backSprite, item, this.isRewardShop != false ? null : Controls.newTextraLabel("[%200]" + reward.getCount() + " " + (Object)reward.type), 0, this.isRewardShop != false ? 0 : -10, false);
                this.needsToBeDisposed = true;
                break;
            }
        }
        if (GuiBase.isAndroid() || Forge.hasGamepad()) {
            this.addListener(new ClickListener(){

                @Override
                public void clicked(InputEvent event, float x, float y) {
                    if (RewardActor.this.flipOnClick) {
                        RewardActor.this.flip();
                    }
                }

                @Override
                public void enter(InputEvent event, float x, float y, int pointer, Actor fromActor) {
                    RewardActor.this.hover = true;
                }

                @Override
                public void exit(InputEvent event, float x, float y, int pointer, Actor fromActor) {
                    RewardActor.this.hover = false;
                }

                @Override
                public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                    RewardActor.this.hover = true;
                    return super.touchDown(event, x, y, pointer, button);
                }

                @Override
                public void touchUp(InputEvent event, float x, float y, int pointer, int button) {
                    RewardActor.this.hover = false;
                    super.touchUp(event, x, y, pointer, button);
                }
            });
        } else {
            this.addListener(new ClickListener(){

                @Override
                public void clicked(InputEvent event, float x, float y) {
                    if (RewardActor.this.flipOnClick) {
                        RewardActor.this.flip();
                    }
                    if (RewardActor.this.frontSideUp()) {
                        RewardActor.this.alternate = !RewardActor.this.alternate;
                    }
                    RewardActor.this.switchTooltip();
                }

                @Override
                public void enter(InputEvent event, float x, float y, int pointer, Actor fromActor) {
                    RewardActor.this.hover = true;
                }

                @Override
                public void exit(InputEvent event, float x, float y, int pointer, Actor fromActor) {
                    RewardActor.this.hover = false;
                }
            });
        }
    }

    private Texture getRenderedBackface(Reward r) {
        if (this.Talt == null) {
            this.Talt = this.renderPlaceholder(new Graphics(), r.getCard(), true);
        }
        return this.Talt;
    }

    private void generateBackFace(Reward r, Texture t2) {
        try {
            if (this.holdTooltip != null && ((HoldTooltip)this.holdTooltip).tooltip_actor.getChildren().size <= 2) {
                this.holdTooltip.tooltip_actor.altcImage = new RewardImage(this.processDrawable(t2));
                this.holdTooltip.tooltip_actor.addActorAt(2, this.holdTooltip.tooltip_actor.altcImage);
                this.holdTooltip.tooltip_actor.swapActor(this.holdTooltip.tooltip_actor.altcImage, this.holdTooltip.tooltip_actor.cImage);
            }
        }
        catch (Exception e) {
            System.err.println("Failed to load alternate image: " + r.getCard());
        }
    }

    private void switchTooltip() {
        if (!Reward.Type.Card.equals((Object)this.reward.type)) {
            return;
        }
        if (!this.reward.getCard().hasBackFace()) {
            return;
        }
        if (GuiBase.isAndroid() || Forge.hasGamepad()) {
            if (this.holdTooltip.tooltip_actor.altcImage != null) {
                this.holdTooltip.tooltip_actor.swapActor(this.holdTooltip.tooltip_actor.cImage, this.holdTooltip.tooltip_actor.altcImage);
            }
        } else {
            Texture alt = ImageCache.getImage(this.reward.getCard().getImageKey(true), false);
            if (this.hover) {
                if (this.alternate) {
                    if (alt != null) {
                        this.tooltip.setActor(new ComplexTooltip(new RewardImage(this.processDrawable(alt))));
                    } else {
                        if (this.Talt == null) {
                            this.Talt = this.renderPlaceholder(new Graphics(), this.reward.getCard(), true);
                        }
                        this.tooltip.setActor(new ComplexTooltip(new RewardImage(this.processDrawable(this.Talt))));
                    }
                } else if (this.toolTipImage != null) {
                    this.tooltip.setActor(new ComplexTooltip(this.toolTipImage));
                }
            }
        }
    }

    private TextureRegionDrawable processDrawable(Texture texture) {
        Float custom;
        TextureRegionDrawable drawable = new TextureRegionDrawable(ImageCache.croppedBorderImage(texture));
        float origW = texture.getWidth();
        float origH = texture.getHeight();
        float boundW = (float)Scene.getIntendedWidth() * 0.95f;
        float boundH = (float)Scene.getIntendedHeight() * 0.95f;
        float newW = origW;
        float newH = origH;
        if (origW > boundW) {
            newW = boundW;
            newH = newW * origH / origW;
        }
        if (newH > boundH) {
            newH = boundH;
            newW = newH * origW / origH;
        }
        float AR = 1.7777778f;
        int x = Forge.getDeviceAdapter().getRealScreenSize(false).getLeft();
        int y = Forge.getDeviceAdapter().getRealScreenSize(false).getRight();
        int realX = Forge.getDeviceAdapter().getRealScreenSize(true).getLeft();
        int realY = Forge.getDeviceAdapter().getRealScreenSize(true).getRight();
        if (realX > x) {
            x = (int)((float)x * 1.1f);
        } else if (realY > y) {
            y = (int)((float)y * 1.1f);
        }
        float fW = Math.max(x, y);
        float fH = Math.min(x, y);
        float mul = fW / fH < AR ? AR / (fW / fH) : fW / fH / AR;
        Float f = custom = Forge.isLandscapeMode() ? Config.instance().getSettingData().cardTooltipAdjLandscape : Config.instance().getSettingData().cardTooltipAdj;
        if (custom != null && custom.floatValue() != 1.0f) {
            mul *= custom.floatValue();
        } else if (fW / fH >= 2.0f) {
            mul = fW / fH - fW / fH / AR;
            if (fW / fH >= 2.1f && fW / fH < 2.2f) {
                mul *= 0.9f;
            } else if (fW / fH > 2.2f) {
                mul *= 0.8f;
            }
        }
        if (Forge.isLandscapeMode()) {
            drawable.setMinSize(newW * mul, newH);
        } else {
            drawable.setMinSize(newW, newH * mul);
        }
        return drawable;
    }

    private void setCardImage(Texture img) {
        if (img == null) {
            return;
        }
        this.image = img;
        if (Forge.isTextureFilteringEnabled()) {
            this.image.setFilter(Texture.TextureFilter.MipMapLinearLinear, Texture.TextureFilter.Linear);
        }
        if (this.toolTipImage == null) {
            this.toolTipImage = new RewardImage(this.processDrawable(this.image));
        }
        if (GuiBase.isAndroid() || Forge.hasGamepad()) {
            if (this.holdTooltip == null) {
                this.holdTooltip = new HoldTooltip(new ComplexTooltip(this.toolTipImage));
            }
            this.addListener(this.holdTooltip);
        } else {
            if (this.tooltip == null) {
                this.tooltip = new ImageToolTip(new ComplexTooltip(this.toolTipImage));
            }
            this.tooltip.setInstant(true);
            this.addListener(this.tooltip);
        }
    }

    public void showTooltip() {
        if (this.holdTooltip != null) {
            this.holdTooltip.show();
        }
    }

    public void hideTooltip() {
        if (this.holdTooltip != null) {
            this.holdTooltip.hide();
        }
    }

    private Texture renderPlaceholder(Graphics g2, PaperCard card, boolean alternate) {
        if (this.renderedCount < 1) {
            ++this.renderedCount;
            g2.begin(488.0f, 680.0f);
            CardImageRenderer.drawCardImage(g2, CardView.getCardForUi(this.reward.getCard()), false, -508.0f, 0.0f, 488.0f, 680.0f, CardRenderer.CardStackPosition.Top, Forge.allowCardBG, true);
            g2.end();
        }
        Matrix4 m4 = new Matrix4();
        FrameBuffer frameBuffer = new FrameBuffer(Pixmap.Format.RGB888, 488, 680, false);
        frameBuffer.begin();
        m4.setToOrtho2D(0.0f, 680.0f, 488.0f, -680.0f);
        g2.begin(488.0f, 680.0f);
        g2.setProjectionMatrix(m4);
        g2.startClip();
        CardImageRenderer.drawCardImage(g2, CardView.getCardForUi(card), alternate, 0.0f, 0.0f, 488.0f, 680.0f, CardRenderer.CardStackPosition.Top, Forge.allowCardBG, true);
        g2.end();
        g2.endClip();
        Pixmap pixmap = Pixmap.createFromFrameBuffer(0, 0, 488, 680);
        Texture result = new Texture(pixmap, Forge.isTextureFilteringEnabled());
        frameBuffer.end();
        g2.dispose();
        frameBuffer.dispose();
        pixmap.dispose();
        return result;
    }

    private void processSprite(Sprite sprite, Sprite item, TextraLabel itemText, int modX, int modY, boolean isBooster) {
        int pw = 192;
        int ph = 256;
        FrameBuffer frameBuffer = new FrameBuffer(Pixmap.Format.RGB888, pw, ph, false);
        SpriteBatch batch = new SpriteBatch();
        frameBuffer.begin();
        Gdx.gl.glClearColor(0.0f, 0.0f, 0.0f, 0.0f);
        Gdx.gl.glClear(16384);
        Matrix4 matrix = new Matrix4();
        matrix.setToOrtho2D(0.0f, ph, pw, -ph);
        batch.setProjectionMatrix(matrix);
        batch.begin();
        batch.draw(sprite, 0.0f, 0.0f, (float)pw, (float)ph);
        if (item != null) {
            if (!isBooster) {
                float iw = item.getWidth() * 4.0f;
                float ih = item.getHeight() * 4.0f;
                batch.draw(item, (float)pw / 2.0f - iw / 2.0f, (float)ph / 2.0f - ih / 2.0f, iw, ih);
            } else {
                batch.draw(item, (float)pw / 4.0f, (float)ph / 4.0f, (float)pw / 2.0f, (float)ph / 2.0f);
            }
        }
        if (itemText != null) {
            itemText.setWrap(true);
            itemText.setAlignment(1);
            itemText.setWidth(pw);
            itemText.setHeight(ph);
            itemText.setX(itemText.getX() + (float)(modX * 4));
            itemText.setY(itemText.getY() + (float)(modY * 8));
            itemText.draw(batch, 1.0f);
        }
        batch.end();
        Pixmap pixmap = Pixmap.createFromFrameBuffer(0, 0, pw, ph);
        this.image = new Texture(pixmap);
        frameBuffer.end();
        batch.dispose();
        pixmap.dispose();
        frameBuffer.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setItemTooltips(Sprite icon, Sprite backSprite, boolean isBooster) {
        int align = 8;
        if (this.generatedTooltip == null) {
            Matrix4 m4 = new Matrix4();
            GlyphLayout layout = new GlyphLayout();
            ItemData item = this.getReward().getItem();
            boolean itemExists = item != null;
            FrameBuffer frameBuffer = new FrameBuffer(Pixmap.Format.RGBA8888, 488, 680, false);
            frameBuffer.begin();
            try {
                m4.setToOrtho2D(0.0f, 680.0f, 488.0f, -680.0f);
                this.getGraphics().begin(488.0f, 680.0f);
                this.getGraphics().setProjectionMatrix(m4);
                this.getGraphics().startClip();
                this.getGraphics().drawImage(backSprite, 0.0f, 0.0f, 488.0f, 680.0f);
                if (!isBooster) {
                    this.getGraphics().drawImage(icon, 169.0f, 160.0f, 160.0f, 160.0f);
                } else {
                    this.getGraphics().drawImage(icon, 0.0f, 0.0f, 488.0f, 680.0f);
                }
                float div = 1.3934426f;
                BitmapFont font = Controls.getBitmapFont("default", 4.0f / div);
                layout.setText(font, itemExists ? item.name : this.getReward().type.name(), Color.WHITE, 424.0f, 1, true);
                this.getGraphics().drawText(font, layout, 32.0f, 610.0f);
                int n = align = itemExists ? 10 : 2;
                if (itemExists) {
                    this.description = item.getDescription();
                    layout.reset();
                } else {
                    this.description = this.getReward().getDeck() != null ? this.getReward().getDeck().getName() : "Adds " + this.getReward().getCount() + " " + (Object)((Object)this.getReward().type);
                }
                if (itemExists && this.description.isEmpty() && item.questItem) {
                    this.description = "Quest Item";
                }
                this.getGraphics().end();
                this.getGraphics().endClip();
                Pixmap pixmap = Pixmap.createFromFrameBuffer(0, 0, 488, 680);
                this.generatedTooltip = new Texture(pixmap, Forge.isTextureFilteringEnabled());
                pixmap.dispose();
            }
            catch (Exception exception) {
            }
            finally {
                frameBuffer.end();
                this.getGraphics().dispose();
                frameBuffer.dispose();
                Controls.getBitmapFont("default");
            }
        }
        if (this.toolTipImage == null) {
            this.toolTipImage = new RewardImage(this.processDrawable(this.generatedTooltip));
        }
        if (GuiBase.isAndroid() || Forge.hasGamepad()) {
            if (this.holdTooltip == null) {
                this.holdTooltip = new HoldTooltip(new ComplexTooltip(this.toolTipImage, align));
            }
            this.addListener(this.holdTooltip);
        } else {
            if (this.tooltip == null) {
                this.tooltip = new ImageToolTip(new ComplexTooltip(this.toolTipImage, align));
                this.tooltip.setInstant(true);
            }
            this.addListener(this.tooltip);
        }
    }

    private boolean frontSideUp() {
        return this.flipProcess >= 0.5f == this.flipOnClick;
    }

    public boolean isFlipped() {
        return this.clicked && this.flipProcess >= 1.0f;
    }

    public void removeTooltip() {
        if (this.tooltip != null && this.tooltip.getActor() != null) {
            ((ComplexTooltip)this.tooltip.getActor()).remove();
        }
    }

    public void clearHoldToolTip() {
        if (this.holdTooltip != null) {
            try {
                this.hover = false;
                this.holdTooltip.tooltip_actor.clear();
                this.holdTooltip.tooltip_actor.remove();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.autoSell != null) {
            this.autoSell.remove();
        }
    }

    public void flip() {
        if (this.clicked) {
            return;
        }
        this.clicked = true;
        this.flipProcess = 0.0f;
        SoundSystem.instance.play(SoundEffectType.FlipCard, false);
        if (this.isLoot && this.autoSell != null) {
            this.autoSell.setPosition(this.getX(), this.getY());
            this.getStage().addActor(this.autoSell);
            this.autoSell.setVisible(false);
        }
    }

    public void sold() {
        if (this.sold) {
            return;
        }
        this.sold = true;
        this.getColor().a = 0.5f;
    }

    @Override
    public void act(float delta) {
        super.act(delta);
        if (this.clicked) {
            this.flipProcess = this.flipProcess < 1.0f ? (float)((double)this.flipProcess + (double)delta * 2.4) : 1.0f;
            if (GuiBase.isAndroid() || Forge.hasGamepad()) {
                if (this.holdTooltip != null && !this.getListeners().contains(this.holdTooltip, true)) {
                    this.addListener(this.holdTooltip);
                }
            } else if (this.tooltip != null && !this.getListeners().contains(this.tooltip, true)) {
                this.addListener(this.tooltip);
            }
            if (this.autoSell != null && !this.autoSell.isVisible() && this.flipProcess == 1.0f) {
                this.autoSell.setVisible(true);
            }
        }
    }

    @Override
    public void draw(Batch batch, float parentAlpha) {
        this.applyTransform(batch, this.computeTransform(batch.getTransformMatrix().cpy()));
        this.oldProjectionTransform.set(batch.getProjectionMatrix());
        this.applyProjectionMatrix(batch);
        if (this.hover | this.hasKeyboardFocus()) {
            batch.setColor(0.5f, 0.5f, 0.5f, 1.0f);
        }
        if (!this.frontSideUp()) {
            if (this.flipOnClick) {
                batch.draw(this.backTexture, -this.getWidth() / 2.0f, -this.getHeight() / 2.0f, this.getWidth(), this.getHeight());
            } else {
                batch.draw(this.backTexture, this.getWidth() / 2.0f, -this.getHeight() / 2.0f, -this.getWidth(), this.getHeight());
            }
        } else {
            this.drawFrontSide(batch);
        }
        batch.setColor(1.0f, 1.0f, 1.0f, 1.0f);
        this.resetTransform(batch);
        batch.setProjectionMatrix(this.oldProjectionTransform);
        if (this.showOverlay && Config.instance().getSettingData().showShopOverlay) {
            if (this.overlayLabel == null) {
                this.setOverlayLabel();
            }
            if (this.overlayLabel != null) {
                this.overlayLabel.draw(batch, parentAlpha);
            }
        }
    }

    private void setOverlayLabel() {
        String display = "";
        int alignment = 2;
        String labelStyle = "background";
        if (this.reward == null) {
            return;
        }
        Reward.Type rewardType = this.reward.getType();
        switch (rewardType) {
            case Card: {
                display = this.reward.getCard() != null ? CardTranslation.getTranslatedName(this.reward.getCard().getName()) : "";
                labelStyle = "dialog";
                break;
            }
            case Life: 
            case Shards: 
            case Gold: {
                display = this.reward.type.toString();
                break;
            }
            case Item: {
                display = this.reward.getItem() != null ? this.reward.getItem().name : "";
                break;
            }
            case CardPack: {
                display = this.reward.getDeck() != null ? "Card Pack (" + this.reward.getDeck().getComment() + ")" : "";
                break;
            }
        }
        this.overlayLabel = Controls.newRewardLabel("[%98]" + display);
        this.overlayLabel.setWidth(this.getWidth());
        this.overlayLabel.setWrap(true);
        this.overlayLabel.setAlignment(alignment);
        this.overlayLabel.style = Controls.getSkin().get(labelStyle, Label.LabelStyle.class);
        this.overlayLabel.layout();
        this.overlayLabel.setHeight(this.overlayLabel.layout.getHeight());
        this.overlayLabel.setPosition(this.getX(), this.getY(2) - this.overlayLabel.layout.getHeight());
    }

    private void drawFrontSide(Batch batch) {
        float x;
        float width;
        if (this.flipOnClick) {
            width = -this.getWidth();
            x = -this.getWidth() / 2.0f + this.getWidth();
        } else {
            width = this.getWidth();
            x = -this.getWidth() / 2.0f;
        }
        if (Reward.Type.Card.equals((Object)this.reward.getType())) {
            if (this.image != null) {
                this.drawCard(batch, this.image, x, width);
            } else if (!this.loaded) {
                if (this.T == null) {
                    this.T = this.renderPlaceholder(new Graphics(), this.reward.getCard(), false);
                }
                this.drawCard(batch, this.T, x, width);
            }
        } else if (this.image != null) {
            batch.draw(this.image, x, -this.getHeight() / 2.0f, width, this.getHeight());
        }
    }

    private void drawCard(Batch batch, Texture image, float x, float width) {
        if (image != null) {
            if (image.toString().contains(".fullborder.") && Forge.enableUIMask.equals("Full")) {
                batch.end();
                this.shaderRoundRect.bind();
                this.shaderRoundRect.setUniformf("u_resolution", (float)image.getWidth(), (float)image.getHeight());
                this.shaderRoundRect.setUniformf("edge_radius", (float)(image.getHeight() / image.getWidth()) * 20.0f);
                this.shaderRoundRect.setUniformf("u_gray", this.sold ? 1.0f : 0.0f);
                batch.setShader(this.shaderRoundRect);
                batch.begin();
                batch.draw(image, x, -this.getHeight() / 2.0f, width, this.getHeight());
                batch.end();
                batch.setShader(null);
                batch.begin();
            } else if (!this.sold) {
                batch.draw(ImageCache.croppedBorderImage(image), x, -this.getHeight() / 2.0f, width, this.getHeight());
            } else {
                batch.end();
                this.shaderGrayscale.bind();
                this.shaderGrayscale.setUniformf("u_grayness", 1.0f);
                this.shaderGrayscale.setUniformf("u_bias", 0.7f);
                batch.setShader(this.shaderGrayscale);
                batch.begin();
                batch.draw(ImageCache.croppedBorderImage(image), x, -this.getHeight() / 2.0f, width, this.getHeight());
                batch.end();
                batch.setShader(null);
                batch.begin();
            }
            if (this.hasbackface) {
                TextureRegion icon = FSkinImage.ADV_FLIPICON.getTextureRegion();
                float scale = this.getHeight() / 4.0f;
                batch.draw(icon, this.getOriginX() - scale / 2.0f, this.getOriginY() - scale / 2.0f, scale, scale);
            }
        }
    }

    private Graphics getGraphics() {
        if (this.graphics == null) {
            this.graphics = new Graphics();
        }
        return this.graphics;
    }

    private void applyProjectionMatrix(Batch batch) {
        Vector3 direction = new Vector3(0.0f, 0.0f, -1.0f);
        Vector3 up = new Vector3(0.0f, 1.0f, 0.0f);
        Vector3 position = new Vector3((float)Scene.getIntendedWidth() / 2.0f, (float)Scene.getIntendedHeight() / 2.0f, 0.0f);
        float fov = 67.0f;
        Matrix4 projection = new Matrix4();
        Matrix4 view = new Matrix4();
        float hy = (float)Scene.getIntendedHeight() / 2.0f;
        float a = (float)((double)hy / Math.sin((float)Math.PI / 180 * (fov / 2.0f)));
        float height = (float)Math.sqrt(a * a - hy * hy);
        position.z = height * 1.0f;
        float far = height * 2.0f;
        float near = height * 0.8f;
        float aspect = (float)Scene.getIntendedWidth() / (float)Scene.getIntendedHeight();
        projection.setToProjection(Math.abs(near), Math.abs(far), fov, aspect);
        view.setToLookAt(position, position.cpy().add(direction), up);
        Matrix4.mul(projection.val, view.val);
        batch.setProjectionMatrix(projection);
    }

    protected void applyTransform(Batch batch, Matrix4 transform) {
        this.oldTransform.set(batch.getTransformMatrix());
        batch.setTransformMatrix(transform);
    }

    protected void resetTransform(Batch batch) {
        batch.setTransformMatrix(this.oldTransform);
    }

    protected Matrix4 computeTransform(Matrix4 worldTransform) {
        float[] val = worldTransform.getValues();
        worldTransform.set(val);
        float originX = this.getOriginX();
        float originY = this.getOriginY();
        worldTransform.translate(this.getX() + this.getWidth() / 2.0f, this.getY() + this.getHeight() / 2.0f, 0.0f);
        if (this.clicked) {
            worldTransform.rotate(0.0f, 1.0f, 0.0f, 180.0f * this.flipProcess);
        }
        this.computedTransform.set(worldTransform);
        return this.computedTransform;
    }

    class RewardImage
    extends Image {
        public RewardImage(TextureRegionDrawable processDrawable) {
            this.setDrawable(processDrawable);
            this.setScaling(Scaling.stretch);
            this.setAlign(1);
        }

        @Override
        public void draw(Batch batch, float parentAlpha) {
            try {
                TextureRegion tr;
                Texture t2;
                if (this.getDrawable() instanceof TextureRegionDrawable && (t2 = (tr = ((TextureRegionDrawable)this.getDrawable()).getRegion()).getTexture()) != null) {
                    float h2;
                    float x = GuiBase.isAndroid() || Forge.hasGamepad() ? (float)Scene.getIntendedWidth() / 2.0f - RewardActor.this.holdTooltip.tooltip_actor.getWidth() / 2.0f : ((ComplexTooltip)RewardActor.this.tooltip.getActor()).getStoredImage().getImageX();
                    float y = GuiBase.isAndroid() || Forge.hasGamepad() ? (float)Scene.getIntendedHeight() / 2.0f - RewardActor.this.holdTooltip.tooltip_actor.getHeight() / 2.0f : ((ComplexTooltip)RewardActor.this.tooltip.getActor()).getStoredImage().getImageY();
                    float w = GuiBase.isAndroid() || Forge.hasGamepad() ? RewardActor.this.holdTooltip.tooltip_actor.getStoredImage().getPrefWidth() : ((ComplexTooltip)RewardActor.this.tooltip.getActor()).getStoredImage().getPrefWidth();
                    float f = h2 = GuiBase.isAndroid() || Forge.hasGamepad() ? RewardActor.this.holdTooltip.tooltip_actor.getStoredImage().getPrefHeight() : ((ComplexTooltip)RewardActor.this.tooltip.getActor()).getStoredImage().getPrefHeight();
                    if (t2.toString().contains(".fullborder.") && Forge.enableUIMask.equals("Full")) {
                        batch.end();
                        RewardActor.this.shaderRoundRect.bind();
                        RewardActor.this.shaderRoundRect.setUniformf("u_resolution", (float)t2.getWidth(), (float)t2.getHeight());
                        RewardActor.this.shaderRoundRect.setUniformf("edge_radius", (float)(t2.getHeight() / t2.getWidth()) * (float)ImageCache.getRadius(t2));
                        RewardActor.this.shaderRoundRect.setUniformf("u_gray", RewardActor.this.sold ? 0.8f : 0.0f);
                        batch.setShader(RewardActor.this.shaderRoundRect);
                        batch.begin();
                        batch.draw(t2, x, y, w, h2);
                        batch.end();
                        batch.setShader(null);
                        batch.begin();
                    } else {
                        batch.end();
                        RewardActor.this.shaderGrayscale.bind();
                        RewardActor.this.shaderGrayscale.setUniformf("u_grayness", RewardActor.this.sold ? 1.0f : 0.0f);
                        RewardActor.this.shaderGrayscale.setUniformf("u_bias", RewardActor.this.sold ? 0.8f : 1.0f);
                        batch.setShader(RewardActor.this.shaderGrayscale);
                        batch.begin();
                        batch.draw(tr, x, y, w, h2);
                        batch.end();
                        batch.setShader(null);
                        batch.begin();
                    }
                    return;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            super.draw(batch, parentAlpha);
        }
    }

    class HoldTooltip
    extends ActorGestureListener {
        private ComplexTooltip tooltip_actor;
        private TextraButton switchButton;

        public HoldTooltip(ComplexTooltip complexTooltip) {
            this.tooltip_actor = complexTooltip;
            this.switchButton = Controls.newTextButton("[+Flip]");
            this.switchButton.addListener(new ClickListener(){

                @Override
                public void clicked(InputEvent event, float x, float y) {
                    RewardActor.this.alternate = !RewardActor.this.alternate;
                    RewardActor.this.switchTooltip();
                    super.clicked(event, x, y);
                }
            });
            this.getGestureDetector().setLongPressSeconds(0.1f);
        }

        public Image getImage() {
            return this.tooltip_actor.getStoredImage();
        }

        @Override
        public boolean longPress(Actor actor, float x, float y) {
            if (!RewardActor.this.frontSideUp()) {
                return false;
            }
            this.show();
            return super.longPress(actor, x, y);
        }

        @Override
        public void touchUp(InputEvent event, float x, float y, int pointer, int button) {
            this.hide();
            super.touchUp(event, x, y, pointer, button);
        }

        @Override
        public void tap(InputEvent event, float x, float y, int count, int button) {
            if (count > 1) {
                RewardActor.this.alternate = !RewardActor.this.alternate;
                RewardActor.this.switchTooltip();
            }
            super.tap(event, x, y, count, button);
        }

        public void show() {
            if (!RewardActor.this.frontSideUp()) {
                return;
            }
            this.tooltip_actor.setBounds(this.tooltip_actor.cImage.getX(), this.tooltip_actor.cImage.getY(), this.tooltip_actor.cImage.getPrefWidth(), this.tooltip_actor.cImage.getPrefHeight());
            this.tooltip_actor.cLabel.setX((float)Scene.getIntendedWidth() / 2.0f - this.tooltip_actor.width / 2.0f);
            this.tooltip_actor.cLabel.setY((float)Scene.getIntendedHeight() / 2.0f - this.tooltip_actor.inset);
            RewardActor.this.getStage().addActor(this.tooltip_actor);
            TextraButton done = (TextraButton)RewardActor.this.getStage().getRoot().findActor("done");
            if (done != null && Reward.Type.Card.equals((Object)RewardActor.this.reward.type)) {
                this.switchButton.setBounds(done.getX(), done.getY(), done.getWidth(), done.getHeight());
                if (RewardActor.this.reward.getCard().hasBackFace()) {
                    RewardActor.this.getStage().addActor(this.switchButton);
                }
            }
            RewardActor.this.shown = true;
        }

        public void hide() {
            if (this.tooltip_actor != null) {
                this.tooltip_actor.remove();
            }
            if (this.switchButton != null) {
                this.switchButton.remove();
            }
            RewardActor.this.shown = false;
        }
    }

    class ImageToolTip
    extends Tooltip<ComplexTooltip> {
        public ImageToolTip(ComplexTooltip contents) {
            super(contents);
        }

        public Image getImage() {
            return ((ComplexTooltip)this.getActor()).getStoredImage();
        }

        @Override
        public void enter(InputEvent event, float x, float y, int pointer, Actor fromActor) {
            if (!RewardActor.this.frontSideUp()) {
                return;
            }
            super.enter(event, x, y, pointer, fromActor);
        }
    }

    class ComplexTooltip
    extends Group {
        private TextraLabel cLabel;
        private Image cImage;
        private Image altcImage;
        private float inset;
        private float width;
        private float x;
        private float y;
        private int ARP;

        public ComplexTooltip(Image i) {
            this(i, 8);
        }

        public ComplexTooltip(Image i, int align) {
            this.cImage = i;
            this.setSize(this.cImage.getPrefWidth(), this.cImage.getPrefHeight());
            this.setPosition(0.0f, 0.0f, 1);
            this.inset = this.cImage.getPrefWidth() * 0.13f;
            this.width = this.cImage.getPrefWidth() - this.inset * 2.0f;
            this.x = this.cImage.getX() + this.inset;
            this.y = this.cImage.getPrefHeight() / 2.3f;
            this.ARP = Forge.isLandscapeMode() ? 100 : 150;
            this.cLabel = new TextraLabel("[%" + this.ARP + "]" + RewardActor.this.description, Controls.getSkin(), Controls.getTextraFont());
            this.cLabel.setAlignment(align);
            this.cLabel.setWrap(true);
            this.cLabel.setWidth(this.width);
            this.cLabel.setX(this.x);
            this.cLabel.setY(this.y);
            this.addActorAt(0, this.cImage);
            this.addActorAt(1, this.cLabel);
        }

        public Image getStoredImage() {
            return this.cImage;
        }

        public TextraLabel getStoredLabel() {
            return this.cLabel;
        }
    }
}

