/*
 * Decompiled with CFR 0.152.
 */
package forge.adventure.util;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.audio.Music;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.g2d.Sprite;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.ui.Dialog;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Timer;
import com.github.tommyettinger.textra.TextraButton;
import com.github.tommyettinger.textra.TypingAdapter;
import com.github.tommyettinger.textra.TypingLabel;
import forge.Forge;
import forge.adventure.character.CharacterSprite;
import forge.adventure.character.EnemySprite;
import forge.adventure.data.AdventureQuestData;
import forge.adventure.data.DialogData;
import forge.adventure.data.RewardData;
import forge.adventure.player.AdventurePlayer;
import forge.adventure.scene.RewardScene;
import forge.adventure.stage.GameHUD;
import forge.adventure.stage.MapStage;
import forge.adventure.util.Config;
import forge.adventure.util.Controls;
import forge.adventure.util.Current;
import forge.adventure.util.JSONStringLoader;
import forge.adventure.util.Reward;
import forge.adventure.world.WorldSave;
import forge.card.ColorSet;
import forge.localinstance.properties.ForgePreferences;
import forge.model.FModel;
import forge.util.Localizer;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.tuple.Pair;

public class MapDialog {
    private final MapStage stage;
    private Array<DialogData> data;
    private final int parentID;
    private static final float WIDTH = 250.0f;
    public String questAccepted = "";
    private static final String defaultJSON = "[\n  {\n    \"name\":\"Error\",\n    \"text\":\"This is a fallback dialog.\\nPlease check Forge logs for errors.\",\n    \"condition\":[],\n    \"options\":[\n        { \"name\":\"OK\" }\n    ]\n  }\n]";
    Pair<FileHandle, Music> audio = null;
    protected List<ChangeListener> dialogCompleteList = new ArrayList<ChangeListener>();
    protected List<ChangeListener> questAcceptedList = new ArrayList<ChangeListener>();

    public MapDialog(String S, MapStage stage, int parentID) {
        this.stage = stage;
        this.parentID = parentID;
        try {
            if (S.isEmpty()) {
                System.err.print("Dialog error. Dialog property is empty.\n");
                this.data = JSONStringLoader.parse(Array.class, DialogData.class, defaultJSON, defaultJSON);
                return;
            }
            this.data = JSONStringLoader.parse(Array.class, DialogData.class, S, defaultJSON);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public MapDialog(DialogData prebuiltDialog, MapStage stage, int parentID, final AdventureQuestData prebuiltQuestData) {
        this.stage = stage;
        this.parentID = parentID;
        try {
            if (prebuiltDialog == null) {
                System.err.print("Dialog error. Dialog provided is null.\n");
                this.data = JSONStringLoader.parse(Array.class, DialogData.class, defaultJSON, defaultJSON);
                return;
            }
            this.data = new Array();
            this.data.add(prebuiltDialog);
            ChangeListener listen = new ChangeListener(){

                @Override
                public void changed(ChangeListener.ChangeEvent changeEvent, Actor actor) {
                    if (prebuiltQuestData != null && Integer.parseInt(MapDialog.this.questAccepted) == prebuiltQuestData.getID()) {
                        Current.player().addQuest(prebuiltQuestData);
                    } else {
                        Current.player().addQuest(MapDialog.this.questAccepted);
                    }
                }
            };
            this.addQuestAcceptedListener(listen);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    void unload() {
        if (this.audio != null) {
            this.audio.getRight().setOnCompletionListener(null);
            this.audio.getRight().stop();
            Forge.getAssets().manager().unload(this.audio.getLeft().path());
            this.audio = null;
        }
    }

    void disposeAudio() {
        this.disposeAudio(false);
    }

    void disposeAudio(boolean fadeout) {
        if (fadeout) {
            final float[] v = new float[]{1.0f};
            for (int i = 10; i > 1; --i) {
                float delay = (float)i * 0.1f;
                final float j = i;
                Timer.schedule(new Timer.Task(){

                    @Override
                    public void run() {
                        v[0] = v[0] - 0.1f;
                        if (v[0] < 0.1f) {
                            v[0] = 0.1f;
                        }
                        if (MapDialog.this.audio != null && j == 2.0f) {
                            MapDialog.this.unload();
                        } else if (MapDialog.this.audio != null && j == 10.0f) {
                            MapDialog.this.audio.getRight().setVolume(v[0]);
                        }
                    }
                }, delay);
            }
        } else {
            this.unload();
        }
    }

    private boolean loadDialog(DialogData dialog) {
        float width;
        this.setEffects(dialog.action);
        if (dialog.options.length == 0 && dialog.text.isEmpty() && dialog.action.length > 0) {
            this.stage.hideDialog();
            this.emitDialogFinished();
            return false;
        }
        Dialog D = this.stage.getDialog();
        Localizer L = Forge.getLocalizer();
        D.getTitleTable().clear();
        D.getContentTable().clear();
        D.getButtonTable().clear();
        D.clearListeners();
        Sprite sprite = null;
        Actor actor = this.stage.getByID(this.parentID);
        if (actor instanceof CharacterSprite) {
            sprite = ((CharacterSprite)actor).getAvatar();
        }
        String text = dialog.loctext != null && !dialog.loctext.isEmpty() ? L.getMessage(dialog.loctext, new Object[0]) : dialog.text;
        this.disposeAudio();
        if (dialog.voiceFile != null) {
            FileHandle file = Gdx.files.absolute(Config.instance().getFilePath(dialog.voiceFile));
            if (file.exists()) {
                this.audio = Pair.of(file, Forge.getAssets().getMusic(file));
            }
            if (this.audio != null) {
                int vol = FModel.getPreferences().getPrefInt(ForgePreferences.FPref.UI_VOL_MUSIC);
                if (vol > 0) {
                    this.fadeOut();
                    this.audio.getRight().setOnCompletionListener(music -> this.fadeIn());
                    this.audio.getRight().play();
                }
            } else {
                this.fadeIn();
            }
        } else {
            this.fadeIn();
        }
        final TypingLabel A2 = Controls.newTypingLabel(text);
        A2.setWrap(true);
        final Array<TextraButton> buttons = new Array<TextraButton>();
        A2.setTypingListener(new TypingAdapter(){

            @Override
            public void end() {
                float delay = 0.09f;
                for (final TextraButton button : buttons) {
                    Timer.schedule(new Timer.Task(){

                        @Override
                        public void run() {
                            button.setVisible(true);
                        }
                    }, delay);
                    delay += 0.1f;
                }
            }
        });
        if (sprite != null) {
            if (actor instanceof EnemySprite && !((EnemySprite)actor).hidden) {
                String name = actor.getName();
                TypingLabel label = Controls.newTypingLabel("[%?BLACKEN]-" + name + "-");
                label.skipToTheEnd();
                D.getTitleTable().add(label).left().expand();
            }
            D.getContentTable().add(new Image(sprite)).width(30.0f).height(30.0f).top();
            width = 220.0f;
        } else {
            width = 250.0f;
        }
        D.getContentTable().add(A2).width(width);
        if (dialog.options != null) {
            int i = 0;
            for (DialogData option : dialog.options) {
                TextraButton B;
                if (!this.isConditionOk(option.condition)) continue;
                String name = option.locname != null && !option.locname.isEmpty() ? L.getMessage(option.locname, new Object[0]) : option.name;
                if (option.isDisabled) {
                    B = Controls.newTextButton(name);
                    B.setDisabled(true);
                } else {
                    B = Controls.newTextButton(name, () -> this.loadDialog(option));
                }
                B.getTextraLabel().setWrap(true);
                buttons.add(B);
                B.setVisible(false);
                D.getButtonTable().add(B).width(240.0f);
                D.getButtonTable().row();
                ++i;
                B.setDisabled(option.isDisabled);
            }
            D.addListener(new ClickListener(){

                @Override
                public void clicked(InputEvent event, float x, float y) {
                    A2.skipToTheEnd();
                    super.clicked(event, x, y);
                }
            });
            if (i == 0) {
                this.stage.hideDialog();
                this.emitDialogFinished();
                return false;
            }
            this.stage.showDialog();
            return true;
        }
        this.stage.hideDialog();
        return false;
    }

    public void addDialogCompleteListener(ChangeListener listener) {
        this.dialogCompleteList.add(listener);
    }

    public void addQuestAcceptedListener(ChangeListener listener) {
        this.questAcceptedList.add(listener);
    }

    private void emitDialogFinished() {
        if (this.dialogCompleteList != null && this.dialogCompleteList.size() > 0) {
            ChangeListener.ChangeEvent evt = new ChangeListener.ChangeEvent();
            for (ChangeListener listener : this.dialogCompleteList) {
                listener.changed(evt, null);
            }
        }
    }

    private void emitQuestAccepted() {
        if (this.questAcceptedList != null && this.questAcceptedList.size() > 0) {
            ChangeListener.ChangeEvent evt = new ChangeListener.ChangeEvent();
            for (ChangeListener listener : this.questAcceptedList) {
                listener.changed(evt, null);
            }
        }
    }

    void fadeIn() {
        this.disposeAudio(true);
        GameHUD.getInstance().fadeIn();
    }

    void fadeOut() {
        GameHUD.getInstance().fadeOut();
    }

    public boolean activate() {
        boolean dialogShown = false;
        for (DialogData dialog : this.data) {
            if (!this.isConditionOk(dialog.condition) || !this.loadDialog(dialog)) continue;
            dialogShown = true;
        }
        return dialogShown;
    }

    void setEffects(DialogData.ActionData[] data) {
        if (data == null) {
            return;
        }
        for (DialogData.ActionData E : data) {
            if (E == null) continue;
            if (E.removeItem != null && !E.removeItem.isEmpty()) {
                Current.player().removeItem(E.removeItem);
            }
            if (E.addItem != null && !E.addItem.isEmpty()) {
                Current.player().addItem(E.addItem);
            }
            if (E.addLife != 0) {
                Current.player().heal(E.addLife);
            }
            if (E.addGold != 0) {
                if (E.addGold > 0) {
                    Current.player().giveGold(E.addGold);
                } else {
                    Current.player().takeGold(-E.addGold);
                }
            }
            if (E.addShards != 0) {
                if (E.addShards > 0) {
                    Current.player().giveGold(E.addShards);
                } else {
                    Current.player().takeGold(-E.addShards);
                }
            }
            if (E.addMapReputation != 0) {
                if (!E.POIReference.isEmpty() && !E.POIReference.contains("$")) {
                    WorldSave.getCurrentSave().getPointOfInterestChanges(E.POIReference).addMapReputation(E.addMapReputation);
                } else {
                    this.stage.getChanges().addMapReputation(E.addMapReputation);
                }
            }
            if (E.deleteMapObject != 0) {
                if (E.deleteMapObject < 0) {
                    this.stage.deleteObject(this.parentID);
                } else {
                    this.stage.deleteObject(E.deleteMapObject);
                }
            }
            if (E.activateMapObject != 0) {
                this.stage.activateMapObject(E.activateMapObject);
            }
            if (E.battleWithActorID != 0) {
                if (E.battleWithActorID < 0) {
                    this.stage.beginDuel(this.stage.getEnemyByID(this.parentID));
                } else {
                    this.stage.beginDuel(this.stage.getEnemyByID(E.battleWithActorID));
                }
            }
            if (E.giveBlessing != null) {
                Current.player().addBlessing(E.giveBlessing);
            }
            if (E.setColorIdentity != null && !E.setColorIdentity.isEmpty()) {
                Current.player().setColorIdentity(E.setColorIdentity);
            }
            if (E.setCharacterFlag != null && !E.setCharacterFlag.key.isEmpty()) {
                Current.player().setCharacterFlag(E.setCharacterFlag.key, E.setCharacterFlag.val);
            }
            if (E.advanceCharacterFlag != null && !E.advanceCharacterFlag.isEmpty()) {
                Current.player().advanceCharacterFlag(E.advanceCharacterFlag);
            }
            if (E.setQuestFlag != null && !E.setQuestFlag.key.isEmpty()) {
                Current.player().setQuestFlag(E.setQuestFlag.key, E.setQuestFlag.val);
            }
            if (E.advanceQuestFlag != null && !E.advanceQuestFlag.isEmpty()) {
                Current.player().advanceQuestFlag(E.advanceQuestFlag);
            }
            if (E.setMapFlag != null && !E.setMapFlag.key.isEmpty()) {
                this.stage.setQuestFlag(E.setMapFlag.key, E.setMapFlag.val);
            }
            if (E.advanceMapFlag != null && !E.advanceMapFlag.isEmpty()) {
                this.stage.advanceQuestFlag(E.advanceMapFlag);
            }
            if (E.setEffect != null) {
                EnemySprite EN = this.stage.getEnemyByID(this.parentID);
                EN.effect = E.setEffect;
            }
            if (E.grantRewards != null && E.grantRewards.length > 0) {
                Array<Reward> ret = new Array<Reward>();
                for (RewardData rdata : E.grantRewards) {
                    ret.addAll(rdata.generate(false, true));
                }
                RewardScene.instance().loadRewards(ret, RewardScene.Type.QuestReward, null);
                Forge.switchScene(RewardScene.instance());
            }
            if (E.issueQuest == null || E.issueQuest.isEmpty()) continue;
            this.questAccepted = E.issueQuest;
            this.emitQuestAccepted();
        }
    }

    public boolean canShow() {
        if (this.data == null) {
            return false;
        }
        for (DialogData dialog : this.data) {
            if (!this.isConditionOk(dialog.condition)) continue;
            return true;
        }
        return false;
    }

    public boolean isConditionOk(DialogData.ConditionData[] data) {
        if (data == null) {
            return true;
        }
        AdventurePlayer player = Current.player();
        for (DialogData.ConditionData condition : data) {
            int QF;
            int val;
            String cond;
            String key;
            if (condition.item != null && !condition.item.isEmpty() && (!player.hasItem(condition.item) ? !condition.not : condition.not)) {
                return false;
            }
            if (condition.colorIdentity != null && !condition.colorIdentity.isEmpty() && (player.getColorIdentity().hasAllColors(ColorSet.fromNames(condition.colorIdentity.toCharArray()).getColor()) ? !condition.not : condition.not)) {
                return false;
            }
            if (condition.hasGold != 0 && (player.getGold() < condition.hasGold ? !condition.not : condition.not)) {
                return false;
            }
            if (condition.hasShards != 0 && (player.getShards() < condition.hasShards ? !condition.not : condition.not)) {
                return false;
            }
            if (condition.hasLife != 0 && (player.getLife() < condition.hasLife + 1 ? !condition.not : condition.not)) {
                return false;
            }
            if (condition.hasMapReputation != Integer.MIN_VALUE && (this.stage.getChanges().getMapReputation() < condition.hasMapReputation + 1 ? !condition.not : condition.not)) {
                return false;
            }
            if (condition.hasBlessing != null && !condition.hasBlessing.isEmpty() && (!player.hasBlessing(condition.hasBlessing) ? !condition.not : condition.not)) {
                return false;
            }
            if (condition.actorID != 0 && (!this.stage.lookForID(condition.actorID) ? !condition.not : condition.not)) {
                return false;
            }
            if (condition.getCharacterFlag != null) {
                key = condition.getCharacterFlag.key;
                cond = condition.getCharacterFlag.op;
                val = condition.getCharacterFlag.val;
                QF = player.getCharacterFlag(key);
                if (!player.checkCharacterFlag(key)) {
                    return false;
                }
                if (!this.checkFlagCondition(QF, cond, val) ? !condition.not : condition.not) {
                    return false;
                }
            }
            if (condition.checkCharacterFlag != null && !condition.checkCharacterFlag.isEmpty() && (!player.checkCharacterFlag(condition.checkCharacterFlag) ? !condition.not : condition.not)) {
                return false;
            }
            if (condition.getQuestFlag != null) {
                key = condition.getQuestFlag.key;
                cond = condition.getQuestFlag.op;
                val = condition.getQuestFlag.val;
                QF = player.getQuestFlag(key);
                if (!player.checkQuestFlag(key)) {
                    return false;
                }
                if (!this.checkFlagCondition(QF, cond, val) ? !condition.not : condition.not) {
                    return false;
                }
            }
            if (condition.checkQuestFlag != null && !condition.checkQuestFlag.isEmpty() && (!player.checkQuestFlag(condition.checkQuestFlag) ? !condition.not : condition.not)) {
                return false;
            }
            if (condition.getMapFlag != null) {
                key = condition.getMapFlag.key;
                cond = condition.getMapFlag.op;
                val = condition.getMapFlag.val;
                QF = this.stage.getQuestFlag(key);
                if (!this.stage.checkQuestFlag(key)) {
                    return false;
                }
                if (!this.checkFlagCondition(QF, cond, val) ? !condition.not : condition.not) {
                    return false;
                }
            }
            if (condition.checkMapFlag == null || condition.checkMapFlag.isEmpty() || !(!this.stage.checkQuestFlag(condition.checkMapFlag) ? !condition.not : condition.not)) continue;
            return false;
        }
        return true;
    }

    private boolean checkFlagCondition(int flag, String condition, int value) {
        switch (condition.toUpperCase()) {
            default: {
                if (flag != value) break;
                return true;
            }
            case "LESSTHAN": 
            case "<": {
                if (flag >= value) break;
                return true;
            }
            case "MORETHAN": 
            case ">": {
                if (flag <= value) break;
                return true;
            }
            case "LE_THAN": 
            case "<=": {
                if (flag > value) break;
                return true;
            }
            case "ME_THAN": 
            case ">=": {
                if (flag < value) break;
                return true;
            }
        }
        return false;
    }
}

