/*
 * Decompiled with CFR 0.152.
 */
package forge.adventure.util;

import com.badlogic.gdx.Input;
import com.badlogic.gdx.controllers.Controller;
import com.badlogic.gdx.controllers.ControllerMapping;
import com.badlogic.gdx.controllers.Controllers;
import forge.gui.GuiBase;

public enum KeyBinding {
    Left("Left", 21, 21),
    Up("Up", 19, 19),
    Right("Right", 22, 22),
    Down("Down", 20, 20),
    Menu("Menu", 111, 108),
    Inventory("Inventory", 37, 99),
    Status("Status", 45, 100),
    Deck("Deck", 33, 96),
    Map("Map", 41, 109),
    Equip("Equip", 33, 99),
    ExitToWorldMap("ExitToWorldMap", 134, 104),
    Bookmark("Bookmark", 30, 105),
    Use("Use", 66, 96),
    Back("Back", 111, 97),
    ScrollUp("ScrollUp", 92, 102),
    ScrollDown("ScrollDown", 93, 103);

    String name;
    int binding;
    int defaultBinding;
    int bindingController;
    int defaultBindingController;
    static String controllerPrefix;

    private KeyBinding(String name, int defaultBinding, int defaultBindingController) {
        this.name = name;
        this.defaultBinding = this.binding = defaultBinding;
        this.defaultBindingController = this.bindingController = defaultBindingController;
    }

    public boolean isPressed(int key) {
        return key == this.binding || key == this.bindingController;
    }

    public String getLabelText(boolean pressed) {
        if (Controllers.getCurrent() != null) {
            return "[%120][+" + controllerPrefix + Input.Keys.toString(this.bindingController).replace(" Button", "") + (pressed ? "_pressed]" : "]");
        }
        if (GuiBase.isAndroid()) {
            return "";
        }
        return "[%120][+" + Input.Keys.toString(this.binding) + (pressed ? "_pressed]" : "]");
    }

    public static int controllerButtonToKey(Controller controller, int key) {
        ControllerMapping map = controller.getMapping();
        if (key == map.buttonA) {
            return 96;
        }
        if (key == map.buttonB) {
            return 97;
        }
        if (key == map.buttonX) {
            return 99;
        }
        if (key == map.buttonY) {
            return 100;
        }
        if (key == map.buttonBack) {
            return 109;
        }
        if (key == map.buttonStart) {
            return 108;
        }
        if (key == map.buttonL1) {
            return 102;
        }
        if (key == map.buttonL2) {
            return 104;
        }
        if (key == map.buttonR1) {
            return 103;
        }
        if (key == map.buttonR2) {
            return 105;
        }
        if (key == map.buttonDpadUp) {
            return 19;
        }
        if (key == map.buttonDpadDown) {
            return 20;
        }
        if (key == map.buttonDpadLeft) {
            return 21;
        }
        if (key == map.buttonDpadRight) {
            return 22;
        }
        if (key == map.buttonLeftStick) {
            return 106;
        }
        if (key == map.buttonRightStick) {
            return 107;
        }
        if (key == map.buttonDpadUp) {
            return 19;
        }
        if (key == map.buttonDpadDown) {
            return 20;
        }
        if (key == map.buttonDpadLeft) {
            return 21;
        }
        if (key == map.buttonDpadRight) {
            return 22;
        }
        return 0;
    }

    static {
        controllerPrefix = "XBox_";
    }
}

