/*
 * Decompiled with CFR 0.152.
 */
package forge.adventure.util;

import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.g2d.Sprite;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Json;
import com.badlogic.gdx.utils.JsonWriter;
import com.badlogic.gdx.utils.ObjectMap;
import forge.Forge;
import forge.ImageKeys;
import forge.adventure.data.ConfigData;
import forge.adventure.data.DifficultyData;
import forge.adventure.data.PointOfInterestData;
import forge.adventure.data.RewardData;
import forge.adventure.data.SettingData;
import forge.adventure.util.AdventureModes;
import forge.adventure.util.CardUtil;
import forge.card.CardEdition;
import forge.card.CardRarity;
import forge.card.CardRules;
import forge.card.ColorSet;
import forge.deck.Deck;
import forge.deck.DeckProxy;
import forge.deck.DeckgenUtil;
import forge.gui.GuiBase;
import forge.item.PaperCard;
import forge.localinstance.properties.ForgeConstants;
import forge.localinstance.properties.ForgePreferences;
import forge.localinstance.properties.ForgeProfileProperties;
import forge.model.FModel;
import forge.util.Aggregates;
import forge.util.FileUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.List;

public class Config {
    private static Config currentConfig;
    private final String commonDirectoryName = "common";
    private final String prefix;
    private final String commonPrefix;
    private final HashMap<String, FileHandle> Cache = new HashMap();
    private ConfigData configData;
    private final String[] adventures;
    private SettingData settingsData;
    private String Lang = "en-us";
    private final String plane;
    private ObjectMap<String, ObjectMap<String, Sprite>> atlasSprites = new ObjectMap();
    private ObjectMap<PointOfInterestData, Array<Sprite>> poiSprites = new ObjectMap();
    private ObjectMap<String, ObjectMap<String, Array<Sprite>>> animatedSprites = new ObjectMap();

    public static Config instance() {
        if (currentConfig == null) {
            currentConfig = new Config();
        }
        return currentConfig;
    }

    private Config() {
        String path = this.resPath();
        FilenameFilter planesFilter = (file, s2) -> !s2.contains(".") && !s2.equals("common");
        this.adventures = new File(GuiBase.isAndroid() ? ForgeConstants.ADVENTURE_DIR : path + "/res/adventure").list(planesFilter);
        try {
            this.settingsData = new Json().fromJson(SettingData.class, new FileHandle(ForgeConstants.USER_ADVENTURE_DIR + "settings.json"));
        }
        catch (Exception e) {
            this.settingsData = new SettingData();
        }
        if ((this.settingsData.plane == null || this.settingsData.plane.isEmpty()) && this.adventures != null && this.adventures.length >= 1) {
            for (String plane : this.adventures) {
                if (!plane.equalsIgnoreCase("Shandalar")) continue;
                this.settingsData.plane = plane;
            }
            if (this.settingsData.plane == null || this.settingsData.plane.isEmpty()) {
                this.settingsData.plane = Aggregates.random(this.adventures);
            }
        }
        this.plane = this.settingsData.plane;
        if (this.settingsData.width == 0 || this.settingsData.height == 0) {
            this.settingsData.width = 1280;
            this.settingsData.height = 720;
        }
        if (this.settingsData.videomode == null || this.settingsData.videomode.isEmpty()) {
            this.settingsData.videomode = "720p";
        }
        if (this.settingsData.rewardCardAdj == null || this.settingsData.rewardCardAdj.floatValue() == 0.0f) {
            this.settingsData.rewardCardAdj = Float.valueOf(1.0f);
        }
        if (this.settingsData.cardTooltipAdj == null || this.settingsData.cardTooltipAdj.floatValue() == 0.0f) {
            this.settingsData.cardTooltipAdj = Float.valueOf(1.0f);
        }
        if (this.settingsData.rewardCardAdjLandscape == null || this.settingsData.rewardCardAdjLandscape.floatValue() == 0.0f) {
            this.settingsData.rewardCardAdjLandscape = Float.valueOf(1.0f);
        }
        if (this.settingsData.cardTooltipAdjLandscape == null || this.settingsData.cardTooltipAdjLandscape.floatValue() == 0.0f) {
            this.settingsData.cardTooltipAdjLandscape = Float.valueOf(1.0f);
        }
        this.prefix = this.getPlanePath(this.settingsData.plane);
        this.commonPrefix = this.resPath() + "/res/adventure/" + "common" + "/";
        currentConfig = this;
        if (FModel.getPreferences() != null) {
            this.Lang = FModel.getPreferences().getPref(ForgePreferences.FPref.UI_LANGUAGE);
        }
        try {
            this.configData = new Json().fromJson(ConfigData.class, new FileHandle(this.commonPrefix + "config.json"));
        }
        catch (Exception e) {
            e.printStackTrace();
            this.configData = new ConfigData();
        }
    }

    private String resPath() {
        return GuiBase.isAndroid() ? ForgeConstants.ASSETS_DIR : (Files.exists(Paths.get("./res", new String[0]), new LinkOption[0]) ? "./" : (Files.exists(Paths.get("./forge-gui/", new String[0]), new LinkOption[0]) ? "./forge-gui/" : "../forge-gui"));
    }

    public String getPlanePath(String plane) {
        if (plane.startsWith("<user>")) {
            return ForgeConstants.USER_ADVENTURE_DIR + "/userplanes/" + plane.substring("<user>".length()) + "/";
        }
        return this.resPath() + "/res/adventure/" + plane + "/";
    }

    public ConfigData getConfigData() {
        return this.configData;
    }

    public int getBlurDivisor() {
        int val = 1;
        try {
            switch (this.settingsData.videomode) {
                case "720p": 
                case "768p": {
                    val = 8;
                    break;
                }
                case "900p": 
                case "1080p": {
                    val = 16;
                    break;
                }
                case "1440p": 
                case "2160p": {
                    val = 32;
                    break;
                }
            }
        }
        catch (Exception e) {
            return val;
        }
        return val;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getFilePath(String path) {
        return this.prefix + path;
    }

    public String getCommonFilePath(String path) {
        return this.commonPrefix + path;
    }

    public FileHandle getFile(String path) {
        if (this.Cache.containsKey(path)) {
            return this.Cache.get(path);
        }
        System.out.print("Looking for resource " + path + "... ");
        String fullPath = (this.prefix + path).replace("//", "/");
        String fileName = fullPath.replaceFirst("[.][^.]+$", "");
        String ext = fullPath.substring(fullPath.lastIndexOf(46));
        String langFile = fileName + "-" + this.Lang + ext;
        for (int iter = 1; iter <= 2; ++iter) {
            if (Files.exists(Paths.get(langFile, new String[0]), new LinkOption[0])) {
                System.out.println("Found!");
                this.Cache.put(path, new FileHandle(langFile));
                break;
            }
            if (Files.exists(Paths.get(fullPath, new String[0]), new LinkOption[0])) {
                System.out.println("Found!");
                this.Cache.put(path, new FileHandle(fullPath));
                break;
            }
            fullPath = (this.commonPrefix + path).replace("//", "/");
            fileName = fullPath.replaceFirst("[.][^.]+$", "");
            langFile = fileName + "-" + this.Lang + ext;
        }
        return this.Cache.get(path);
    }

    public String getPlane() {
        return this.plane.replace("<user>", "user_");
    }

    public String[] colorIdNames() {
        return this.configData.colorIdNames;
    }

    public String[] colorIds() {
        return this.configData.colorIds;
    }

    public String[] starterEditionNames() {
        return this.configData.starterEditionNames;
    }

    public String[] starterEditions() {
        return this.configData.starterEditions;
    }

    public Deck starterDeck(ColorSet color, DifficultyData difficultyData, AdventureModes mode, int index, CardEdition starterEdition) {
        switch (mode) {
            case Constructed: {
                for (ObjectMap.Entry entry : difficultyData.constructedStarterDecks) {
                    if (ColorSet.fromNames(((String)entry.key).toCharArray()).getColor() != color.getColor()) continue;
                    return CardUtil.getDeck((String)entry.value, false, false, "", false, false);
                }
            }
            case Standard: {
                for (ObjectMap.Entry entry : difficultyData.starterDecks) {
                    if (ColorSet.fromNames(((String)entry.key).toCharArray()).getColor() != color.getColor()) continue;
                    return CardUtil.getDeck((String)entry.value, false, false, "", false, false, starterEdition, true);
                }
            }
            case Chaos: {
                return DeckgenUtil.getRandomOrPreconOrThemeDeck("", false, false, false);
            }
            case Custom: {
                return DeckProxy.getAllCustomStarterDecks().get(index).getDeck();
            }
            case Pile: {
                for (ObjectMap.Entry entry : difficultyData.pileDecks) {
                    if (ColorSet.fromNames(((String)entry.key).toCharArray()).getColor() != color.getColor()) continue;
                    return CardUtil.getDeck((String)entry.value, false, false, "", false, false);
                }
                break;
            }
        }
        return null;
    }

    public TextureAtlas getAtlas(String spriteAtlas) {
        String fileName = this.getFile(spriteAtlas).path();
        TextureAtlas atlas = Forge.getAssets().manager().get(fileName, TextureAtlas.class, false);
        if (atlas == null) {
            Forge.getAssets().manager().load(fileName, TextureAtlas.class);
            Forge.getAssets().manager().finishLoadingAsset(fileName);
            atlas = Forge.getAssets().manager().get(fileName, TextureAtlas.class, false);
        }
        return atlas;
    }

    public Sprite getItemSprite(String itemName) {
        return this.getAtlasSprite("sprites/items.atlas", itemName);
    }

    public Sprite getAtlasSprite(String atlasName, String itemName) {
        Sprite sprite;
        ObjectMap<String, Sprite> sprites = this.atlasSprites.get(atlasName);
        if (sprites == null) {
            sprites = new ObjectMap();
        }
        if ((sprite = sprites.get(itemName)) == null && (sprite = this.getAtlas(atlasName).createSprite(itemName)) != null) {
            sprites.put(itemName, sprite);
            this.atlasSprites.put(atlasName, sprites);
        }
        return sprite;
    }

    public Array<Sprite> getPOISprites(PointOfInterestData d) {
        Array<Sprite> sprites = this.poiSprites.get(d);
        if (sprites == null) {
            sprites = this.getAtlas(d.spriteAtlas).createSprites(d.sprite);
            this.poiSprites.put(d, sprites);
        }
        return sprites;
    }

    public Array<Sprite> getAnimatedSprites(String path, String animationName) {
        Array<Sprite> sprites;
        ObjectMap<String, Array<Sprite>> mapSprites = this.animatedSprites.get(path);
        if (mapSprites == null) {
            mapSprites = new ObjectMap();
        }
        if ((sprites = mapSprites.get(animationName)) == null && (sprites = this.getAtlas(path).createSprites(animationName)) != null) {
            mapSprites.put(animationName, sprites);
            this.animatedSprites.put(path, mapSprites);
        }
        return sprites;
    }

    public SettingData getSettingData() {
        return this.settingsData;
    }

    public Array<String> getAllAdventures() {
        String path = ForgeConstants.USER_ADVENTURE_DIR + "/userplanes/";
        Array<String> adventures = new Array<String>();
        if (new File(path).exists()) {
            adventures.addAll(new File(path).list());
        }
        for (int i = 0; i < adventures.size; ++i) {
            adventures.set(i, "<user>" + adventures.get(i));
        }
        adventures.addAll(this.adventures);
        return adventures;
    }

    public void saveSettings() {
        Json json = new Json(JsonWriter.OutputType.json);
        FileHandle handle = new FileHandle(ForgeProfileProperties.getUserDir() + "/adventure/settings.json");
        handle.writeString(json.prettyPrint(json.toJson((Object)this.settingsData, SettingData.class)), false);
    }

    public void loadResources() {
        RewardData.getAllCards();
        CardRules.Reader rulesReader = new CardRules.Reader();
        ImageKeys.ADVENTURE_CARD_PICS_DIR = currentConfig.getCommonFilePath("custom_card_pics");
        File[] customCards = new File(this.getCommonFilePath("custom_cards")).listFiles();
        if (customCards == null) {
            return;
        }
        for (File cardFile : customCards) {
            try {
                FileInputStream fileInputStream = new FileInputStream(cardFile);
                rulesReader.reset();
                List<String> lines = FileUtil.readAllLines(new InputStreamReader((InputStream)fileInputStream, Charset.forName("UTF-8")), true);
                CardRules rules = rulesReader.readCard(lines, com.google.common.io.Files.getNameWithoutExtension(cardFile.getName()));
                rules.setCustom();
                PaperCard card = new PaperCard(rules, CardEdition.UNKNOWN.getCode(), CardRarity.Special){

                    @Override
                    public String getImageKey(boolean altState) {
                        return "a:" + this.getName();
                    }
                };
                FModel.getMagicDb().getCommonCards().addCard(card);
            }
            catch (FileNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

