/*
 * Decompiled with CFR 0.152.
 */
package forge.adventure.util;

import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Json;
import forge.adventure.character.EnemySprite;
import forge.adventure.data.AdventureEventData;
import forge.adventure.data.AdventureQuestData;
import forge.adventure.data.AdventureQuestStage;
import forge.adventure.data.DialogData;
import forge.adventure.data.EnemyData;
import forge.adventure.data.ItemData;
import forge.adventure.data.WorldData;
import forge.adventure.pointofintrest.PointOfInterest;
import forge.adventure.pointofintrest.PointOfInterestChanges;
import forge.adventure.stage.GameStage;
import forge.adventure.stage.MapStage;
import forge.adventure.util.AdventureQuestEvent;
import forge.adventure.util.AdventureQuestEventType;
import forge.adventure.util.Config;
import forge.adventure.util.Current;
import forge.adventure.util.MapDialog;
import forge.adventure.world.WorldSave;
import forge.util.Aggregates;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Random;
import java.util.stream.Collectors;

public class AdventureQuestController
implements Serializable {
    private Map<String, Long> nextQuestDate = new HashMap<String, Long>();
    private int maximumSideQuests = 5;
    private transient boolean inDialog = false;
    private transient Array<AdventureQuestData> allQuests = new Array();
    private transient Array<AdventureQuestData> allSideQuests = new Array();
    private Queue<DialogData> dialogQueue = new LinkedList<DialogData>();
    private Map<String, Date> questAvailability = new HashMap<String, Date>();
    public PointOfInterest mostRecentPOI;
    private List<EnemySprite> enemySpriteList = new ArrayList<EnemySprite>();
    private int nextQuestID = 0;
    private static AdventureQuestController object;

    public static void trackQuest(AdventureQuestData quest) {
        for (AdventureQuestData q : Current.player().getQuests()) {
            q.isTracked = q.equals(quest);
        }
    }

    public List<EnemyData> getExtraQuestSpawns(float difficultyFactor) {
        ArrayList<EnemyData> extraSpawns = new ArrayList<EnemyData>();
        for (AdventureQuestData q : Current.player().getQuests()) {
            for (AdventureQuestStage c : q.stages) {
                if (!c.getStatus().equals((Object)QuestStatus.ACTIVE) || !c.objective.equals((Object)ObjectiveTypes.Defeat)) continue;
                if (c.getTargetEnemyData() != null) {
                    extraSpawns.add(c.getTargetEnemyData());
                    continue;
                }
                for (EnemyData enemy : WorldData.getAllEnemies()) {
                    List candidateTags = Arrays.stream(enemy.questTags).collect(Collectors.toList());
                    boolean match = true;
                    for (String targetTag : c.enemyTags) {
                        if (candidateTags.contains(targetTag)) continue;
                        match = false;
                        break;
                    }
                    for (String targetTag : c.enemyExcludeTags) {
                        if (!candidateTags.contains(targetTag)) continue;
                        match = false;
                        break;
                    }
                    if (!match) continue;
                    extraSpawns.add(enemy);
                }
            }
        }
        return extraSpawns;
    }

    public Map<String, Float> getBoostedSpawns(List<EnemyData> localSpawns, float totalWeightToAssign) {
        HashMap<String, Float> boostedSpawns = new HashMap<String, Float>();
        for (AdventureQuestData q : Current.player().getQuests()) {
            for (AdventureQuestStage c : q.stages) {
                if (!c.getStatus().equals((Object)QuestStatus.ACTIVE) || !c.objective.equals((Object)ObjectiveTypes.Defeat)) continue;
                ArrayList<String> toBoost = new ArrayList<String>();
                if (c.mixedEnemies) {
                    for (EnemyData enemy : localSpawns) {
                        List candidateTags = Arrays.stream(enemy.questTags).collect(Collectors.toList());
                        boolean match = true;
                        for (String targetTag : c.enemyTags) {
                            if (candidateTags.contains(targetTag)) continue;
                            match = false;
                            break;
                        }
                        for (String targetTag : c.enemyExcludeTags) {
                            if (!candidateTags.contains(targetTag)) continue;
                            match = false;
                            break;
                        }
                        if (!match) continue;
                        toBoost.add(enemy.getName());
                    }
                } else {
                    toBoost.add(c.getTargetEnemyData().getName());
                }
                if (toBoost.isEmpty()) continue;
                float value = totalWeightToAssign / (float)toBoost.size();
                for (String key : toBoost) {
                    float existingValue = boostedSpawns.getOrDefault(key, Float.valueOf(0.0f)).floatValue();
                    boostedSpawns.put(key, Float.valueOf(value + existingValue));
                }
            }
        }
        return boostedSpawns;
    }

    public void showQuestDialogs(GameStage stage) {
        ArrayList<AdventureQuestData> finishedQuests = new ArrayList<AdventureQuestData>();
        for (AdventureQuestData quest : Current.player().getQuests()) {
            DialogData prologue = quest.getPrologue();
            if (prologue != null) {
                this.dialogQueue.add(prologue);
            }
            for (AdventureQuestStage questStage : quest.stages) {
                if (questStage.getStatus() == QuestStatus.INACTIVE) continue;
                if (questStage.prologue != null && !questStage.prologueDisplayed) {
                    questStage.prologueDisplayed = true;
                    this.dialogQueue.add(questStage.prologue);
                }
                if (questStage.getStatus() == QuestStatus.FAILED && questStage.failureDialog != null) {
                    this.dialogQueue.add(questStage.failureDialog);
                    continue;
                }
                if (questStage.getStatus() != QuestStatus.COMPLETE || questStage.epilogue == null || questStage.epilogueDisplayed) continue;
                questStage.epilogueDisplayed = true;
                this.dialogQueue.add(questStage.epilogue);
            }
            if (quest.failed) {
                finishedQuests.add(quest);
                if (quest.failureDialog != null) {
                    this.dialogQueue.add(quest.failureDialog);
                }
            }
            if (!quest.completed) continue;
            DialogData epilogue = quest.getEpilogue();
            if (epilogue != null) {
                this.dialogQueue.add(epilogue);
            }
            finishedQuests.add(quest);
            this.updateQuestComplete(quest);
        }
        if (!this.inDialog) {
            this.inDialog = true;
            this.displayNextDialog((MapStage)stage);
        }
        for (AdventureQuestData toRemove : finishedQuests) {
            if (!toRemove.failed && this.locationHasMoreQuests()) {
                this.nextQuestDate.remove(toRemove.sourceID);
            }
            Current.player().removeQuest(toRemove);
        }
    }

    public boolean locationHasMoreQuests() {
        return new Random().nextFloat() <= 0.85f;
    }

    public void displayNextDialog(final MapStage stage) {
        if (this.dialogQueue.peek() == null) {
            this.inDialog = false;
            return;
        }
        DialogData data = this.dialogQueue.remove();
        MapDialog dialog = new MapDialog(data, stage, -1, null);
        if (data.options == null || data.options.length == 0) {
            dialog.setEffects(data.action);
            this.displayNextDialog(stage);
            return;
        }
        stage.showDialog();
        dialog.activate();
        ChangeListener listen = new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent changeEvent, Actor actor) {
                AdventureQuestController.this.displayNextDialog(stage);
            }
        };
        dialog.addDialogCompleteListener(listen);
        if (data.options == null || data.options.length == 0) {
            this.displayNextDialog(stage);
        }
    }

    public static AdventureQuestController instance() {
        if (object == null) {
            object = new AdventureQuestController();
            object.loadData();
        }
        return object;
    }

    public static void clear() {
        object = null;
    }

    private AdventureQuestController() {
    }

    public AdventureQuestController(AdventureQuestController other) {
        if (object == null) {
            this.maximumSideQuests = other.maximumSideQuests;
            this.mostRecentPOI = other.mostRecentPOI;
            this.dialogQueue = other.dialogQueue;
            this.questAvailability = other.questAvailability;
            object = this;
            this.loadData();
        } else {
            System.out.println("Could not initialize AdventureQuestController. An instance already exists and cannot be merged.");
        }
    }

    private void loadData() {
        Json json = new Json();
        FileHandle handle = Config.instance().getFile("world/quests.json");
        if (handle.exists()) {
            this.allQuests = json.fromJson(Array.class, AdventureQuestData.class, handle);
        }
        for (AdventureQuestData q : this.allQuests) {
            if (q.storyQuest) continue;
            this.allSideQuests.add(q);
        }
    }

    public int getNextQuestID() {
        if (this.nextQuestID == 0 && this.allQuests.size > 0) {
            for (int i = 0; i < this.allQuests.size; ++i) {
                if (this.allQuests.get(i).getID() < this.nextQuestID) continue;
                this.nextQuestID = this.allQuests.get(i).getID() + 1;
            }
        }
        return this.nextQuestID++;
    }

    public void activateNextStages() {
        for (AdventureQuestData currentQuest : Current.player().getQuests()) {
            currentQuest.activateNextStages();
        }
    }

    public void updateEnteredPOI(PointOfInterest arrivedAt) {
        AdventureQuestEvent event = new AdventureQuestEvent();
        event.type = AdventureQuestEventType.ENTERPOI;
        event.poi = arrivedAt;
        event.count3 = WorldSave.getCurrentSave().getPointOfInterestChanges(arrivedAt.getID()).getMapReputation();
        for (AdventureQuestData currentQuest : Current.player().getQuests()) {
            currentQuest.updateStages(event);
        }
        this.activateNextStages();
    }

    public void updateQuestsMapFlag(String updatedMapFlag, int updatedFlagValue) {
        AdventureQuestEvent event = new AdventureQuestEvent();
        event.type = AdventureQuestEventType.MAPFLAG;
        event.flagName = updatedMapFlag;
        event.flagValue = updatedFlagValue;
        for (AdventureQuestData currentQuest : Current.player().getQuests()) {
            currentQuest.updateStages(event);
        }
        this.activateNextStages();
    }

    public void updateQuestsCharacterFlag(String updatedCharacterFlag, int updatedCharacterFlagValue) {
        AdventureQuestEvent event = new AdventureQuestEvent();
        event.type = AdventureQuestEventType.CHARACTERFLAG;
        event.flagName = updatedCharacterFlag;
        event.flagValue = updatedCharacterFlagValue;
        for (AdventureQuestData currentQuest : Current.player().getQuests()) {
            currentQuest.updateStages(event);
        }
        this.activateNextStages();
    }

    public void updateQuestsQuestFlag(String updatedQuestFlag, int updatedQuestFlagValue) {
        AdventureQuestEvent event = new AdventureQuestEvent();
        event.type = AdventureQuestEventType.QUESTFLAG;
        event.flagName = updatedQuestFlag;
        event.flagValue = updatedQuestFlagValue;
        for (AdventureQuestData currentQuest : Current.player().getQuests()) {
            currentQuest.updateStages(event);
        }
        this.activateNextStages();
    }

    public void updateQuestsLeave() {
        AdventureQuestEvent event = new AdventureQuestEvent();
        event.type = AdventureQuestEventType.LEAVEPOI;
        for (AdventureQuestData currentQuest : Current.player().getQuests()) {
            currentQuest.updateStages(event);
        }
        this.activateNextStages();
    }

    public void updateQuestsWin(EnemySprite defeated, ArrayList<EnemySprite> enemies) {
        this.enemySpriteList.remove(defeated);
        boolean allEnemiesCleared = true;
        if (enemies != null) {
            for (EnemySprite enemy : enemies) {
                if (enemy.getStage() == null || enemy.equals(defeated) || enemy.defeatDialog != null) continue;
                allEnemiesCleared = false;
                break;
            }
        }
        AdventureQuestEvent event = new AdventureQuestEvent();
        event.type = AdventureQuestEventType.MATCHCOMPLETE;
        event.winner = true;
        event.enemy = defeated;
        event.clear = allEnemiesCleared;
        for (AdventureQuestData currentQuest : Current.player().getQuests()) {
            currentQuest.updateStages(event);
        }
        this.activateNextStages();
    }

    public void updateQuestsWin(EnemySprite defeated) {
        this.updateQuestsWin(defeated, null);
    }

    public void updateQuestsLose(EnemySprite defeatedBy) {
        this.enemySpriteList.remove(defeatedBy);
        AdventureQuestEvent event = new AdventureQuestEvent();
        event.type = AdventureQuestEventType.MATCHCOMPLETE;
        event.winner = false;
        event.enemy = defeatedBy;
        event.clear = false;
        for (AdventureQuestData currentQuest : Current.player().getQuests()) {
            currentQuest.updateStages(event);
        }
        this.activateNextStages();
    }

    public void updateDespawn(EnemySprite despawned) {
        this.enemySpriteList.remove(despawned);
        AdventureQuestEvent event = new AdventureQuestEvent();
        event.type = AdventureQuestEventType.DESPAWN;
        event.enemy = despawned;
        for (AdventureQuestData currentQuest : Current.player().getQuests()) {
            currentQuest.updateStages(event);
        }
        this.activateNextStages();
    }

    public void updateArenaComplete(boolean winner) {
        AdventureQuestEvent event = new AdventureQuestEvent();
        event.type = AdventureQuestEventType.ARENACOMPLETE;
        event.winner = winner;
        for (AdventureQuestData currentQuest : Current.player().getQuests()) {
            currentQuest.updateStages(event);
        }
        this.activateNextStages();
    }

    public void updateEventComplete(AdventureEventData completedEvent) {
        AdventureQuestEvent event = new AdventureQuestEvent();
        event.type = AdventureQuestEventType.EVENTCOMPLETE;
        event.winner = completedEvent.playerWon;
        for (AdventureQuestData currentQuest : Current.player().getQuests()) {
            currentQuest.updateStages(event);
        }
        this.activateNextStages();
    }

    public void updateQuestComplete(AdventureQuestData completedQuest) {
        AdventureQuestEvent event = new AdventureQuestEvent();
        event.type = AdventureQuestEventType.QUESTCOMPLETE;
        event.otherQuest = completedQuest;
        for (AdventureQuestData currentQuest : Current.player().getQuests()) {
            currentQuest.updateStages(event);
        }
        this.activateNextStages();
    }

    public void updateItemUsed(ItemData data) {
        AdventureQuestEvent event = new AdventureQuestEvent();
        event.type = AdventureQuestEventType.USEITEM;
        event.item = data;
        for (AdventureQuestData currentQuest : Current.player().getQuests()) {
            currentQuest.updateStages(event);
        }
        this.activateNextStages();
    }

    public void updateItemReceived(ItemData data) {
        AdventureQuestEvent event = new AdventureQuestEvent();
        event.type = AdventureQuestEventType.RECEIVEITEM;
        event.item = data;
        for (AdventureQuestData currentQuest : Current.player().getQuests()) {
            currentQuest.updateStages(event);
        }
        this.activateNextStages();
    }

    public AdventureQuestData generateQuest(int id) {
        AdventureQuestData generated = null;
        for (AdventureQuestData template : this.allQuests) {
            if (!template.isTemplate || template.getID() != id) continue;
            generated = new AdventureQuestData(template);
            generated.initialize();
            break;
        }
        return generated;
    }

    public void addQuestSprites(AdventureQuestStage stage) {
        if (stage.getTargetSprite() != null) {
            this.enemySpriteList.add(stage.getTargetSprite());
        }
    }

    public List<EnemySprite> getQuestSprites() {
        return this.enemySpriteList;
    }

    public void rematchQuestSprite(EnemySprite sprite) {
        for (AdventureQuestData q : Current.player().getQuests()) {
            for (AdventureQuestStage s2 : q.stages) {
                if (sprite.questStageID == null || s2.stageID == null || !sprite.questStageID.equals(s2.stageID.toString())) continue;
                s2.setTargetSprite(sprite);
            }
        }
    }

    String randomItemName() {
        String[] options = new String[]{"collection of frequently asked questions", "case of card sleeves", "well loved playmat", "copy of Richard Garfield's autobiography", "collection of random foreign language cards", "lucky coin", "giant card binder", "unsorted box of commons", "bucket full of pieces of shattered artifacts", "depleted mana shard"};
        return Aggregates.random(options);
    }

    public void abandon(AdventureQuestData quest) {
        quest.fail();
    }

    public AdventureQuestData getQuestNPCResponse(String pointID, PointOfInterestChanges changes, String questOrigin) {
        DialogData dismiss;
        DialogData response;
        for (AdventureQuestData q : Current.player().getQuests()) {
            if (q.completed || q.storyQuest || !q.sourceID.equals(pointID)) continue;
            DialogData response2 = new DialogData();
            response2.text = "\"You haven't finished the last thing we asked you to do!\" (" + q.name + ") ";
            DialogData dismiss2 = new DialogData();
            dismiss2.name = "\"Oh, right, let me go take care of that.\"";
            response2.options = new DialogData[]{dismiss2};
            AdventureQuestData ret = new AdventureQuestData();
            ret.offerDialog = response2;
            return ret;
        }
        if (this.nextQuestDate.containsKey(pointID) && this.nextQuestDate.get(pointID) >= LocalDate.now().toEpochDay()) {
            response = new DialogData();
            response.text = "\"We don't have anything new for you to do right now. Come back tomorrow.\"";
            dismiss = new DialogData();
            dismiss.name = "\"Okay.\" (Leave)";
            response.options = new DialogData[]{dismiss};
            AdventureQuestData ret = new AdventureQuestData();
            ret.offerDialog = response;
            return ret;
        }
        if (this.tooManyQuests(Current.player().getQuests())) {
            response = new DialogData();
            response.text = "\"Adventurer, we need your assistance!\"";
            dismiss = new DialogData();
            dismiss.name = "\"I can't, I have far too many things to do right now\" (Your quest log is too full already) (Leave)";
            response.options = new DialogData[]{dismiss};
            AdventureQuestData ret = new AdventureQuestData();
            ret.offerDialog = response;
            return ret;
        }
        this.nextQuestDate.put(pointID, LocalDate.now().toEpochDay());
        Array<AdventureQuestData> validSideQuests = new Array<AdventureQuestData>();
        block1: for (AdventureQuestData option : this.allSideQuests) {
            if (option.questSourceTags.length == 0) {
                validSideQuests.add(option);
            }
            for (int i = 0; i < option.questSourceTags.length; ++i) {
                if (option.questSourceTags[i] == null || !option.questSourceTags[i].equals(questOrigin)) continue;
                validSideQuests.add(option);
                continue block1;
            }
        }
        AdventureQuestData ret = validSideQuests.size > 0 ? new AdventureQuestData((AdventureQuestData)Aggregates.random(validSideQuests)) : new AdventureQuestData(Aggregates.random(this.allSideQuests));
        ret.sourceID = pointID;
        ret.initialize();
        return ret;
    }

    private boolean tooManyQuests(List<AdventureQuestData> existing) {
        int sideQuests = 0;
        for (AdventureQuestData quest : existing) {
            if (quest.storyQuest || quest.completed || quest.failed) continue;
            ++sideQuests;
        }
        return sideQuests >= this.maximumSideQuests;
    }

    public static class DistanceSort
    implements Comparator<PointOfInterest> {
        @Override
        public int compare(PointOfInterest a, PointOfInterest b) {
            float distToB;
            float distToA = new Vector2(a.getPosition()).sub(Current.player().getWorldPosX(), Current.player().getWorldPosY()).len();
            if (distToA - (distToB = new Vector2(b.getPosition()).sub(Current.player().getWorldPosX(), Current.player().getWorldPosY()).len()) < 0.0f) {
                return -1;
            }
            if (distToA - distToB > 0.0f) {
                return 1;
            }
            return 0;
        }
    }

    public static enum QuestStatus {
        NONE,
        INACTIVE,
        ACTIVE,
        COMPLETE,
        FAILED;

    }

    public static enum ObjectiveTypes {
        None,
        Arena,
        CharacterFlag,
        Clear,
        CompleteQuest,
        Defeat,
        Delivery,
        Escort,
        EventFinish,
        EventWin,
        EventWinMatches,
        Fetch,
        Find,
        Gather,
        Give,
        HaveReputation,
        HaveReputationInCurrentLocation,
        Hunt,
        MapFlag,
        Leave,
        Patrol,
        QuestFlag,
        Rescue,
        Siege,
        Travel,
        Use;

    }
}

