/*
 * Decompiled with CFR 0.152.
 */
package forge.adventure.stage;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.controllers.Controllers;
import com.badlogic.gdx.math.GridPoint2;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.utils.Timer;
import com.badlogic.gdx.utils.viewport.Viewport;
import forge.Forge;
import forge.adventure.character.CharacterSprite;
import forge.adventure.character.EnemySprite;
import forge.adventure.character.MapActor;
import forge.adventure.data.AdventureQuestData;
import forge.adventure.data.BiomeData;
import forge.adventure.data.EnemyData;
import forge.adventure.data.WorldData;
import forge.adventure.pointofintrest.PointOfInterest;
import forge.adventure.scene.DuelScene;
import forge.adventure.scene.RewardScene;
import forge.adventure.scene.Scene;
import forge.adventure.scene.TileMapScene;
import forge.adventure.stage.GameHUD;
import forge.adventure.stage.GameStage;
import forge.adventure.stage.MapStage;
import forge.adventure.stage.PointOfInterestMapSprite;
import forge.adventure.stage.WorldBackground;
import forge.adventure.util.AdventureQuestController;
import forge.adventure.util.Current;
import forge.adventure.util.NavArrowActor;
import forge.adventure.util.SaveFileContent;
import forge.adventure.util.SaveFileData;
import forge.adventure.world.World;
import forge.adventure.world.WorldSave;
import forge.gui.FThreads;
import forge.screens.TransitionScreen;
import forge.sound.SoundEffectType;
import forge.sound.SoundSystem;
import forge.util.MyRandom;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import org.apache.commons.lang3.tuple.Pair;

public class WorldStage
extends GameStage
implements SaveFileContent {
    private static WorldStage instance = null;
    protected EnemySprite currentMob;
    protected Random rand = MyRandom.getRandom();
    WorldBackground background;
    private float spawnDelay = 0.0f;
    private static final float spawnInterval = 4.0f;
    private PointOfInterestMapSprite collidingPoint;
    protected ArrayList<Pair<Float, EnemySprite>> enemies = new ArrayList();
    private static final Float dieTimer = Float.valueOf(20.0f);
    private Float globalTimer = Float.valueOf(0.0f);
    private transient boolean directlyEnterPOI = false;
    NavArrowActor navArrow;
    final Rectangle tempBoundingRect = new Rectangle();
    final Vector2 enemyMoveVector = new Vector2();
    boolean collided = false;

    public WorldStage() {
        this.background = new WorldBackground(this);
        this.addActor(this.background);
        this.background.setZIndex(0);
        this.navArrow = new NavArrowActor();
        this.addActor(this.navArrow);
        this.navArrow.toFront();
    }

    public static WorldStage getInstance() {
        return instance == null ? (instance = new WorldStage()) : instance;
    }

    @Override
    protected void onActing(float delta) {
        if (this.isPaused() || MapStage.getInstance().isDialogOnlyInput() || Forge.advFreezePlayerControls) {
            return;
        }
        this.drawNavigationArrow();
        if (this.player.isMoving()) {
            this.handleMonsterSpawn(delta);
            this.handlePointsOfInterestCollision();
            this.globalTimer = Float.valueOf(this.globalTimer.floatValue() + delta);
            Iterator<Pair<Float, EnemySprite>> it = this.enemies.iterator();
            while (it.hasNext()) {
                int duration;
                Pair<Float, EnemySprite> pair = it.next();
                if (this.globalTimer.floatValue() >= pair.getKey().floatValue() + pair.getValue().getLifetime()) {
                    AdventureQuestController.instance().updateDespawn(pair.getValue());
                    AdventureQuestController.instance().showQuestDialogs(MapStage.getInstance());
                    this.foregroundSprites.removeActor(pair.getValue());
                    it.remove();
                    continue;
                }
                EnemySprite mob = pair.getValue();
                if (!this.currentModifications.containsKey((Object)GameStage.PlayerModification.Hide)) {
                    this.enemyMoveVector.set(this.player.getX(), this.player.getY()).sub(mob.pos());
                    this.enemyMoveVector.setLength(mob.speed() * delta);
                    this.tempBoundingRect.set(mob.getX() + this.enemyMoveVector.x, mob.getY() + this.enemyMoveVector.y, mob.getWidth(), mob.getHeight() * mob.getCollisionHeight());
                    if (!mob.getData().flying && WorldSave.getCurrentSave().getWorld().collidingTile(this.tempBoundingRect)) {
                        this.tempBoundingRect.set(mob.getX() + this.enemyMoveVector.x, mob.getY(), mob.getWidth(), mob.getHeight());
                        if (WorldSave.getCurrentSave().getWorld().collidingTile(this.tempBoundingRect)) {
                            this.tempBoundingRect.set(mob.getX(), mob.getY() + this.enemyMoveVector.y, mob.getWidth(), mob.getHeight());
                            if (!WorldSave.getCurrentSave().getWorld().collidingTile(this.tempBoundingRect)) {
                                mob.moveBy(0.0f, this.enemyMoveVector.y);
                            }
                        } else {
                            mob.moveBy(this.enemyMoveVector.x, 0.0f);
                        }
                    } else {
                        mob.moveBy(this.enemyMoveVector.x, this.enemyMoveVector.y);
                    }
                }
                if (!this.player.collideWith(mob)) continue;
                if (this.collided) {
                    return;
                }
                this.collided = true;
                this.player.setAnimation(CharacterSprite.AnimationTypes.Attack);
                this.player.playEffect("particle_effects/sparks.p", 0.5f);
                mob.setAnimation(CharacterSprite.AnimationTypes.Attack);
                SoundSystem.instance.play(SoundEffectType.Block, false);
                Gdx.input.vibrate(50);
                int n = duration = mob.getData().boss ? 400 : 200;
                if (Controllers.getCurrent() != null && Controllers.getCurrent().canVibrate()) {
                    Controllers.getCurrent().startVibration(duration, 1.0f);
                }
                Forge.advFreezePlayerControls = true;
                this.player.clearCollisionHeight();
                this.startPause(0.8f, () -> {
                    Forge.setCursor(null, Forge.magnifyToggle ? "1" : "2");
                    SoundSystem.instance.play(SoundEffectType.ManaBurn, false);
                    DuelScene duelScene = DuelScene.instance();
                    FThreads.invokeInEdtNowOrLater(() -> {
                        Forge.setTransitionScreen(new TransitionScreen(() -> {
                            this.collided = false;
                            duelScene.initDuels(this.player, mob);
                            Forge.switchScene(duelScene);
                        }, Forge.takeScreenshot(), true, false, false, false, "", Current.player().avatar(), mob.getAtlasPath(), Current.player().getName(), mob.getName()));
                        this.currentMob = mob;
                        WorldSave.getCurrentSave().autoSave();
                    });
                });
                break;
            }
        } else {
            for (Pair<Float, EnemySprite> pair : this.enemies) {
                pair.getValue().setAnimation(CharacterSprite.AnimationTypes.Idle);
            }
        }
    }

    private void removeEnemy(EnemySprite currentMob) {
        currentMob.removeAfterEffects();
        Iterator<Pair<Float, EnemySprite>> it = this.enemies.iterator();
        while (it.hasNext()) {
            Pair<Float, EnemySprite> pair = it.next();
            if (pair.getValue() != currentMob) continue;
            it.remove();
            return;
        }
    }

    @Override
    public void setWinner(boolean playerIsWinner) {
        if (playerIsWinner) {
            this.currentMob.clearCollisionHeight();
            Current.player().win();
            this.player.setAnimation(CharacterSprite.AnimationTypes.Attack);
            this.currentMob.playEffect("particle_effects/blood.p", 0.5f);
            Timer.schedule(new Timer.Task(){

                @Override
                public void run() {
                    WorldStage.this.currentMob.setAnimation(CharacterSprite.AnimationTypes.Death);
                    WorldStage.this.currentMob.resetCollisionHeight();
                    WorldStage.this.startPause(0.3f, () -> {
                        RewardScene.instance().loadRewards(WorldStage.this.currentMob.getRewards(), RewardScene.Type.Loot, null);
                        WorldStage.this.removeEnemy(WorldStage.this.currentMob);
                        AdventureQuestController.instance().updateQuestsWin(WorldStage.this.currentMob);
                        AdventureQuestController.instance().showQuestDialogs(MapStage.getInstance());
                        Forge.switchScene(RewardScene.instance());
                        WorldStage.this.currentMob = null;
                    });
                }
            }, 1.0f);
        } else {
            this.currentMob.clearCollisionHeight();
            this.player.setAnimation(CharacterSprite.AnimationTypes.Hit);
            this.currentMob.setAnimation(CharacterSprite.AnimationTypes.Attack);
            this.startPause(0.5f, () -> {
                this.currentMob.resetCollisionHeight();
                boolean defeated = Current.player().defeated();
                AdventureQuestController.instance().updateQuestsLose(this.currentMob);
                AdventureQuestController.instance().showQuestDialogs(MapStage.getInstance());
                this.removeEnemy(this.currentMob);
                this.currentMob = null;
                if (defeated) {
                    WorldStage.getInstance().resetPlayerLocation();
                }
            });
        }
    }

    public void handlePointsOfInterestCollision() {
        for (Actor actor : this.foregroundSprites.getChildren()) {
            PointOfInterestMapSprite point;
            if (actor.getClass() != PointOfInterestMapSprite.class || !(point = (PointOfInterestMapSprite)actor).getPointOfInterest().getActive()) continue;
            if (this.player.collideWith(point.getBoundingRect())) {
                if (point == this.collidingPoint) continue;
                WorldSave.getCurrentSave().autoSave();
                this.loadPOI(point.getPointOfInterest());
                point.getMapSprite().checkOut();
                continue;
            }
            if (point != this.collidingPoint) continue;
            this.collidingPoint = null;
        }
    }

    public void loadPOI(PointOfInterest poi) {
        try {
            TileMapScene.instance().load(poi);
            this.stop();
            TileMapScene.instance().setFromWorldMap(true);
            Forge.switchScene(TileMapScene.instance());
        }
        catch (Exception e) {
            System.err.println("Error loading map...");
            e.printStackTrace();
        }
    }

    @Override
    public boolean isColliding(Rectangle boundingRect) {
        if (this.currentModifications.containsKey((Object)GameStage.PlayerModification.Fly)) {
            return false;
        }
        return WorldSave.getCurrentSave().getWorld().collidingTile(boundingRect);
    }

    @Override
    public Vector2 adjustMovement(Vector2 direction, Rectangle boundingRect) {
        if (this.isColliding(boundingRect)) {
            return direction;
        }
        return super.adjustMovement(direction, boundingRect);
    }

    public boolean spawn(String enemy) {
        return this.spawn(WorldData.getEnemy(enemy));
    }

    private void handleMonsterSpawn(float delta) {
        float sprintingMod;
        for (EnemySprite questSprite : AdventureQuestController.instance().getQuestSprites()) {
            if (this.foregroundSprites.getChildren().contains(questSprite, true)) continue;
            this.spawnQuestSprite(questSprite, 2.5f);
        }
        World world = WorldSave.getCurrentSave().getWorld();
        int currentBiome = World.highestBiome(world.getBiome((int)this.player.getX() / world.getTileSize(), (int)this.player.getY() / world.getTileSize()));
        List<BiomeData> biomeData = WorldSave.getCurrentSave().getWorld().getData().GetBiomes();
        float f = sprintingMod = this.currentModifications.containsKey((Object)GameStage.PlayerModification.Sprint) ? 2.0f : 1.0f;
        if (biomeData.size() <= currentBiome) {
            this.player.setMoveModifier(1.5f * sprintingMod);
            return;
        }
        this.player.setMoveModifier(1.0f * sprintingMod);
        BiomeData data = biomeData.get(currentBiome);
        if (data == null) {
            return;
        }
        this.spawnDelay -= delta;
        if (this.spawnDelay >= 0.0f) {
            return;
        }
        this.spawnDelay = 4.0f + this.rand.nextFloat() * 4.0f;
        ArrayList<EnemyData> list = data.getEnemyList();
        if (list == null) {
            return;
        }
        EnemyData enemyData = data.getEnemy(1.0f);
        EnemyData extraSpawnForQuests = data.getExtraSpawnEnemy(1.0f);
        if (extraSpawnForQuests != null) {
            float spawnPicker = this.rand.nextFloat();
            if (spawnPicker > 0.5f) {
                this.spawn(enemyData);
                this.spawn(extraSpawnForQuests);
            } else if (spawnPicker > 0.2f) {
                this.spawn(extraSpawnForQuests);
            } else {
                this.spawn(enemyData);
            }
        } else {
            this.spawn(enemyData);
        }
    }

    private boolean spawn(EnemySprite sprite) {
        if (sprite == null) {
            return false;
        }
        float unit = (float)Scene.getIntendedHeight() / 6.0f;
        Vector2 spawnPos = new Vector2(1.0f, 1.0f);
        for (int j = 0; j < 10; ++j) {
            spawnPos.setLength(unit + unit * 3.0f * this.rand.nextFloat());
            spawnPos.setAngleDeg(360.0f * this.rand.nextFloat());
            for (int i = 0; i < 10; ++i) {
                boolean enemyXIsBigger = sprite.getX() > this.player.getX();
                boolean enemyYIsBigger = sprite.getY() > this.player.getY();
                sprite.setX(this.player.getX() + spawnPos.x + (float)i * sprite.getWidth() * (float)(enemyXIsBigger ? 1 : -1));
                sprite.setY(this.player.getY() + spawnPos.y + (float)i * sprite.getHeight() * (float)(enemyYIsBigger ? 1 : -1));
                if (!sprite.getData().flying && WorldSave.getCurrentSave().getWorld().collidingTile(sprite.boundingRect())) continue;
                this.enemies.add(Pair.of(this.globalTimer, sprite));
                this.foregroundSprites.addActor(sprite);
                return true;
            }
        }
        return false;
    }

    private boolean spawn(EnemyData enemyData) {
        if (enemyData == null) {
            return false;
        }
        EnemySprite sprite = new EnemySprite(enemyData);
        return this.spawn(sprite);
    }

    private boolean spawnQuestSprite(EnemySprite sprite, float distanceMultiplier) {
        if (sprite == null) {
            return false;
        }
        float unit = (float)Scene.getIntendedHeight() / 6.0f;
        Vector2 spawnPos = new Vector2(1.0f, 1.0f);
        for (int j = 0; j < 10; ++j) {
            spawnPos.setLength((unit + unit * 3.0f * this.rand.nextFloat()) * distanceMultiplier);
            spawnPos.setAngleDeg(360.0f * this.rand.nextFloat());
            for (int i = 0; i < 10; ++i) {
                boolean enemyXIsBigger = sprite.getX() > this.player.getX();
                boolean enemyYIsBigger = sprite.getY() > this.player.getY();
                sprite.setX(this.player.getX() + spawnPos.x + (float)i * sprite.getWidth() * (float)(enemyXIsBigger ? 1 : -1));
                sprite.setY(this.player.getY() + spawnPos.y + (float)i * sprite.getHeight() * (float)(enemyYIsBigger ? 1 : -1));
                if (!sprite.getData().flying && WorldSave.getCurrentSave().getWorld().collidingTile(sprite.boundingRect())) continue;
                this.enemies.add(Pair.of(this.globalTimer, sprite));
                this.foregroundSprites.addActor(sprite);
                return true;
            }
        }
        return false;
    }

    @Override
    public void draw() {
        this.background.setPlayerPos(this.player.getX(), this.player.getY());
        super.draw();
        if (WorldSave.getCurrentSave().getPlayer().hasAnnounceFantasy()) {
            MapStage.getInstance().showDeckAwardDialog("{BLINK=WHITE;RED}Chaos Mode!{ENDBLINK}\nEnemy will use Preconstructed or Random Generated Decks. Genetic AI Decks will be available to some enemies on Hard difficulty.", WorldSave.getCurrentSave().getPlayer().getSelectedDeck());
            WorldSave.getCurrentSave().getPlayer().clearAnnounceFantasy();
        } else if (WorldSave.getCurrentSave().getPlayer().hasAnnounceCustom()) {
            MapStage.getInstance().showDeckAwardDialog("{GRADIENT}Custom Deck Mode!{ENDGRADIENT}\nSome enemies will use Genetic AI Decks randomly.", WorldSave.getCurrentSave().getPlayer().getSelectedDeck());
            WorldSave.getCurrentSave().getPlayer().clearAnnounceCustom();
        }
    }

    public void setDirectlyEnterPOI() {
        this.directlyEnterPOI = true;
    }

    public PointOfInterestMapSprite getMapSprite(PointOfInterest poi) {
        if (poi == null) {
            return null;
        }
        for (Actor actor : this.foregroundSprites.getChildren()) {
            PointOfInterestMapSprite point;
            if (actor.getClass() != PointOfInterestMapSprite.class || poi != (point = (PointOfInterestMapSprite)actor).getPointOfInterest() || poi.getPosition() != point.getPointOfInterest().getPosition()) continue;
            return point;
        }
        return null;
    }

    @Override
    public void enter() {
        this.getPlayerSprite().LoadPos();
        this.getPlayerSprite().setMovementDirection(Vector2.Zero);
        if (this.directlyEnterPOI) {
            this.directlyEnterPOI = false;
        } else {
            for (Actor actor : this.foregroundSprites.getChildren()) {
                PointOfInterestMapSprite point;
                if (actor.getClass() != PointOfInterestMapSprite.class || !this.player.collideWith((point = (PointOfInterestMapSprite)actor).getBoundingRect())) continue;
                this.collidingPoint = point;
            }
        }
        this.setBounds(WorldSave.getCurrentSave().getWorld().getWidthInPixels(), WorldSave.getCurrentSave().getWorld().getHeightInPixels());
        GridPoint2 pos = this.background.translateFromWorldToChunk(this.player.getX(), this.player.getY());
        this.background.loadChunk(pos.x, pos.y);
    }

    @Override
    public void leave() {
        this.getPlayerSprite().storePos();
    }

    @Override
    public void load(SaveFileData data) {
        try {
            this.clearCache();
            MapStage.getInstance().clearIsInMap();
            GameHUD.getInstance().clearNotifications();
            List timeouts = (List)data.readObject("timeouts");
            List names = (List)data.readObject("names");
            List x = (List)data.readObject("x");
            List y = (List)data.readObject("y");
            List questStageIDs = (List)data.readObject("questStageIDs");
            for (int i = 0; i < timeouts.size(); ++i) {
                EnemySprite sprite = new EnemySprite(WorldData.getEnemy((String)names.get(i)));
                sprite.setX(((Float)x.get(i)).floatValue());
                sprite.setY(((Float)y.get(i)).floatValue());
                sprite.questStageID = (String)questStageIDs.get(i);
                if (sprite.questStageID != null) {
                    AdventureQuestController.instance().rematchQuestSprite(sprite);
                }
                this.enemies.add(Pair.of((Float)timeouts.get(i), sprite));
                this.foregroundSprites.addActor(sprite);
            }
            this.globalTimer = Float.valueOf(data.readFloat("globalTimer"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void clearCache() {
        for (Pair<Float, EnemySprite> enemy : this.enemies) {
            this.foregroundSprites.removeActor(enemy.getValue());
        }
        this.enemies.clear();
        this.background.clear();
        this.player = null;
    }

    @Override
    public SaveFileData save() {
        SaveFileData data = new SaveFileData();
        ArrayList<Float> timeouts = new ArrayList<Float>();
        ArrayList<String> names = new ArrayList<String>();
        ArrayList<Float> x = new ArrayList<Float>();
        ArrayList<Float> y = new ArrayList<Float>();
        ArrayList<String> questStageIDs = new ArrayList<String>();
        for (Pair<Float, EnemySprite> enemy : this.enemies) {
            timeouts.add(enemy.getKey());
            names.add(enemy.getValue().getData().getName());
            x.add(Float.valueOf(enemy.getValue().getX()));
            y.add(Float.valueOf(enemy.getValue().getY()));
            questStageIDs.add(enemy.getValue().questStageID);
        }
        data.storeObject("timeouts", timeouts);
        data.storeObject("names", names);
        data.storeObject("x", x);
        data.storeObject("y", y);
        data.storeObject("questStageIDs", questStageIDs);
        data.store("globalTimer", this.globalTimer.floatValue());
        return data;
    }

    @Override
    public Viewport getViewport() {
        return super.getViewport();
    }

    public void removeNearestEnemy() {
        float shortestDist = Float.MAX_VALUE;
        MapActor enemy = null;
        for (Pair<Float, EnemySprite> pair : this.enemies) {
            float dist = pair.getValue().pos().sub(this.player.pos()).len();
            if (!(dist < shortestDist)) continue;
            shortestDist = dist;
            enemy = pair.getValue();
        }
        if (enemy != null) {
            enemy.playEffect("particle_effects/killed.p");
            this.removeEnemy((EnemySprite)enemy);
            this.player.playEffect("particle_effects/kill.p");
        }
    }

    private void drawNavigationArrow() {
        Vector2 navDirection = null;
        for (AdventureQuestData adq : Current.player().getQuests()) {
            if (!adq.isTracked) continue;
            PointOfInterest nearestValidPOI = adq.getClosestValidPOI(this.player.pos());
            if (nearestValidPOI != null) {
                navDirection = new Vector2(nearestValidPOI.getPosition()).sub(this.player.pos());
                break;
            }
            if (adq.getTargetEnemySprite() == null) break;
            EnemySprite target = adq.getTargetEnemySprite();
            for (Pair<Float, EnemySprite> active : this.enemies) {
                EnemySprite sprite = active.getValue();
                if (!sprite.equals(target)) continue;
                navDirection = new Vector2(adq.getTargetEnemySprite().pos()).sub(this.player.pos());
            }
        }
        if (navDirection != null) {
            this.navArrow.navTargetAngle = navDirection.angleDeg();
            this.navArrow.setVisible(true);
            this.navArrow.setPosition(this.getPlayerSprite().getX() + this.getPlayerSprite().getWidth() / 2.0f, this.getPlayerSprite().getY() + this.getPlayerSprite().getHeight() / 2.0f);
        } else {
            this.navArrow.setVisible(false);
        }
    }
}

