/*
 * Decompiled with CFR 0.152.
 */
package forge.adventure.stage;

import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.math.GridPoint2;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.utils.Array;
import forge.adventure.stage.GameStage;
import forge.adventure.stage.MapSprite;
import forge.adventure.world.WorldSave;
import java.util.ArrayList;

public class WorldBackground
extends Actor {
    int chunkSize;
    int tileSize;
    int playerX;
    int playerY;
    Texture[][] chunks;
    Texture loadingTexture;
    Texture t;
    Array<Actor>[][] chunksSprites;
    Array<Actor>[][] chunksSpritesBackground;
    int currentChunkX;
    int currentChunkY;
    GameStage stage;

    public WorldBackground(GameStage gameStage) {
        this.stage = gameStage;
    }

    @Override
    public void draw(Batch batch, float parentAlpha) {
        if (this.chunks == null) {
            this.initialize();
        }
        GridPoint2 pos = this.translateFromWorldToChunk(this.playerX, this.playerY);
        if (this.currentChunkX != pos.x || this.currentChunkY != pos.y) {
            int y;
            int x;
            int xDiff = this.currentChunkX - pos.x;
            int yDiff = this.currentChunkY - pos.y;
            ArrayList<GridPoint2> points = new ArrayList<GridPoint2>();
            for (x = -1; x < 2; ++x) {
                for (y = -1; y < 2; ++y) {
                    points.add(new GridPoint2(pos.x + x, pos.y + y));
                }
            }
            for (x = -1; x < 2; ++x) {
                for (y = -1; y < 2; ++y) {
                    GridPoint2 point = new GridPoint2(this.currentChunkX + x, this.currentChunkY + y);
                    if (points.contains(point)) {
                        points.remove(point);
                        continue;
                    }
                    if (point.y < 0 || point.x < 0 || point.y >= this.chunks[0].length || point.x >= this.chunks.length) continue;
                    this.unLoadChunk(point.x, point.y);
                }
            }
            for (GridPoint2 point : points) {
                if (point.y < 0 || point.x < 0 || point.y >= this.chunks[0].length || point.x >= this.chunks.length) continue;
                this.loadChunk(point.x, point.y);
            }
            this.currentChunkX = pos.x;
            this.currentChunkY = pos.y;
        }
        for (int x = -1; x < 2; ++x) {
            for (int y = -1; y < 2; ++y) {
                if (pos.y + y < 0 || pos.x + x < 0 || pos.y >= this.chunks[0].length || pos.x >= this.chunks.length) continue;
                batch.draw(this.getChunkTexture(pos.x + x, pos.y + y), (float)this.transChunkToWorld(pos.x + x), (float)this.transChunkToWorld(pos.y + y));
            }
        }
    }

    public void loadChunk(int x, int y) {
        if (this.chunksSprites[x][y] == null) {
            this.chunksSprites[x][y] = MapSprite.getMapSprites(x, y, MapSprite.SpriteLayer);
        }
        for (Actor sprite : this.chunksSprites[x][y]) {
            this.stage.getSpriteGroup().addActor(sprite);
        }
        if (this.chunksSpritesBackground[x][y] == null) {
            this.chunksSpritesBackground[x][y] = MapSprite.getMapSprites(x, y, MapSprite.BackgroundLayer);
        }
        for (Actor sprite : this.chunksSpritesBackground[x][y]) {
            this.stage.getBackgroundSprites().addActor(sprite);
        }
    }

    private void unLoadChunk(int x, int y) {
        Array<Actor> sprites = this.chunksSprites[x][y];
        if (sprites != null) {
            for (Actor sprite : sprites) {
                this.stage.getSpriteGroup().removeActor(sprite);
            }
        }
        if ((sprites = this.chunksSpritesBackground[x][y]) != null) {
            for (Actor sprite : sprites) {
                this.stage.getBackgroundSprites().removeActor(sprite);
            }
        }
    }

    public Texture getChunkTexture(int x, int y) {
        Texture tex = this.chunks[x][y];
        if (tex == null) {
            Texture newChunk = new Texture(this.chunkSize * this.tileSize, this.chunkSize * this.tileSize, Pixmap.Format.RGBA8888);
            for (int cx = 0; cx < this.chunkSize; ++cx) {
                for (int cy = 0; cy < this.chunkSize; ++cy) {
                    newChunk.draw(WorldSave.getCurrentSave().getWorld().getBiomeSprite(cx + this.chunkSize * x, cy + this.chunkSize * y), cx * this.tileSize, this.chunkSize * this.tileSize - (cy + 1) * this.tileSize);
                }
            }
            this.chunks[x][y] = newChunk;
        }
        return this.chunks[x][y];
    }

    public void initialize() {
        this.tileSize = WorldSave.getCurrentSave().getWorld().getTileSize();
        this.chunkSize = WorldSave.getCurrentSave().getWorld().getChunkSize();
        if (this.chunks != null) {
            this.stage.getSpriteGroup().clear();
            Texture[][] textureArray = this.chunks;
            int n = textureArray.length;
            for (int i = 0; i < n; ++i) {
                Texture[] chunk;
                for (Texture texture : chunk = textureArray[i]) {
                    if (texture == null) continue;
                    texture.dispose();
                }
            }
        }
        this.chunks = new Texture[WorldSave.getCurrentSave().getWorld().getWidthInTiles()][WorldSave.getCurrentSave().getWorld().getHeightInTiles()];
        Array[][] createChunks = new Array[WorldSave.getCurrentSave().getWorld().getWidthInTiles()][WorldSave.getCurrentSave().getWorld().getHeightInTiles()];
        this.chunksSprites = createChunks;
        Array[][] createSprites = new Array[WorldSave.getCurrentSave().getWorld().getWidthInTiles()][WorldSave.getCurrentSave().getWorld().getHeightInTiles()];
        this.chunksSpritesBackground = createSprites;
        if (this.loadingTexture == null) {
            Pixmap loadPix = new Pixmap(this.chunkSize * this.tileSize, this.chunkSize * this.tileSize, Pixmap.Format.RGBA8888);
            loadPix.setColor(0.5f, 0.5f, 0.5f, 1.0f);
            loadPix.fill();
            this.loadingTexture = new Texture(loadPix);
        }
        for (int x = -1; x < 2; ++x) {
            for (int y = -1; y < 2; ++y) {
                GridPoint2 point = new GridPoint2(this.currentChunkX + x, this.currentChunkY + y);
                if (point.y < 0 || point.x < 0 || point.y >= this.chunks[0].length || point.x >= this.chunks.length) continue;
                this.loadChunk(point.x, point.y);
            }
        }
    }

    @Override
    public void clear() {
        super.clear();
        this.initialize();
    }

    int transChunkToWorld(int xy) {
        return xy * this.tileSize * this.chunkSize;
    }

    GridPoint2 translateFromWorldToChunk(float x, float y) {
        float worldWidthTiles = x / (float)this.tileSize;
        float worldHeightTiles = y / (float)this.tileSize;
        return new GridPoint2((int)worldWidthTiles / this.chunkSize, (int)worldHeightTiles / this.chunkSize);
    }

    public void setPlayerPos(float x, float y) {
        this.playerX = (int)x;
        this.playerY = (int)y;
    }
}

