/*
 * Decompiled with CFR 0.152.
 */
package forge.adventure.stage;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.math.Rectangle;
import forge.adventure.pointofintrest.PointOfInterest;
import forge.adventure.stage.MapSprite;

public class PointOfInterestMapSprite
extends MapSprite {
    PointOfInterest pointOfInterest;
    Texture debugTexture;
    Rectangle boundingRect;
    MapSprite mapSprite;

    public PointOfInterestMapSprite(PointOfInterest point) {
        super(point.getPosition(), point.getSprite(), point);
        this.pointOfInterest = point;
        this.mapSprite = this;
        this.boundingRect = new Rectangle(this.getX(), this.getY(), this.texture.getRegionWidth(), this.texture.getRegionHeight());
    }

    public PointOfInterest getPointOfInterest() {
        return this.pointOfInterest;
    }

    public MapSprite getMapSprite() {
        return this.mapSprite;
    }

    private Texture getDebugTexture() {
        if (this.debugTexture == null) {
            Pixmap pixmap = new Pixmap(this.texture.getRegionWidth(), this.texture.getRegionHeight(), Pixmap.Format.RGBA8888);
            pixmap.setColor(Color.RED);
            pixmap.drawRectangle(0, 0, (int)this.getWidth(), (int)this.getHeight());
            this.debugTexture = new Texture(pixmap);
            pixmap.dispose();
        }
        return this.debugTexture;
    }

    public Rectangle getBoundingRect() {
        return this.boundingRect;
    }

    @Override
    public void draw(Batch batch, float parentAlpha) {
        if (this.pointOfInterest.getActive()) {
            super.draw(batch, parentAlpha);
        }
    }
}

