/*
 * Decompiled with CFR 0.152.
 */
package forge.adventure.stage;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.controllers.Controllers;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.maps.MapLayer;
import com.badlogic.gdx.maps.MapObject;
import com.badlogic.gdx.maps.MapProperties;
import com.badlogic.gdx.maps.objects.RectangleMapObject;
import com.badlogic.gdx.maps.tiled.TiledMap;
import com.badlogic.gdx.maps.tiled.TiledMapTileLayer;
import com.badlogic.gdx.maps.tiled.objects.TiledMapTileMapObject;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.physics.box2d.World;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.actions.Actions;
import com.badlogic.gdx.scenes.scene2d.ui.Button;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Timer;
import com.github.tommyettinger.textra.TextraButton;
import com.github.tommyettinger.textra.TypingAdapter;
import com.github.tommyettinger.textra.TypingLabel;
import forge.Forge;
import forge.adventure.character.CharacterSprite;
import forge.adventure.character.DialogActor;
import forge.adventure.character.DummySprite;
import forge.adventure.character.EnemySprite;
import forge.adventure.character.EntryActor;
import forge.adventure.character.MapActor;
import forge.adventure.character.OnCollide;
import forge.adventure.character.PortalActor;
import forge.adventure.character.QuestActor;
import forge.adventure.character.RewardSprite;
import forge.adventure.character.ShopActor;
import forge.adventure.character.TextureSprite;
import forge.adventure.data.ArenaData;
import forge.adventure.data.DifficultyData;
import forge.adventure.data.EffectData;
import forge.adventure.data.EnemyData;
import forge.adventure.data.RewardData;
import forge.adventure.data.ShopData;
import forge.adventure.data.WorldData;
import forge.adventure.player.AdventurePlayer;
import forge.adventure.pointofintrest.PointOfInterestChanges;
import forge.adventure.scene.ArenaScene;
import forge.adventure.scene.DuelScene;
import forge.adventure.scene.GameScene;
import forge.adventure.scene.InnScene;
import forge.adventure.scene.RewardScene;
import forge.adventure.scene.ShardTraderScene;
import forge.adventure.scene.SpellSmithScene;
import forge.adventure.scene.TileMapScene;
import forge.adventure.stage.GameHUD;
import forge.adventure.stage.GameStage;
import forge.adventure.stage.WorldStage;
import forge.adventure.util.AdventureQuestController;
import forge.adventure.util.Config;
import forge.adventure.util.Controls;
import forge.adventure.util.Current;
import forge.adventure.util.JSONStringLoader;
import forge.adventure.util.KeyBinding;
import forge.adventure.util.MapDialog;
import forge.adventure.util.Reward;
import forge.adventure.util.pathfinding.NavigationMap;
import forge.adventure.util.pathfinding.NavigationVertex;
import forge.adventure.util.pathfinding.ProgressableGraphPath;
import forge.adventure.world.WorldSave;
import forge.gui.FThreads;
import forge.screens.TransitionScreen;
import forge.sound.SoundEffectType;
import forge.sound.SoundSystem;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.Random;

public class MapStage
extends GameStage {
    public static MapStage instance;
    final Array<MapActor> actors = new Array();
    public World gdxWorld;
    public TiledMap tiledMap;
    public Array<Rectangle> collisionRect = new Array();
    public Map<Float, NavigationMap> navMaps = new HashMap<Float, NavigationMap>();
    private boolean isInMap = false;
    MapLayer spriteLayer;
    private PointOfInterestChanges changes;
    private EnemySprite currentMob;
    Queue<Vector2> positions = new LinkedList<Vector2>();
    private boolean isLoadingMatch = false;
    private EffectData effect;
    private boolean preventEscape = false;
    public InputEvent eventTouchDown;
    public InputEvent eventTouchUp;
    private boolean respawnEnemies;
    private boolean canFailDungeon = false;
    protected ArrayList<EnemySprite> enemies = new ArrayList();
    public Map<Integer, Vector2> waypoints = new HashMap<Integer, Vector2>();
    float collisionWidthMod = 0.4f;
    float defaultSpriteSize = 16.0f;
    float navMapSize = this.defaultSpriteSize * this.collisionWidthMod;
    private boolean freezeAllEnemyBehaviors = false;
    Group collisionGroup;
    Array<EntryActor> otherEntries = new Array();
    Array<EntryActor> spawnClassified = new Array();
    Array<EntryActor> sourceMapMatch = new Array();
    boolean started = false;

    public boolean canEscape() {
        return !this.preventEscape;
    }

    public void clearIsInMap() {
        this.isInMap = false;
        this.effect = null;
        this.preventEscape = false;
        GameHUD.getInstance().showHideMap(true);
    }

    public void draw(Batch batch) {
        if (!this.getRoot().isVisible()) {
            return;
        }
        this.getRoot().draw(batch, 1.0f);
    }

    public MapLayer getSpriteLayer() {
        return this.spriteLayer;
    }

    public PointOfInterestChanges getChanges() {
        return TileMapScene.instance().getPointOfInterestChanges();
    }

    protected MapStage() {
        this.disposeWorld();
        this.gdxWorld = new World(new Vector2(0.0f, 0.0f), false);
        this.eventTouchDown = new InputEvent();
        this.eventTouchDown.setPointer(-1);
        this.eventTouchDown.setType(InputEvent.Type.touchDown);
        this.eventTouchUp = new InputEvent();
        this.eventTouchUp.setPointer(-1);
        this.eventTouchUp.setType(InputEvent.Type.touchUp);
    }

    public static MapStage getInstance() {
        return instance == null ? (instance = new MapStage()) : instance;
    }

    public void disposeWorld() {
        if (this.gdxWorld != null) {
            try {
                this.gdxWorld.dispose();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void addMapActor(MapObject obj, MapActor newActor) {
        newActor.setWidth(Float.parseFloat(obj.getProperties().get("width").toString()));
        newActor.setHeight(Float.parseFloat(obj.getProperties().get("height").toString()));
        newActor.setX(Float.parseFloat(obj.getProperties().get("x").toString()));
        newActor.setY(Float.parseFloat(obj.getProperties().get("y").toString()));
        this.actors.add(newActor);
        this.foregroundSprites.addActor(newActor);
    }

    public void addMapActor(MapActor newActor) {
        this.actors.add(newActor);
        this.foregroundSprites.addActor(newActor);
    }

    @Override
    public boolean isColliding(Rectangle adjustedBoundingRect) {
        for (Rectangle collision : this.collisionRect) {
            if (!collision.overlaps(adjustedBoundingRect)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void prepareCollision(Vector2 pos, Vector2 direction, Rectangle boundingRect) {
    }

    @Override
    public void debugCollision(boolean b) {
        if (this.collisionGroup == null) {
            this.collisionGroup = new Group();
            for (Rectangle rectangle : this.collisionRect) {
                MapActor collisionActor = new MapActor(0);
                collisionActor.setBoundDebug(true);
                collisionActor.setWidth(rectangle.width);
                collisionActor.setHeight(rectangle.height);
                collisionActor.setX(rectangle.x);
                collisionActor.setY(rectangle.y);
                this.collisionGroup.addActor(collisionActor);
            }
        }
        if (b) {
            this.addActor(this.collisionGroup);
        } else {
            this.collisionGroup.remove();
        }
        super.debugCollision(b);
    }

    public void loadMap(TiledMap map, String sourceMap, String targetMap) {
        this.loadMap(map, sourceMap, targetMap, 0);
    }

    public void loadMap(TiledMap map, String sourceMap, String targetMap, int spawnTargetId) {
        int oldSize;
        this.disposeWorld();
        this.gdxWorld = new World(new Vector2(0.0f, 0.0f), false);
        this.isLoadingMatch = false;
        this.isInMap = true;
        GameHUD.getInstance().showHideMap(false);
        this.tiledMap = map;
        for (MapActor actor : new Array.ArrayIterator<MapActor>(this.actors)) {
            actor.remove();
            this.foregroundSprites.removeActor(actor);
        }
        this.positions.clear();
        this.actors.clear();
        this.collisionRect.clear();
        this.waypoints.clear();
        if (this.collisionGroup != null) {
            this.collisionGroup.remove();
        }
        this.collisionGroup = null;
        float width = Float.parseFloat(map.getProperties().get("width").toString());
        float height = Float.parseFloat(map.getProperties().get("height").toString());
        float tileHeight = Float.parseFloat(map.getProperties().get("tileheight").toString());
        float tileWidth = Float.parseFloat(map.getProperties().get("tilewidth").toString());
        this.setBounds(width * tileWidth, height * tileHeight);
        MapProperties MP = map.getProperties();
        if (MP.get("dungeonEffect") != null && !MP.get("dungeonEffect").toString().isEmpty()) {
            this.effect = JSONStringLoader.parse(EffectData.class, map.getProperties().get("dungeonEffect").toString(), "");
            this.effectDialog(this.effect);
        }
        this.respawnEnemies = MP.get("respawnEnemies") != null && MP.get("respawnEnemies") instanceof Boolean && (Boolean)MP.get("respawnEnemies") != false;
        this.canFailDungeon = MP.get("canFailDungeon") != null && MP.get("canFailDungeon") instanceof Boolean && (Boolean)MP.get("canFailDungeon") != false;
        if (MP.get("preventEscape") != null) {
            this.preventEscape = (Boolean)MP.get("preventEscape");
        }
        if (MP.get("music") == null || !MP.get("music").toString().isEmpty()) {
            // empty if block
        }
        this.getPlayerSprite().stop();
        this.spriteLayer = null;
        this.otherEntries.clear();
        this.spawnClassified.clear();
        this.sourceMapMatch.clear();
        this.enemies.clear();
        for (MapLayer layer : map.getLayers()) {
            if (layer.getProperties().containsKey("spriteLayer") && layer.getProperties().get("spriteLayer", Boolean.TYPE).booleanValue()) {
                this.spriteLayer = layer;
            }
            if (layer instanceof TiledMapTileLayer) {
                this.loadCollision((TiledMapTileLayer)layer);
                continue;
            }
            this.loadObjects(layer, sourceMap, targetMap);
        }
        this.spawn(spawnTargetId);
        do {
            oldSize = this.collisionRect.size;
            block3: for (int i = 0; i < this.collisionRect.size; ++i) {
                Rectangle r1 = this.collisionRect.get(i);
                for (int j = i + 1; j < this.collisionRect.size; ++j) {
                    Rectangle r2 = this.collisionRect.get(j);
                    if (!(Math.abs(r1.x - (r2.x + r2.width)) < 1.0f && Math.abs(r1.y - r2.y) < 1.0f && Math.abs(r1.height - r2.height) < 1.0f || Math.abs(r1.x + r1.width - r2.x) < 1.0f && Math.abs(r1.y - r2.y) < 1.0f && Math.abs(r1.height - r2.height) < 1.0f || Math.abs(r1.x - r2.x) < 1.0f && Math.abs(r1.y + r1.height - r2.y) < 1.0f && Math.abs(r1.width - r2.width) < 1.0f || Math.abs(r1.x - r2.x) < 1.0f && Math.abs(r1.y - (r2.y + r2.height)) < 1.0f && Math.abs(r1.width - r2.width) < 1.0f || MapStage.containsOrEquals(r1, r2)) && !MapStage.containsOrEquals(r2, r1)) continue;
                    r1.merge(r2);
                    this.collisionRect.removeIndex(j);
                    --i;
                    continue block3;
                }
            }
        } while (oldSize != this.collisionRect.size);
        if (this.spriteLayer == null) {
            System.err.print("Warning: No spriteLayer present in map.\n");
        }
        this.navMaps.clear();
        this.navMaps.put(Float.valueOf(this.navMapSize), new NavigationMap(this.navMapSize));
        this.navMaps.get(Float.valueOf(this.navMapSize)).initializeGeometryGraph();
        this.getPlayerSprite().stop();
    }

    public void spawn(int targetId) {
        this.stop();
        boolean hasSpawned = false;
        if (targetId > 0) {
            for (int i = 0; i < this.actors.size; ++i) {
                if (this.actors.get(i).getObjectId() != targetId || !(this.actors.get(i) instanceof EntryActor)) continue;
                ((EntryActor)this.actors.get(i)).spawn();
                hasSpawned = true;
            }
        }
        if (!hasSpawned) {
            if (!this.spawnClassified.isEmpty()) {
                this.spawnClassified.first().spawn();
            } else if (!this.sourceMapMatch.isEmpty()) {
                this.sourceMapMatch.first().spawn();
            } else if (!this.otherEntries.isEmpty()) {
                this.otherEntries.first().spawn();
            }
        }
    }

    public static boolean containsOrEquals(Rectangle r1, Rectangle r2) {
        float xmi = r2.x;
        float xma = xmi + r2.width;
        float ymi = r2.y;
        float yma = ymi + r2.height;
        return xmi >= r1.x && xmi <= r1.x + r1.width && xma >= r1.x && xma <= r1.x + r1.width && ymi >= r1.y && ymi <= r1.y + r1.height && yma >= r1.y && yma <= r1.y + r1.height;
    }

    private void loadCollision(TiledMapTileLayer layer) {
        for (int x = 0; x < layer.getWidth(); ++x) {
            for (int y = 0; y < layer.getHeight(); ++y) {
                TiledMapTileLayer.Cell cell = layer.getCell(x, y);
                if (cell == null) continue;
                for (MapObject collision : cell.getTile().getObjects()) {
                    if (!(collision instanceof RectangleMapObject)) continue;
                    Rectangle r = ((RectangleMapObject)collision).getRectangle();
                    this.collisionRect.add(new Rectangle((float)(layer.getTileWidth() * x) + r.x, (float)(layer.getTileHeight() * y) + r.y, Math.round(r.width), Math.round(r.height)));
                }
            }
        }
    }

    private boolean canSpawn(MapProperties prop) {
        DifficultyData difficultyData = Current.player().getDifficulty();
        boolean spawnEasy = prop.get("spawn.Easy", Boolean.class);
        boolean spawnNorm = prop.get("spawn.Normal", Boolean.class);
        boolean spawnHard = prop.get("spawn.Hard", Boolean.class);
        if (difficultyData.spawnRank == 2 && !spawnHard) {
            return false;
        }
        if (difficultyData.spawnRank == 1 && !spawnNorm) {
            return false;
        }
        if (difficultyData.spawnRank == 0 && !spawnEasy) {
            return false;
        }
        if (!prop.containsKey("spawnCondition") || !prop.get("spawnCondition").toString().isEmpty()) {
            // empty if block
        }
        return true;
    }

    private void loadObjects(MapLayer layer, String sourceMap, String currentMap) {
        this.player.setMoveModifier(2.0f);
        Array<String> shopsAlreadyPresent = new Array<String>();
        block40: for (MapObject obj : layer.getObjects()) {
            int id;
            MapProperties prop = obj.getProperties();
            String type = prop.get("type", String.class);
            if (type == null || this.changes.isObjectDeleted(id = prop.get("id", Integer.TYPE).intValue())) continue;
            boolean hidden = !obj.isVisible();
            String rotatingShop = "";
            switch (type) {
                case "collision": {
                    float cX = Float.parseFloat(prop.get("x").toString());
                    float cY = Float.parseFloat(prop.get("y").toString());
                    float cW = Float.parseFloat(prop.get("width").toString());
                    float cH = Float.parseFloat(prop.get("height").toString());
                    this.collisionRect.add(new Rectangle(cX, cY, cW, cH));
                    break;
                }
                case "waypoint": {
                    this.waypoints.put(id, new Vector2(Float.parseFloat(prop.get("x").toString()), Float.parseFloat(prop.get("y").toString())));
                    break;
                }
                case "entry": {
                    float x = Float.parseFloat(prop.get("x").toString());
                    float y = Float.parseFloat(prop.get("y").toString());
                    float w = Float.parseFloat(prop.get("width").toString());
                    float h2 = Float.parseFloat(prop.get("height").toString());
                    String targetMap = prop.containsKey("teleport") ? prop.get("teleport").toString() : "";
                    String direction = prop.containsKey("direction") ? prop.get("direction").toString() : "";
                    boolean canStillSpawnPlayerThere = targetMap == null || targetMap.isEmpty() && sourceMap.isEmpty() || !sourceMap.isEmpty() && targetMap.equals(sourceMap);
                    int entryTargetId = !prop.containsKey("teleportObjectId") || prop.get("teleportObjectId") == null || prop.get("teleportObjectId").toString().isEmpty() ? 0 : Integer.parseInt(prop.get("teleportObjectId").toString());
                    EntryActor entry = new EntryActor(this, id, targetMap, x, y, w, h2, direction, currentMap, entryTargetId);
                    if (prop.containsKey("spawn") && prop.get("spawn").toString().equals("true")) {
                        this.spawnClassified.add(entry);
                    } else if (canStillSpawnPlayerThere) {
                        this.sourceMapMatch.add(entry);
                    } else {
                        this.otherEntries.add(entry);
                    }
                    if (prop.containsKey("noExit") && !prop.get("noExit").toString().equals("false")) continue block40;
                    this.addMapActor(obj, entry);
                    break;
                }
                case "portal": {
                    float px = Float.parseFloat(prop.get("x").toString());
                    float py = Float.parseFloat(prop.get("y").toString());
                    float pw = Float.parseFloat(prop.get("width").toString());
                    float ph = Float.parseFloat(prop.get("height").toString());
                    Object portalSpriteProvided = prop.get("sprite");
                    String portalSpriteToUse = "sprites/portal.atlas";
                    if (portalSpriteProvided != null && !portalSpriteProvided.toString().isEmpty()) {
                        portalSpriteToUse = portalSpriteProvided.toString();
                    } else {
                        System.err.printf("No sprite defined for portal (ID:%s), defaulting to \"sprites/portal.atlas\"", id);
                    }
                    String portalTargetMap = prop.get("teleport").toString();
                    boolean validSpawnPoint = portalTargetMap == null || portalTargetMap.isEmpty() && sourceMap.isEmpty() || !sourceMap.isEmpty() && portalTargetMap.equals(sourceMap);
                    int portalTargetId = !prop.containsKey("teleportObjectId") || prop.get("teleportObjectId") == null || prop.get("teleportObjectId").toString().isEmpty() ? 0 : Integer.parseInt(prop.get("teleportObjectId").toString());
                    PortalActor portal = new PortalActor(this, id, prop.get("teleport").toString(), px, py, pw, ph, prop.get("direction").toString(), currentMap, portalTargetId, portalSpriteToUse);
                    if (prop.containsKey("activeQuestFlag") && Current.player().checkQuestFlag(prop.get("activeQuestFlag").toString())) {
                        portal.setAnimation("active");
                    } else if (prop.containsKey("inactiveQuestFlag") && Current.player().checkQuestFlag(prop.get("inactiveQuestFlag").toString())) {
                        portal.setAnimation("inactive");
                    } else if (prop.containsKey("closedQuestFlag") && Current.player().checkQuestFlag(prop.get("closedQuestFlag").toString())) {
                        portal.setAnimation("closed");
                    } else if (prop.containsKey("portalState")) {
                        portal.setAnimation(prop.get("portalState").toString());
                    }
                    if (prop.containsKey("spawn") && prop.get("spawn").toString().equals("true")) {
                        this.spawnClassified.add(portal);
                    } else if (validSpawnPoint) {
                        this.sourceMapMatch.add(portal);
                    } else {
                        this.otherEntries.add(portal);
                    }
                    this.addMapActor(obj, portal);
                    break;
                }
                case "reward": {
                    if (!this.canSpawn(prop)) break;
                    Object R = prop.get("reward");
                    if (R == null || R.toString().isEmpty()) continue block40;
                    Object S = prop.get("sprite");
                    String Sp = "sprites/treasure.atlas";
                    if (S != null && !S.toString().isEmpty()) {
                        Sp = S.toString();
                    } else {
                        System.err.printf("No sprite defined for reward (ID:%s), defaulting to \"sprites/treasure.atlas\"", id);
                    }
                    RewardSprite RW = new RewardSprite(id, R.toString(), Sp);
                    RW.hidden = hidden;
                    this.addMapActor(obj, RW);
                    break;
                }
                case "enemy": {
                    if (!this.canSpawn(prop)) break;
                    Object enemy = prop.get("enemy");
                    if (enemy == null || enemy.toString().isEmpty()) continue block40;
                    EnemyData EN = WorldData.getEnemy(enemy.toString());
                    if (EN == null) {
                        System.err.printf("Enemy \"%s\" not found, choosing a random one for current biome\n", enemy);
                        forge.adventure.world.World world = Current.world();
                        Vector2 poiPos = AdventureQuestController.instance().mostRecentPOI.getPosition();
                        int currentBiome = forge.adventure.world.World.highestBiome(world.getBiome((int)poiPos.x / world.getTileSize(), (int)poiPos.y / world.getTileSize()));
                        EN = world.getData().GetBiomes().get(currentBiome).getEnemy(1.0f);
                    }
                    EnemySprite mob = new EnemySprite(id, EN);
                    Object dialogObject = prop.get("dialog");
                    if (dialogObject != null && !dialogObject.toString().isEmpty()) {
                        mob.dialog = new MapDialog(dialogObject.toString(), this, mob.getId());
                    }
                    if ((dialogObject = prop.get("defeatDialog")) != null && !dialogObject.toString().isEmpty()) {
                        mob.defeatDialog = new MapDialog(dialogObject.toString(), this, mob.getId());
                    }
                    if ((dialogObject = prop.get("displayNameOverride")) != null && !dialogObject.toString().isEmpty()) {
                        mob.nameOverride = dialogObject.toString();
                    }
                    if ((dialogObject = prop.get("effect")) != null && !dialogObject.toString().isEmpty()) {
                        mob.effect = JSONStringLoader.parse(EffectData.class, dialogObject.toString(), "");
                    }
                    if ((dialogObject = prop.get("ignoreDungeonEffect")) != null && !dialogObject.toString().isEmpty()) {
                        mob.ignoreDungeonEffect = Boolean.parseBoolean(dialogObject.toString());
                    }
                    if ((dialogObject = prop.get("reward")) != null && !dialogObject.toString().isEmpty()) {
                        mob.rewards = JSONStringLoader.parse(RewardData[].class, dialogObject.toString(), "[]");
                    }
                    if (prop.containsKey("threatRange")) {
                        mob.threatRange = Float.parseFloat(prop.get("threatRange").toString());
                    }
                    if (prop.containsKey("threatRange")) {
                        mob.pursueRange = Float.parseFloat(prop.get("pursueRange").toString());
                    }
                    if (prop.containsKey("fleeRange")) {
                        mob.fleeRange = Float.parseFloat(prop.get("fleeRange").toString());
                    }
                    if (prop.containsKey("speed")) {
                        mob.getData().speed = Float.parseFloat(prop.get("speed").toString());
                    }
                    if (prop.containsKey("flying")) {
                        mob.getData().flying = Boolean.parseBoolean(prop.get("flying").toString());
                    }
                    if (prop.containsKey("hidden")) {
                        hidden = Boolean.parseBoolean(prop.get("hidden").toString());
                    }
                    if (prop.containsKey("inactive")) {
                        mob.inactive = Boolean.parseBoolean(prop.get("inactive").toString());
                        if (mob.inactive) {
                            mob.clearCollisionHeight();
                        }
                    }
                    if ((dialogObject = prop.get("deckOverride")) != null && !dialogObject.toString().isEmpty()) {
                        mob.overrideDeck(dialogObject.toString());
                    }
                    if (hidden) {
                        mob.hidden = hidden;
                        mob.setAnimation(CharacterSprite.AnimationTypes.Hidden);
                    }
                    if ((dialogObject = prop.get("waypoints")) != null && !dialogObject.toString().isEmpty()) {
                        mob.parseWaypoints(dialogObject.toString());
                    }
                    if (prop.containsKey("speedModifier")) {
                        mob.speedModifier = Float.parseFloat(prop.get("speedModifier").toString());
                    }
                    this.enemies.add(mob);
                    this.addMapActor(obj, mob);
                    break;
                }
                case "dummy": {
                    TiledMapTileMapObject obj2 = (TiledMapTileMapObject)obj;
                    DummySprite D = new DummySprite(id, obj2.getTextureRegion(), this);
                    if (prop.containsKey("blocking")) {
                        D.blocking = Boolean.parseBoolean(prop.get("blocking").toString());
                    }
                    if (prop.containsKey("hidden")) {
                        D.setVisible(!Boolean.parseBoolean(prop.get("hidden").toString()));
                    }
                    this.addMapActor(obj, D);
                    break;
                }
                case "inn": {
                    this.addMapActor(obj, new OnCollide(() -> Forge.switchScene(InnScene.instance(TileMapScene.instance(), TileMapScene.instance().rootPoint.getID(), this.changes, id))));
                    break;
                }
                case "spellsmith": {
                    this.addMapActor(obj, new OnCollide(() -> Forge.switchScene(SpellSmithScene.instance())));
                    break;
                }
                case "shardtrader": {
                    OnCollide shardTraderActor = new OnCollide(() -> Forge.switchScene(ShardTraderScene.instance()));
                    this.addMapActor(obj, shardTraderActor);
                    if (!prop.containsKey("hasSign") || !Boolean.parseBoolean(prop.get("hasSign").toString()) || !prop.containsKey("signYOffset") || !prop.containsKey("signXOffset")) continue block40;
                    try {
                        TextureSprite sprite = new TextureSprite(Config.instance().getAtlasSprite("maps/tileset/buildings.atlas", "ShardTrader"));
                        sprite.setX(shardTraderActor.getX() + Float.parseFloat(prop.get("signXOffset").toString()));
                        sprite.setY(shardTraderActor.getY() + Float.parseFloat(prop.get("signYOffset").toString()));
                        this.addMapActor(sprite);
                    }
                    catch (Exception e) {
                        System.err.print("Can not create Texture for Shard Trader");
                    }
                    break;
                }
                case "arena": {
                    this.addMapActor(obj, new OnCollide(() -> {
                        ArenaData arenaData = JSONStringLoader.parse(ArenaData.class, prop.get("arena").toString(), "");
                        ArenaScene.instance().loadArenaData(arenaData, WorldSave.getCurrentSave().getWorld().getRandom().nextLong());
                        Forge.switchScene(ArenaScene.instance());
                    }));
                    break;
                }
                case "exit": {
                    this.addMapActor(obj, new OnCollide(() -> this.exitDungeon(false)));
                    break;
                }
                case "dialog": {
                    if (!(obj instanceof TiledMapTileMapObject)) continue block40;
                    TiledMapTileMapObject tiledObj = (TiledMapTileMapObject)obj;
                    DialogActor dialog = prop.containsKey("sprite") ? new DialogActor(this, id, prop.get("dialog").toString(), prop.get("sprite").toString()) : new DialogActor(this, id, prop.get("dialog").toString(), tiledObj.getTextureRegion());
                    if (prop.containsKey("hidden") && Boolean.parseBoolean(prop.get("hidden").toString())) {
                        dialog.setVisible(false);
                    }
                    this.addMapActor(obj, dialog);
                    break;
                }
                case "quest": {
                    if (!prop.containsKey("questtype")) continue block40;
                    String questOrigin = prop.containsKey("questtype") ? prop.get("questtype").toString() : "";
                    QuestActor questActor = new QuestActor(TileMapScene.instance().rootPoint.getID(), this.changes, questOrigin, this, id);
                    questActor.setVisible(false);
                    this.addMapActor(obj, questActor);
                    break;
                }
                case "Rotating": {
                    String rotation = "";
                    if (prop.containsKey("rotation")) {
                        rotation = prop.get("rotation").toString();
                    }
                    Array<String> possibleShops = new Array<String>(rotation.split(","));
                    if (possibleShops.size > 0) {
                        long rotatingRandomSeed = WorldSave.getCurrentSave().getWorld().getRandom().nextLong() + LocalDate.now().toEpochDay();
                        Random rotatingShopRandom = new Random(rotatingRandomSeed);
                        rotatingShop = possibleShops.get(rotatingShopRandom.nextInt(possibleShops.size));
                        this.changes.setRotatingShopSeed(id, rotatingRandomSeed);
                    }
                }
                case "shop": {
                    Array<ShopData> shops;
                    boolean isRotatingShop;
                    int restockPrice = 0;
                    String shopList = "";
                    boolean bl = isRotatingShop = !rotatingShop.isEmpty();
                    if (isRotatingShop) {
                        shopList = rotatingShop;
                        restockPrice = 7;
                    } else {
                        int rarity = WorldSave.getCurrentSave().getWorld().getRandom().nextInt(100);
                        if (rarity > 95 & prop.containsKey("mythicShopList")) {
                            shopList = prop.get("mythicShopList").toString();
                            restockPrice = 5;
                        }
                        if (shopList.isEmpty() && rarity > 85 & prop.containsKey("rareShopList")) {
                            shopList = prop.get("rareShopList").toString();
                            restockPrice = 4;
                        }
                        if (shopList.isEmpty() && rarity > 55 & prop.containsKey("uncommonShopList")) {
                            shopList = prop.get("uncommonShopList").toString();
                            restockPrice = 3;
                        }
                        if (shopList.isEmpty() && prop.containsKey("commonShopList")) {
                            shopList = prop.get("commonShopList").toString();
                            restockPrice = 2;
                        }
                        if (shopList.trim().isEmpty() && prop.containsKey("shopList")) {
                            shopList = prop.get("shopList").toString();
                            restockPrice = 0;
                        }
                        shopList = shopList.replaceAll("\\s", "");
                    }
                    if (prop.containsKey("noRestock") && ((Boolean)prop.get("noRestock")).booleanValue()) {
                        restockPrice = 0;
                    }
                    Array<String> possibleShops = new Array<String>(shopList.split(","));
                    Array<Object> filteredPossibleShops = new Array();
                    if (!isRotatingShop) {
                        for (String string : possibleShops) {
                            if (shopsAlreadyPresent.contains(string, false)) continue;
                            filteredPossibleShops.add(string);
                        }
                    }
                    if (filteredPossibleShops.isEmpty()) {
                        filteredPossibleShops = possibleShops;
                    }
                    if (filteredPossibleShops.size == 0 || shopList.isEmpty()) {
                        shops = WorldData.getShopList();
                    } else {
                        shops = new Array();
                        for (ShopData data : new Array.ArrayIterator<ShopData>(WorldData.getShopList())) {
                            if (!filteredPossibleShops.contains(data.name, false)) continue;
                            data.restockPrice = restockPrice;
                            shops.add(data);
                        }
                    }
                    if (shops.size == 0) continue block40;
                    ShopData shopData = shops.get(WorldSave.getCurrentSave().getWorld().getRandom().nextInt(shops.size));
                    shopsAlreadyPresent.add(shopData.name);
                    Array<Reward> ret = new Array<Reward>();
                    WorldSave.getCurrentSave().getWorld().getRandom().setSeed(this.changes.getShopSeed(id));
                    for (RewardData rdata : new Array.ArrayIterator<RewardData>(shopData.rewards)) {
                        ret.addAll(rdata.generate(false, false));
                    }
                    ShopActor actor = new ShopActor(this, id, ret, shopData);
                    this.addMapActor(obj, actor);
                    if (!prop.containsKey("hasSign") || !((Boolean)prop.get("hasSign")).booleanValue() || !prop.containsKey("signYOffset") || !prop.containsKey("signXOffset")) continue block40;
                    try {
                        TextureSprite sprite = new TextureSprite(Config.instance().getAtlasSprite(shopData.spriteAtlas, shopData.sprite));
                        sprite.setX(actor.getX() + Float.parseFloat(prop.get("signXOffset").toString()));
                        sprite.setY(actor.getY() + Float.parseFloat(prop.get("signYOffset").toString()));
                        this.addMapActor(sprite);
                        if (shopData.overlaySprite == null || shopData.overlaySprite.isEmpty()) continue block40;
                        TextureSprite overlay = new TextureSprite(Config.instance().getAtlasSprite(shopData.spriteAtlas, shopData.overlaySprite));
                        overlay.setX(actor.getX() + Float.parseFloat(prop.get("signXOffset").toString()));
                        overlay.setY(actor.getY() + Float.parseFloat(prop.get("signYOffset").toString()));
                        this.addMapActor(overlay);
                    }
                    catch (Exception e) {
                        System.err.print("Can not create Texture for " + shopData.sprite + " Obj:" + shopData);
                    }
                    break;
                }
                default: {
                    System.err.println("Unexpected value: " + type);
                }
            }
        }
    }

    public boolean exitDungeon(boolean defeated) {
        AdventureQuestController.instance().updateQuestsLeave();
        this.clearIsInMap();
        AdventureQuestController.instance().showQuestDialogs(this);
        this.isLoadingMatch = false;
        this.effect = null;
        if (defeated) {
            WorldStage.getInstance().resetPlayerLocation();
        }
        Forge.switchScene(GameScene.instance());
        return true;
    }

    @Override
    public void setWinner(boolean playerWins) {
        this.isLoadingMatch = false;
        this.freezeAllEnemyBehaviors = true;
        if (playerWins) {
            this.currentMob.clearCollisionHeight();
            Current.player().win();
            this.player.setAnimation(CharacterSprite.AnimationTypes.Attack);
            this.currentMob.playEffect("particle_effects/blood.p", 0.5f);
            Timer.schedule(new Timer.Task(){

                @Override
                public void run() {
                    MapStage.this.currentMob.setAnimation(CharacterSprite.AnimationTypes.Death);
                    MapStage.this.currentMob.resetCollisionHeight();
                    MapStage.this.startPause(0.3f, () -> {
                        MapStage.this.getReward();
                        AdventureQuestController.instance().updateQuestsWin(MapStage.this.currentMob, MapStage.this.enemies);
                        AdventureQuestController.instance().showQuestDialogs(MapStage.this);
                        MapStage.this.currentMob = null;
                    });
                    MapStage.this.player.setAnimation(CharacterSprite.AnimationTypes.Idle);
                }
            }, 1.0f);
        } else {
            this.currentMob.clearCollisionHeight();
            this.player.setAnimation(CharacterSprite.AnimationTypes.Hit);
            this.currentMob.setAnimation(CharacterSprite.AnimationTypes.Attack);
            this.startPause(0.3f, () -> {
                this.player.setAnimation(CharacterSprite.AnimationTypes.Idle);
                this.currentMob.setAnimation(CharacterSprite.AnimationTypes.Idle);
                this.currentMob.resetCollisionHeight();
                if (this.positions.peek() != null) {
                    this.player.setPosition(this.positions.peek());
                }
                this.currentMob.freezeMovement();
                AdventureQuestController.instance().updateQuestsLose(this.currentMob);
                AdventureQuestController.instance().showQuestDialogs(this);
                boolean defeated = Current.player().defeated();
                if (this.canFailDungeon && !defeated) {
                    this.dungeonFailedDialog(true);
                } else {
                    this.exitDungeon(defeated);
                }
                this.stop();
                this.currentMob = null;
            });
        }
    }

    private void dungeonFailedDialog(final boolean exit) {
        this.dialog.getButtonTable().clear();
        this.dialog.getContentTable().clear();
        this.dialog.clearListeners();
        final TextraButton ok = Controls.newTextButton("OK", this::hideDialog);
        ok.setVisible(false);
        final TypingLabel L = Controls.newTypingLabel("{GRADIENT=RED;WHITE;1;1}Defeated and unable to continue, you use the last of your power to escape the area.");
        L.setWrap(true);
        L.setTypingListener(new TypingAdapter(){

            @Override
            public void end() {
                ok.setVisible(true);
            }
        });
        this.dialog.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                L.skipToTheEnd();
                super.clicked(event, x, y);
                if (exit) {
                    MapStage.this.exitDungeon(false);
                }
            }
        });
        this.dialog.getButtonTable().add(ok).width(240.0f);
        this.dialog.getContentTable().add(L).width(250.0f);
        this.dialog.setKeepWithinStage(true);
        this.showDialog();
    }

    public boolean deleteObject(int id) {
        this.changes.deleteObject(id);
        for (int i = 0; i < this.actors.size; ++i) {
            if (this.actors.get(i).getObjectId() != id || id <= 0) continue;
            if (this.actors.get(i).getClass().equals(EnemySprite.class)) {
                this.enemies.remove((EnemySprite)this.actors.get(i));
            }
            this.actors.get(i).remove();
            this.actors.removeIndex(i);
            return true;
        }
        return false;
    }

    public boolean activateMapObject(int id) {
        if (this.changes.isObjectDeleted(id)) {
            return false;
        }
        for (int i = 0; i < this.actors.size; ++i) {
            if (this.actors.get(i).getObjectId() != id || id <= 0) continue;
            if (this.actors.get(i) instanceof EnemySprite) {
                ((EnemySprite)this.actors.get((int)i)).inactive = false;
                this.actors.get(i).resetCollisionHeight();
                return true;
            }
            if (!(this.actors.get(i) instanceof PortalActor)) continue;
            PortalActor thisPortal = (PortalActor)this.actors.get(i);
            if (thisPortal.getAnimation().equals("active")) {
                thisPortal.setAnimation("closed");
            } else {
                thisPortal.setAnimation("active");
            }
            return true;
        }
        return false;
    }

    public boolean lookForID(int id) {
        for (MapActor A2 : new Array.ArrayIterator<MapActor>(this.actors)) {
            if (A2.getId() != id) continue;
            return true;
        }
        return false;
    }

    public EnemySprite getEnemyByID(int id) {
        for (MapActor A2 : new Array.ArrayIterator<MapActor>(this.actors)) {
            if (!(A2 instanceof EnemySprite) || A2.getId() != id) continue;
            return (EnemySprite)A2;
        }
        return null;
    }

    public Actor getByID(int id) {
        for (MapActor A2 : new Array.ArrayIterator<MapActor>(this.actors)) {
            if (A2.getId() != id) continue;
            return A2;
        }
        return null;
    }

    protected void getReward() {
        this.isLoadingMatch = false;
        RewardScene.instance().loadRewards(this.currentMob.getRewards(), RewardScene.Type.Loot, null);
        Forge.switchScene(RewardScene.instance());
        if (this.currentMob.defeatDialog == null) {
            this.currentMob.remove();
            this.actors.removeValue(this.currentMob, true);
            if (!this.respawnEnemies || this.currentMob.getData().boss) {
                this.changes.deleteObject(this.currentMob.getId());
            }
            this.enemies.remove(this.currentMob);
        } else {
            this.currentMob.defeatDialog.activate();
            this.player.setAnimation(CharacterSprite.AnimationTypes.Idle);
            this.currentMob.setAnimation(CharacterSprite.AnimationTypes.Idle);
        }
    }

    public void removeAllEnemies() {
        Array<Integer> idsToRemove = new Array<Integer>();
        for (MapActor actor : new Array.ArrayIterator<MapActor>(this.actors)) {
            if (!(actor instanceof EnemySprite)) continue;
            idsToRemove.add(actor.getObjectId());
        }
        for (Integer i : idsToRemove) {
            this.deleteObject(i);
        }
    }

    @Override
    protected void onActing(float delta) {
        if (this.isPaused() || this.isDialogOnlyInput() || Forge.advFreezePlayerControls) {
            return;
        }
        Iterator<EnemySprite> it = this.enemies.iterator();
        if (this.freezeAllEnemyBehaviors) {
            if (!this.positions.contains(this.player.pos())) {
                this.freezeAllEnemyBehaviors = false;
            } else {
                return;
            }
        }
        float mobSize = this.navMapSize;
        ArrayList<NavigationVertex> verticesNearPlayer = new ArrayList<NavigationVertex>(this.navMaps.get((Object)Float.valueOf((float)mobSize)).navGraph.getNodes());
        verticesNearPlayer.sort(Comparator.comparingInt(o -> Math.round((o.pos.x - this.player.pos().x) * (o.pos.x - this.player.pos().x) + (o.pos.y - this.player.pos().y) * (o.pos.y - this.player.pos().y))));
        if (!this.freezeAllEnemyBehaviors) {
            while (it.hasNext()) {
                EnemySprite mob = it.next();
                if (mob.inactive) continue;
                mob.updatePositon();
                ProgressableGraphPath<Object> navPath = new ProgressableGraphPath<NavigationVertex>(0);
                if (mob.getData().flying) {
                    navPath.add(new NavigationVertex(mob.getTargetVector(this.player, null, delta)));
                } else {
                    Vector2 destination = mob.getTargetVector(this.player, verticesNearPlayer, delta);
                    if (mob.isFrozen() || destination.epsilonEquals(mob.pos()) && !mob.aggro) {
                        mob.setAnimation(CharacterSprite.AnimationTypes.Idle);
                        continue;
                    }
                    if (destination.equals(mob.targetVector) && mob.getNavPath() != null) {
                        navPath = mob.getNavPath();
                    }
                    if (navPath.nodes.size == 0 || !destination.equals(mob.targetVector)) {
                        mob.targetVector = destination;
                        navPath = this.navMaps.get(Float.valueOf(mobSize)).findShortestPath(Float.valueOf(mobSize), mob.pos(), mob.targetVector);
                    }
                    if (mob.aggro) {
                        navPath.add(new NavigationVertex(this.player.pos()));
                    }
                }
                if (navPath == null || navPath.getCount() == 0 || navPath.get(0) == null) {
                    mob.setAnimation(CharacterSprite.AnimationTypes.Idle);
                    continue;
                }
                Vector2 currentVector = null;
                while (navPath.getCount() > 0 && navPath.get(0) != null && (((NavigationVertex)navPath.get((int)0)).pos == null || ((NavigationVertex)navPath.get((int)0)).pos.dst(mob.pos()) < 0.5f)) {
                    navPath.remove(0);
                }
                if (navPath.getCount() != 0) {
                    currentVector = new Vector2(((NavigationVertex)navPath.get((int)0)).pos).sub(mob.pos());
                }
                mob.setNavPath(navPath);
                mob.clearActions();
                if (currentVector == null || currentVector.x == 0.0f && currentVector.y == 0.0f) {
                    mob.setAnimation(CharacterSprite.AnimationTypes.Idle);
                    continue;
                }
                mob.steer(currentVector);
                mob.update(delta);
            }
        }
        float sprintingMod = this.currentModifications.containsKey((Object)GameStage.PlayerModification.Sprint) ? 2.0f : 1.0f;
        this.player.setMoveModifier(2.0f * sprintingMod);
        this.positions.add(this.player.pos());
        if (this.positions.size() > 4) {
            this.positions.remove();
        }
        for (MapActor actor : new Array.ArrayIterator<MapActor>(this.actors)) {
            if (!actor.collideWithPlayer(this.player)) continue;
            if (actor instanceof EnemySprite) {
                EnemySprite mob;
                this.currentMob = mob = (EnemySprite)actor;
                this.resetPosition();
                if (mob.dialog != null && mob.dialog.canShow()) {
                    mob.dialog.activate();
                    break;
                }
                this.beginDuel(mob);
                break;
            }
            if (!(actor instanceof RewardSprite)) continue;
            this.freezeAllEnemyBehaviors = true;
            Gdx.input.vibrate(50);
            if (Controllers.getCurrent() != null && Controllers.getCurrent().canVibrate()) {
                Controllers.getCurrent().startVibration(100, 1.0f);
            }
            RewardSprite RS = (RewardSprite)actor;
            Array<Reward> rewards = RS.getRewards();
            if (rewards.size == 1) {
                Reward reward = rewards.get(0);
                switch (reward.getType()) {
                    case Life: 
                    case Shards: 
                    case Gold: {
                        String message = Forge.getLocalizer().getMessageorUseDefault("lbl" + reward.getType().name(), reward.getType().name(), new Object[0]);
                        AdventurePlayer.current().addStatusMessage(reward.getType().name(), message, reward.getCount(), actor.getX(), actor.getY() + this.player.getHeight());
                        AdventurePlayer.current().addReward(reward);
                        break;
                    }
                    default: {
                        this.showRewardScene(rewards);
                        break;
                    }
                }
            } else {
                this.showRewardScene(rewards);
            }
            RS.remove();
            this.actors.removeValue(RS, true);
            this.changes.deleteObject(RS.getId());
            break;
        }
    }

    private void showRewardScene(Array<Reward> rewards) {
        this.startPause(0.1f, () -> {
            RewardScene.instance().loadRewards(rewards, RewardScene.Type.Loot, null);
            Forge.switchScene(RewardScene.instance());
        });
    }

    public void beginDuel(EnemySprite mob) {
        int duration;
        if (mob == null) {
            return;
        }
        mob.clearCollisionHeight();
        this.currentMob = mob;
        this.player.setAnimation(CharacterSprite.AnimationTypes.Attack);
        this.player.playEffect("particle_effects/sparks.p", 0.5f);
        mob.setAnimation(CharacterSprite.AnimationTypes.Attack);
        SoundSystem.instance.play(SoundEffectType.Block, false);
        Gdx.input.vibrate(50);
        int n = duration = mob.getData().boss ? 400 : 200;
        if (Controllers.getCurrent() != null && Controllers.getCurrent().canVibrate()) {
            Controllers.getCurrent().startVibration(duration, 1.0f);
        }
        Forge.advFreezePlayerControls = true;
        this.player.clearCollisionHeight();
        this.startPause(0.8f, () -> {
            if (this.started) {
                return;
            }
            this.started = true;
            Forge.setCursor(null, Forge.magnifyToggle ? "1" : "2");
            SoundSystem.instance.play(SoundEffectType.ManaBurn, false);
            DuelScene duelScene = DuelScene.instance();
            FThreads.invokeInEdtNowOrLater(() -> {
                if (!this.isLoadingMatch) {
                    this.isLoadingMatch = true;
                    Forge.setTransitionScreen(new TransitionScreen(() -> {
                        this.started = false;
                        duelScene.initDuels(this.player, mob);
                        if (this.isInMap && this.effect != null && !mob.ignoreDungeonEffect) {
                            duelScene.setDungeonEffect(this.effect);
                        }
                        Forge.switchScene(duelScene);
                    }, Forge.takeScreenshot(), true, false, false, false, "", Current.player().avatar(), mob.getAtlasPath(), Current.player().getName(), mob.getName()));
                }
            });
        });
    }

    public void setPointOfInterest(PointOfInterestChanges change) {
        this.changes = change;
    }

    public boolean isInMap() {
        return this.isInMap;
    }

    @Override
    public void showDialog() {
        if (this.dialogStage == null) {
            this.setDialogStage(GameHUD.getInstance());
        }
        GameHUD.getInstance().playerIdle();
        this.dialogButtonMap.clear();
        for (int i = 0; i < this.dialog.getButtonTable().getCells().size; ++i) {
            this.dialogButtonMap.add((TextraButton)this.dialog.getButtonTable().getCells().get(i).getActor());
        }
        this.freezeAllEnemyBehaviors = true;
        this.dialog.show(this.dialogStage, Actions.show());
        this.dialog.setPosition((this.dialogStage.getWidth() - this.dialog.getWidth()) / 2.0f, (this.dialogStage.getHeight() - this.dialog.getHeight()) / 2.0f);
        this.dialogOnlyInput = true;
        if (Forge.hasGamepad() && !this.dialogButtonMap.isEmpty()) {
            this.dialogStage.setKeyboardFocus((Actor)this.dialogButtonMap.first());
        }
    }

    public void resetPosition() {
        if (this.positions.peek() != null) {
            this.player.setPosition(this.positions.peek());
        }
        this.stop();
    }

    public void setQuestFlag(String key, int value) {
        this.changes.getMapFlags().put(key, (byte)value);
        AdventureQuestController.instance().updateQuestsMapFlag(key, value);
        AdventureQuestController.instance().showQuestDialogs(this);
    }

    public void advanceQuestFlag(String key) {
        Map<String, Byte> C2 = this.changes.getMapFlags();
        if (C2.get(key) != null) {
            C2.put(key, (byte)(C2.get(key) + 1));
        } else {
            C2.put(key, (byte)1);
        }
        AdventureQuestController.instance().updateQuestsMapFlag(key, this.changes.getMapFlags().get(key).byteValue());
        AdventureQuestController.instance().showQuestDialogs(this);
    }

    public boolean checkQuestFlag(String key) {
        return this.changes.getMapFlags().get(key) != null;
    }

    public int getQuestFlag(String key) {
        return this.changes.getMapFlags().getOrDefault(key, (byte)0).byteValue();
    }

    public void resetQuestFlags() {
        this.changes.getMapFlags().clear();
    }

    public boolean dialogInput(int keycode) {
        if (this.dialogOnlyInput) {
            if (KeyBinding.Up.isPressed(keycode)) {
                this.selectPreviousDialogButton();
            }
            if (KeyBinding.Down.isPressed(keycode)) {
                this.selectNextDialogButton();
            }
            if (KeyBinding.Use.isPressed(keycode)) {
                this.performTouch(this.dialogStage.getKeyboardFocus());
            }
        }
        return true;
    }

    public void performTouch(final Actor actor) {
        if (actor == null) {
            return;
        }
        actor.fire(this.eventTouchDown);
        Timer.schedule(new Timer.Task(){

            @Override
            public void run() {
                actor.fire(MapStage.this.eventTouchUp);
            }
        }, 0.1f);
    }

    private void selectNextDialogButton() {
        if (this.dialogButtonMap.size < 2) {
            return;
        }
        if (!(this.dialogStage.getKeyboardFocus() instanceof Button)) {
            this.dialogStage.setKeyboardFocus((Actor)this.dialogButtonMap.first());
            return;
        }
        for (int i = 0; i < this.dialogButtonMap.size; ++i) {
            if (this.dialogStage.getKeyboardFocus() != this.dialogButtonMap.get(i)) continue;
            ++i;
            this.dialogStage.setKeyboardFocus((Actor)this.dialogButtonMap.get(i %= this.dialogButtonMap.size));
            return;
        }
    }

    private void selectPreviousDialogButton() {
        if (this.dialogButtonMap.size < 2) {
            return;
        }
        if (!(this.dialogStage.getKeyboardFocus() instanceof Button)) {
            this.dialogStage.setKeyboardFocus((Actor)this.dialogButtonMap.first());
            return;
        }
        for (int i = 0; i < this.dialogButtonMap.size; ++i) {
            if (this.dialogStage.getKeyboardFocus() != this.dialogButtonMap.get(i)) continue;
            if (--i < 0) {
                i = this.dialogButtonMap.size - 1;
            }
            this.dialogStage.setKeyboardFocus((Actor)this.dialogButtonMap.get(i));
            return;
        }
    }
}

