/*
 * Decompiled with CFR 0.152.
 */
package forge.adventure.stage;

import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.Sprite;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.utils.Array;
import forge.adventure.data.BiomeSpriteData;
import forge.adventure.pointofintrest.PointOfInterest;
import forge.adventure.pointofintrest.PointOfInterestChanges;
import forge.adventure.scene.MapViewScene;
import forge.adventure.stage.PointOfInterestMapSprite;
import forge.adventure.util.Config;
import forge.adventure.world.WorldSave;
import java.util.List;
import org.apache.commons.lang3.tuple.Pair;

public class MapSprite
extends Actor {
    public static int BackgroundLayer = -1;
    public static int SpriteLayer = 0;
    TextureRegion texture;
    Sprite bookmark = Config.instance().getItemSprite("Star");
    Sprite magnifier = Config.instance().getItemSprite("Magnifier");
    boolean isCaveDungeon;
    boolean isOldorVisited;
    boolean isBookmarked;

    public MapSprite(Vector2 pos, TextureRegion sprite, PointOfInterest point) {
        if (point != null) {
            PointOfInterestChanges changes = WorldSave.getCurrentSave().getPointOfInterestChanges(point.getID());
            this.setBookmarked(changes.isBookmarked(), point);
            boolean bl = this.isCaveDungeon = "cave".equalsIgnoreCase(point.getData().type) || "dungeon".equalsIgnoreCase(point.getData().type);
            if (point.getData().map != null && point.getID() != null) {
                this.isOldorVisited = changes.hasDeletedObjects();
            }
        } else {
            this.setBookmarked(false, null);
        }
        this.texture = sprite;
        this.setPosition(pos.x, pos.y);
        this.setHeight(this.texture.getRegionHeight());
        this.setWidth(this.texture.getRegionWidth());
    }

    public void checkOut() {
        this.isOldorVisited = true;
    }

    public void setBookmarked(boolean val, PointOfInterest poi) {
        this.isBookmarked = val;
        if (this.isBookmarked) {
            MapViewScene.instance().addBookmark(poi);
        } else {
            MapViewScene.instance().removeBookmark(poi);
        }
    }

    public static Array<Actor> getMapSprites(int chunkX, int chunkY, int layer) {
        Array<Actor> actorGroup = new Array<Actor>();
        List<Pair<Vector2, Integer>> objects = WorldSave.getCurrentSave().getWorld().GetMapObjects(chunkX, chunkY);
        if (layer == SpriteLayer) {
            List<PointOfInterest> pointsOfInterest = WorldSave.getCurrentSave().getWorld().getPointsOfInterest(chunkX, chunkY);
            for (PointOfInterest poi : pointsOfInterest) {
                PointOfInterestMapSprite sprite = new PointOfInterestMapSprite(poi);
                actorGroup.add(sprite);
            }
        }
        for (Pair<Vector2, Integer> entry : objects) {
            Sprite biomeSprite;
            BiomeSpriteData data = WorldSave.getCurrentSave().getWorld().getObject(entry.getValue());
            if (data.layer != layer || (biomeSprite = WorldSave.getCurrentSave().getWorld().getData().GetBiomeSprites().getSprite(data.name, (int)entry.getKey().x + (int)entry.getKey().y * 11483)) == null) continue;
            MapSprite sprite = new MapSprite(entry.getKey(), biomeSprite, null);
            actorGroup.add(sprite);
        }
        return actorGroup;
    }

    @Override
    public void draw(Batch batch, float parentAlpha) {
        if (this.texture == null) {
            return;
        }
        batch.draw(this.texture, this.getX(), this.getY());
        if (this.isCaveDungeon && !this.isOldorVisited && this.magnifier != null) {
            this.magnifier.setScale(0.7f, 0.7f);
            this.magnifier.setPosition(this.getX() - 7.0f, this.getY() + 2.0f);
            this.magnifier.draw(batch, parentAlpha);
        }
        if (this.isBookmarked && this.bookmark != null) {
            this.bookmark.setScale(0.7f, 0.7f);
            this.bookmark.setPosition(this.getRight() - 8.0f, this.getY() + this.getHeight() / 1.5f);
            this.bookmark.draw(batch, parentAlpha);
        }
    }
}

