/*
 * Decompiled with CFR 0.152.
 */
package forge.adventure.stage;

import com.badlogic.gdx.controllers.Controller;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.OrthographicCamera;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.scenes.scene2d.Action;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.actions.Actions;
import com.badlogic.gdx.scenes.scene2d.ui.Dialog;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Scaling;
import com.badlogic.gdx.utils.Timer;
import com.badlogic.gdx.utils.viewport.ScalingViewport;
import com.github.tommyettinger.textra.TextraButton;
import com.github.tommyettinger.textra.TextraLabel;
import com.github.tommyettinger.textra.TypingAdapter;
import com.github.tommyettinger.textra.TypingLabel;
import forge.Forge;
import forge.Graphics;
import forge.adventure.character.CharacterSprite;
import forge.adventure.character.MapActor;
import forge.adventure.character.PlayerSprite;
import forge.adventure.data.DialogData;
import forge.adventure.data.EffectData;
import forge.adventure.data.PointOfInterestData;
import forge.adventure.pointofintrest.PointOfInterest;
import forge.adventure.scene.Scene;
import forge.adventure.scene.StartScene;
import forge.adventure.scene.TileMapScene;
import forge.adventure.stage.GameHUD;
import forge.adventure.stage.MapStage;
import forge.adventure.stage.SpriteGroup;
import forge.adventure.stage.WorldStage;
import forge.adventure.util.Config;
import forge.adventure.util.Controls;
import forge.adventure.util.Current;
import forge.adventure.util.KeyBinding;
import forge.adventure.util.MapDialog;
import forge.adventure.world.WorldSave;
import forge.assets.FBufferedImage;
import forge.assets.FImageComplex;
import forge.assets.FSkinImage;
import forge.card.CardRenderer;
import forge.card.ColorSet;
import forge.deck.Deck;
import forge.deck.DeckProxy;
import forge.game.GameType;
import forge.gui.FThreads;
import forge.gui.GuiBase;
import forge.screens.TransitionScreen;
import forge.util.MyRandom;
import java.util.HashMap;
import java.util.Map;

public abstract class GameStage
extends Stage {
    private final OrthographicCamera camera;
    Group backgroundSprites;
    SpriteGroup foregroundSprites;
    PlayerSprite player;
    private float touchX = -1.0f;
    private float touchY = -1.0f;
    private final float timer = 0.0f;
    private float animationTimeout = 0.0f;
    public static float maximumScrollDistance = 1.5f;
    public static float minimumScrollDistance = 0.3f;
    protected final Dialog dialog;
    protected Stage dialogStage;
    protected boolean dialogOnlyInput;
    protected final Array<TextraButton> dialogButtonMap = new Array();
    TextraButton selectedKey;
    HashMap<PlayerModification, Float> currentModifications = new HashMap();
    Runnable onEndAction;

    public boolean getDialogOnlyInput() {
        return this.dialogOnlyInput;
    }

    public Dialog getDialog() {
        return this.dialog;
    }

    public boolean isDialogOnlyInput() {
        return this.dialogOnlyInput;
    }

    public void setDialogStage(Stage dialogStage) {
        this.dialogStage = dialogStage;
    }

    public void showDialog() {
        if (this.dialogStage == null) {
            this.setDialogStage(GameHUD.getInstance());
        }
        GameHUD.getInstance().playerIdle();
        this.dialogButtonMap.clear();
        for (int i = 0; i < this.dialog.getButtonTable().getCells().size; ++i) {
            this.dialogButtonMap.add((TextraButton)this.dialog.getButtonTable().getCells().get(i).getActor());
        }
        this.dialog.show(this.dialogStage, Actions.show());
        this.dialog.setPosition((this.dialogStage.getWidth() - this.dialog.getWidth()) / 2.0f, (this.dialogStage.getHeight() - this.dialog.getHeight()) / 2.0f);
        this.dialogOnlyInput = true;
        if (Forge.hasGamepad() && !this.dialogButtonMap.isEmpty()) {
            this.dialogStage.setKeyboardFocus(this.dialogButtonMap.first());
        }
    }

    public void hideDialog() {
        this.dialog.hide(Actions.sequence((Action)Actions.sizeTo(this.dialog.getOriginX(), this.dialog.getOriginY(), 0.3f), (Action)Actions.hide()));
        this.dialogOnlyInput = false;
        this.selectedKey = null;
        this.dialog.clearListeners();
    }

    public void effectDialog(EffectData effectData) {
        this.dialog.getButtonTable().clear();
        this.dialog.getContentTable().clear();
        this.dialog.clearListeners();
        final TextraButton ok = Controls.newTextButton("OK", this::hideDialog);
        ok.setVisible(false);
        final TypingLabel L = Controls.newTypingLabel("{GRADIENT=CYAN;WHITE;1;1}Strange magical energies flow within this place...{ENDGRADIENT}\nAll opponents get:\n" + effectData.getDescription());
        L.setWrap(true);
        L.setTypingListener(new TypingAdapter(){

            @Override
            public void end() {
                ok.setVisible(true);
            }
        });
        this.dialog.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                L.skipToTheEnd();
                super.clicked(event, x, y);
            }
        });
        this.dialog.getButtonTable().add(ok).width(240.0f);
        this.dialog.getContentTable().add(L).width(250.0f);
        this.dialog.setKeepWithinStage(true);
        this.showDialog();
    }

    public void showImageDialog(String message, final FBufferedImage fb, Runnable runnable) {
        this.dialog.getContentTable().clear();
        this.dialog.getButtonTable().clear();
        this.dialog.clearListeners();
        if (fb != null && fb.getTexture() != null) {
            TextureRegion tr = new TextureRegion(fb.getTexture());
            tr.flip(true, true);
            Image image = new Image(tr);
            image.setScaling(Scaling.fit);
            this.dialog.getContentTable().add(image).height(100.0f);
            this.dialog.getContentTable().add().row();
        }
        TypingLabel L = Controls.newTypingLabel(message);
        L.setWrap(true);
        L.skipToTheEnd();
        this.dialog.getContentTable().add(L).width(250.0f);
        this.dialog.getButtonTable().add(Controls.newTextButton("OK", () -> {
            this.hideDialog();
            Timer.schedule(new Timer.Task(){

                @Override
                public void run() {
                    if (fb != null) {
                        fb.dispose();
                    }
                }
            }, 0.5f);
            if (runnable != null) {
                runnable.run();
            }
        })).width(240.0f);
        this.dialog.setKeepWithinStage(true);
        this.setDialogStage(GameHUD.getInstance());
        this.showDialog();
    }

    public void showDeckAwardDialog(String message, Deck deck) {
        this.dialog.getContentTable().clear();
        this.dialog.getButtonTable().clear();
        this.dialog.clearListeners();
        DeckProxy dp = new DeckProxy(deck, "Constructed", GameType.Constructed, null);
        FImageComplex cardArt = CardRenderer.getCardArt(dp.getHighestCMCCard());
        if (cardArt != null) {
            Image art = new Image(cardArt.getTextureRegion());
            art.setWidth(58.0f);
            art.setHeight(46.0f);
            art.setPosition(25.0f, 43.0f);
            Image image = new Image(FSkinImage.ADV_DECKBOX.getTextureRegion());
            image.setWidth(60.0f);
            image.setHeight(80.0f);
            image.setPosition(24.0f, 10.0f);
            ColorSet colorSet = DeckProxy.getColorIdentity(deck);
            TypingLabel deckColors = Controls.newTypingLabel(Controls.colorIdToTypingString(colorSet, true).toUpperCase());
            deckColors.skipToTheEnd();
            deckColors.setAlignment(1);
            deckColors.setPosition(14.0f, 44.0f);
            TextraLabel deckname = Controls.newTextraLabel(deck.getName());
            deckname.setAlignment(1);
            deckname.setWrap(true);
            deckname.setWidth(80.0f);
            deckname.setPosition(14.0f, 28.0f);
            Group group = new Group();
            group.addActor(art);
            group.addActor(image);
            group.addActor(deckColors);
            group.addActor(deckname);
            this.dialog.getContentTable().add(group).height(100.0f).width(100.0f).center();
            this.dialog.getContentTable().add().row();
        } else {
            TypingLabel label = Controls.newTypingLabel("[%120]" + Controls.colorIdToTypingString(DeckProxy.getColorIdentity(deck)).toUpperCase() + "\n[%]" + deck.getName());
            label.skipToTheEnd();
            label.setAlignment(1);
            this.dialog.getContentTable().add(label).align(1);
            this.dialog.getContentTable().add().row();
        }
        TypingLabel L = Controls.newTypingLabel(message);
        L.setWrap(true);
        L.skipToTheEnd();
        this.dialog.getContentTable().add(L).width(250.0f);
        this.dialog.getButtonTable().add(Controls.newTextButton("OK", this::hideDialog)).width(240.0f);
        this.dialog.setKeepWithinStage(true);
        this.setDialogStage(GameHUD.getInstance());
        this.showDialog();
    }

    public boolean axisMoved(Controller controller, int axisIndex, float value) {
        if (MapStage.getInstance().isDialogOnlyInput() || this.isPaused()) {
            return true;
        }
        this.player.getMovementDirection().x = controller.getAxis(0);
        this.player.getMovementDirection().y = -controller.getAxis(1);
        if ((double)this.player.getMovementDirection().len() < 0.2) {
            this.player.stop();
        }
        return true;
    }

    public void modifyPlayer(PlayerModification mod, float value) {
        float currentValue = 0.0f;
        if (this.currentModifications.containsKey((Object)mod)) {
            currentValue = this.currentModifications.get((Object)mod).floatValue();
        }
        this.currentModifications.put(mod, Float.valueOf(currentValue + value));
    }

    public void flyFor(float value) {
        this.modifyPlayer(PlayerModification.Fly, value);
        this.player.playEffect("particle_effects/fly.p");
    }

    public void hideFor(float value) {
        this.modifyPlayer(PlayerModification.Hide, value);
        this.player.setColor(this.player.getColor().r, this.player.getColor().g, this.player.getColor().b, 0.5f);
        this.player.playEffect("particle_effects/hide.p");
    }

    public void sprintFor(float value) {
        this.modifyPlayer(PlayerModification.Sprint, value);
        this.player.playEffect("particle_effects/sprint.p");
    }

    public void startPause(float i) {
        this.startPause(i, null);
    }

    public void startPause(float i, Runnable runnable) {
        this.onEndAction = runnable;
        this.animationTimeout = i;
        this.player.setMovementDirection(Vector2.Zero);
    }

    public boolean isPaused() {
        return this.animationTimeout > 0.0f;
    }

    public GameStage() {
        super(new ScalingViewport(Scaling.stretch, Scene.getIntendedWidth(), Scene.getIntendedHeight(), new OrthographicCamera()));
        WorldSave.getCurrentSave().onLoad(() -> {
            if (this.player == null) {
                return;
            }
            this.foregroundSprites.removeActor(this.player);
            this.player = null;
            this.getPlayerSprite();
        });
        this.camera = (OrthographicCamera)this.getCamera();
        this.backgroundSprites = new Group();
        this.foregroundSprites = new SpriteGroup();
        this.addActor(this.backgroundSprites);
        this.addActor(this.foregroundSprites);
        this.dialog = Controls.newDialog("");
    }

    public void setWinner(boolean b) {
    }

    public void setBounds(float width, float height) {
        this.getViewport().setWorldSize(width, height);
    }

    public PlayerSprite getPlayerSprite() {
        if (this.player == null) {
            this.player = new PlayerSprite(this);
            this.foregroundSprites.addActor(this.player);
        }
        return this.player;
    }

    public SpriteGroup getSpriteGroup() {
        return this.foregroundSprites;
    }

    public Group getBackgroundSprites() {
        return this.backgroundSprites;
    }

    @Override
    public final void act(float delta) {
        super.act(delta);
        if (this.animationTimeout >= 0.0f) {
            this.animationTimeout -= delta;
            return;
        }
        Array<PlayerModification> modsToRemove = new Array<PlayerModification>();
        for (Map.Entry<PlayerModification, Float> entry : this.currentModifications.entrySet()) {
            entry.setValue(Float.valueOf(entry.getValue().floatValue() - delta));
            if (!(entry.getValue().floatValue() < 0.0f)) continue;
            modsToRemove.add(entry.getKey());
        }
        for (PlayerModification playerModification : modsToRemove) {
            this.currentModifications.remove((Object)playerModification);
            this.onRemoveEffect(playerModification);
        }
        if (this.isPaused()) {
            return;
        }
        if (this.onEndAction != null) {
            this.onEndAction.run();
            this.onEndAction = null;
        }
        if (this.touchX >= 0.0f) {
            Vector2 target = this.screenToStageCoordinates(new Vector2(this.touchX, this.touchY));
            target.x -= this.player.getWidth() / 2.0f;
            Vector2 vector2 = target.sub(this.player.pos());
            if (vector2.len() < 2.0f) {
                vector2.setZero();
                this.player.stop();
            }
            this.player.setMovementDirection(vector2);
        }
        this.camera.position.x = Math.min(Math.max((float)Scene.getIntendedWidth() / 2.0f, this.player.pos().x), this.getViewport().getWorldWidth() - (float)Scene.getIntendedWidth() / 2.0f);
        this.camera.position.y = Math.min(Math.max((float)Scene.getIntendedHeight() / 2.0f, this.player.pos().y), this.getViewport().getWorldHeight() - (float)Scene.getIntendedHeight() / 2.0f);
        this.onActing(delta);
    }

    private void onRemoveEffect(PlayerModification mod) {
        switch (mod) {
            case Hide: {
                this.player.setColor(this.player.getColor().r, this.player.getColor().g, this.player.getColor().b, 1.0f);
                break;
            }
            case Fly: {
                this.player.removeEffect("particle_effects/fly.p");
                break;
            }
            case Sprint: {
                this.player.removeEffect("particle_effects/sprint.p");
            }
        }
    }

    protected abstract void onActing(float var1);

    @Override
    public boolean keyDown(int keycode) {
        super.keyDown(keycode);
        if (this.isPaused()) {
            return true;
        }
        if (KeyBinding.Left.isPressed(keycode)) {
            this.player.getMovementDirection().x = -1.0f;
        }
        if (KeyBinding.Right.isPressed(keycode)) {
            this.player.getMovementDirection().x = 1.0f;
        }
        if (KeyBinding.Up.isPressed(keycode)) {
            this.player.getMovementDirection().y = 1.0f;
        }
        if (KeyBinding.Down.isPressed(keycode)) {
            this.player.getMovementDirection().y = -1.0f;
        }
        if (keycode == 135) {
            if (TileMapScene.instance().currentMap().isInMap()) {
                DialogData noQuicksave = new DialogData();
                DialogData noQuicksaveOK = new DialogData();
                noQuicksave.text = "Game not saved. Quicksave is only available on the world map.";
                noQuicksaveOK.name = "OK";
                noQuicksave.options = new DialogData[]{noQuicksaveOK};
                MapDialog noQuicksaveDialog = new MapDialog(noQuicksave, MapStage.getInstance(), -1, null);
                this.showDialog();
                noQuicksaveDialog.activate();
            } else {
                this.getPlayerSprite().storePos();
                WorldSave.getCurrentSave().header.createPreview();
                WorldSave.getCurrentSave().quickSave();
            }
        }
        if (keycode == 138 && !TileMapScene.instance().currentMap().isInMap()) {
            WorldSave.getCurrentSave().quickLoad();
            this.enter();
        }
        if (keycode == 141) {
            this.debugCollision(false);
        }
        if (keycode == 142) {
            this.debugCollision(true);
        }
        if (keycode == 132) {
            TileMapScene S = TileMapScene.instance();
            PointOfInterestData P = PointOfInterestData.getPointOfInterest("DEBUGZONE");
            if (P != null) {
                PointOfInterest PoI = new PointOfInterest(P, new Vector2(0.0f, 0.0f), MyRandom.getRandom());
                S.load(PoI);
                Forge.switchScene(S);
            }
        }
        if (keycode == 141) {
            this.debugCollision(false);
            for (Actor actor : this.foregroundSprites.getChildren()) {
                if (!(actor instanceof MapActor)) continue;
                ((MapActor)actor).setBoundDebug(false);
            }
            this.player.setBoundDebug(false);
            this.setDebugAll(false);
        }
        return true;
    }

    public void debugCollision(boolean b) {
        for (Actor actor : this.foregroundSprites.getChildren()) {
            if (!(actor instanceof MapActor)) continue;
            ((MapActor)actor).setBoundDebug(b);
        }
        this.setDebugAll(b);
        this.player.setBoundDebug(b);
    }

    @Override
    public boolean scrolled(float amountX, float amountY) {
        if (this.isPaused()) {
            return true;
        }
        this.camera.zoom = (float)((double)this.camera.zoom + (double)amountY * 0.03);
        if (this.camera.zoom < minimumScrollDistance) {
            this.camera.zoom = minimumScrollDistance;
        }
        if (this.camera.zoom > maximumScrollDistance) {
            this.camera.zoom = maximumScrollDistance;
        }
        return super.scrolled(amountX, amountY);
    }

    @Override
    public boolean touchDragged(int screenX, int screenY, int pointer) {
        if (this.isPaused()) {
            return true;
        }
        if (!GuiBase.isAndroid()) {
            this.touchX = screenX;
            this.touchY = screenY;
        }
        return true;
    }

    @Override
    public boolean touchDown(int screenX, int screenY, int pointer, int button) {
        if (this.isPaused()) {
            return true;
        }
        if (!GuiBase.isAndroid()) {
            this.touchX = screenX;
            this.touchY = screenY;
        }
        return true;
    }

    public void stop() {
        WorldStage.getInstance().getPlayerSprite().setMovementDirection(Vector2.Zero);
        MapStage.getInstance().getPlayerSprite().setMovementDirection(Vector2.Zero);
        this.touchX = -1.0f;
        this.touchY = -1.0f;
        this.player.stop();
    }

    @Override
    public boolean touchUp(int screenX, int screenY, int pointer, int button) {
        this.stop();
        return true;
    }

    @Override
    public boolean keyUp(int keycode) {
        if (this.isPaused()) {
            return true;
        }
        if (KeyBinding.Left.isPressed(keycode) || KeyBinding.Right.isPressed(keycode)) {
            this.player.getMovementDirection().x = 0.0f;
            if (!this.player.isMoving()) {
                this.stop();
            }
        }
        if (KeyBinding.Down.isPressed(keycode) || KeyBinding.Up.isPressed(keycode)) {
            this.player.getMovementDirection().y = 0.0f;
            if (!this.player.isMoving()) {
                this.stop();
            }
        }
        if (KeyBinding.Menu.isPressed(keycode)) {
            this.openMenu();
        }
        return false;
    }

    @Override
    public boolean touchCancelled(int screenX, int screenY, int pointer, int button) {
        this.stop();
        return super.touchCancelled(screenX, screenY, pointer, button);
    }

    public void openMenu() {
        if (Forge.advFreezePlayerControls) {
            return;
        }
        WorldSave.getCurrentSave().header.createPreview();
        Forge.switchScene(StartScene.instance());
    }

    public void enter() {
        this.stop();
    }

    public void leave() {
        this.stop();
    }

    public boolean isColliding(Rectangle boundingRect) {
        return false;
    }

    public void prepareCollision(Vector2 pos, Vector2 direction, Rectangle boundingRect) {
    }

    public Vector2 adjustMovement(Vector2 direction, Rectangle boundingRect) {
        Vector2 adjDirX = direction.cpy();
        Vector2 adjDirY = direction.cpy();
        boolean foundX = false;
        boolean foundY = false;
        while (true) {
            if (!this.isColliding(new Rectangle(boundingRect.x + adjDirX.x, boundingRect.y + adjDirX.y, boundingRect.width, boundingRect.height))) {
                foundX = true;
                break;
            }
            if (adjDirX.x == 0.0f) break;
            if (adjDirX.x >= 0.0f) {
                adjDirX.x = Math.max(0.0f, adjDirX.x - 0.2f);
                continue;
            }
            adjDirX.x = Math.min(0.0f, adjDirX.x + 0.2f);
        }
        while (true) {
            if (!this.isColliding(new Rectangle(boundingRect.x + adjDirY.x, boundingRect.y + adjDirY.y, boundingRect.width, boundingRect.height))) {
                foundY = true;
                break;
            }
            if (adjDirY.y == 0.0f) break;
            if (adjDirY.y >= 0.0f) {
                adjDirY.y = Math.max(0.0f, adjDirY.y - 0.2f);
                continue;
            }
            adjDirY.y = Math.min(0.0f, adjDirY.y + 0.2f);
        }
        if (foundY && foundX) {
            return adjDirX.len() > adjDirY.len() ? adjDirX : adjDirY;
        }
        if (foundY) {
            return adjDirY;
        }
        if (foundX) {
            return adjDirX;
        }
        return Vector2.Zero.cpy();
    }

    protected void teleported(Vector2 position) {
    }

    public void setPosition(Vector2 position) {
        this.getPlayerSprite().setPosition(position);
        this.teleported(position);
    }

    public void resetPlayerLocation() {
        final PointOfInterest poi = Current.world().findPointsOfInterest("Spawn");
        if (poi != null) {
            Forge.advFreezePlayerControls = true;
            this.getPlayerSprite().setAnimation(CharacterSprite.AnimationTypes.Death);
            this.getPlayerSprite().playEffect("particle_effects/blood.p", 0.5f);
            Timer.schedule(new Timer.Task(){

                @Override
                public void run() {
                    GameStage.this.showImageDialog(Current.generateDefeatMessage(), GameStage.this.getDefeatBadge(), () -> FThreads.invokeInEdtNowOrLater(() -> Forge.setTransitionScreen(new TransitionScreen(() -> {
                        Forge.advFreezePlayerControls = false;
                        WorldStage.getInstance().setPosition(new Vector2(poi2.getPosition().x - 16.0f, poi2.getPosition().y + 16.0f));
                        WorldStage.getInstance().loadPOI(poi);
                        WorldSave.getCurrentSave().autoSave();
                        Forge.clearTransitionScreen();
                    }, Forge.takeScreenshot(), ""))));
                }
            }, 1.0f);
        }
    }

    private FBufferedImage getDefeatBadge() {
        FileHandle defeat = Config.instance().getFile("ui/defeat.png");
        if (defeat.exists()) {
            final TextureRegion tr = new TextureRegion(Forge.getAssets().getTexture(defeat, true, false));
            tr.flip(true, false);
            return new FBufferedImage(176.0f, 200.0f){

                @Override
                protected void draw(Graphics g2, float w, float h2) {
                    g2.drawImage(tr, 0.0f, 0.0f, 176.0f, 200.0f);
                }
            };
        }
        return null;
    }

    static enum PlayerModification {
        Sprint,
        Hide,
        Fly;

    }
}

