/*
 * Decompiled with CFR 0.152.
 */
package forge.adventure.stage;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.audio.Music;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.scenes.scene2d.Action;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.Touchable;
import com.badlogic.gdx.scenes.scene2d.actions.Actions;
import com.badlogic.gdx.scenes.scene2d.actions.AfterAction;
import com.badlogic.gdx.scenes.scene2d.actions.SequenceAction;
import com.badlogic.gdx.scenes.scene2d.ui.Button;
import com.badlogic.gdx.scenes.scene2d.ui.Dialog;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.ScrollPane;
import com.badlogic.gdx.scenes.scene2d.ui.TextButton;
import com.badlogic.gdx.scenes.scene2d.ui.Touchpad;
import com.badlogic.gdx.scenes.scene2d.utils.ActorGestureListener;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.badlogic.gdx.scenes.scene2d.utils.TextureRegionDrawable;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Scaling;
import com.badlogic.gdx.utils.Timer;
import com.badlogic.gdx.utils.viewport.ScalingViewport;
import com.github.tommyettinger.textra.TextraButton;
import com.github.tommyettinger.textra.TextraLabel;
import com.github.tommyettinger.textra.TypingLabel;
import forge.Forge;
import forge.adventure.character.CharacterSprite;
import forge.adventure.data.AdventureQuestData;
import forge.adventure.data.ItemData;
import forge.adventure.player.AdventurePlayer;
import forge.adventure.scene.DeckSelectScene;
import forge.adventure.scene.GameScene;
import forge.adventure.scene.InventoryScene;
import forge.adventure.scene.MapViewScene;
import forge.adventure.scene.QuestLogScene;
import forge.adventure.scene.Scene;
import forge.adventure.scene.TileMapScene;
import forge.adventure.stage.Console;
import forge.adventure.stage.ConsoleCommandInterpreter;
import forge.adventure.stage.GameStage;
import forge.adventure.stage.MapStage;
import forge.adventure.stage.PointOfInterestMapSprite;
import forge.adventure.stage.WorldStage;
import forge.adventure.util.AdventureQuestController;
import forge.adventure.util.Config;
import forge.adventure.util.Controls;
import forge.adventure.util.Current;
import forge.adventure.util.KeyBinding;
import forge.adventure.util.UIActor;
import forge.adventure.world.WorldSave;
import forge.deck.Deck;
import forge.gui.GuiBase;
import forge.localinstance.properties.ForgePreferences;
import forge.model.FModel;
import forge.sound.MusicPlaylist;
import forge.sound.SoundSystem;
import org.apache.commons.lang3.tuple.Pair;

public class GameHUD
extends Stage {
    public static GameHUD instance;
    private final GameStage gameStage;
    private final Image avatar;
    private final Image miniMapPlayer;
    private final TypingLabel lifePoints;
    private final TypingLabel money;
    private final TypingLabel shards;
    private final TextraLabel keys;
    private final TextraLabel notificationText = Controls.newTextraLabel("");
    private final Image miniMap;
    private final Image gamehud;
    private final Image mapborder;
    private final Image avatarborder;
    private final Image blank;
    private final InputEvent eventTouchDown;
    private final InputEvent eventTouchUp;
    private final TextraButton deckActor;
    private final TextraButton openMapActor;
    private final TextraButton menuActor;
    private final TextraButton logbookActor;
    private final TextraButton inventoryActor;
    private final TextraButton exitToWorldMapActor;
    private final TextraButton bookmarkActor;
    public final UIActor ui;
    private final Touchpad touchpad;
    private final Console console;
    float TOUCHPAD_SCALE = 70.0f;
    float referenceX;
    float opacity = 1.0f;
    private boolean debugMap;
    private boolean transluscent;
    private boolean hidden;
    private final Dialog dialog;
    private boolean dialogOnlyInput;
    private final Array<TextraButton> dialogButtonMap = new Array();
    private final Array<TextraButton> abilityButtonMap = new Array();
    private final Array<String> questKeys = new Array();
    private String lifepointsTextColor = "";
    private final ScrollPane scrollPane;
    private final ScrollPane notificationPane;
    private final Group mapGroup = new Group();
    private final Group hudGroup = new Group();
    private final Group menuGroup = new Group();
    private final Group avatarGroup = new Group();
    Texture miniMapTexture;
    Texture miniMapToolTipTexture;
    Pixmap miniMapToolTipPixmap;
    public boolean fromWorldMap = false;
    private Pair<FileHandle, Music> audio = null;
    float fade = 1.0f;
    float targetfade = 1.0f;
    private MusicPlaylist currentAudioPlaylist = null;

    private GameHUD(GameStage gameStage) {
        super(new ScalingViewport(Scaling.stretch, Scene.getIntendedWidth(), Scene.getIntendedHeight()), gameStage.getBatch());
        instance = this;
        this.gameStage = gameStage;
        this.ui = new UIActor(Config.instance().getFile(GuiBase.isAndroid() ? (Forge.isLandscapeMode() ? "ui/hud_landscape.json" : "ui/hud_portrait.json") : (Forge.isLandscapeMode() ? "ui/hud.json" : "ui/hud_portrait.json")));
        this.blank = (Image)this.ui.findActor("blank");
        this.miniMap = (Image)this.ui.findActor("map");
        this.mapborder = (Image)this.ui.findActor("mapborder");
        this.avatarborder = (Image)this.ui.findActor("avatarborder");
        this.deckActor = (TextraButton)this.ui.findActor("deck");
        this.openMapActor = (TextraButton)this.ui.findActor("openmap");
        this.ui.onButtonPress("openmap", this::openMap);
        this.menuActor = (TextraButton)this.ui.findActor("menu");
        this.referenceX = this.menuActor.getX();
        this.logbookActor = (TextraButton)this.ui.findActor("logbook");
        this.inventoryActor = (TextraButton)this.ui.findActor("inventory");
        this.gamehud = (Image)this.ui.findActor("gamehud");
        this.exitToWorldMapActor = (TextraButton)this.ui.findActor("exittoworldmap");
        this.bookmarkActor = (TextraButton)this.ui.findActor("bookmark");
        this.dialog = Controls.newDialog("");
        this.miniMapPlayer = new Image(Forge.getAssets().getTexture(Config.instance().getFile("ui/minimap_player.png")));
        this.touchpad = new Touchpad(10.0f, Controls.getSkin());
        this.touchpad.setBounds(15.0f, 15.0f, this.TOUCHPAD_SCALE, this.TOUCHPAD_SCALE);
        this.touchpad.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent changeEvent, Actor actor) {
                if (MapStage.getInstance().isInMap()) {
                    if (MapStage.getInstance().isPaused()) {
                        return;
                    }
                    MapStage.getInstance().getPlayerSprite().getMovementDirection().x += ((Touchpad)actor).getKnobPercentX();
                    MapStage.getInstance().getPlayerSprite().getMovementDirection().y += ((Touchpad)actor).getKnobPercentY();
                } else {
                    if (WorldStage.getInstance().isPaused()) {
                        return;
                    }
                    WorldStage.getInstance().getPlayerSprite().getMovementDirection().x += ((Touchpad)actor).getKnobPercentX();
                    WorldStage.getInstance().getPlayerSprite().getMovementDirection().y += ((Touchpad)actor).getKnobPercentY();
                }
            }
        });
        if (GuiBase.isAndroid()) {
            this.ui.addActor(this.touchpad);
        }
        this.avatar = (Image)this.ui.findActor("avatar");
        this.ui.onButtonPress("menu", this::menu);
        this.ui.onButtonPress("inventory", this::openInventory);
        this.ui.onButtonPress("logbook", this::logbook);
        this.ui.onButtonPress("deck", this::openDeck);
        this.ui.onButtonPress("exittoworldmap", this::exitToWorldMap);
        this.ui.onButtonPress("bookmark", this::bookmark);
        this.lifePoints = (TypingLabel)this.ui.findActor("lifePoints");
        this.lifePoints.skipToTheEnd();
        this.shards = (TypingLabel)this.ui.findActor("shards");
        this.shards.skipToTheEnd();
        this.money = (TypingLabel)this.ui.findActor("money");
        this.money.skipToTheEnd();
        this.shards.setText("[%95][+Shards]");
        this.money.setText("[%95][+Gold]");
        this.lifePoints.setText("[%95][+Life]");
        this.keys = Controls.newTextraLabel("");
        this.scrollPane = new ScrollPane((Actor)this.keys);
        this.scrollPane.setPosition(2.0f, 2.0f);
        this.scrollPane.setStyle(Controls.getSkin().get("translucent", ScrollPane.ScrollPaneStyle.class));
        this.addActor(this.scrollPane);
        AdventurePlayer.current().onLifeChange(() -> {
            String effect = "{EMERGE}";
            String effectEnd = "{ENDEMERGE}";
            String heartbeat = "";
            if (Current.player().getLife() >= Current.player().getMaxLife()) {
                this.lifepointsTextColor = "[GREEN]";
            } else if (Current.player().getLife() <= 5) {
                effect = "";
                effectEnd = "";
                heartbeat = "{HEARTBEAT=0.5;0.5}";
                this.lifepointsTextColor = "{ENDHEARTBEAT}[RED]";
            } else {
                this.lifepointsTextColor = "[WHITE]";
            }
            this.lifePoints.restart("[%95]" + heartbeat + "[+Life]" + this.lifepointsTextColor + effect + " " + AdventurePlayer.current().getLife() + effectEnd + "/" + AdventurePlayer.current().getMaxLife());
        });
        AdventurePlayer.current().onShardsChange(() -> this.shards.restart("[%95][+Shards]{EMERGE} " + AdventurePlayer.current().getShards() + "{ENDEMERGE}"));
        AdventurePlayer.current().onGoldChange(() -> this.money.restart("[%95][+Gold]{EMERGE} " + AdventurePlayer.current().getGold() + "{ENDEMERGE}"));
        AdventurePlayer.current().onEquipmentChanged(this::updateAbility);
        this.addActor(this.ui);
        this.addActor(this.miniMapPlayer);
        this.console = new Console();
        this.console.setBounds(0.0f, GuiBase.isAndroid() ? this.getHeight() : 0.0f, this.getWidth(), this.getHeight() / 2.0f);
        this.console.setVisible(false);
        this.ui.addActor(this.console);
        this.avatar.addListener(new ConsoleToggleListener());
        this.avatarborder.addListener(new ConsoleToggleListener());
        this.gamehud.addListener(new ConsoleToggleListener());
        WorldSave.getCurrentSave().onLoad(this::enter);
        this.eventTouchDown = new InputEvent();
        this.eventTouchDown.setPointer(-1);
        this.eventTouchDown.setType(InputEvent.Type.touchDown);
        this.eventTouchUp = new InputEvent();
        this.eventTouchUp.setPointer(-1);
        this.eventTouchUp.setType(InputEvent.Type.touchUp);
        this.notificationPane = new ScrollPane((Actor)this.notificationText);
        this.notificationPane.setTouchable(Touchable.childrenOnly);
        this.notificationPane.setBounds(5.0f, GuiBase.isAndroid() ? this.getHeight() : -this.notificationText.getPrefHeight(), this.getWidth() * 0.4f, 25.0f);
        this.notificationPane.setStyle(Controls.getSkin().get("paper", ScrollPane.ScrollPaneStyle.class));
        this.notificationPane.getColor().a = 0.0f;
        this.ui.addActor(this.notificationPane);
        this.mapGroup.addActor(this.miniMap);
        this.mapGroup.addActor(this.mapborder);
        this.mapGroup.addActor(this.openMapActor);
        this.mapGroup.addActor(this.miniMapPlayer);
        this.ui.addActor(this.mapGroup);
        this.hudGroup.addActor(this.gamehud);
        this.hudGroup.addActor(this.lifePoints);
        this.hudGroup.addActor(this.shards);
        this.hudGroup.addActor(this.money);
        this.hudGroup.addActor(this.blank);
        this.ui.addActor(this.hudGroup);
        this.menuGroup.addActor(this.deckActor);
        this.menuGroup.addActor(this.menuActor);
        this.menuGroup.addActor(this.logbookActor);
        this.menuGroup.addActor(this.inventoryActor);
        this.menuGroup.addActor(this.exitToWorldMapActor);
        this.menuGroup.addActor(this.bookmarkActor);
        this.ui.addActor(this.menuGroup);
        this.avatarGroup.addActor(this.avatar);
        this.avatarGroup.addActor(this.avatarborder);
        this.ui.addActor(this.avatarGroup);
    }

    private void openMap() {
        if (this.console.isVisible()) {
            return;
        }
        if (Forge.advFreezePlayerControls) {
            return;
        }
        Forge.switchScene(MapViewScene.instance());
    }

    private void logbook() {
        if (this.console.isVisible()) {
            return;
        }
        if (Forge.advFreezePlayerControls) {
            return;
        }
        Forge.switchScene(QuestLogScene.instance(Forge.getCurrentScene()));
    }

    public static GameHUD getInstance() {
        return instance == null ? (instance = new GameHUD(WorldStage.getInstance())) : instance;
    }

    public Touchpad getTouchpad() {
        return this.touchpad;
    }

    @Override
    public boolean touchUp(int screenX, int screenY, int pointer, int button) {
        this.touchpad.setVisible(false);
        MapStage.getInstance().getPlayerSprite().setMovementDirection(Vector2.Zero);
        WorldStage.getInstance().getPlayerSprite().setMovementDirection(Vector2.Zero);
        return super.touchUp(screenX, screenY, pointer, button);
    }

    @Override
    public boolean touchDragged(int screenX, int screenY, int pointer) {
        Vector2 c = new Vector2();
        this.screenToStageCoordinates(c.set(screenX, screenY));
        float x = (c.x - this.miniMap.getX()) / this.miniMap.getWidth();
        float y = (c.y - this.miniMap.getY()) / this.miniMap.getHeight();
        if (Controls.actorContainsVector(this.miniMap, c)) {
            this.touchpad.setVisible(false);
            if (this.debugMap) {
                WorldStage.getInstance().getPlayerSprite().setPosition(x * (float)WorldSave.getCurrentSave().getWorld().getWidthInPixels(), y * (float)WorldSave.getCurrentSave().getWorld().getHeightInPixels());
            }
            return true;
        }
        return super.touchDragged(screenX, screenY, pointer);
    }

    @Override
    public boolean touchDown(int screenX, int screenY, int pointer, int button) {
        Vector2 c = new Vector2();
        Vector2 touch = new Vector2();
        this.screenToStageCoordinates(touch.set(screenX, screenY));
        this.screenToStageCoordinates(c.set(screenX, screenY));
        float x = (c.x - this.miniMap.getX()) / this.miniMap.getWidth();
        float y = (c.y - this.miniMap.getY()) / this.miniMap.getHeight();
        if (Controls.actorContainsVector(this.gamehud, c)) {
            super.touchDown(screenX, screenY, pointer, button);
            return true;
        }
        if (Controls.actorContainsVector(this.miniMap, c)) {
            if (this.debugMap) {
                WorldStage.getInstance().getPlayerSprite().setPosition(x * (float)WorldSave.getCurrentSave().getWorld().getWidthInPixels(), y * (float)WorldSave.getCurrentSave().getWorld().getHeightInPixels());
            }
            return true;
        }
        if (!(!GuiBase.isAndroid() || MapStage.getInstance().getDialogOnlyInput() || this.console.isVisible() || Controls.actorContainsVector(this.avatar, touch) || Controls.actorContainsVector(this.miniMap, touch) || Controls.actorContainsVector(this.gamehud, touch) || Controls.actorContainsVector(this.menuActor, touch) || Controls.actorContainsVector(this.deckActor, touch) || Controls.actorContainsVector(this.openMapActor, touch) || Controls.actorContainsVector(this.logbookActor, touch) || Controls.actorContainsVector(this.inventoryActor, touch) || Controls.actorContainsVector(this.exitToWorldMapActor, touch) || Controls.actorContainsVector(this.bookmarkActor, touch) || Controls.actorContainsVector(this.abilityButtonMap, touch) || !Controls.actorContainsVector(this.ui, touch) || pointer >= 1)) {
            this.touchpad.setBounds(touch.x - this.TOUCHPAD_SCALE / 2.0f, touch.y - this.TOUCHPAD_SCALE / 2.0f, this.TOUCHPAD_SCALE, this.TOUCHPAD_SCALE);
            this.touchpad.setVisible(true);
            this.touchpad.setResetOnTouchUp(true);
            return super.touchDown(screenX, screenY, pointer, button);
        }
        return super.touchDown(screenX, screenY, pointer, button);
    }

    @Override
    public void draw() {
        int yPos = (int)this.gameStage.player.getY();
        int xPos = (int)this.gameStage.player.getX();
        this.act(Gdx.graphics.getDeltaTime());
        super.draw();
        int xPosMini = (int)((float)xPos / (float)WorldSave.getCurrentSave().getWorld().getTileSize() / (float)WorldSave.getCurrentSave().getWorld().getWidthInTiles() * this.miniMap.getWidth());
        int yPosMini = (int)((float)yPos / (float)WorldSave.getCurrentSave().getWorld().getTileSize() / (float)WorldSave.getCurrentSave().getWorld().getHeightInTiles() * this.miniMap.getHeight());
        this.miniMapPlayer.setPosition(this.miniMap.getX() + (float)xPosMini - this.miniMapPlayer.getWidth() / 2.0f, this.miniMap.getY() + (float)yPosMini - this.miniMapPlayer.getHeight() / 2.0f);
        this.miniMapPlayer.setVisible(this.miniMap.isVisible() && !Controls.actorContainsVector(this.notificationPane, new Vector2(this.miniMapPlayer.getX(), this.miniMapPlayer.getY())) && (!Controls.actorContainsVector(this.console, new Vector2(this.miniMapPlayer.getX(), this.miniMapPlayer.getY())) || !this.console.isVisible()));
        if (!MapStage.getInstance().isInMap()) {
            this.updateMusic();
        } else {
            SoundSystem.instance.pause();
        }
    }

    public void enter() {
        this.questKeys.clear();
        if (this.miniMapTexture != null) {
            this.miniMapTexture.dispose();
        }
        this.miniMapTexture = new Texture(WorldSave.getCurrentSave().getWorld().getBiomeImage());
        if (this.miniMapToolTipTexture != null) {
            this.miniMapToolTipTexture.dispose();
        }
        if (this.miniMapToolTipPixmap != null) {
            this.miniMapToolTipPixmap.dispose();
        }
        this.miniMapToolTipPixmap = new Pixmap((int)(this.miniMap.getWidth() * 3.0f), (int)(this.miniMap.getHeight() * 3.0f), Pixmap.Format.RGBA8888);
        this.miniMapToolTipPixmap.drawPixmap(WorldSave.getCurrentSave().getWorld().getBiomeImage(), 0, 0, WorldSave.getCurrentSave().getWorld().getBiomeImage().getWidth(), WorldSave.getCurrentSave().getWorld().getBiomeImage().getHeight(), 0, 0, this.miniMapToolTipPixmap.getWidth(), this.miniMapToolTipPixmap.getHeight());
        this.miniMapToolTipTexture = new Texture(this.miniMapToolTipPixmap);
        this.miniMap.setDrawable(new TextureRegionDrawable(this.miniMapTexture));
        this.avatar.setDrawable(new TextureRegionDrawable(Current.player().avatar()));
        Deck deck = AdventurePlayer.current().getSelectedDeck();
        if (AdventurePlayer.current().hasItem("Red Key")) {
            this.questKeys.add("[+RedKey]");
        }
        if (AdventurePlayer.current().hasItem("Green Key")) {
            this.questKeys.add("[+GreenKey]");
        }
        if (AdventurePlayer.current().hasItem("Blue Key")) {
            this.questKeys.add("[+BlueKey]");
        }
        if (AdventurePlayer.current().hasItem("Black Key")) {
            this.questKeys.add("[+BlackKey]");
        }
        if (AdventurePlayer.current().hasItem("White Key")) {
            this.questKeys.add("[+WhiteKey]");
        }
        if (AdventurePlayer.current().hasItem("Strange Key")) {
            this.questKeys.add("[+StrangeKey]");
        }
        if (!this.questKeys.isEmpty()) {
            this.keys.setText(String.join((CharSequence)"\n", this.questKeys));
            this.scrollPane.setSize(this.keys.getWidth() + 8.0f, this.keys.getHeight() + 5.0f);
            this.scrollPane.layout();
            this.keys.layout();
            this.scrollPane.getColor().a = this.opacity;
        } else {
            this.keys.setText("");
            this.scrollPane.getColor().a = 0.0f;
        }
        switch (GameScene.instance().getAdventurePlayerLocation(false, false)) {
            case "capital": 
            case "town": {
                if (!MapStage.getInstance().isInMap()) break;
                int rep = TileMapScene.instance().getPointOfInterestChanges().getMapReputation();
                String reputationText = TileMapScene.instance().rootPoint.getDisplayName() + "\nReputation: " + (rep > 0 ? "[GREEN]" : (rep < 0 ? "[RED]" : "[WHITE]")) + rep + "[/]";
                if (!this.fromWorldMap) break;
                this.addNotification(reputationText);
                this.fromWorldMap = false;
                break;
            }
            case "dungeon": 
            case "cave": 
            case "castle": {
                if (!this.fromWorldMap) break;
                this.addNotification(TileMapScene.instance().rootPoint.getDisplayName());
                this.fromWorldMap = false;
                break;
            }
        }
        if (deck == null || deck.isEmpty() || deck.getMain().toFlatList().size() < 30) {
            this.deckActor.setColor(Color.RED);
        } else {
            this.deckActor.setColor(this.menuActor.getColor());
        }
        if (MapStage.getInstance().isInMap()) {
            SoundSystem.instance.pause();
            this.playAudio();
        } else {
            this.unloadAudio();
            SoundSystem.instance.resume();
        }
        this.updateAbility();
        this.restorePlayerCollision();
        if (this.openMapActor != null) {
            String val = "[%80]" + Forge.getLocalizer().getMessageorUseDefault("lblZoom", "Zoom", new Object[0]);
            for (AdventureQuestData adq : Current.player().getQuests()) {
                if (adq.getTargetPOI() == null) continue;
                val = "[%80][+GPS] " + Forge.getLocalizer().getMessageorUseDefault("lblZoom", "Zoom", new Object[0]);
                break;
            }
            this.openMapActor.setText(val);
            this.openMapActor.layout();
        }
        if (MapStage.getInstance().isInMap()) {
            this.updateBookmarkActor(MapStage.getInstance().getChanges().isBookmarked());
        }
        this.avatarGroup.setZIndex(this.ui.getChildren().size);
    }

    void clearAbility() {
        for (TextraButton button : this.abilityButtonMap) {
            button.remove();
        }
        this.abilityButtonMap.clear();
    }

    void updateAbility() {
        this.clearAbility();
        this.setAbilityButton(AdventurePlayer.current().getEquippedAbility1());
        this.setAbilityButton(AdventurePlayer.current().getEquippedAbility2());
        float x = Forge.isLandscapeMode() ? 426.0f : 216.0f;
        float y = Forge.isLandscapeMode() ? 10.0f : 60.0f;
        float w = 45.0f;
        float h2 = 35.0f;
        for (TextraButton button : this.abilityButtonMap) {
            button.getColor().a = this.opacity;
            button.setSize(w, h2);
            button.setPosition(x, y);
            y += h2 + 15.0f;
            this.addActor(button);
        }
    }

    void setAbilityButton(ItemData data) {
        if (data != null) {
            TextraButton button = Controls.newTextButton("[%90][+" + data.iconName + "][+Shards][BLACK]" + data.shardsNeeded, () -> {
                if (this.console.isVisible()) {
                    return;
                }
                if (Forge.advFreezePlayerControls) {
                    return;
                }
                boolean isInPoi = MapStage.getInstance().isInMap();
                if (!(isInPoi && data.usableInPoi || !isInPoi && data.usableOnWorldMap)) {
                    return;
                }
                if (data.shardsNeeded > Current.player().getShards()) {
                    return;
                }
                Current.player().addShards(-data.shardsNeeded);
                ConsoleCommandInterpreter.getInstance().command(data.commandOnUse);
                AdventureQuestController.instance().updateItemUsed(data);
            });
            button.setStyle(Controls.getSkin().get("menu", TextButton.TextButtonStyle.class));
            this.abilityButtonMap.add(button);
        }
    }

    public void switchAudio() {
        if (MapStage.getInstance().isInMap()) {
            this.pauseMusic();
            this.playAudio();
        }
    }

    public void playAudio() {
        switch (GameScene.instance().getAdventurePlayerLocation(false, false)) {
            case "capital": 
            case "town": {
                this.setAudio(MusicPlaylist.TOWN);
                break;
            }
            case "dungeon": 
            case "cave": {
                this.setAudio(MusicPlaylist.CAVE);
                break;
            }
            case "castle": {
                this.setAudio(MusicPlaylist.CASTLE);
                break;
            }
        }
        if (this.audio != null) {
            this.audio.getRight().setLooping(true);
            this.audio.getRight().play();
            this.audio.getRight().setVolume((float)FModel.getPreferences().getPrefInt(ForgePreferences.FPref.UI_VOL_MUSIC) / 100.0f);
        }
    }

    public void fadeAudio(float value) {
        if (this.audio != null) {
            this.audio.getRight().setVolume((float)FModel.getPreferences().getPrefInt(ForgePreferences.FPref.UI_VOL_MUSIC) * value / 100.0f);
        }
    }

    public boolean audioIsPlaying() {
        if (this.audio == null) {
            return false;
        }
        return this.audio.getRight().isPlaying();
    }

    @Override
    public void act(float delta) {
        super.act(delta);
        if (this.fade < this.targetfade) {
            this.fade += delta / 2.0f;
            if (this.fade > this.targetfade) {
                this.fade = this.targetfade;
            }
            this.fadeAudio(this.fade);
        } else if (this.fade > this.targetfade) {
            this.fade -= delta / 2.0f;
            if (this.fade < this.targetfade) {
                this.fade = this.targetfade;
            }
            this.fadeAudio(this.fade);
        }
    }

    public void fadeIn() {
        this.targetfade = 1.0f;
    }

    public void fadeOut() {
        this.targetfade = 0.1f;
    }

    public void stopAudio() {
        if (this.audio != null) {
            this.audio.getRight().stop();
        }
    }

    public void pauseMusic() {
        if (this.audio != null) {
            this.audio.getRight().pause();
        }
        SoundSystem.instance.pause();
    }

    public void unloadAudio() {
        if (this.audio != null) {
            this.audio.getRight().setOnCompletionListener(null);
            this.audio.getRight().stop();
            Forge.getAssets().manager().unload(this.audio.getLeft().path());
        }
        this.audio = null;
        this.currentAudioPlaylist = null;
    }

    private void setAudio(MusicPlaylist playlist) {
        if (playlist.equals((Object)this.currentAudioPlaylist)) {
            return;
        }
        this.unloadAudio();
        this.audio = this.getMusic(playlist);
    }

    private Pair<FileHandle, Music> getMusic(MusicPlaylist playlist) {
        String filename = playlist.getNewRandomFilename();
        if (filename == null) {
            return null;
        }
        FileHandle file = Gdx.files.absolute(filename);
        Music music = Forge.getAssets().getMusic(file);
        if (music != null) {
            this.currentAudioPlaylist = playlist;
            return Pair.of(file, music);
        }
        this.currentAudioPlaylist = null;
        return null;
    }

    private void openDeck() {
        if (this.console.isVisible()) {
            return;
        }
        if (Forge.advFreezePlayerControls) {
            return;
        }
        Forge.switchScene(DeckSelectScene.instance());
    }

    private void openInventory() {
        if (this.console.isVisible()) {
            return;
        }
        if (Forge.advFreezePlayerControls) {
            return;
        }
        WorldSave.getCurrentSave().header.createPreview();
        Forge.switchScene(InventoryScene.instance());
    }

    private void exitToWorldMap() {
        if (this.console.isVisible()) {
            return;
        }
        if (!MapStage.getInstance().isInMap()) {
            return;
        }
        if (!MapStage.getInstance().canEscape()) {
            return;
        }
        if (Forge.advFreezePlayerControls) {
            return;
        }
        this.dialog.getButtonTable().clear();
        this.dialog.getContentTable().clear();
        this.dialog.clearListeners();
        TextraButton YES = Controls.newTextButton(Forge.getLocalizer().getMessage("lblYes", new Object[0]), this::exitDungeonCallback);
        TextraButton NO = Controls.newTextButton(Forge.getLocalizer().getMessage("lblNo", new Object[0]), this::hideDialog);
        TypingLabel L = Controls.newTypingLabel(Forge.getLocalizer().getMessageorUseDefault("lblExitToWoldMap", "Exit to the World Map?", new Object[0]));
        L.setWrap(true);
        L.skipToTheEnd();
        this.dialog.getButtonTable().add(YES).width(60.0f);
        this.dialog.getButtonTable().add(NO).width(60.0f);
        this.dialog.getContentTable().add(L).width(120.0f);
        this.dialog.setKeepWithinStage(true);
        this.showDialog();
    }

    private void bookmark() {
        if (this.console.isVisible()) {
            return;
        }
        if (!MapStage.getInstance().isInMap()) {
            return;
        }
        if (!MapStage.getInstance().canEscape()) {
            return;
        }
        if (Forge.advFreezePlayerControls) {
            return;
        }
        if (MapStage.getInstance().isInMap()) {
            if (MapStage.getInstance().getChanges().isBookmarked()) {
                MapStage.getInstance().getChanges().setIsBookmarked(false);
                PointOfInterestMapSprite mapSprite = WorldStage.getInstance().getMapSprite(GameScene.instance().getMapPOI());
                if (mapSprite != null) {
                    MapStage.getInstance().getChanges().save();
                    mapSprite.setBookmarked(false, mapSprite.getPointOfInterest());
                    this.updateBookmarkActor(false);
                }
            } else {
                MapStage.getInstance().getChanges().setIsBookmarked(true);
                PointOfInterestMapSprite mapSprite = WorldStage.getInstance().getMapSprite(GameScene.instance().getMapPOI());
                if (mapSprite != null) {
                    MapStage.getInstance().getChanges().save();
                    mapSprite.setBookmarked(true, mapSprite.getPointOfInterest());
                    this.updateBookmarkActor(true);
                }
            }
        }
    }

    private void updateBookmarkActor(boolean value) {
        if (this.bookmarkActor == null) {
            return;
        }
        this.bookmarkActor.setText("[%120][+" + (value ? "Bookmark" : "Unmark") + "]");
    }

    private void exitDungeonCallback() {
        this.hideDialog(true);
    }

    private void hideDialog() {
        this.hideDialog(false);
    }

    private void menu() {
        if (this.console.isVisible()) {
            return;
        }
        if (Forge.advFreezePlayerControls) {
            return;
        }
        this.gameStage.openMenu();
    }

    private void setDisabled(Actor actor, boolean value, String enabled, String disabled) {
        if (actor instanceof TextraButton) {
            ((TextraButton)actor).setDisabled(value);
            ((TextraButton)actor).setText(((TextraButton)actor).isDisabled() ? disabled : enabled);
        }
    }

    private void setAlpha(Actor actor, boolean visible) {
        if (actor != null) {
            if (visible) {
                actor.addAction(Actions.alpha(1.0f, 0.5f));
            } else {
                actor.addAction(Actions.alpha(actor == this.mapGroup ? 0.0f : 0.4f, 0.5f));
            }
        }
    }

    public void showHideMap(boolean visible) {
        this.transluscent = !visible;
        this.setAlpha(this.mapGroup, visible);
        this.setAlpha(this.hudGroup, visible);
        this.setAlpha(this.menuGroup, visible);
        this.setAlpha(this.avatarGroup, visible);
        this.setDisabled(this.exitToWorldMapActor, !MapStage.getInstance().isInMap(), "[%120][+ExitToWorldMap]", "\uff0f");
        this.setDisabled(this.bookmarkActor, !MapStage.getInstance().isInMap(), "[%120][+Bookmark]", "\uff0f");
        for (TextraButton button : this.abilityButtonMap) {
            this.setAlpha(button, visible);
        }
        this.opacity = visible ? 1.0f : 0.4f;
    }

    public void setHUDOpacity(boolean translucent) {
        if (translucent) {
            if (!MapStage.getInstance().isInMap()) {
                return;
            }
            this.setAlpha(this.hudGroup, false);
            this.setAlpha(this.menuGroup, false);
            this.setAlpha(this.avatarGroup, false);
            for (TextraButton button : this.abilityButtonMap) {
                this.setAlpha(button, false);
            }
            this.transluscent = true;
        } else {
            this.setAlpha(this.hudGroup, true);
            this.setAlpha(this.menuGroup, true);
            this.setAlpha(this.avatarGroup, true);
            for (TextraButton button : this.abilityButtonMap) {
                this.setAlpha(button, true);
            }
            this.transluscent = false;
        }
    }

    public void showHideHUD(boolean hide) {
        if (hide) {
            this.hudGroup.addAction(Actions.fadeOut(0.5f));
            this.menuGroup.addAction(Actions.fadeOut(0.5f));
            if (!MapStage.getInstance().isInMap()) {
                this.mapGroup.addAction(Actions.fadeOut(0.5f));
            }
            if (MapStage.getInstance().isInMap()) {
                this.avatarGroup.addAction(Actions.alpha(0.4f, 0.5f));
            }
            this.hidden = true;
        } else {
            float alpha = MapStage.getInstance().isInMap() ? 0.4f : 1.0f;
            this.avatarGroup.addAction(Actions.alpha(alpha, 0.5f));
            this.hudGroup.addAction(Actions.alpha(alpha, 0.5f));
            this.menuGroup.addAction(Actions.alpha(alpha, 0.5f));
            if (!MapStage.getInstance().isInMap()) {
                this.mapGroup.addAction(Actions.fadeIn(0.5f));
            }
            this.hidden = false;
        }
    }

    void toggleConsole() {
        this.console.toggle();
        if (this.console.isVisible()) {
            this.clearAbility();
        } else {
            this.updateAbility();
        }
    }

    @Override
    public boolean keyUp(int keycode) {
        this.ui.pressUp(keycode);
        return super.keyUp(keycode);
    }

    @Override
    public boolean keyDown(int keycode) {
        if (this.dialogOnlyInput) {
            return this.dialogInput(keycode);
        }
        this.ui.pressDown(keycode);
        if (keycode == 139 || keycode == 140) {
            this.toggleConsole();
            return true;
        }
        if (keycode == 4 && this.console.isVisible()) {
            this.toggleConsole();
        }
        if (this.console.isVisible()) {
            return true;
        }
        Button pressedButton = this.ui.buttonPressed(keycode);
        if (pressedButton != null) {
            this.performTouch(pressedButton);
        }
        return super.keyDown(keycode);
    }

    private boolean dialogInput(int keycode) {
        if (this.dialogOnlyInput) {
            if (KeyBinding.Up.isPressed(keycode)) {
                this.selectPreviousDialogButton();
            }
            if (KeyBinding.Down.isPressed(keycode)) {
                this.selectNextDialogButton();
            }
            if (KeyBinding.Use.isPressed(keycode)) {
                this.performTouch(this.getKeyboardFocus());
            }
        }
        return true;
    }

    private void performTouch(final Actor actor) {
        if (actor == null) {
            return;
        }
        actor.fire(this.eventTouchDown);
        Timer.schedule(new Timer.Task(){

            @Override
            public void run() {
                actor.fire(GameHUD.this.eventTouchUp);
            }
        }, 0.1f);
    }

    public void setDebug(boolean b) {
        this.debugMap = b;
    }

    public void playerIdle() {
        if (MapStage.getInstance().isInMap()) {
            MapStage.getInstance().startPause(1.0f);
            MapStage.getInstance().getPlayerSprite().stop();
        } else {
            WorldStage.getInstance().startPause(1.0f);
            WorldStage.getInstance().getPlayerSprite().stop();
        }
    }

    private void showDialog() {
        this.playerIdle();
        this.dialogButtonMap.clear();
        for (int i = 0; i < this.dialog.getButtonTable().getCells().size; ++i) {
            this.dialogButtonMap.add((TextraButton)this.dialog.getButtonTable().getCells().get(i).getActor());
        }
        this.dialog.show(this, Actions.show());
        this.dialog.setPosition((this.getWidth() - this.dialog.getWidth()) / 2.0f, (this.getHeight() - this.dialog.getHeight()) / 2.0f);
        this.dialogOnlyInput = true;
        if (Forge.hasGamepad() && !this.dialogButtonMap.isEmpty()) {
            this.setKeyboardFocus(this.dialogButtonMap.first());
        }
    }

    private void hideDialog(final boolean exitDungeon) {
        this.dialog.hide(Actions.sequence((Action)Actions.sizeTo(this.dialog.getOriginX(), this.dialog.getOriginY(), 0.3f), (Action)Actions.hide(), new Action(){

            @Override
            public boolean act(float v) {
                if (exitDungeon) {
                    MapStage.getInstance().exitDungeon(false);
                    GameHUD.this.setDisabled(GameHUD.this.exitToWorldMapActor, true, "[%120][+ExitToWorldMap]", "\uff0f");
                    GameHUD.this.setDisabled(GameHUD.this.bookmarkActor, true, "[%120][+Bookmark]", "\uff0f");
                }
                return true;
            }
        }));
        this.dialogOnlyInput = false;
    }

    private void selectNextDialogButton() {
        if (this.dialogButtonMap.size < 2) {
            return;
        }
        if (!(this.getKeyboardFocus() instanceof Button)) {
            this.setKeyboardFocus(this.dialogButtonMap.first());
            return;
        }
        for (int i = 0; i < this.dialogButtonMap.size; ++i) {
            if (this.getKeyboardFocus() != this.dialogButtonMap.get(i)) continue;
            ++i;
            this.setKeyboardFocus(this.dialogButtonMap.get(i %= this.dialogButtonMap.size));
            return;
        }
    }

    private void selectPreviousDialogButton() {
        if (this.dialogButtonMap.size < 2) {
            return;
        }
        if (!(this.getKeyboardFocus() instanceof Button)) {
            this.setKeyboardFocus(this.dialogButtonMap.first());
            return;
        }
        for (int i = 0; i < this.dialogButtonMap.size; ++i) {
            if (this.getKeyboardFocus() != this.dialogButtonMap.get(i)) continue;
            if (--i < 0) {
                i = this.dialogButtonMap.size - 1;
            }
            this.setKeyboardFocus(this.dialogButtonMap.get(i));
            return;
        }
    }

    public void updateMusic() {
        switch (GameScene.instance().getAdventurePlayerLocation(false, false)) {
            case "green": {
                this.changeBGM(MusicPlaylist.GREEN);
                break;
            }
            case "red": {
                this.changeBGM(MusicPlaylist.RED);
                break;
            }
            case "blue": {
                this.changeBGM(MusicPlaylist.BLUE);
                break;
            }
            case "black": {
                this.changeBGM(MusicPlaylist.BLACK);
                break;
            }
            case "white": {
                this.changeBGM(MusicPlaylist.WHITE);
                break;
            }
            case "waste": {
                this.changeBGM(MusicPlaylist.COLORLESS);
                break;
            }
        }
    }

    void changeBGM(MusicPlaylist playlist) {
        if (!this.audioIsPlaying() && !playlist.equals((Object)SoundSystem.instance.getCurrentPlaylist())) {
            SoundSystem.instance.setBackgroundMusic(playlist);
        }
    }

    void flicker(final CharacterSprite sprite) {
        if (sprite.getCollisionHeight() == 0.0f) {
            SequenceAction flicker = new SequenceAction(Actions.fadeOut(0.25f), Actions.fadeIn(0.25f), Actions.fadeOut(0.25f), Actions.fadeIn(0.25f), new Action(){

                @Override
                public boolean act(float v) {
                    Timer.schedule(new Timer.Task(){

                        @Override
                        public void run() {
                            sprite.resetCollisionHeight();
                        }
                    }, 0.5f);
                    return true;
                }
            });
            sprite.addAction(flicker);
        }
    }

    void restorePlayerCollision() {
        this.flicker(MapStage.getInstance().getPlayerSprite());
        this.flicker(WorldStage.getInstance().getPlayerSprite());
    }

    public void addNotification(final String text) {
        Action preconfigureNotification = new Action(){

            @Override
            public boolean act(float delta) {
                GameHUD.this.notificationText.setWrap(false);
                GameHUD.this.notificationText.setText(text);
                GameHUD.this.notificationText.setColor(Color.BLACK);
                GameHUD.this.notificationText.setWidth(Math.min(GameHUD.this.notificationText.getPrefWidth(), Forge.isLandscapeMode() ? GameHUD.this.getWidth() * 0.25f : GameHUD.this.getWidth() - 25.0f));
                GameHUD.this.notificationText.setWrap(true);
                GameHUD.this.notificationText.layout();
                GameHUD.this.notificationPane.setSize(GameHUD.this.notificationText.getWidth() + 10.0f, GameHUD.this.notificationText.getPrefHeight() + 20.0f);
                GameHUD.this.notificationPane.setPosition(5.0f, Forge.isLandscapeMode() ? -GameHUD.this.notificationPane.getHeight() : GameHUD.this.getHeight());
                ((GameHUD)GameHUD.this).notificationPane.getColor().a = 1.0f;
                GameHUD.this.notificationPane.layout();
                GameHUD.this.notificationText.layout();
                return true;
            }
        };
        AfterAction newNotification = Forge.isLandscapeMode() ? Actions.after(Actions.sequence(preconfigureNotification, (Action)Actions.moveTo(5.0f, 0.0f, 2.0f), (Action)Actions.delay(10.0f), (Action)Actions.alpha(0.0f, 3.0f), (Action)Actions.sizeTo(0.0f, 0.0f))) : Actions.after(Actions.sequence(preconfigureNotification, (Action)Actions.moveToAligned(5.0f, this.getHeight(), 10, 2.0f), (Action)Actions.delay(10.0f), (Action)Actions.alpha(0.0f, 3.0f), (Action)Actions.sizeTo(0.0f, 0.0f)));
        this.notificationPane.addAction(newNotification);
    }

    public void clearNotifications() {
        this.notificationText.setText("");
        this.notificationPane.setBounds(5.0f, Forge.isLandscapeMode() ? -this.notificationText.getPrefHeight() : this.getHeight(), this.getWidth() * 0.4f, 25.0f);
        this.notificationPane.setStyle(Controls.getSkin().get("paper", ScrollPane.ScrollPaneStyle.class));
        this.notificationPane.getColor().a = 0.0f;
    }

    class ConsoleToggleListener
    extends ActorGestureListener {
        public ConsoleToggleListener() {
            this.getGestureDetector().setLongPressSeconds(0.6f);
        }

        @Override
        public boolean longPress(Actor actor, float x, float y) {
            if (GuiBase.isAndroid()) {
                GameHUD.this.toggleConsole();
            }
            return super.longPress(actor, x, y);
        }

        @Override
        public void tap(InputEvent event, float x, float y, int count, int button) {
            if (GameHUD.this.console.isVisible()) {
                return;
            }
            if (count > 1 && button == 0) {
                GameHUD.this.showHideHUD(!GameHUD.this.hidden);
            } else if (button == 0) {
                GameHUD.this.setHUDOpacity(!GameHUD.this.transluscent);
            }
            super.tap(event, x, y, count, button);
        }
    }
}

