/*
 * Decompiled with CFR 0.152.
 */
package forge.adventure.scene;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.maps.tiled.TiledMap;
import com.google.common.collect.Lists;
import forge.Forge;
import forge.adventure.pointofintrest.PointOfInterest;
import forge.adventure.pointofintrest.PointOfInterestChanges;
import forge.adventure.scene.HudScene;
import forge.adventure.scene.Scene;
import forge.adventure.stage.MapStage;
import forge.adventure.stage.PointOfInterestMapRenderer;
import forge.adventure.util.AdventureQuestController;
import forge.adventure.util.Config;
import forge.adventure.util.Current;
import forge.adventure.util.TemplateTmxMapLoader;
import forge.adventure.world.WorldSave;
import forge.sound.SoundEffectType;
import forge.sound.SoundSystem;
import java.util.ArrayList;

public class TileMapScene
extends HudScene {
    TiledMap map;
    PointOfInterestMapRenderer tiledMapRenderer = new PointOfInterestMapRenderer((MapStage)this.stage);
    private String nextMap;
    private int nextSpawnPoint;
    private boolean autoheal = false;
    private static TileMapScene object;
    private static final ArrayList<String> AUTO_HEAL_LOCATIONS;
    public PointOfInterest rootPoint;
    String oldMap;

    private TileMapScene() {
        super(MapStage.getInstance());
        MapStage.getInstance().setDialogStage(this.hud);
    }

    public static TileMapScene instance() {
        if (object == null) {
            object = new TileMapScene();
        }
        return object;
    }

    public MapStage currentMap() {
        return (MapStage)this.stage;
    }

    @Override
    public void dispose() {
        if (this.map != null) {
            this.map.dispose();
        }
    }

    @Override
    public void act(float delta) {
        if (this.map == null) {
            return;
        }
        if (this.nextMap != null) {
            this.load(this.nextMap, this.nextSpawnPoint);
            this.nextMap = null;
            this.nextSpawnPoint = 0;
        }
        this.stage.act(Gdx.graphics.getDeltaTime());
        this.hud.act(Gdx.graphics.getDeltaTime());
        if (this.autoheal) {
            this.stage.getPlayerSprite().playEffect("particle_effects/heal.p", 2.0f);
            SoundSystem.instance.play(SoundEffectType.Enchantment, false);
            this.autoheal = false;
        }
    }

    @Override
    public void render() {
        if (this.map == null) {
            return;
        }
        Gdx.gl.glClearColor(0.0f, 0.0f, 0.0f, 1.0f);
        Gdx.gl.glClear(16384);
        Gdx.gl.glBlendFunc(770, 771);
        this.tiledMapRenderer.setView(this.stage.getCamera().combined, this.stage.getCamera().position.x - (float)Scene.getIntendedWidth() / 2.0f, this.stage.getCamera().position.y - (float)Scene.getIntendedHeight() / 2.0f, Scene.getIntendedWidth(), Scene.getIntendedHeight());
        if (!Forge.isLandscapeMode()) {
            this.stage.getCamera().position.x = this.stage.getPlayerSprite().pos().x;
        }
        this.tiledMapRenderer.render();
        this.hud.draw();
    }

    @Override
    public void enter() {
        super.enter();
        if (this.isAutoHealLocation() && Current.player().fullHeal()) {
            this.autoheal = true;
        }
        AdventureQuestController.instance().updateEnteredPOI(this.rootPoint);
        AdventureQuestController.instance().showQuestDialogs(this.stage);
    }

    public void load(PointOfInterest point) {
        AdventureQuestController.instance().mostRecentPOI = point;
        this.rootPoint = point;
        this.oldMap = point.getData().map;
        this.map = new TemplateTmxMapLoader().load(Config.instance().getCommonFilePath(point.getData().map));
        ((MapStage)this.stage).setPointOfInterest(this.getPointOfInterestChanges());
        this.stage.getPlayerSprite().setPosition(0.0f, 0.0f);
        WorldSave.getCurrentSave().getWorld().setSeed(point.getSeedOffset());
        this.tiledMapRenderer.loadMap(this.map, "", this.oldMap, 0);
        this.stage.getPlayerSprite().stop();
    }

    public boolean isAutoHealLocation() {
        return AUTO_HEAL_LOCATIONS.contains(this.rootPoint.getData().type);
    }

    private void load(String targetMap, int nextSpawnPoint) {
        this.map = new TemplateTmxMapLoader().load(Config.instance().getFilePath(targetMap));
        ((MapStage)this.stage).setPointOfInterest(this.getPointOfInterestChanges(targetMap));
        this.stage.getPlayerSprite().setPosition(0.0f, 0.0f);
        WorldSave.getCurrentSave().getWorld().setSeed(this.rootPoint.getSeedOffset());
        this.tiledMapRenderer.loadMap(this.map, this.oldMap, targetMap, nextSpawnPoint);
        this.oldMap = targetMap;
        this.stage.getPlayerSprite().stop();
    }

    public PointOfInterestChanges getPointOfInterestChanges() {
        return WorldSave.getCurrentSave().getPointOfInterestChanges(this.rootPoint.getID());
    }

    public PointOfInterestChanges getPointOfInterestChanges(String targetMap) {
        if (this.rootPoint.getID().endsWith(targetMap)) {
            return this.getPointOfInterestChanges();
        }
        return WorldSave.getCurrentSave().getPointOfInterestChanges(this.rootPoint.getID() + targetMap);
    }

    @Override
    public boolean isInHudOnlyMode() {
        return MapStage.getInstance().getDialogOnlyInput();
    }

    public void loadNext(String targetMap, int entryTargetObject) {
        this.nextMap = targetMap;
        this.nextSpawnPoint = entryTargetObject;
    }

    static {
        AUTO_HEAL_LOCATIONS = Lists.newArrayList("capital", "town");
    }
}

