/*
 * Decompiled with CFR 0.152.
 */
package forge.adventure.scene;

import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.ui.CheckBox;
import com.badlogic.gdx.scenes.scene2d.ui.Dialog;
import com.badlogic.gdx.scenes.scene2d.ui.ScrollPane;
import com.badlogic.gdx.scenes.scene2d.ui.SelectBox;
import com.badlogic.gdx.scenes.scene2d.ui.Slider;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.ui.TextField;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.github.tommyettinger.textra.TextraButton;
import com.github.tommyettinger.textra.TextraLabel;
import forge.Forge;
import forge.Graphics;
import forge.adventure.scene.UIScene;
import forge.adventure.util.Config;
import forge.adventure.util.Controls;
import forge.assets.ImageCache;
import forge.gui.GuiBase;
import forge.localinstance.properties.ForgeConstants;
import forge.localinstance.properties.ForgePreferences;
import forge.model.FModel;
import forge.sound.SoundSystem;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Stream;

public class SettingsScene
extends UIScene {
    private final Table settingGroup = new Table();
    TextraButton backButton;
    ScrollPane scrollPane;
    SelectBox<String> selectSourcePlane;
    TextField newPlaneName;
    Dialog createNewPlane;
    Dialog copyPlane;
    Dialog errorDialog;
    private static SettingsScene object;

    private void copyNewPlane() {
        String plane = this.selectSourcePlane.getSelected();
        Path source = Paths.get(Config.instance().getPlanePath(plane), new String[0]);
        Path destination = Paths.get(Config.instance().getPlanePath("<user>" + this.newPlaneName.getText()), new String[0]);
        AtomicBoolean somethingWentWrong = new AtomicBoolean(false);
        try (Stream<Path> stream = Files.walk(source, new FileVisitOption[0]);){
            Files.createDirectories(destination, new FileAttribute[0]);
            stream.forEach(s2 -> {
                try {
                    Files.copy(s2, destination.resolve(source.relativize((Path)s2)), StandardCopyOption.REPLACE_EXISTING);
                }
                catch (IOException e) {
                    somethingWentWrong.set(true);
                }
            });
        }
        catch (IOException e) {
            somethingWentWrong.set(true);
        }
        if (somethingWentWrong.get()) {
            if (this.errorDialog == null) {
                this.errorDialog = this.createGenericDialog("Something went wrong", "Copy was not successful check your access right\n and if the folder is in use", Forge.getLocalizer().getMessage("lblOK", new Object[0]), Forge.getLocalizer().getMessage("lblAbort", new Object[0]), this::removeDialog, this::removeDialog);
            }
            this.showDialog(this.errorDialog);
        } else {
            if (this.copyPlane == null) {
                this.copyPlane = this.createGenericDialog("Copied plane", "New plane " + this.newPlaneName.getText() + " was created\nYou can now start the editor to change the plane\nor edit it manually from the folder\n" + Config.instance().getPlanePath("<user>" + this.newPlaneName.getText()), Forge.getLocalizer().getMessage("lblOK", new Object[0]), Forge.getLocalizer().getMessage("lblAbort", new Object[0]), this::removeDialog, this::removeDialog);
            }
            Config.instance().getSettingData().plane = "<user>" + this.newPlaneName.getText();
            Config.instance().saveSettings();
            this.showDialog(this.copyPlane);
        }
    }

    private void createNewPlane() {
        if (this.createNewPlane == null) {
            this.createNewPlane = this.createGenericDialog("Create your own Plane", "Select a plane to copy", Forge.getLocalizer().getMessage("lblOK", new Object[0]), Forge.getLocalizer().getMessage("lblAbort", new Object[0]), () -> {
                this.copyNewPlane();
                this.removeDialog();
            }, this::removeDialog);
            this.createNewPlane.getContentTable().row();
            this.createNewPlane.getContentTable().add(this.selectSourcePlane);
            this.createNewPlane.getContentTable().row();
            this.createNewPlane.text("Set new plane name");
            this.createNewPlane.getContentTable().row();
            this.createNewPlane.getContentTable().add(this.newPlaneName);
            this.newPlaneName.setText(this.selectSourcePlane.getSelected() + "_copy");
        }
        this.showDialog(this.createNewPlane);
    }

    private SettingsScene() {
        super(Forge.isLandscapeMode() ? "ui/settings.json" : "ui/settings_portrait.json");
        if (!GuiBase.isAndroid()) {
            SelectBox<String> videomode = Controls.newComboBox(ForgeConstants.VIDEO_MODES, Config.instance().getSettingData().videomode, o -> {
                String mode = (String)o;
                if (mode == null) {
                    mode = "720p";
                }
                Graphics.setVideoMode(mode);
                if (!FModel.getPreferences().getPref(ForgePreferences.FPref.UI_VIDEO_MODE).equalsIgnoreCase(mode)) {
                    FModel.getPreferences().setPref(ForgePreferences.FPref.UI_VIDEO_MODE, mode);
                    FModel.getPreferences().save();
                }
                return null;
            });
            this.addLabel(Forge.getLocalizer().getMessage("lblVideoMode", new Object[0]));
            this.settingGroup.add(videomode).align(16).pad(2.0f);
        }
        if (Forge.isLandscapeMode()) {
            SelectBox<Float> rewardCardAdjLandscape = Controls.newComboBox(new Float[]{Float.valueOf(0.6f), Float.valueOf(0.65f), Float.valueOf(0.7f), Float.valueOf(0.75f), Float.valueOf(0.8f), Float.valueOf(0.85f), Float.valueOf(0.9f), Float.valueOf(0.95f), Float.valueOf(1.0f), Float.valueOf(1.05f), Float.valueOf(1.1f), Float.valueOf(1.15f), Float.valueOf(1.2f), Float.valueOf(1.25f), Float.valueOf(1.3f), Float.valueOf(1.35f), Float.valueOf(1.4f), Float.valueOf(1.45f), Float.valueOf(1.5f), Float.valueOf(1.55f), Float.valueOf(1.6f)}, Config.instance().getSettingData().rewardCardAdjLandscape.floatValue(), o -> {
                Float val = (Float)o;
                if (val == null || val.floatValue() == 0.0f) {
                    val = Float.valueOf(1.0f);
                }
                Config.instance().getSettingData().rewardCardAdjLandscape = val;
                Config.instance().saveSettings();
                return null;
            });
            this.addLabel("Reward/Shop Card Display Ratio");
            this.settingGroup.add(rewardCardAdjLandscape).align(16).pad(2.0f);
            SelectBox<Float> tooltipAdjLandscape = Controls.newComboBox(new Float[]{Float.valueOf(0.6f), Float.valueOf(0.65f), Float.valueOf(0.7f), Float.valueOf(0.75f), Float.valueOf(0.8f), Float.valueOf(0.85f), Float.valueOf(0.9f), Float.valueOf(0.95f), Float.valueOf(1.0f), Float.valueOf(1.05f), Float.valueOf(1.1f), Float.valueOf(1.15f), Float.valueOf(1.2f), Float.valueOf(1.25f), Float.valueOf(1.3f), Float.valueOf(1.35f), Float.valueOf(1.4f), Float.valueOf(1.45f), Float.valueOf(1.5f), Float.valueOf(1.55f), Float.valueOf(1.6f)}, Config.instance().getSettingData().cardTooltipAdjLandscape.floatValue(), o -> {
                Float val = (Float)o;
                if (val == null || val.floatValue() == 0.0f) {
                    val = Float.valueOf(1.0f);
                }
                Config.instance().getSettingData().cardTooltipAdjLandscape = val;
                Config.instance().saveSettings();
                return null;
            });
            this.addLabel("Reward/Shop Card Tooltip Ratio");
            this.settingGroup.add(tooltipAdjLandscape).align(16).pad(2.0f);
        } else {
            SelectBox<Float> rewardCardAdj = Controls.newComboBox(new Float[]{Float.valueOf(0.5f), Float.valueOf(0.6f), Float.valueOf(0.7f), Float.valueOf(0.8f), Float.valueOf(0.9f), Float.valueOf(1.0f), Float.valueOf(1.1f), Float.valueOf(1.2f), Float.valueOf(1.3f), Float.valueOf(1.4f), Float.valueOf(1.5f), Float.valueOf(1.6f), Float.valueOf(1.8f), Float.valueOf(1.9f), Float.valueOf(2.0f)}, Config.instance().getSettingData().rewardCardAdj.floatValue(), o -> {
                Float val = (Float)o;
                if (val == null || val.floatValue() == 0.0f) {
                    val = Float.valueOf(1.0f);
                }
                Config.instance().getSettingData().rewardCardAdj = val;
                Config.instance().saveSettings();
                return null;
            });
            this.addLabel("Reward/Shop Card Display Ratio");
            this.settingGroup.add(rewardCardAdj).align(16).pad(2.0f);
            SelectBox<Float> tooltipAdj = Controls.newComboBox(new Float[]{Float.valueOf(0.5f), Float.valueOf(0.6f), Float.valueOf(0.7f), Float.valueOf(0.8f), Float.valueOf(0.9f), Float.valueOf(1.0f), Float.valueOf(1.1f), Float.valueOf(1.2f), Float.valueOf(1.3f), Float.valueOf(1.4f), Float.valueOf(1.5f), Float.valueOf(1.6f), Float.valueOf(1.8f), Float.valueOf(1.9f), Float.valueOf(2.0f)}, Config.instance().getSettingData().cardTooltipAdj.floatValue(), o -> {
                Float val = (Float)o;
                if (val == null || val.floatValue() == 0.0f) {
                    val = Float.valueOf(1.0f);
                }
                Config.instance().getSettingData().cardTooltipAdj = val;
                Config.instance().saveSettings();
                return null;
            });
            this.addLabel("Reward/Shop Card Tooltip Ratio");
            this.settingGroup.add(tooltipAdj).align(16).pad(2.0f);
        }
        if (!GuiBase.isAndroid()) {
            this.addSettingField(Forge.getLocalizer().getMessage("lblFullScreen", new Object[0]), Config.instance().getSettingData().fullScreen, new ChangeListener(){

                @Override
                public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                    boolean value;
                    Config.instance().getSettingData().fullScreen = value = ((CheckBox)actor).isChecked();
                    Config.instance().saveSettings();
                    FModel.getPreferences().setPref(ForgePreferences.FPref.UI_FULLSCREEN_MODE, Config.instance().getSettingData().fullScreen);
                    FModel.getPreferences().save();
                }
            });
        }
        this.addSettingField(Forge.getLocalizer().getMessage("lblDay", new Object[0]) + " | " + Forge.getLocalizer().getMessage("lblNight", new Object[0]) + " " + Forge.getLocalizer().getMessage("lblBackgroundImage", new Object[0]), Config.instance().getSettingData().dayNightBG, new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                boolean value;
                Config.instance().getSettingData().dayNightBG = value = ((CheckBox)actor).isChecked();
                Config.instance().saveSettings();
                if (value) {
                    SettingsScene.this.updateBG(true);
                }
            }
        });
        this.addSettingField(Forge.getLocalizer().getMessage("lblDisableWinLose", new Object[0]), Config.instance().getSettingData().disableWinLose, new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                Config.instance().getSettingData().disableWinLose = ((CheckBox)actor).isChecked();
                Config.instance().saveSettings();
            }
        });
        this.addSettingField(Forge.getLocalizer().getMessage("lblShowShopOverlay", new Object[0]), Config.instance().getSettingData().showShopOverlay, new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                Config.instance().getSettingData().showShopOverlay = ((CheckBox)actor).isChecked();
                Config.instance().saveSettings();
            }
        });
        this.addSettingField(Forge.getLocalizer().getMessage("lblUseAllCardVariants", new Object[0]), Config.instance().getSettingData().useAllCardVariants, new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                Config.instance().getSettingData().useAllCardVariants = ((CheckBox)actor).isChecked();
                Config.instance().saveSettings();
            }
        });
        this.addSettingField(Forge.getLocalizer().getMessage("lblGenerateLDADecks", new Object[0]), Config.instance().getSettingData().generateLDADecks, new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                Config.instance().getSettingData().generateLDADecks = ((CheckBox)actor).isChecked();
                Config.instance().saveSettings();
            }
        });
        this.addCheckBox(Forge.getLocalizer().getMessage("lblCardName", new Object[0]), ForgePreferences.FPref.UI_OVERLAY_CARD_NAME);
        this.addSettingSlider(Forge.getLocalizer().getMessage("cbAdjustMusicVolume", new Object[0]), ForgePreferences.FPref.UI_VOL_MUSIC, 0, 100);
        this.addSettingSlider(Forge.getLocalizer().getMessage("cbAdjustSoundsVolume", new Object[0]), ForgePreferences.FPref.UI_VOL_SOUNDS, 0, 100);
        this.addCheckBox(Forge.getLocalizer().getMessage("lblManaCost", new Object[0]), ForgePreferences.FPref.UI_OVERLAY_CARD_MANA_COST);
        this.addCheckBox(Forge.getLocalizer().getMessage("lblPowerOrToughness", new Object[0]), ForgePreferences.FPref.UI_OVERLAY_CARD_POWER);
        this.addCheckBox(Forge.getLocalizer().getMessage("lblCardID", new Object[0]), ForgePreferences.FPref.UI_OVERLAY_CARD_ID);
        this.addCheckBox(Forge.getLocalizer().getMessage("lblAbilityIcon", new Object[0]), ForgePreferences.FPref.UI_OVERLAY_ABILITY_ICONS);
        this.addCheckBox(Forge.getLocalizer().getMessage("cbImageFetcher", new Object[0]), ForgePreferences.FPref.UI_ENABLE_ONLINE_IMAGE_FETCHER);
        if (!GuiBase.isAndroid()) {
            this.addCheckBox(Forge.getLocalizer().getMessage("lblBattlefieldTextureFiltering", new Object[0]), ForgePreferences.FPref.UI_LIBGDX_TEXTURE_FILTERING);
            this.addCheckBox(Forge.getLocalizer().getMessage("lblAltZoneTabs", new Object[0]), ForgePreferences.FPref.UI_ALT_PLAYERZONETABS);
        }
        this.addCheckBox(Forge.getLocalizer().getMessage("lblLandscapeMode", new Object[0]), ForgePreferences.FPref.UI_LANDSCAPE_MODE);
        this.addCheckBox(Forge.getLocalizer().getMessage("lblAnimatedCardTapUntap", new Object[0]), ForgePreferences.FPref.UI_ANIMATED_CARD_TAPUNTAP);
        if (!GuiBase.isAndroid()) {
            String[] item = new String[]{FModel.getPreferences().getPref(ForgePreferences.FPref.UI_ENABLE_BORDER_MASKING)};
            SelectBox<String> borderMask = Controls.newComboBox(new String[]{"Off", "Crop", "Full", "Art"}, item[0], o -> {
                String mode = (String)o;
                if (mode == null) {
                    mode = "Crop";
                }
                item[0] = mode;
                if (!FModel.getPreferences().getPref(ForgePreferences.FPref.UI_ENABLE_BORDER_MASKING).equalsIgnoreCase(mode)) {
                    FModel.getPreferences().setPref(ForgePreferences.FPref.UI_ENABLE_BORDER_MASKING, mode);
                    FModel.getPreferences().save();
                    Forge.enableUIMask = FModel.getPreferences().getPref(ForgePreferences.FPref.UI_ENABLE_BORDER_MASKING);
                }
                ImageCache.clearGeneratedCards();
                ImageCache.disposeTextures();
                return null;
            });
            this.addLabel(Forge.getLocalizer().getMessage("lblBorderMaskOption", new Object[0]));
            this.settingGroup.add(borderMask).align(16).pad(2.0f);
            this.addCheckBox(Forge.getLocalizer().getMessage("lblPreloadExtendedArtCards", new Object[0]), ForgePreferences.FPref.UI_ENABLE_PRELOAD_EXTENDED_ART);
            this.addCheckBox(Forge.getLocalizer().getMessage("lblAutoCacheSize", new Object[0]), ForgePreferences.FPref.UI_AUTO_CACHE_SIZE);
            this.addCheckBox(Forge.getLocalizer().getMessage("lblDisposeTextures", new Object[0]), ForgePreferences.FPref.UI_ENABLE_DISPOSE_TEXTURES);
        }
        this.settingGroup.row();
        this.backButton = (TextraButton)this.ui.findActor("return");
        this.ui.onButtonPress("return", this::back);
        this.scrollPane = (ScrollPane)this.ui.findActor("settings");
        this.scrollPane.setActor(this.settingGroup);
        this.addToSelectable(this.settingGroup);
    }

    @Override
    public boolean back() {
        Forge.switchToLast();
        return true;
    }

    private void addInputField(String name, final ForgePreferences.FPref pref) {
        TextField box = Controls.newTextField("");
        box.setText(FModel.getPreferences().getPref(pref));
        box.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                FModel.getPreferences().setPref(pref, ((TextField)actor).getText());
                FModel.getPreferences().save();
            }
        });
        this.addLabel(name);
        this.settingGroup.add(box).align(16);
    }

    private void addCheckBox(String name, final ForgePreferences.FPref pref) {
        CheckBox box = Controls.newCheckBox("");
        box.setChecked(FModel.getPreferences().getPrefBoolean(pref));
        box.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                FModel.getPreferences().setPref(pref, ((CheckBox)actor).isChecked());
                FModel.getPreferences().save();
            }
        });
        this.addLabel(name);
        this.settingGroup.add(box).align(16);
    }

    private void addSettingSlider(String name, final ForgePreferences.FPref pref, int min2, int max) {
        Slider slide = Controls.newSlider(min2, max, 1.0f, false);
        slide.setValue(FModel.getPreferences().getPrefInt(pref));
        slide.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                FModel.getPreferences().setPref(pref, String.valueOf((int)((Slider)actor).getValue()));
                FModel.getPreferences().save();
                if (ForgePreferences.FPref.UI_VOL_MUSIC.equals((Object)pref)) {
                    SoundSystem.instance.refreshVolume();
                }
            }
        });
        this.addLabel(name);
        this.settingGroup.add(slide).align(16);
    }

    private void addSettingField(String name, boolean value, ChangeListener change) {
        CheckBox box = Controls.newCheckBox("");
        box.setChecked(value);
        box.addListener(change);
        this.addLabel(name);
        this.settingGroup.add(box).align(16);
    }

    private void addSettingField(String name, int value, ChangeListener change) {
        TextField text = Controls.newTextField(String.valueOf(value));
        text.setTextFieldFilter((textField, c) -> Character.isDigit(c));
        text.addListener(change);
        this.addLabel(name);
        this.settingGroup.add(text).align(16);
    }

    void addLabel(String name) {
        TextraLabel label = Controls.newTextraLabel(name);
        label.setWrap(true);
        this.settingGroup.row().space(5.0f);
        int w = Forge.isLandscapeMode() ? 160 : 80;
        this.settingGroup.add(label).align(8).pad(2.0f, 2.0f, 2.0f, 5.0f).width(w).expand();
    }

    public static SettingsScene instance() {
        if (object == null) {
            object = new SettingsScene();
        }
        return object;
    }

    @Override
    public void dispose() {
        if (this.stage != null) {
            this.stage.dispose();
        }
    }
}

