/*
 * Decompiled with CFR 0.152.
 */
package forge.adventure.scene;

import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.ui.Dialog;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.ScrollPane;
import com.badlogic.gdx.scenes.scene2d.ui.SelectBox;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.ui.TextField;
import com.badlogic.gdx.scenes.scene2d.ui.Window;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;
import com.badlogic.gdx.scenes.scene2d.utils.TextureRegionDrawable;
import com.badlogic.gdx.utils.GdxRuntimeException;
import com.badlogic.gdx.utils.IntMap;
import com.badlogic.gdx.utils.Scaling;
import com.github.tommyettinger.textra.TextraButton;
import com.github.tommyettinger.textra.TextraLabel;
import forge.Forge;
import forge.adventure.data.DifficultyData;
import forge.adventure.player.AdventurePlayer;
import forge.adventure.scene.GameScene;
import forge.adventure.scene.Scene;
import forge.adventure.scene.TileMapScene;
import forge.adventure.scene.UIScene;
import forge.adventure.stage.WorldStage;
import forge.adventure.util.Config;
import forge.adventure.util.Controls;
import forge.adventure.util.Current;
import forge.adventure.world.WorldSave;
import forge.adventure.world.WorldSaveHeader;
import forge.screens.TransitionScreen;
import forge.sound.SoundSystem;
import forge.util.TextUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.text.DateFormat;
import java.util.zip.InflaterInputStream;

public class SaveLoadScene
extends UIScene {
    private static final int NUMBEROFSAVESLOTS = 11;
    private final IntMap<UIScene.Selectable<TextraButton>> buttons = new IntMap();
    IntMap<WorldSaveHeader> previews = new IntMap();
    Table layout;
    Modes mode;
    TextField textInput;
    TextraLabel header;
    int currentSlot = 0;
    int lastSelectedSlot = 0;
    Image previewImage;
    TextraLabel previewDate;
    TextraLabel playerLocation;
    TextraButton saveLoadButton;
    TextraButton back;
    UIScene.Selectable<TextraButton> quickSave;
    UIScene.Selectable<TextraButton> autoSave;
    SelectBox difficulty;
    ScrollPane scrollPane;
    char ASCII_179 = (char)9474;
    Dialog saveDialog;
    private static SaveLoadScene object;
    boolean loaded = false;

    private SaveLoadScene() {
        super(Forge.isLandscapeMode() ? "ui/save_load.json" : "ui/save_load_portrait.json");
        Table root = new Table();
        this.layout = new Table();
        this.scrollPane = new ScrollPane((Actor)this.layout);
        Window window = (Window)this.ui.findActor("saveSlots");
        window.add(root);
        this.textInput = Controls.newTextField("");
        int c = 0;
        String[] diffList = new String[Config.instance().getConfigData().difficulties.length];
        for (DifficultyData diff : Config.instance().getConfigData().difficulties) {
            diffList[c] = Forge.getLocalizer().getMessageorUseDefault("lbl" + diff.name, diff.name, new Object[0]);
            ++c;
        }
        this.difficulty = Controls.newComboBox(diffList, null, o -> null);
        this.previewImage = (Image)this.ui.findActor("preview");
        this.previewDate = (TextraLabel)this.ui.findActor("saveDate");
        this.playerLocation = Controls.newTextraLabel("");
        this.playerLocation.setText("");
        this.playerLocation.setX(this.previewImage.getX());
        this.playerLocation.setY(this.previewImage.getY() + 5.0f);
        this.ui.addActor(this.playerLocation);
        this.header = Controls.newTextraLabel(Forge.getLocalizer().getMessage("lblSave", new Object[0]));
        root.row();
        root.add(this.header).grow();
        root.add(this.difficulty);
        root.row();
        root.add(this.scrollPane).colspan(2).width(window.getWidth() - 20.0f);
        this.autoSave = this.addSaveSlot(Forge.getLocalizer().getMessage("lblAutoSave", new Object[0]), -1);
        this.quickSave = this.addSaveSlot(Forge.getLocalizer().getMessage("lblQuickSave", new Object[0]), -2);
        for (int i = 1; i < 11; ++i) {
            this.addSaveSlot(Forge.getLocalizer().getMessage("lblSlot", new Object[0]) + ": " + i, i);
        }
        this.saveLoadButton = (TextraButton)this.ui.findActor("save");
        this.saveLoadButton.setText(Forge.getLocalizer().getMessage("lblSave", new Object[0]));
        this.ui.onButtonPress("save", this::loadSave);
        this.back = (TextraButton)this.ui.findActor("return");
        this.ui.onButtonPress("return", this::back);
        this.difficulty.setSelectedIndex(1);
        this.difficulty.setAlignment(1);
        this.difficulty.setX(this.scrollPane.getWidth() - this.difficulty.getWidth() + 5.0f);
        this.difficulty.setY(this.scrollPane.getTop() - this.difficulty.getHeight() - 5.0f);
    }

    public static SaveLoadScene instance() {
        if (object == null) {
            object = new SaveLoadScene();
        }
        return object;
    }

    private UIScene.Selectable<TextraButton> addSaveSlot(String name, int i) {
        this.layout.add(Controls.newLabel(name)).align(8).pad(2.0f, 5.0f, 2.0f, 10.0f);
        SaveSlot button = new SaveSlot(i);
        this.layout.add((TextraButton)button.actor).fill(true, false).expand(true, false).align(8).expandX();
        this.buttons.put(i, button);
        this.layout.row();
        this.addToSelectable(button);
        return button;
    }

    public boolean select(int slot) {
        if (!this.buttons.containsKey(slot)) {
            return false;
        }
        this.selectActor(this.buttons.get(slot));
        return this.updateSlot(slot);
    }

    private boolean updateSlot(int slot) {
        this.currentSlot = slot;
        if (slot > 0) {
            this.lastSelectedSlot = slot;
        }
        if (this.previews.containsKey(slot)) {
            WorldSaveHeader worldSaveHeader = this.previews.get(slot);
            if (worldSaveHeader.preview != null) {
                this.previewImage.setDrawable(new TextureRegionDrawable(new Texture(worldSaveHeader.preview)));
                this.previewImage.setScaling(Scaling.fit);
                this.previewImage.layout();
                this.previewImage.setVisible(true);
                this.previewDate.setVisible(true);
                if (worldSaveHeader.saveDate != null) {
                    this.previewDate.setText("[%98]" + DateFormat.getDateInstance().format(worldSaveHeader.saveDate) + " " + DateFormat.getTimeInstance(3).format(worldSaveHeader.saveDate));
                } else {
                    this.previewDate.setText("");
                }
                this.playerLocation.setText(this.getSplitHeaderName(worldSaveHeader, true));
            }
        } else {
            if (this.previewImage != null) {
                this.previewImage.setVisible(false);
            }
            if (this.previewDate != null) {
                this.previewDate.setVisible(false);
            }
        }
        return true;
    }

    public void loadSave() {
        if (this.loaded) {
            return;
        }
        this.loaded = true;
        switch (this.mode) {
            case Save: {
                if (TileMapScene.instance().currentMap().isInMap()) {
                    Dialog noSave = this.createGenericDialog("", Forge.getLocalizer().getMessage("lblGameNotSaved", new Object[0]), Forge.getLocalizer().getMessage("lblOK", new Object[0]), null, null, null);
                    this.showDialog(noSave);
                    return;
                }
                if (this.currentSlot > 0) {
                    this.textInput.setText(((TextraButton)this.buttons.get((int)this.currentSlot).actor).getText());
                    if (this.saveDialog == null) {
                        this.saveDialog = this.createGenericDialog(Forge.getLocalizer().getMessage("lblSave", new Object[0]), null, Forge.getLocalizer().getMessage("lblOK", new Object[0]), Forge.getLocalizer().getMessage("lblAbort", new Object[0]), () -> {
                            this.save();
                            this.removeDialog();
                        }, this::removeDialog);
                        this.saveDialog.getContentTable().add(Controls.newLabel(Forge.getLocalizer().getMessage("lblNameYourSaveFile", new Object[0]))).colspan(2).pad(2.0f, 15.0f, 2.0f, 15.0f);
                        this.saveDialog.getContentTable().row();
                        this.saveDialog.getContentTable().add(Controls.newLabel(Forge.getLocalizer().getMessage("lblName", new Object[0]) + ": ")).align(8).pad(2.0f, 15.0f, 2.0f, 2.0f);
                        this.saveDialog.getContentTable().add(this.textInput).fillX().expandX().padRight(15.0f);
                        this.saveDialog.getContentTable().row();
                    }
                    this.showDialog(this.saveDialog);
                    this.stage.setKeyboardFocus(this.textInput);
                }
                this.loaded = false;
                break;
            }
            case Load: {
                try {
                    Forge.setTransitionScreen(new TransitionScreen(() -> {
                        this.loaded = false;
                        if (WorldSave.load(this.currentSlot)) {
                            SoundSystem.instance.changeBackgroundTrack();
                            Forge.switchScene(GameScene.instance());
                        } else {
                            Forge.clearTransitionScreen();
                        }
                    }, null, false, true, Forge.getLocalizer().getMessage("lblLoadingWorld", new Object[0])));
                }
                catch (Exception e) {
                    Forge.clearTransitionScreen();
                }
                break;
            }
            case NewGamePlus: {
                try {
                    Forge.setTransitionScreen(new TransitionScreen(() -> {
                        this.loaded = false;
                        if (WorldSave.load(this.currentSlot)) {
                            WorldSave.getCurrentSave().clearChanges();
                            WorldSave.getCurrentSave().getWorld().generateNew(0L);
                            if (this.difficulty != null) {
                                Current.player().updateDifficulty(Config.instance().getConfigData().difficulties[this.difficulty.getSelectedIndex()]);
                            }
                            Current.player().setWorldPosY((int)(WorldSave.getCurrentSave().getWorld().getData().playerStartPosY * (float)WorldSave.getCurrentSave().getWorld().getData().height * (float)WorldSave.getCurrentSave().getWorld().getTileSize()));
                            Current.player().setWorldPosX((int)(WorldSave.getCurrentSave().getWorld().getData().playerStartPosX * (float)WorldSave.getCurrentSave().getWorld().getData().width * (float)WorldSave.getCurrentSave().getWorld().getTileSize()));
                            Current.player().getQuests().clear();
                            Current.player().resetQuestFlags();
                            Current.player().setCharacterFlag("newGamePlus", 1);
                            AdventurePlayer.current().addQuest("28");
                            WorldStage.getInstance().setDirectlyEnterPOI();
                            SoundSystem.instance.changeBackgroundTrack();
                            Forge.switchScene(GameScene.instance());
                        } else {
                            Forge.clearTransitionScreen();
                        }
                    }, null, false, true, Forge.getLocalizer().getMessage("lblGeneratingWorld", new Object[0])));
                    break;
                }
                catch (Exception e) {
                    this.loaded = false;
                    Forge.clearTransitionScreen();
                }
            }
        }
    }

    public void save() {
        if (!TileMapScene.instance().currentMap().isInMap() && WorldSave.getCurrentSave().save(this.textInput.getText() + this.getSaveFileSuffix(), this.currentSlot)) {
            this.updateFiles();
            Scene restoreScene = Forge.switchToLast();
            if (restoreScene != null) {
                restoreScene = Forge.switchToLast();
            }
            if (restoreScene == null) {
                restoreScene = GameScene.instance();
            }
            Forge.switchScene(restoreScene);
        }
    }

    private void updateFiles() {
        File f = new File(WorldSave.getSaveDir());
        f.mkdirs();
        File[] names = f.listFiles();
        if (names == null) {
            throw new RuntimeException("Can not find save directory");
        }
        this.previews.clear();
        for (File name : names) {
            if (!WorldSave.isSafeFile(name.getName())) continue;
            try (FileInputStream fos = new FileInputStream(name.getAbsolutePath());
                 InflaterInputStream inf = new InflaterInputStream(fos);
                 ObjectInputStream oos = new ObjectInputStream(inf);){
                int slot = WorldSave.filenameToSlot(name.getName());
                WorldSaveHeader worldSaveHeader = (WorldSaveHeader)oos.readObject();
                ((TextraButton)this.buttons.get((int)slot).actor).setText(this.getSplitHeaderName(worldSaveHeader, false));
                this.previews.put(slot, worldSaveHeader);
            }
            catch (GdxRuntimeException | IOException | ClassNotFoundException exception) {
                // empty catch block
            }
        }
    }

    private String getSplitHeaderName(WorldSaveHeader worldSaveHeader, boolean getLocation) {
        String noMapData = "[RED]No Map Data!";
        if (worldSaveHeader.name.contains(Character.toString(this.ASCII_179))) {
            String[] split = TextUtil.split(worldSaveHeader.name, this.ASCII_179);
            if (getLocation) {
                return split.length > 1 ? split[1] : noMapData;
            }
            return split[0];
        }
        return getLocation ? noMapData : worldSaveHeader.name;
    }

    public void setMode(Modes mode) {
        switch (mode) {
            case Save: {
                this.header.setText(Forge.getLocalizer().getMessage("lblSaveGame", new Object[0]));
                this.saveLoadButton.setText(Forge.getLocalizer().getMessage("lblSave", new Object[0]));
                break;
            }
            case Load: {
                this.header.setText(Forge.getLocalizer().getMessage("lblLoadGame", new Object[0]));
                this.saveLoadButton.setText(Forge.getLocalizer().getMessage("lblLoad", new Object[0]));
                break;
            }
            case NewGamePlus: {
                this.header.setText(Forge.getLocalizer().getMessage("lblNewGame", new Object[0]) + "+");
                this.saveLoadButton.setText(Forge.getLocalizer().getMessage("lblStart", new Object[0]));
            }
        }
        ((TextraButton)this.autoSave.actor).setDisabled(mode == Modes.Save);
        ((TextraButton)this.quickSave.actor).setDisabled(mode == Modes.Save);
        this.mode = mode;
    }

    @Override
    public void enter() {
        this.unselectActors();
        this.select(this.lastSelectedSlot);
        this.updateFiles();
        ((TextraButton)this.autoSave.actor).setText(Forge.getLocalizer().getMessage("lblAutoSave", new Object[0]));
        ((TextraButton)this.quickSave.actor).setText(Forge.getLocalizer().getMessage("lblQuickSave", new Object[0]));
        if (this.mode == Modes.NewGamePlus) {
            if (this.difficulty != null) {
                this.difficulty.setVisible(true);
                this.difficulty.setSelectedIndex(1);
            }
        } else if (this.difficulty != null) {
            this.difficulty.setVisible(false);
        }
        this.performTouch(this.scrollPane);
        super.enter();
    }

    public String getSaveFileSuffix() {
        String difficulty;
        switch (AdventurePlayer.current().getDifficulty().name) {
            case "easy": 
            case "Easy": {
                difficulty = "[%99][CYAN]\uff0a[WHITE]";
                break;
            }
            case "normal": 
            case "Normal": {
                difficulty = "[%99][GREEN]\uff0a[WHITE]";
                break;
            }
            case "hard": 
            case "Hard": {
                difficulty = "[%99][GOLD]\uff0a[WHITE]";
                break;
            }
            case "insane": 
            case "Insane": {
                difficulty = "[%99][RED]\uff0a[WHITE]";
                break;
            }
            default: {
                difficulty = "[%99][WHITE]";
            }
        }
        return this.ASCII_179 + difficulty + GameScene.instance().getAdventurePlayerLocation(true, true);
    }

    public static enum Modes {
        Save,
        Load,
        NewGamePlus;

    }

    public class SaveSlot
    extends UIScene.Selectable<TextraButton> {
        private final int slotNumber;

        public SaveSlot(int slotNumber) {
            super(Controls.newTextButton("..."));
            this.slotNumber = slotNumber;
            final SaveSlot self = this;
            ((TextraButton)this.actor).addListener(new ClickListener(){

                @Override
                public void clicked(InputEvent event, float x, float y) {
                    try {
                        if (!((TextraButton)SaveSlot.this.actor).isDisabled()) {
                            SaveLoadScene.this.selectActor(self);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });
        }

        @Override
        public void onSelect(UIScene scene) {
            super.onSelect(scene);
            SaveLoadScene.this.updateSlot(this.slotNumber);
        }
    }
}

