/*
 * Decompiled with CFR 0.152.
 */
package forge.adventure.scene;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.controllers.Controller;
import com.badlogic.gdx.controllers.Controllers;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Timer;
import com.github.tommyettinger.textra.TextraButton;
import com.github.tommyettinger.textra.TextraLabel;
import com.github.tommyettinger.textra.TypingLabel;
import forge.Forge;
import forge.adventure.character.ShopActor;
import forge.adventure.data.RewardData;
import forge.adventure.data.ShopData;
import forge.adventure.player.AdventurePlayer;
import forge.adventure.pointofintrest.PointOfInterestChanges;
import forge.adventure.scene.UIScene;
import forge.adventure.stage.GameHUD;
import forge.adventure.util.CardUtil;
import forge.adventure.util.Config;
import forge.adventure.util.Controls;
import forge.adventure.util.Current;
import forge.adventure.util.Reward;
import forge.adventure.util.RewardActor;
import forge.adventure.world.WorldSave;
import forge.assets.ImageCache;
import forge.deck.Deck;
import forge.item.PaperCard;
import forge.sound.SoundEffectType;
import forge.sound.SoundSystem;
import forge.util.ItemPool;

public class RewardScene
extends UIScene {
    private TextraButton doneButton;
    private TextraButton detailButton;
    private TextraButton restockButton;
    private TextraLabel playerGold;
    private TextraLabel playerShards;
    private TypingLabel headerLabel;
    private ShopActor shopActor;
    private static RewardScene object;
    private PointOfInterestChanges changes;
    private boolean showTooltips = false;
    Type type;
    Array<Actor> generated = new Array();
    public static final float CARD_WIDTH = 550.0f;
    public static final float CARD_HEIGHT = 400.0f;
    public static final float CARD_WIDTH_TO_HEIGHT = 1.375f;
    ItemPool<PaperCard> collectionPool = null;
    private int remainingSelections = 0;
    boolean doneClicked = false;
    boolean shown = false;
    float flipCountDown = 1.0f;
    float exitCountDown = 0.0f;

    public static RewardScene instance() {
        if (object == null) {
            object = new RewardScene();
        }
        return object;
    }

    private RewardScene() {
        super(Forge.isLandscapeMode() ? "ui/items.json" : "ui/items_portrait.json");
        this.playerGold = Controls.newAccountingLabel((TextraLabel)this.ui.findActor("playerGold"), false);
        this.playerShards = Controls.newAccountingLabel((TextraLabel)this.ui.findActor("playerShards"), true);
        this.headerLabel = (TypingLabel)this.ui.findActor("shopName");
        this.ui.onButtonPress("done", this::done);
        this.ui.onButtonPress("detail", this::toggleToolTip);
        this.ui.onButtonPress("restock", this::restockShop);
        this.detailButton = (TextraButton)this.ui.findActor("detail");
        this.detailButton.setVisible(false);
        this.doneButton = (TextraButton)this.ui.findActor("done");
        this.restockButton = (TextraButton)this.ui.findActor("restock");
    }

    @Override
    public void connected(Controller controller) {
        super.connected(controller);
        this.updateDetailButton();
    }

    @Override
    public void disconnected(Controller controller) {
        super.disconnected(controller);
        this.updateDetailButton();
    }

    private void updateDetailButton() {
        this.detailButton.setVisible(Controllers.getCurrent() != null);
        this.detailButton.layout();
    }

    private void toggleToolTip() {
        RewardActor actor;
        UIScene.Selectable selectable = this.getSelected();
        if (selectable == null) {
            return;
        }
        if (selectable.actor instanceof BuyButton) {
            actor = ((BuyButton)selectable.actor).rewardActor;
        } else if (selectable.actor instanceof RewardActor) {
            actor = (RewardActor)selectable.actor;
        } else {
            return;
        }
        if (actor.toolTipIsVisible()) {
            actor.hideTooltip();
        } else if (!actor.isFlipped()) {
            actor.showTooltip();
        }
    }

    public void quitScene() {
        for (Actor A2 : new Array.ArrayIterator<Actor>(this.generated)) {
            if (!(A2 instanceof RewardActor)) continue;
            ((RewardActor)A2).removeTooltip();
            ((RewardActor)A2).dispose();
            A2.remove();
        }
        ImageCache.unloadCardTextures(true);
        Forge.advFreezePlayerControls = false;
        if (this.collectionPool != null) {
            this.collectionPool.clear();
            this.collectionPool = null;
        }
        Forge.switchToLast();
    }

    public void reactivateInputs() {
        Gdx.input.setInputProcessor(this.stage);
        this.doneButton.toFront();
    }

    public boolean done() {
        return this.done(false);
    }

    boolean done(boolean skipShowLoot) {
        GameHUD.getInstance().getTouchpad().setVisible(false);
        if (!skipShowLoot) {
            this.doneButton.setText("[+OK]");
            this.showLootOrDone();
            return true;
        }
        if (this.type != null) {
            switch (this.type) {
                case Shop: {
                    this.doneButton.setText("[+OK]");
                    break;
                }
                case QuestReward: 
                case Loot: {
                    this.doneButton.setText("[+OK]");
                }
            }
        }
        this.shown = false;
        this.clearGenerated();
        this.quitScene();
        return true;
    }

    void clearGenerated() {
        for (Actor actor : new Array.ArrayIterator<Actor>(this.generated)) {
            if (!(actor instanceof RewardActor)) continue;
            RewardActor reward = (RewardActor)actor;
            if (this.type == Type.Loot) {
                AdventurePlayer.current().addReward(reward.getReward());
            }
            if (this.type == Type.QuestReward) {
                AdventurePlayer.current().addReward(reward.getReward());
            }
            reward.clearHoldToolTip();
            try {
                this.stage.getActors().removeValue(reward, true);
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public void act(float delta) {
        this.stage.act(delta);
        ImageCache.allowSingleLoad();
        if (this.doneClicked) {
            if (this.type == Type.Loot || this.type == Type.QuestReward) {
                this.flipCountDown -= Gdx.graphics.getDeltaTime();
                this.exitCountDown += Gdx.graphics.getDeltaTime();
            }
            if (this.flipCountDown <= 0.0f) {
                this.clearGenerated();
                this.quitScene();
            }
        }
    }

    @Override
    public void enter() {
        this.doneButton.setText("[+OK]");
        this.updateDetailButton();
        super.enter();
    }

    private void showLootOrDone() {
        boolean exit = true;
        for (Actor actor : new Array.ArrayIterator<Actor>(this.generated)) {
            RewardActor reward;
            if (!(actor instanceof RewardActor) || (reward = (RewardActor)actor).isFlipped()) continue;
            exit = false;
            break;
        }
        if (exit) {
            this.done(true);
        } else if (!(this.type != Type.Loot && this.type != Type.QuestReward || this.shown)) {
            this.shown = true;
            float delay = 0.09f;
            this.generated.shuffle();
            for (Actor actor : new Array.ArrayIterator<Actor>(this.generated)) {
                RewardActor reward;
                if (!(actor instanceof RewardActor) || (reward = (RewardActor)actor).isFlipped()) continue;
                Timer.schedule(new Timer.Task(){

                    @Override
                    public void run() {
                        reward.flip();
                    }
                }, delay);
                delay += 0.15f;
            }
        } else {
            this.done(true);
        }
    }

    void updateRestockButton() {
        if (!this.shopActor.canRestock()) {
            return;
        }
        int price = this.shopActor.getRestockPrice();
        this.restockButton.setText("[+Refresh][+shards]" + price);
        this.restockButton.setDisabled(WorldSave.getCurrentSave().getPlayer().getShards() < price);
    }

    void restockShop() {
        if (!this.shopActor.canRestock()) {
            return;
        }
        int price = this.shopActor.getRestockPrice();
        if (this.changes != null) {
            this.changes.generateNewShopSeed(this.shopActor.getObjectId());
        }
        Current.player().takeShards(price);
        Gdx.input.vibrate(5);
        SoundSystem.instance.play(SoundEffectType.Shuffle, false);
        this.updateBuyButtons();
        if (this.changes == null) {
            return;
        }
        this.clearGenerated();
        ShopData data = this.shopActor.getShopData();
        Array<Reward> ret = new Array<Reward>();
        long shopSeed = this.changes.getShopSeed(this.shopActor.getObjectId());
        WorldSave.getCurrentSave().getWorld().getRandom().setSeed(shopSeed);
        for (RewardData rdata : new Array.ArrayIterator<RewardData>(data.rewards)) {
            ret.addAll(rdata.generate(false, false));
        }
        this.shopActor.setRewardData(ret);
        this.loadRewards(ret, Type.Shop, this.shopActor);
    }

    public void loadRewards(Deck deck, Type type, ShopActor shopActor, boolean noSell) {
        Array<Reward> rewards = new Array<Reward>();
        for (PaperCard card : deck.getAllCardsInASinglePool().toFlatList()) {
            rewards.add(new Reward(card, noSell));
        }
        this.loadRewards(rewards, type, shopActor);
    }

    public void loadSelectableRewards(Array<Reward> choices, Type type, int countToSelect) {
        if (type != Type.RewardChoice) {
            return;
        }
        this.remainingSelections = countToSelect;
        this.loadRewards(choices, type, null);
    }

    void updateCollectionPool() {
        if (Type.Shop != this.type) {
            return;
        }
        if (this.collectionPool == null) {
            this.collectionPool = new ItemPool<PaperCard>(PaperCard.class);
        } else {
            this.collectionPool.clear();
        }
        this.collectionPool.addAllFlat(AdventurePlayer.current().getCollectionCards(true).toFlatList());
    }

    public void loadRewards(Array<Reward> newRewards, Type type, ShopActor shopActor) {
        Float custom;
        float fH;
        float mul;
        this.clearSelectable();
        this.type = type;
        this.doneClicked = false;
        this.updateCollectionPool();
        if (type == Type.Shop) {
            this.shopActor = shopActor;
            this.changes = shopActor.getMapStage().getChanges();
            this.addToSelectable(this.restockButton);
        }
        for (Actor actor : new Array.ArrayIterator<Actor>(this.generated)) {
            actor.remove();
            if (!(actor instanceof RewardActor)) continue;
            ((RewardActor)actor).dispose();
        }
        this.addToSelectable(this.doneButton);
        this.generated.clear();
        Object card = this.ui.findActor("cards");
        if (type == Type.Shop) {
            String shopName = shopActor.getDescription();
            if (shopName != null && !shopName.isEmpty()) {
                this.headerLabel.setVisible(true);
                this.headerLabel.setText("[%?SHINY]{GRADIENT}" + shopName + "{ENDGRADIENT}");
                this.headerLabel.skipToTheEnd();
            } else {
                this.headerLabel.setVisible(false);
            }
            Object background = this.ui.findActor("market_background");
            if (background != null) {
                ((Actor)background).setVisible(true);
            }
        } else {
            this.headerLabel.setVisible(false);
            this.headerLabel.setText("");
            Object background = this.ui.findActor("market_background");
            if (background != null) {
                ((Actor)background).setVisible(false);
            }
        }
        float targetWidth = ((Actor)card).getWidth();
        float targetHeight = ((Actor)card).getHeight();
        float xOff = ((Actor)card).getX();
        float yOff = ((Actor)card).getY();
        int numberOfRows = 0;
        float cardWidth = 0.0f;
        float cardHeight = 0.0f;
        float bestCardHeight = 0.0f;
        int numberOfColumns = 0;
        float targetArea = targetHeight * targetWidth;
        float oldCardArea = 0.0f;
        float newArea = 0.0f;
        switch (type) {
            case Shop: {
                this.doneButton.setText("[+OK]");
                String shopName = shopActor.getDescription();
                if (shopName != null && !shopName.isEmpty()) {
                    this.headerLabel.setVisible(true);
                    this.headerLabel.setText("[%?SHINY]{GRADIENT}" + shopName + "{ENDGRADIENT}");
                    this.headerLabel.skipToTheEnd();
                }
                if (shopActor.canRestock()) {
                    this.restockButton.setVisible(true);
                    break;
                }
                this.restockButton.setVisible(false);
                this.restockButton.setDisabled(true);
                break;
            }
            case QuestReward: 
            case Loot: {
                this.headerLabel.setVisible(false);
                this.headerLabel.setText("");
                this.restockButton.setVisible(false);
                this.doneButton.setText("[+OK]");
                break;
            }
            case RewardChoice: {
                this.restockButton.setVisible(false);
                this.doneButton.setText("[+OK]");
                this.headerLabel.setVisible(this.remainingSelections > 0);
                this.headerLabel.setText("Select " + this.remainingSelections + " rewards");
                this.doneButton.setDisabled(this.remainingSelections > 0);
            }
        }
        int h2 = 1;
        while ((float)h2 < targetHeight) {
            cardHeight = h2;
            if (type == Type.Shop || type == Type.RewardChoice) {
                cardHeight += this.doneButton.getHeight();
            }
            cardWidth = (float)h2 / 1.375f;
            newArea = (float)newRewards.size * cardWidth * cardHeight;
            int rows = (int)(targetHeight / cardHeight);
            int cols = (int)Math.ceil((double)newRewards.size / (double)rows);
            if (newArea > oldCardArea && newArea <= targetArea && (float)rows * cardHeight < targetHeight && (float)cols * cardWidth < targetWidth) {
                oldCardArea = newArea;
                numberOfRows = rows;
                numberOfColumns = cols;
                bestCardHeight = h2;
            }
            ++h2;
        }
        float AR = 1.7777778f;
        int x = Forge.getDeviceAdapter().getRealScreenSize(false).getLeft();
        int y = Forge.getDeviceAdapter().getRealScreenSize(false).getRight();
        int realX = Forge.getDeviceAdapter().getRealScreenSize(true).getLeft();
        int realY = Forge.getDeviceAdapter().getRealScreenSize(true).getRight();
        float fW = Math.max(x, y);
        float f = mul = fW / (fH = (float)Math.min(x, y)) < AR ? AR / (fW / fH) : fW / fH / AR;
        if (fW / fH >= 2.0f) {
            mul = fW / fH - fW / fH / AR;
            if (fW / fH >= 2.1f && fW / fH < 2.2f) {
                mul *= 0.9f;
            } else if (fW / fH > 2.2f) {
                mul *= 0.8f;
            }
        }
        cardHeight = bestCardHeight * 0.9f;
        Float f2 = custom = Forge.isLandscapeMode() ? Config.instance().getSettingData().rewardCardAdjLandscape : Config.instance().getSettingData().rewardCardAdj;
        if (custom != null && custom.floatValue() != 1.0f) {
            mul *= custom.floatValue();
        } else if (realX > x || realY > y) {
            mul *= Forge.isLandscapeMode() ? 0.95f : 1.05f;
        } else if (fW / fH > 2.2f) {
            mul *= Forge.isLandscapeMode() ? 1.1f : 1.6f;
        } else if (fW / fH >= 2.1f) {
            mul *= Forge.isLandscapeMode() ? 1.05f : 1.5f;
        } else if (fW / fH >= 2.0f) {
            mul *= Forge.isLandscapeMode() ? 1.0f : 1.4f;
        }
        cardWidth = cardHeight / 1.375f * mul;
        yOff += (targetHeight - cardHeight * (float)numberOfRows) / 2.0f;
        xOff += (targetWidth - cardWidth * (float)numberOfColumns) / 2.0f;
        float spacing = 2.0f;
        int i = 0;
        for (Reward reward : new Array.ArrayIterator<Reward>(newRewards)) {
            int lastRowCount;
            boolean skipCard = false;
            if (type == Type.Shop && this.changes.wasCardBought(shopActor.getObjectId(), i)) {
                skipCard = true;
            }
            int currentRow = i / numberOfColumns;
            float lastRowXAdjust = 0.0f;
            if (currentRow == numberOfRows - 1 && (lastRowCount = newRewards.size % numberOfColumns) != 0) {
                lastRowXAdjust = ((float)numberOfColumns * cardWidth - (float)lastRowCount * cardWidth) / 2.0f;
            }
            RewardActor actor = new RewardActor(reward, type == Type.Loot || type == Type.QuestReward, type, type == Type.Shop && (numberOfRows > 2 || numberOfColumns > 2));
            actor.setBounds(lastRowXAdjust + xOff + cardWidth * (float)(i % numberOfColumns) + spacing, yOff + cardHeight * (float)currentRow + spacing, cardWidth - spacing * 2.0f, cardHeight - spacing * 2.0f);
            if (type == Type.Shop) {
                if (currentRow != (i + 1) / numberOfColumns) {
                    yOff += this.doneButton.getHeight();
                }
                BuyButton buyCardButton = new BuyButton(shopActor.getObjectId(), i, actor, reward, this.doneButton, shopActor.getPriceModifier());
                this.generated.add(buyCardButton);
                if (!skipCard) {
                    this.stage.addActor(buyCardButton);
                    this.addToSelectable(buyCardButton);
                }
            } else if (type == Type.RewardChoice) {
                if (currentRow != (i + 1) / numberOfColumns) {
                    yOff += this.doneButton.getHeight();
                }
                ChooseRewardButton chooseRewardButton = new ChooseRewardButton(i, actor, reward, this.doneButton);
                this.generated.add(chooseRewardButton);
                this.stage.addActor(chooseRewardButton);
                this.addToSelectable(chooseRewardButton);
            } else {
                this.addToSelectable(actor);
            }
            this.generated.add(actor);
            if (!skipCard) {
                this.stage.addActor(actor);
            }
            ++i;
        }
        if (type == Type.Shop) {
            this.updateBuyButtons();
            this.updateRestockButton();
        }
    }

    private void updateBuyButtons() {
        for (Actor actor : new Array.ArrayIterator<Actor>(this.generated)) {
            if (!(actor instanceof BuyButton)) continue;
            ((BuyButton)actor).update();
        }
    }

    private void updateChooseRewardButtons() {
        for (Actor actor : new Array.ArrayIterator<Actor>(this.generated)) {
            if (!(actor instanceof ChooseRewardButton)) continue;
            ((ChooseRewardButton)actor).update();
        }
    }

    private class ChooseRewardButton
    extends TextraButton {
        private final int index;
        public RewardActor rewardActor;
        private Reward reward;
        int price;
        boolean isSold;

        void update() {
            this.setDisabled(RewardScene.this.remainingSelections <= 0);
            if (this.isSold) {
                this.setText("SELECTED");
            } else {
                this.updateOwned();
            }
        }

        void updateOwned() {
            if (Type.Shop != RewardScene.this.type) {
                return;
            }
            if (RewardScene.this.collectionPool != null && Reward.Type.Card.equals((Object)this.reward.getType())) {
                this.setText("Pick Reward\n" + Forge.getLocalizer().getMessage("lblOwned", new Object[0]) + ": " + RewardScene.this.collectionPool.count(this.reward.getCard()));
            } else if (Reward.Type.Item.equals((Object)this.reward.getType())) {
                this.setText("Pick Reward\n" + Forge.getLocalizer().getMessage("lblOwned", new Object[0]) + ": " + AdventurePlayer.current().countItem(this.reward.getItem().name));
            }
        }

        public ChooseRewardButton(int i, RewardActor actor, Reward reward, TextraButton style) {
            super("", style.getStyle(), Controls.getTextraFont());
            this.index = i;
            this.rewardActor = actor;
            this.reward = reward;
            this.setHeight(style.getHeight());
            this.setWidth(actor.getWidth());
            this.setX(actor.getX());
            this.setY(actor.getY() - this.getHeight());
            this.setText("Pick Reward");
            this.updateOwned();
            this.addListener(new ClickListener(){

                @Override
                public void clicked(InputEvent event, float x, float y) {
                    if (RewardScene.this.remainingSelections >= 1) {
                        RewardScene.this.remainingSelections--;
                        Current.player().addReward(ChooseRewardButton.this.rewardActor.getReward());
                        RewardScene.this.headerLabel.setVisible(RewardScene.this.remainingSelections > 0);
                        RewardScene.this.headerLabel.setText("Select " + RewardScene.this.remainingSelections + " rewards");
                        RewardScene.this.doneButton.setDisabled(RewardScene.this.remainingSelections > 0);
                        Gdx.input.vibrate(5);
                        ChooseRewardButton.this.isSold = true;
                        ChooseRewardButton.this.setDisabled(true);
                        ChooseRewardButton.this.rewardActor.sold();
                        ChooseRewardButton.this.getColor().a = 0.5f;
                        RewardScene.this.updateCollectionPool();
                        RewardScene.this.updateChooseRewardButtons();
                        ChooseRewardButton.this.removeListener(this);
                    }
                }
            });
        }
    }

    private class BuyButton
    extends TextraButton {
        private final int objectID;
        private final int index;
        public RewardActor rewardActor;
        private Reward reward;
        int price;
        boolean isSold;

        void update() {
            this.setDisabled(WorldSave.getCurrentSave().getPlayer().getGold() < this.price);
            if (this.isSold) {
                this.setText("SOLD");
            } else {
                this.updateOwned();
            }
        }

        void updateOwned() {
            if (Type.Shop != RewardScene.this.type) {
                return;
            }
            if (RewardScene.this.collectionPool != null && Reward.Type.Card.equals((Object)this.reward.getType())) {
                this.setText("[%75][+GoldCoin] " + this.price + "\n" + Forge.getLocalizer().getMessage("lblOwned", new Object[0]) + ": " + RewardScene.this.collectionPool.count(this.reward.getCard()));
            } else if (Reward.Type.Item.equals((Object)this.reward.getType())) {
                this.setText("[%75][+GoldCoin] " + this.price + "\n" + Forge.getLocalizer().getMessage("lblOwned", new Object[0]) + ": " + AdventurePlayer.current().countItem(this.reward.getItem().name));
            }
        }

        public BuyButton(int id, int i, RewardActor actor, Reward reward, TextraButton style, float shopModifier) {
            super("", style.getStyle(), Controls.getTextraFont());
            this.objectID = id;
            this.index = i;
            this.rewardActor = actor;
            this.reward = reward;
            this.setHeight(style.getHeight());
            this.setWidth(actor.getWidth());
            this.setX(actor.getX());
            this.setY(actor.getY() - this.getHeight());
            this.price = CardUtil.getRewardPrice(actor.getReward());
            this.price = (int)((float)this.price * Current.player().goldModifier());
            this.price = (int)((float)this.price * shopModifier);
            this.setText("[+GoldCoin] " + this.price);
            this.updateOwned();
            this.addListener(new ClickListener(){

                @Override
                public void clicked(InputEvent event, float x, float y) {
                    if (Current.player().getGold() >= BuyButton.this.price) {
                        if (!RewardScene.this.shopActor.isUnlimited()) {
                            RewardScene.this.changes.buyCard(BuyButton.this.objectID, BuyButton.this.index);
                        }
                        Current.player().takeGold(BuyButton.this.price);
                        Current.player().addReward(BuyButton.this.rewardActor.getReward());
                        Gdx.input.vibrate(5);
                        SoundSystem.instance.play(SoundEffectType.FlipCoin, false);
                        if (RewardScene.this.changes == null) {
                            return;
                        }
                        BuyButton.this.isSold = true;
                        BuyButton.this.setDisabled(true);
                        BuyButton.this.rewardActor.sold();
                        BuyButton.this.getColor().a = 0.5f;
                        RewardScene.this.updateCollectionPool();
                        RewardScene.this.updateBuyButtons();
                        BuyButton.this.removeListener(this);
                    }
                }
            });
        }
    }

    public static enum Type {
        Shop,
        Loot,
        QuestReward,
        RewardChoice;

    }
}

