/*
 * Decompiled with CFR 0.152.
 */
package forge.adventure.scene;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.Touchable;
import com.badlogic.gdx.scenes.scene2d.ui.Dialog;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.ScrollPane;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.ui.Window;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;
import com.github.tommyettinger.textra.TextraButton;
import com.github.tommyettinger.textra.TypingLabel;
import forge.Forge;
import forge.adventure.data.AdventureQuestData;
import forge.adventure.data.AdventureQuestStage;
import forge.adventure.scene.GameScene;
import forge.adventure.scene.PlayerStatisticScene;
import forge.adventure.scene.Scene;
import forge.adventure.scene.UIScene;
import forge.adventure.stage.MapStage;
import forge.adventure.util.AdventureQuestController;
import forge.adventure.util.Controls;
import forge.adventure.util.Current;

public class QuestLogScene
extends UIScene {
    private Table scrollContainer;
    private Table detailScrollContainer;
    Window scrollWindow;
    ScrollPane scroller;
    ScrollPane detailScroller;
    Table root;
    Table detailRoot;
    TextraButton trackButton;
    TextraButton backToListButton;
    TextraButton abandonQuestButton;
    Scene lastGameScene;
    private static QuestLogScene object;

    private QuestLogScene() {
        super(Forge.isLandscapeMode() ? "ui/quests.json" : "ui/quests_portrait.json");
        this.scrollWindow = (Window)this.ui.findActor("scrollWindow");
        this.root = (Table)this.ui.findActor("questList");
        this.detailRoot = (Table)this.ui.findActor("questDetails");
        this.abandonQuestButton = Controls.newTextButton("Abandon Quest");
        this.trackButton = Controls.newTextButton("Track Quest");
        this.backToListButton = Controls.newTextButton("Quest List");
        this.ui.onButtonPress("return", this::back);
        this.ui.onButtonPress("status", this::status);
        this.ui.onButtonPress("backToList", this::backToList);
        this.scrollContainer = new Table(Controls.getSkin());
        this.scrollContainer.row();
        this.detailScrollContainer = new Table(Controls.getSkin());
        this.detailScrollContainer.row();
        this.detailScroller = new ScrollPane((Actor)this.detailScrollContainer);
        this.detailScroller.setScrollingDisabled(true, false);
        if (Forge.isLandscapeMode()) {
            this.detailRoot.add(this.abandonQuestButton).fillX().top().padTop(5.0f);
            this.detailRoot.add(this.trackButton).fillX().top().padTop(5.0f);
            this.detailRoot.add(this.backToListButton).fillX().top().padTop(5.0f);
        } else {
            this.detailRoot.add(this.abandonQuestButton).fillX().top().padTop(5.0f).colspan(3);
            this.detailRoot.row();
            this.detailRoot.add(this.trackButton).fillX().top().padTop(5.0f).colspan(3);
            this.detailRoot.row();
            this.detailRoot.add(this.backToListButton).fillX().top().padTop(5.0f).colspan(3);
        }
        this.detailRoot.row();
        this.detailRoot.add(this.detailScroller).colspan(3).expandX().fillX().expandY();
        this.detailRoot.row();
        this.scrollWindow.setTouchable(Touchable.disabled);
        this.detailRoot.setVisible(false);
        this.scroller = new ScrollPane((Actor)this.scrollContainer);
        this.root.add(this.scroller).colspan(3);
        this.root.align(16);
        this.root.row();
        Label column0Label = new Label((CharSequence)Forge.getLocalizer().getMessage("lblQuestName", new Object[0]), Controls.getSkin());
        column0Label.setColor(Color.BLACK);
        this.root.add(column0Label).align(12);
        this.root.row();
        ScrollPane scroller = new ScrollPane((Actor)this.scrollContainer);
        this.root.add(scroller).colspan(3).fill().expand();
    }

    public static QuestLogScene instance(Scene lastGameScene) {
        object = new QuestLogScene();
        if (lastGameScene != null) {
            QuestLogScene.object.lastGameScene = lastGameScene;
        }
        return object;
    }

    @Override
    public void dispose() {
    }

    @Override
    public void enter() {
        super.enter();
        this.buildList();
    }

    public void buildList() {
        this.backToList();
        this.scrollContainer.clear();
        for (final AdventureQuestData quest : Current.player().getQuests()) {
            TypingLabel nameLabel = Controls.newTypingLabel(quest.getName());
            nameLabel.skipToTheEnd();
            nameLabel.setWrap(true);
            nameLabel.setColor(Color.BLACK);
            this.scrollContainer.add(nameLabel).align(8).expandX();
            TextraButton details = Controls.newTextButton(Forge.getLocalizer().getMessage("lblDetails", new Object[0]));
            details.addListener(new ClickListener(){

                @Override
                public void clicked(InputEvent event, float x, float y) {
                    QuestLogScene.this.loadDetailsPane(quest);
                }
            });
            this.scrollContainer.add(details).align(1).padRight(10.0f);
            this.scrollContainer.row().padTop(5.0f);
            this.addToSelectable(details);
        }
        this.performTouch(this.scrollPaneOfActor(this.scrollContainer));
    }

    private void backToList() {
        this.abandonQuestButton.setVisible(false);
        this.trackButton.setVisible(false);
        this.backToListButton.setVisible(false);
        this.root.setVisible(true);
        this.detailRoot.setVisible(false);
    }

    private void loadDetailsPane(final AdventureQuestData quest) {
        if (quest == null) {
            return;
        }
        this.root.setVisible(false);
        this.detailRoot.setVisible(true);
        this.detailScrollContainer.clear();
        this.detailScrollContainer.row();
        this.trackButton.setText(quest.isTracked ? Forge.getLocalizer().getMessage("lblUntrackQuest", new Object[0]) : Forge.getLocalizer().getMessage("lblTrackQuest", new Object[0]));
        this.trackButton.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                QuestLogScene.this.toggleTracked(quest);
            }
        });
        this.abandonQuestButton.setColor(Color.RED);
        this.abandonQuestButton.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                Dialog confirm = QuestLogScene.this.createGenericDialog("", Forge.getLocalizer().getMessage("lblAbandonQuestConfirm", new Object[0]), Forge.getLocalizer().getMessage("lblYes", new Object[0]), Forge.getLocalizer().getMessage("lblNo", new Object[0]), () -> QuestLogScene.this.abandonQuest(quest), null);
                QuestLogScene.this.showDialog(confirm);
            }
        });
        TypingLabel dNameLabel = Controls.newTypingLabel(quest.getName());
        dNameLabel.skipToTheEnd();
        dNameLabel.setWrap(true);
        dNameLabel.setColor(Color.BLACK);
        this.detailScrollContainer.add(dNameLabel).align(8).expandX().padLeft(10.0f);
        this.abandonQuestButton.setVisible(!quest.storyQuest);
        this.trackButton.setVisible(true);
        this.backToListButton.setVisible(true);
        TypingLabel dDescriptionLabel = Controls.newTypingLabel(quest.getDescription());
        dDescriptionLabel.skipToTheEnd();
        dDescriptionLabel.setWrap(true);
        dDescriptionLabel.setColor(Color.DARK_GRAY);
        this.detailScrollContainer.row();
        this.detailScrollContainer.add(dDescriptionLabel).align(8).padLeft(25.0f).width(this.detailRoot.getWidth() - 25.0f);
        for (AdventureQuestStage stage : quest.getCompletedStages()) {
            TypingLabel completeLabel = Controls.newTypingLabel("*  " + stage.name);
            completeLabel.skipToTheEnd();
            completeLabel.setColor(Color.GREEN);
            completeLabel.setWrap(true);
            this.detailScrollContainer.row();
            this.detailScrollContainer.add(completeLabel).align(8).padLeft(25.0f);
        }
        for (AdventureQuestStage stage : quest.getActiveStages()) {
            TypingLabel activeLabel = Controls.newTypingLabel("*  " + stage.name);
            activeLabel.skipToTheEnd();
            activeLabel.setColor(Color.BLACK);
            activeLabel.setWrap(true);
            this.detailScrollContainer.row();
            this.detailScrollContainer.add(activeLabel).align(8).padLeft(25.0f);
            TypingLabel activeDescriptionLabel = Controls.newTypingLabel(stage.description);
            activeDescriptionLabel.skipToTheEnd();
            activeDescriptionLabel.setColor(Color.DARK_GRAY);
            activeDescriptionLabel.setWrap(true);
            this.detailScrollContainer.row();
            this.detailScrollContainer.add(activeDescriptionLabel).padLeft(35.0f).width(this.detailRoot.getWidth() - 50.0f);
            this.detailScrollContainer.row();
        }
    }

    private void toggleTracked(AdventureQuestData quest) {
        if (quest.isTracked) {
            quest.isTracked = false;
            this.trackButton.setText(Forge.getLocalizer().getMessage("lblTrackQuest", new Object[0]));
        } else {
            AdventureQuestController.trackQuest(quest);
            this.trackButton.setText(Forge.getLocalizer().getMessage("lblUntrackQuest", new Object[0]));
        }
    }

    private void status() {
        Forge.switchScene(PlayerStatisticScene.instance(this.lastGameScene), true);
    }

    @Override
    public boolean back() {
        Forge.switchScene(this.lastGameScene == null ? GameScene.instance() : this.lastGameScene);
        return true;
    }

    private void abandonQuest(AdventureQuestData quest) {
        AdventureQuestController.instance().abandon(quest);
        AdventureQuestController.instance().showQuestDialogs(MapStage.getInstance());
        this.buildList();
    }
}

