/*
 * Decompiled with CFR 0.152.
 */
package forge.adventure.scene;

import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.ScrollPane;
import com.badlogic.gdx.scenes.scene2d.utils.TextureRegionDrawable;
import com.github.tommyettinger.textra.TextraButton;
import com.github.tommyettinger.textra.TypingLabel;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import forge.Forge;
import forge.adventure.data.AdventureQuestData;
import forge.adventure.pointofintrest.PointOfInterest;
import forge.adventure.scene.UIScene;
import forge.adventure.stage.GameHUD;
import forge.adventure.stage.WorldStage;
import forge.adventure.util.Controls;
import forge.adventure.util.Current;
import forge.adventure.world.WorldSave;
import java.util.List;
import java.util.Set;

public class MapViewScene
extends UIScene {
    private static MapViewScene object;
    private final ScrollPane scroll;
    private final Image img;
    private Texture miniMapTexture;
    private final Image miniMapPlayer;
    private final Group table;
    private final List<TypingLabel> labels;
    private int index = -1;
    private float avatarX = 0.0f;
    private float avatarY = 0.0f;
    private Set<Vector2> positions;
    private Set<PointOfInterest> bookmark;

    public static MapViewScene instance() {
        if (object == null) {
            object = new MapViewScene();
        }
        return object;
    }

    private MapViewScene() {
        super(Forge.isLandscapeMode() ? "ui/map.json" : "ui/map_portrait.json");
        this.ui.onButtonPress("done", this::done);
        this.ui.onButtonPress("quest", this::scroll);
        this.scroll = (ScrollPane)this.ui.findActor("map");
        this.labels = Lists.newArrayList();
        this.positions = Sets.newHashSet();
        this.bookmark = Sets.newHashSet();
        this.table = new Group();
        this.scroll.setActor(this.table);
        this.img = new Image();
        this.miniMapPlayer = new Image();
        this.img.setPosition(0.0f, 0.0f);
        this.table.addActor(this.img);
        this.table.addActor(this.miniMapPlayer);
    }

    public boolean done() {
        GameHUD.getInstance().getTouchpad().setVisible(false);
        for (Actor a : this.table.getChildren()) {
            if (!(a instanceof TypingLabel)) continue;
            a.remove();
        }
        this.labels.clear();
        this.positions.clear();
        this.index = -1;
        Forge.switchToLast();
        return true;
    }

    public void addBookmark(PointOfInterest point) {
        if (point == null) {
            return;
        }
        this.bookmark.add(point);
    }

    public void removeBookmark(PointOfInterest point) {
        if (point == null) {
            return;
        }
        this.bookmark.remove(point);
    }

    public boolean scroll() {
        if (!this.labels.isEmpty()) {
            ++this.index;
            if (this.index >= this.labels.size()) {
                this.index = -1;
                this.scroll.scrollTo(this.avatarX, this.avatarY, this.miniMapPlayer.getWidth(), this.miniMapPlayer.getHeight(), true, true);
                return true;
            }
            TypingLabel label = this.labels.get(this.index);
            this.scroll.scrollTo(label.getX(), label.getY(), this.miniMapPlayer.getWidth(), this.miniMapPlayer.getHeight(), true, true);
        }
        return true;
    }

    @Override
    public void enter() {
        if (this.miniMapTexture != null) {
            this.miniMapTexture.dispose();
        }
        this.miniMapTexture = new Texture(WorldSave.getCurrentSave().getWorld().getBiomeImage());
        this.img.setSize(WorldSave.getCurrentSave().getWorld().getBiomeImage().getWidth(), WorldSave.getCurrentSave().getWorld().getBiomeImage().getHeight());
        this.img.getParent().setSize(WorldSave.getCurrentSave().getWorld().getBiomeImage().getWidth(), WorldSave.getCurrentSave().getWorld().getBiomeImage().getHeight());
        this.img.setDrawable(new TextureRegionDrawable(this.miniMapTexture));
        this.miniMapPlayer.setDrawable(new TextureRegionDrawable(Current.player().avatar()));
        this.miniMapPlayer.setSize(Current.player().avatar().getRegionWidth(), Current.player().avatar().getRegionHeight());
        this.avatarX = this.getMapX(WorldStage.getInstance().getPlayerSprite().getX()) - this.miniMapPlayer.getWidth() / 2.0f;
        this.avatarY = this.getMapY(WorldStage.getInstance().getPlayerSprite().getY()) - this.miniMapPlayer.getHeight() / 2.0f;
        this.miniMapPlayer.setPosition(this.avatarX, this.avatarY);
        this.miniMapPlayer.layout();
        this.scroll.scrollTo(this.avatarX, this.avatarY, this.miniMapPlayer.getWidth(), this.miniMapPlayer.getHeight(), true, true);
        for (AdventureQuestData adq : Current.player().getQuests()) {
            PointOfInterest poi = adq.getTargetPOI();
            if (poi == null || this.positions.contains(poi.getPosition())) continue;
            TypingLabel label = Controls.newTypingLabel("[+GPS][%?BLACKEN] " + adq.name);
            this.labels.add(label);
            this.table.addActor(label);
            label.setPosition(this.getMapX(poi.getPosition().x) - label.getWidth() / 2.0f, this.getMapY(poi.getPosition().y) - label.getHeight() / 2.0f);
            label.skipToTheEnd();
            this.positions.add(poi.getPosition());
        }
        for (PointOfInterest poi : this.bookmark) {
            TypingLabel label = Controls.newTypingLabel("[%75][+Star] ");
            this.table.addActor(label);
            label.setPosition(this.getMapX(poi.getPosition().x) - label.getWidth() / 2.0f, this.getMapY(poi.getPosition().y) - label.getHeight() / 2.0f);
            label.skipToTheEnd();
        }
        TextraButton questButton = (TextraButton)this.ui.findActor("quest");
        if (questButton != null) {
            questButton.setDisabled(this.labels.isEmpty());
            questButton.setVisible(!this.labels.isEmpty());
        }
        super.enter();
    }

    float getMapX(float posX) {
        return posX / (float)WorldSave.getCurrentSave().getWorld().getTileSize() / (float)WorldSave.getCurrentSave().getWorld().getWidthInTiles() * this.img.getWidth();
    }

    float getMapY(float posY) {
        return posY / (float)WorldSave.getCurrentSave().getWorld().getTileSize() / (float)WorldSave.getCurrentSave().getWorld().getHeightInTiles() * this.img.getHeight();
    }
}

