/*
 * Decompiled with CFR 0.152.
 */
package forge.adventure.scene;

import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.github.tommyettinger.textra.TextraButton;
import com.github.tommyettinger.textra.TextraLabel;
import forge.Forge;
import forge.adventure.data.AdventureEventData;
import forge.adventure.player.AdventurePlayer;
import forge.adventure.pointofintrest.PointOfInterestChanges;
import forge.adventure.scene.EventScene;
import forge.adventure.scene.GameScene;
import forge.adventure.scene.Scene;
import forge.adventure.scene.ShopScene;
import forge.adventure.scene.UIScene;
import forge.adventure.stage.GameHUD;
import forge.adventure.util.AdventureEventController;
import forge.adventure.util.Controls;
import forge.adventure.util.Current;

public class InnScene
extends UIScene {
    private static InnScene object;
    private static int localObjectId;
    private static String localPointOfInterestId;
    private static AdventureEventData localEvent;
    Scene lastGameScene;
    TextraButton tempHitPointCost = (TextraButton)this.ui.findActor("tempHitPointCost");
    TextraButton sell;
    TextraButton leave;
    TextraButton event;
    Image healIcon;
    Image sellIcon;
    Image leaveIcon;
    private TextraLabel playerGold;
    private TextraLabel playerShards;
    private TextraLabel eventDescription;
    int tempHealthCost = 0;
    static PointOfInterestChanges changes;

    public static InnScene instance() {
        return InnScene.instance(null, "", null, -1);
    }

    public static InnScene instance(Scene lastGameScene, String pointOfInterestId, PointOfInterestChanges localChanges, int objectId) {
        if (object == null) {
            object = new InnScene();
        }
        changes = localChanges;
        localPointOfInterestId = pointOfInterestId;
        localObjectId = objectId;
        if (lastGameScene != null) {
            InnScene.object.lastGameScene = lastGameScene;
        }
        InnScene.getLocalEvent();
        return object;
    }

    private InnScene() {
        super(Forge.isLandscapeMode() ? "ui/inn.json" : "ui/inn_portrait.json");
        this.ui.onButtonPress("done", this::done);
        this.ui.onButtonPress("tempHitPointCost", this::potionOfFalseLife);
        this.ui.onButtonPress("sell", this::sell);
        this.leave = (TextraButton)this.ui.findActor("done");
        this.sell = (TextraButton)this.ui.findActor("sell");
        this.playerGold = Controls.newAccountingLabel((TextraLabel)this.ui.findActor("playerGold"), false);
        this.playerShards = Controls.newAccountingLabel((TextraLabel)this.ui.findActor("playerShards"), true);
        this.leaveIcon = (Image)this.ui.findActor("leaveIcon");
        this.healIcon = (Image)this.ui.findActor("healIcon");
        this.sellIcon = (Image)this.ui.findActor("sellIcon");
        this.event = (TextraButton)this.ui.findActor("event");
        this.eventDescription = (TextraLabel)this.ui.findActor("eventDescription");
        this.ui.onButtonPress("event", this::startEvent);
    }

    public void done() {
        GameHUD.getInstance().getTouchpad().setVisible(false);
        Forge.switchScene(this.lastGameScene == null ? GameScene.instance() : this.lastGameScene);
    }

    public void potionOfFalseLife() {
        if (Current.player().potionOfFalseLife()) {
            this.refreshStatus();
        }
    }

    @Override
    public void act(float delta) {
        this.stage.act(delta);
    }

    @Override
    public void render() {
        super.render();
    }

    @Override
    public void enter() {
        super.enter();
        this.refreshStatus();
        GameHUD.getInstance().switchAudio();
    }

    private void refreshStatus() {
        this.tempHealthCost = Math.round((float)Current.player().falseLifeCost() * changes.getTownPriceModifier());
        boolean purchaseable = Current.player().getMaxLife() == Current.player().getLife() && this.tempHealthCost <= Current.player().getGold();
        this.tempHitPointCost.setDisabled(!purchaseable);
        this.tempHitPointCost.setText("[+GoldCoin] " + this.tempHealthCost);
        InnScene.getLocalEvent();
        if (localEvent == null) {
            this.eventDescription.setText("[GREY]No events at this time");
            this.event.setDisabled(true);
        } else {
            this.event.setDisabled(false);
            switch (InnScene.localEvent.eventStatus) {
                case Available: {
                    this.eventDescription.setText(InnScene.localEvent.format.toString() + " available");
                    break;
                }
                case Entered: {
                    this.eventDescription.setText(InnScene.localEvent.format.toString() + " [GREEN]entered");
                    break;
                }
                case Ready: {
                    this.eventDescription.setText(InnScene.localEvent.format.toString() + " [GREEN]ready");
                    break;
                }
                case Started: {
                    this.eventDescription.setText(InnScene.localEvent.format.toString() + " [GREEN]in progress");
                    break;
                }
                case Completed: {
                    this.eventDescription.setText(InnScene.localEvent.format.toString() + " [GREEN]rewards available");
                    break;
                }
                case Awarded: {
                    this.eventDescription.setText(InnScene.localEvent.format.toString() + " complete");
                    break;
                }
                case Abandoned: {
                    this.eventDescription.setText(InnScene.localEvent.format.toString() + " [RED]abandoned");
                    this.event.setDisabled(true);
                }
            }
        }
    }

    private void sell() {
        ShopScene.instance().loadChanges(changes);
        Forge.switchScene(ShopScene.instance());
    }

    private static void getLocalEvent() {
        localEvent = null;
        for (AdventureEventData data : AdventurePlayer.current().getEvents()) {
            if (!data.sourceID.equals(localPointOfInterestId) || data.eventOrigin != localObjectId) continue;
            localEvent = data;
            return;
        }
        localEvent = AdventureEventController.instance().createEvent(AdventureEventController.EventStyle.Bracket, localPointOfInterestId, localObjectId, changes);
    }

    private void startEvent() {
        Forge.switchScene(EventScene.instance(this, localEvent, changes), true);
    }
}

