/*
 * Decompiled with CFR 0.152.
 */
package forge.adventure.scene;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.InputProcessor;
import com.badlogic.gdx.controllers.Controller;
import forge.Forge;
import forge.adventure.scene.Scene;
import forge.adventure.stage.GameHUD;
import forge.adventure.stage.GameStage;
import forge.adventure.stage.IAfterMatch;
import forge.adventure.stage.MapStage;
import forge.adventure.util.KeyBinding;

public abstract class HudScene
extends Scene
implements InputProcessor,
IAfterMatch {
    GameHUD hud;
    GameStage stage;

    protected HudScene(GameStage s2) {
        this.stage = s2;
        this.hud = GameHUD.getInstance();
    }

    @Override
    public boolean touchCancelled(int x, int y, int pointer, int button) {
        return this.touchUp(x, y, pointer, button);
    }

    @Override
    public void connected(Controller controller) {
        this.hud.ui.controllerConnected();
    }

    @Override
    public void disconnected(Controller controller) {
        this.hud.ui.controllerDisconnected();
    }

    @Override
    public boolean leave() {
        this.stage.leave();
        return super.leave();
    }

    @Override
    public void enter() {
        Gdx.input.setInputProcessor(this);
        this.stage.enter();
        this.hud.enter();
        super.enter();
    }

    @Override
    public void dispose() {
        this.stage.dispose();
    }

    @Override
    public void act(float delta) {
        this.stage.act(delta);
        this.hud.act(delta);
    }

    @Override
    public void render() {
        Gdx.gl.glClear(16384);
        this.stage.draw();
        this.hud.draw();
    }

    @Override
    public boolean keyDown(int keycode) {
        if (MapStage.getInstance().isDialogOnlyInput()) {
            MapStage.getInstance().stop();
            return MapStage.getInstance().dialogInput(keycode);
        }
        if (this.hud.keyDown(keycode)) {
            return true;
        }
        if (this.isInHudOnlyMode()) {
            return false;
        }
        if (Forge.advFreezePlayerControls) {
            return false;
        }
        return this.stage.keyDown(keycode);
    }

    @Override
    public boolean keyUp(int keycode) {
        if (MapStage.getInstance().isDialogOnlyInput()) {
            MapStage.getInstance().stop();
            return true;
        }
        if (this.hud.keyUp(keycode)) {
            return true;
        }
        if (this.isInHudOnlyMode()) {
            return false;
        }
        if (Forge.advFreezePlayerControls) {
            return false;
        }
        return this.stage.keyUp(keycode);
    }

    @Override
    public boolean buttonDown(Controller var1, int var2) {
        return this.keyDown(KeyBinding.controllerButtonToKey(var1, var2));
    }

    @Override
    public boolean buttonUp(Controller var1, int var2) {
        return this.keyUp(KeyBinding.controllerButtonToKey(var1, var2));
    }

    @Override
    public boolean keyTyped(char character) {
        if (this.hud.keyTyped(character)) {
            return true;
        }
        if (this.isInHudOnlyMode()) {
            return false;
        }
        if (Forge.advFreezePlayerControls) {
            return false;
        }
        return this.stage.keyTyped(character);
    }

    @Override
    public boolean touchDown(int screenX, int screenY, int pointer, int button) {
        if (this.hud.touchDown(screenX, screenY, pointer, button)) {
            return true;
        }
        if (this.isInHudOnlyMode()) {
            return false;
        }
        if (Forge.advFreezePlayerControls) {
            return false;
        }
        return this.stage.touchDown(screenX, screenY, pointer, button);
    }

    @Override
    public boolean touchUp(int screenX, int screenY, int pointer, int button) {
        if (this.hud.touchUp(screenX, screenY, pointer, button)) {
            return true;
        }
        if (this.isInHudOnlyMode()) {
            return false;
        }
        return this.stage.touchUp(screenX, screenY, pointer, button);
    }

    @Override
    public boolean touchDragged(int screenX, int screenY, int pointer) {
        if (this.hud.touchDragged(screenX, screenY, pointer)) {
            return true;
        }
        if (this.isInHudOnlyMode()) {
            return false;
        }
        if (Forge.advFreezePlayerControls) {
            return false;
        }
        return this.stage.touchDragged(screenX, screenY, pointer);
    }

    @Override
    public boolean mouseMoved(int screenX, int screenY) {
        if (this.hud.mouseMoved(screenX, screenY)) {
            return true;
        }
        if (this.isInHudOnlyMode()) {
            return false;
        }
        if (Forge.advFreezePlayerControls) {
            return false;
        }
        return this.stage.mouseMoved(screenX, screenY);
    }

    @Override
    public boolean scrolled(float amountX, float amountY) {
        if (this.hud.scrolled(amountX, amountY)) {
            return true;
        }
        if (this.isInHudOnlyMode()) {
            return false;
        }
        if (Forge.advFreezePlayerControls) {
            return false;
        }
        return this.stage.scrolled(amountX, amountY);
    }

    @Override
    public boolean axisMoved(Controller controller, int axisIndex, float value) {
        return this.stage.axisMoved(controller, axisIndex, value);
    }

    @Override
    public void setWinner(boolean winner) {
        this.stage.setWinner(winner);
    }

    public boolean isInHudOnlyMode() {
        return false;
    }

    public void setFromWorldMap(boolean val) {
        this.hud.fromWorldMap = val;
    }
}

