/*
 * Decompiled with CFR 0.152.
 */
package forge.adventure.scene;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.math.Vector2;
import forge.Forge;
import forge.adventure.data.BiomeData;
import forge.adventure.pointofintrest.PointOfInterest;
import forge.adventure.scene.HudScene;
import forge.adventure.scene.TileMapScene;
import forge.adventure.stage.MapStage;
import forge.adventure.stage.WorldStage;
import forge.adventure.util.Current;
import forge.adventure.world.World;
import forge.util.TextUtil;
import java.util.List;

public class GameScene
extends HudScene {
    private static GameScene object;
    private String location = "";

    public GameScene() {
        super(WorldStage.getInstance());
    }

    public static GameScene instance() {
        if (object == null) {
            object = new GameScene();
        }
        return object;
    }

    @Override
    public void dispose() {
        this.stage.dispose();
    }

    @Override
    public void act(float delta) {
        this.stage.act(delta);
    }

    @Override
    public void render() {
        Gdx.gl.glClear(16384);
        this.stage.draw();
        this.hud.draw();
    }

    @Override
    public void enter() {
        MapStage.getInstance().clearIsInMap();
        Forge.clearTransitionScreen();
        Forge.clearCurrentScreen();
        super.enter();
        WorldStage.getInstance().handlePointsOfInterestCollision();
    }

    public String getAdventurePlayerLocation(boolean forHeader, boolean skipRoads) {
        if (MapStage.getInstance().isInMap()) {
            this.location = forHeader ? TileMapScene.instance().rootPoint.getDisplayName() : TileMapScene.instance().rootPoint.getData().type;
        } else {
            World world = Current.world();
            int currentBiome = World.highestBiome(world.getBiomeMapXY((int)this.stage.getPlayerSprite().getX() / world.getTileSize(), (int)this.stage.getPlayerSprite().getY() / world.getTileSize()));
            List<BiomeData> biomeData = world.getData().GetBiomes();
            if (biomeData.size() <= currentBiome) {
                this.location = skipRoads ? (forHeader ? "Waste Map" : "waste") : "";
            } else {
                BiomeData data = biomeData.get(currentBiome);
                this.location = forHeader ? TextUtil.capitalize(data.name) + " Map" : data.name;
            }
        }
        return this.location;
    }

    public String getBiomeByPosition(Vector2 position) {
        World world = Current.world();
        int currentBiome = World.highestBiome(world.getBiomeMapXY((int)position.x / world.getTileSize(), (int)position.y / world.getTileSize()));
        List<BiomeData> biomeData = world.getData().GetBiomes();
        return biomeData.size() <= currentBiome ? "waste" : biomeData.get((int)currentBiome).name;
    }

    public PointOfInterest getMapPOI() {
        if (MapStage.getInstance().isInMap()) {
            return TileMapScene.instance().rootPoint;
        }
        return null;
    }
}

